/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.util.Converter;
import com.mathworks.util.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class FileScopedTreeModel
implements TreeModel {
    private final Collection<TreeModelListener> fListeners;
    private final Collection<TreeModelListener> fWillChangeListeners;
    private final Collection<Predicate<FileScopedNode>> fFilters;
    private final Predicate<FileScopedNode> fProxyFilter;
    private final List<FileScopedNode> fSingletonLeafList;
    private final Map<FileScopedNode, List<FileScopedNode>> fNodes = new HashMap<FileScopedNode, List<FileScopedNode>>();
    private final Map<File, FileScopedNode> fFileNodes;
    private final TreeModelListener fDispatcher;
    private FileScopedNode fRoot;
    private Converter<FileScopedNode, Collection<FileScopedNode>> fNodeProvider;
    private Converter<FileScopedNode, File> fNodeToFileBinder;

    public FileScopedTreeModel(FileScopedNode fileScopedNode, Converter<FileScopedNode, Collection<FileScopedNode>> converter) {
        this.fListeners = new LinkedList<TreeModelListener>();
        this.fWillChangeListeners = new LinkedList<TreeModelListener>();
        this.fFileNodes = new HashMap<File, FileScopedNode>();
        this.fSingletonLeafList = Collections.unmodifiableList(new LinkedList());
        this.fFilters = new LinkedList<Predicate<FileScopedNode>>();
        final TreeModelListener treeModelListener = this.createDispatcher(this.fListeners);
        final TreeModelListener treeModelListener2 = this.createDispatcher(this.fWillChangeListeners);
        this.fDispatcher = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                treeModelListener2.treeNodesChanged(treeModelEvent);
                treeModelListener.treeNodesChanged(treeModelEvent);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                treeModelListener2.treeNodesInserted(treeModelEvent);
                treeModelListener.treeNodesInserted(treeModelEvent);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                treeModelListener2.treeNodesRemoved(treeModelEvent);
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                treeModelListener2.treeStructureChanged(treeModelEvent);
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        };
        this.fProxyFilter = new Predicate<FileScopedNode>(){

            public boolean accept(FileScopedNode fileScopedNode) {
                for (Predicate predicate : FileScopedTreeModel.this.fFilters) {
                    if (predicate.accept((Object)fileScopedNode)) continue;
                    return false;
                }
                return true;
            }
        };
        this.setNodeProvider(converter);
        this.setRoot(fileScopedNode);
    }

    public FileScopedTreeModel(FileSetIntegrationContext fileSetIntegrationContext, Converter<FileScopedNode, Collection<FileScopedNode>> converter) {
        this(new FileScopedNode(fileSetIntegrationContext), converter);
    }

    public FileScopedTreeModel(FileSetIntegrationContext fileSetIntegrationContext) {
        this(fileSetIntegrationContext, null);
    }

    public FileScopedTreeModel() {
        this((FileScopedNode)null, null);
    }

    public void setRoot(FileScopedNode fileScopedNode) {
        if (fileScopedNode == null) {
            return;
        }
        this.fRoot = fileScopedNode;
        this.fDispatcher.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.fRoot}));
        this.populate();
    }

    public void setNodeProvider(Converter<FileScopedNode, Collection<FileScopedNode>> converter) {
        if (converter == null) {
            converter = new Converter<FileScopedNode, Collection<FileScopedNode>>(){

                public Collection<FileScopedNode> convert(FileScopedNode fileScopedNode) {
                    return Collections.emptyList();
                }
            };
        }
        this.fNodeProvider = converter;
        this.reset();
    }

    public void setNodeToFileBinder(Converter<FileScopedNode, File> converter) {
        this.fNodeToFileBinder = converter;
        this.reset();
    }

    private void reset() {
        this.fNodes.clear();
        this.fFileNodes.clear();
        this.populate();
    }

    public void addNodeFilter(Predicate<FileScopedNode> predicate) {
        this.fFilters.add(predicate);
    }

    public void removeNodeFilter(Predicate<FileScopedNode> predicate) {
        this.fFilters.remove(predicate);
    }

    public boolean containsFile(File file) {
        return this.fFileNodes.containsKey(file);
    }

    public FileScopedNode getFileRoot(File file) {
        return this.fFileNodes.get(file);
    }

    public int getFileCount() {
        return this.fFileNodes.size();
    }

    public void addWillChangeListener(TreeModelListener treeModelListener) {
        this.fWillChangeListeners.add(treeModelListener);
    }

    private TreeModelListener createDispatcher(final Collection<TreeModelListener> collection) {
        return new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                for (TreeModelListener treeModelListener : collection) {
                    treeModelListener.treeNodesChanged(treeModelEvent);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                for (TreeModelListener treeModelListener : collection) {
                    treeModelListener.treeNodesInserted(treeModelEvent);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                for (TreeModelListener treeModelListener : collection) {
                    treeModelListener.treeNodesRemoved(treeModelEvent);
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                for (TreeModelListener treeModelListener : collection) {
                    treeModelListener.treeStructureChanged(treeModelEvent);
                }
            }
        };
    }

    public Collection<TreePath> getExpandablePaths(FileScopedNode fileScopedNode) {
        fileScopedNode = fileScopedNode != null ? fileScopedNode : this.fRoot;
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        if (fileScopedNode != null) {
            this.createExpandablePaths(fileScopedNode, linkedList);
        }
        return linkedList;
    }

    private boolean createExpandablePaths(FileScopedNode fileScopedNode, Collection<TreePath> collection) {
        if (this.isLeaf(fileScopedNode)) {
            return false;
        }
        boolean bl = false;
        for (FileScopedNode fileScopedNode2 : this.getNodeChildren(fileScopedNode)) {
            boolean bl2 = this.createExpandablePaths(fileScopedNode2, collection);
            if (bl) continue;
            bl2 = bl;
        }
        if (!bl) {
            collection.add(new TreePath(FileScopedTreeModel.getPath(fileScopedNode, true)));
        }
        return true;
    }

    public Collection<FileScopedNode> getNodeChildren(FileScopedNode fileScopedNode) {
        if (fileScopedNode == null) {
            fileScopedNode = this.fRoot;
        }
        if (this.fNodes.containsKey(fileScopedNode)) {
            return new LinkedList<FileScopedNode>((Collection)this.fNodes.get(fileScopedNode));
        }
        this.populate(fileScopedNode, true);
        return this.fNodes.containsKey(fileScopedNode) ? new LinkedList(this.fNodes.get(fileScopedNode)) : new LinkedList();
    }

    public void populate() {
        if (this.fRoot == null) {
            return;
        }
        this.populate(this.fRoot, true);
        this.fDispatcher.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.fRoot}));
    }

    public void populate(FileScopedNode fileScopedNode, boolean bl) {
        LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
        linkedList.add(fileScopedNode);
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        LinkedList<FileScopedNode> linkedList3 = new LinkedList<FileScopedNode>();
        while (!linkedList.isEmpty()) {
            FileScopedNode fileScopedNode2;
            int n;
            FileScopedNode fileScopedNode3 = (FileScopedNode)linkedList.poll();
            ArrayList arrayList = new ArrayList((Collection)this.fNodeProvider.convert((Object)fileScopedNode3));
            List<FileScopedNode> list = this.fNodes.containsKey(fileScopedNode3) ? this.fNodes.get(fileScopedNode3) : this.fSingletonLeafList;
            arrayList = arrayList != null ? arrayList : this.fSingletonLeafList;
            File file = null;
            if (fileScopedNode3.getNodeType().equals((Object)FileScopedNode.NodeType.FILE_NODE)) {
                file = fileScopedNode3.getAssociatedFile();
            } else if (this.fNodeToFileBinder != null) {
                file = (File)this.fNodeToFileBinder.convert((Object)fileScopedNode3);
            }
            if (file != null) {
                this.fFileNodes.put(file, fileScopedNode3);
            }
            if (arrayList.isEmpty()) {
                this.fNodes.put(fileScopedNode3, this.fSingletonLeafList);
            } else {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (this.fProxyFilter.accept(iterator.next())) continue;
                    iterator.remove();
                }
                this.fNodes.put(fileScopedNode3, new ArrayList(arrayList));
                if (bl) {
                    linkedList.addAll(arrayList);
                }
            }
            linkedList2.clear();
            linkedList3.clear();
            for (n = 0; n < list.size(); ++n) {
                fileScopedNode2 = list.get(n);
                if (arrayList.contains(fileScopedNode2)) continue;
                linkedList2.add(n);
                linkedList3.add(fileScopedNode2);
            }
            linkedList2.clear();
            linkedList3.clear();
            for (n = 0; n < arrayList.size(); ++n) {
                fileScopedNode2 = arrayList.get(n);
                if (list.contains(fileScopedNode2)) continue;
                linkedList2.add(n);
                linkedList3.add(fileScopedNode2);
            }
            this.fDispatcher.treeNodesInserted(new TreeModelEvent((Object)this, FileScopedTreeModel.getPath(fileScopedNode3, true), FileScopedTreeModel.toIntArray(linkedList2), linkedList3.toArray()));
        }
    }

    private static int[] toIntArray(Collection<Integer> collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            nArray[n++] = iterator.next();
        }
        return nArray;
    }

    public static Object[] getPath(FileScopedNode fileScopedNode, boolean bl) {
        FileScopedNode fileScopedNode2;
        LinkedList<FileScopedNode> linkedList = new LinkedList<FileScopedNode>();
        FileScopedNode fileScopedNode3 = fileScopedNode2 = bl ? fileScopedNode : fileScopedNode.getParent();
        while (fileScopedNode2 != null) {
            linkedList.add(fileScopedNode2);
            fileScopedNode2 = fileScopedNode2.getParent();
        }
        Collections.reverse(linkedList);
        return linkedList.toArray();
    }

    @Override
    public FileScopedNode getRoot() {
        return this.fRoot;
    }

    @Override
    public FileScopedNode getChild(Object object, int n) {
        return this.fNodes.containsKey(object) ? this.fNodes.get(object).get(n) : null;
    }

    @Override
    public int getChildCount(Object object) {
        return this.fNodes.containsKey(object) ? this.fNodes.get(object).size() : 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (this.fRoot != null && this.fRoot.equals(object)) {
            return false;
        }
        return this.fNodes.containsKey(object) ? this.fNodes.get(object).isEmpty() : true;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return object != null && this.fNodes.containsKey(object) ? this.fNodes.get(object).indexOf(object2) : -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.fListeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.fListeners.remove(treeModelListener);
    }
}

