/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.util.ParameterRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class InferenceTable {
    private final MJPanel fComponent;
    private final InferenceTableContext fContext;
    private final Collection<ParameterRunnable<Set<Variable>>> fSelectionListeners;
    private Function fSelectedFunction;
    private PropertyTable<Variable> fTable;

    public InferenceTable(InferenceTableContext inferenceTableContext) {
        this.fContext = inferenceTableContext;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fSelectionListeners = new LinkedList<ParameterRunnable<Set<Variable>>>();
        this.fContext.getInferenceModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InferenceTable.this.update();
            }
        });
        this.fContext.setInferenceTable(this);
        this.update();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void addInferenceTableSelectionListener(final ParameterRunnable<Set<Variable>> parameterRunnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InferenceTable.this.fSelectionListeners.add(parameterRunnable);
            }
        });
    }

    public void fireDataChanged() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InferenceTable.this.fTable != null) {
                    InferenceTable.this.fTable.getModel().fireChange();
                }
            }
        });
    }

    public void setSelectedFunction(Function function) {
        this.fSelectedFunction = function;
        this.update();
    }

    public Function getSelectedFunction() {
        return this.fSelectedFunction;
    }

    public Set<Variable> getSelectedVariables() {
        assert (MJUtilities.isEventDispatchThread());
        return this.fTable != null ? new LinkedHashSet(this.fTable.getSelectedValues(0)) : new HashSet();
    }

    public void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InferenceTable.this.fComponent.removeAll();
                if (InferenceTable.this.fTable != null) {
                    InferenceTable.this.fTable.dispose();
                }
                if (InferenceTable.this.fSelectedFunction != null) {
                    Variable variable2;
                    final InferenceModel inferenceModel = InferenceTable.this.fContext.getInferenceModel();
                    ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
                    List<Variable> list = inferenceModel.getVariables(InferenceTable.this.fSelectedFunction);
                    Collections.sort(list, new Comparator<Variable>(){

                        @Override
                        public int compare(Variable variable, Variable variable2) {
                            return inferenceModel.getVariableKind(variable).compareTo(inferenceModel.getVariableKind(variable2));
                        }
                    });
                    LinkedHashMap<Integer, VariableKind> linkedHashMap = new LinkedHashMap<Integer, VariableKind>();
                    final HashMap<Integer, Variable> hashMap = new HashMap<Integer, Variable>();
                    VariableKind variableKind = null;
                    PropertyTableNode propertyTableNode = null;
                    int n = 0;
                    for (Variable variable2 : list) {
                        VariableKind variableKind2 = inferenceModel.getVariableKind(variable2);
                        if (variableKind2.equals((Object)VariableKind.FIELD) || variableKind2.equals((Object)VariableKind.PROPERTY)) continue;
                        if (variableKind == null || variableKind2 != variableKind) {
                            variableKind = variableKind2;
                            propertyTableNode = new PropertyTableNode(null, true, variableKind.getLabel());
                            arrayList.add(propertyTableNode);
                            linkedHashMap.put(n++, variableKind);
                        }
                        if (inferenceModel.hasFieldNature(variable2)) {
                            PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, variable2.getName());
                            hashMap.put(n, variable2);
                            for (Variable variable3 : inferenceModel.getFieldNature(variable2).getFields()) {
                                new PropertyTableNode(propertyTableNode2, false, Arrays.asList(variable3));
                                ++n;
                            }
                        } else {
                            new PropertyTableNode(propertyTableNode, false, Arrays.asList(variable2));
                        }
                        ++n;
                    }
                    InferenceTable.this.fContext.setCurrentGroups(linkedHashMap);
                    final ArrayList arrayList2 = new ArrayList();
                    arrayList2.add(new NameColumn());
                    arrayList2.addAll(InferenceTable.this.fContext.getColumnsForFunction(InferenceTable.this.fSelectedFunction));
                    variable2 = new PropertyTableModel(arrayList2, arrayList){

                        public Object getValue(int n, int n2) {
                            Object object = super.getValue(n, n2);
                            if (object != null || hashMap.containsKey(n)) {
                                // empty if block
                            }
                            return object;
                        }

                        public String getColumnText(int n, int n2) {
                            String string = super.getColumnText(n, n2);
                            if ((string == null || string.trim().isEmpty()) && hashMap.containsKey(n)) {
                                string = ((PropertyTableColumn)arrayList2.get(n2)).getText(hashMap.get(n));
                            }
                            return string;
                        }
                    };
                    variable2.expandAll();
                    if (InferenceTable.this.fContext.getCellEditorFactory() != null) {
                        InferenceTable.this.fTable = new PropertyTable((PropertyTableModel)variable2, InferenceTable.this.fContext.getCellEditorFactory());
                    } else {
                        InferenceTable.this.fTable = new PropertyTable((PropertyTableModel)variable2);
                    }
                    InferenceTable.this.fTable.getSelectionModel().addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            for (ParameterRunnable parameterRunnable : InferenceTable.this.fSelectionListeners) {
                                parameterRunnable.run(InferenceTable.this.getSelectedVariables());
                            }
                        }
                    });
                    InferenceTable.this.fTable.getSelectionModel().setAllowMultiselect(true);
                    InferenceTable.this.fTable.setColumnWeights(HDLTableUtils.distributeColumns(arrayList2.size(), 0.2, 0.4, true));
                    InferenceTable.this.fComponent.add((Component)InferenceTable.this.fTable.getComponent());
                }
                InferenceTable.this.fComponent.revalidate();
                InferenceTable.this.fComponent.repaint();
            }
        });
    }

    public static interface InferenceTableContext {
        public InferenceModel getInferenceModel();

        public List<PropertyTableColumn<Variable>> getColumnsForFunction(Function var1);

        public PropertyTableCellEditorFactory<Variable> getCellEditorFactory();

        public void setInferenceTable(InferenceTable var1);

        public void setCurrentGroups(Map<Integer, VariableKind> var1);

        public boolean allowGroupSelection();

        public boolean allowMultipleSelection();
    }

    private class NameColumn
    extends AbstractPropertyTableColumn<Variable> {
        public NameColumn() {
            super(CoderResources.getString("f2f.column.variable"));
        }

        public String getText(Variable variable) {
            VariableKind variableKind = InferenceTable.this.fContext.getInferenceModel().getVariableKind(variable);
            if (variableKind != null && (variableKind.equals((Object)VariableKind.FIELD) || variableKind.equals((Object)VariableKind.PROPERTY))) {
                variable = InferenceTable.this.fContext.getInferenceModel().getUnqualifiedField(variable);
            }
            return variable.getName();
        }
    }
}

