/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownTable;
import com.mathworks.toolbox.coder.wfa.build.HDLInferenceTableContext;
import com.mathworks.toolbox.coder.wfa.build.HDLParameterCellEditorFactory;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.toolbox.coder.wfa.build.InferenceTable;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class HDLDrillDownDelegates {
    private HDLDrillDownDelegates() {
    }

    static final class FunctionDrillDownSourceView
    extends AbstractDrillDownSourceView<Function> {
        private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout());
        private PropertyTable<Function> fTable;

        FunctionDrillDownSourceView() {
        }

        void setTable(PropertyTable<Function> propertyTable) {
            this.fComponent.removeAll();
            this.fComponent.add((Component)propertyTable.getComponent(), (Object)"Center");
            this.fTable = propertyTable;
            this.fTable.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    FunctionDrillDownSourceView.this.fireChangeEvent();
                }
            });
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }

        @Override
        public Collection<Function> getSelectedEntries() {
            return this.fTable != null ? this.fTable.getSelectedValues(0) : new LinkedList();
        }

        @Override
        public JComponent getComponent() {
            return this.fComponent;
        }
    }

    static final class DefaultDrillDownView<T>
    implements HDLDrillDownTable.DrillDownView<T> {
        private static final String SECTION_NAME = "hdldrilldown";
        private static final String RES_LABEL = "wfa.hdl.drillDown.batchLabel";
        private final HDLExtendedModel.HDLParameterObserver fObserver;
        private final JComponent fComponent;
        private final SectionPanel fSection;
        private final MJPanel fPanel;
        private final Converter<T, String> fNameConverter;
        private Collection<HDLExtendedModel.HDLParameter<?>> fParamsToShow;
        private PropertyTableModel<HDLExtendedModel.HDLParameter> fTableModel;

        DefaultDrillDownView(CoderApp coderApp, Converter<T, String> converter) {
            this.fNameConverter = converter;
            this.fPanel = new MJPanel((LayoutManager)new BorderLayout());
            this.fObserver = new HDLExtendedModel.HDLParameterObserver(){

                @Override
                public void hdlParameterChanged(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (DefaultDrillDownView.this.fTableModel != null) {
                                DefaultDrillDownView.this.fTableModel.fireChange();
                            }
                        }
                    });
                }
            };
            this.fSection = new SectionPanel(new DataTransferSupport(), true, coderApp.getModel().getConfiguration());
            this.fSection.addSection(SECTION_NAME, "", "", null, null, (Component)this.fPanel);
            this.fComponent = this.fSection.getComponent();
        }

        @Override
        public void setCurrentEntries(Collection<HDLExtendedModel.HDLParameter<?>> collection, Collection<T> collection2) {
            if (this.fParamsToShow != null) {
                for (HDLExtendedModel.HDLParameter<?> object2 : this.fParamsToShow) {
                    object2.removeHDLParameterObserver(this.fObserver);
                }
            }
            this.fParamsToShow = new LinkedList(collection);
            ArrayList arrayList = new ArrayList();
            arrayList.add(new HDLTableUtils.ParameterNameColumn());
            arrayList.add(new ParameterValueColumn(collection2));
            ArrayList<PropertyTableNode> arrayList2 = new ArrayList<PropertyTableNode>();
            for (HDLExtendedModel.HDLParameter<?> hDLParameter : collection) {
                arrayList2.add(new PropertyTableNode(null, false, Arrays.asList(hDLParameter)));
                hDLParameter.addHDLParameterObserver(this.fObserver);
            }
            this.fTableModel = new PropertyTableModel((List)arrayList, arrayList2);
            PropertyTable propertyTable = new PropertyTable(this.fTableModel, this.createCellEditorFactory(collection2));
            propertyTable.getSelectionModel().setAllowMultiselect(true);
            propertyTable.setColumnWeights(new double[]{0.5, 0.5});
            this.fSection.setDisplayName(SECTION_NAME, this.buildNameString(collection2));
            this.fSection.setToolTip(SECTION_NAME, this.buildNameString(collection2));
            this.fPanel.removeAll();
            this.fPanel.add((Component)propertyTable.getComponent());
            this.fPanel.setMinimumSize(new Dimension((int)(this.fPanel.getPreferredSize().getWidth() * 0.4), this.fPanel.getPreferredSize().height));
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }

        @Override
        public JComponent getComponent() {
            return this.fComponent;
        }

        private String buildNameString(Collection<T> collection) {
            StringBuilder stringBuilder = new StringBuilder(CoderResources.getString(RES_LABEL));
            if (collection.size() > 0) {
                stringBuilder.append(" - ");
            }
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append((String)this.fNameConverter.convert(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        private PropertyTableCellEditorFactory<HDLExtendedModel.HDLParameter<?>> createCellEditorFactory(final Collection<T> collection) {
            return HDLParameterCellEditorFactory.createEditorFactory(new HDLParameterCellEditorFactory.CellEditorValueContext<HDLExtendedModel.HDLParameter<?>>(){

                @Override
                public Collection<?> getKeys() {
                    return collection;
                }

                @Override
                public List<HDLExtendedModel.HDLParameter<?>> getHDLParameters(HDLExtendedModel.HDLParameter<?> hDLParameter, int n) {
                    LinkedList linkedList = new LinkedList();
                    linkedList.add(hDLParameter);
                    return linkedList;
                }
            });
        }

        private static String createLabelString(Collection<Variable> collection) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Variable> iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        private class ParameterValueColumn
        extends AbstractPropertyTableColumn<HDLExtendedModel.HDLParameter> {
            private final Collection<T> fKeys;

            ParameterValueColumn(Collection<T> collection) {
                super(CoderResources.getString("wfa.hdl.column.paramValueLabel"));
                this.fKeys = collection;
            }

            public String getText(HDLExtendedModel.HDLParameter hDLParameter) {
                Object var2_2 = null;
                for (Object t : this.fKeys) {
                    if (var2_2 != null) {
                        Object t2 = hDLParameter.getValue(t);
                        if (t2.equals(var2_2)) continue;
                        return "";
                    }
                    var2_2 = hDLParameter.getValue(t);
                }
                return var2_2 != null && this.fKeys.size() > 0 ? HDLTableUtils.getHDLParameterValueString(hDLParameter, this.fKeys.iterator().next()) : "";
            }

            public boolean isEditable() {
                return true;
            }
        }
    }

    static final class InferenceSourceView
    extends AbstractDrillDownSourceView<Variable> {
        private final MJPanel panel;
        private final HDLInferenceTableContext fTableContext;

        InferenceSourceView(HDLInferenceTableContext hDLInferenceTableContext) {
            this.fTableContext = hDLInferenceTableContext;
            this.panel = new MJPanel((LayoutManager)new BorderLayout());
        }

        @Override
        public Collection<Variable> getSelectedEntries() {
            return this.fTableContext.getInferenceTable().getSelectedVariables();
        }

        @Override
        public JComponent getComponent() {
            return this.panel;
        }

        public void updateView(InferenceTable inferenceTable) {
            inferenceTable.addInferenceTableSelectionListener(new ParameterRunnable<Set<Variable>>(){

                public void run(Set<Variable> set) {
                    InferenceSourceView.this.fireChangeEvent();
                }
            });
            this.panel.removeAll();
            this.panel.add((Component)inferenceTable.getComponent(), (Object)"Center");
        }
    }

    public static abstract class AbstractDrillDownSourceView<T>
    implements HDLDrillDownTable.DrillDownSourceView<T> {
        private final Collection<ChangeListener> fChangeListeners = new LinkedList<ChangeListener>();

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.add(changeListener);
        }

        protected void fireChangeEvent() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.fChangeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

