/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJButton;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class BuildButton
extends MJButton
implements ToolbarButton {
    private final boolean fFixedPoint;
    private final String fText;
    private final int fTextWidth;
    private final Icon fIcon;
    private final Icon fGrayIcon;

    public BuildButton(boolean bl) {
        this.fFixedPoint = bl;
        this.fText = bl ? CoderResources.getString("wfa.convert") : null;
        int n = this.fTextWidth = bl ? ToolbarUtils.getTextWidth(this.fText) : 0;
        if (bl) {
            this.fIcon = BuildButton.createBuildIcon(18, 18, false);
            this.fGrayIcon = BuildButton.createBuildIcon(18, 18, true);
        } else {
            this.fIcon = BuildButton.createBuildIcon(25, 24, false);
            this.fGrayIcon = BuildButton.createBuildIcon(25, 24, true);
        }
        this.setName("wfa.button.convert");
        this.setToolTipText(bl ? null : CoderResources.getString("wfa.build.tooltip"));
    }

    public void paintComponent(Graphics graphics) {
        ToolbarUtils.paint(this, graphics);
    }

    @Override
    public void paintContent(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.5f, 1, 1));
        if (this.isEnabled()) {
            this.fIcon.paintIcon((Component)((Object)this), graphics2D, this.fFixedPoint ? 5 : 0, this.getHeight() / 2 - this.fIcon.getIconHeight() / 2);
        } else {
            this.fGrayIcon.paintIcon((Component)((Object)this), graphics2D, this.fFixedPoint ? 5 : 0, this.getHeight() / 2 - this.fGrayIcon.getIconHeight() / 2);
        }
        if (this.fFixedPoint) {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.getHeight() / 2, this.getHeight() / 2);
            graphics2D.draw(double_);
            ToolbarUtils.drawString((Component)((Object)this), graphics2D, this.fText, this.fIcon.getIconWidth() + 8);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fIcon.getIconWidth() + 3 + this.fTextWidth + (this.fTextWidth == 0 ? 0 : 12), 24);
    }

    private static Icon createBuildIcon(int n, int n2, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        if (bl) {
            graphics2D.setColor(ToolbarUtils.DISABLED_COLOR);
        }
        graphics2D.setStroke(new BasicStroke(1.5f, 1, 1));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.draw(new RoundRectangle2D.Double(0.0, n2 / 2 - 2, n - 1, n2 / 2 + 1, 10.0, 10.0));
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(4.0, 0.0, 4.0, n2 / 2 - 4), false);
        generalPath.append(new Line2D.Double(4.0, n2 / 2 - 4, 2.0, n2 / 2 - 6), false);
        generalPath.append(new Line2D.Double(4.0, n2 / 2 - 4, 6.0, n2 / 2 - 6), false);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.append(new Line2D.Double(n / 2, 0.0, n / 2, n2 / 2 - 4), false);
        generalPath2.append(new Line2D.Double(n / 2, n2 / 2 - 4, n / 2 - 2, n2 / 2 - 6), false);
        generalPath2.append(new Line2D.Double(n / 2, n2 / 2 - 4, n / 2 + 2, n2 / 2 - 6), false);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath2.append(new Line2D.Double(n - 5, 0.0, n - 5, n2 / 2 - 4), false);
        generalPath2.append(new Line2D.Double(n - 5, n2 / 2 - 4, n - 7, n2 / 2 - 6), false);
        generalPath2.append(new Line2D.Double(n - 5, n2 / 2 - 4, n - 3, n2 / 2 - 6), false);
        graphics2D.draw(generalPath);
        graphics2D.draw(generalPath2);
        graphics2D.draw(generalPath3);
        if (n > 20) {
            graphics2D.fill(new Rectangle2D.Double(4.0, n2 / 2 + 3, 3.0, 3.0));
            graphics2D.fill(new Rectangle2D.Double(11.0, n2 / 2 + 3, 3.0, 3.0));
            graphics2D.fill(new Rectangle2D.Double(18.0, n2 / 2 + 3, 3.0, 3.0));
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }
}

