/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.FacetAttribute;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.AbstractStepModel;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import com.mathworks.toolbox.coder.wfa.hdltarget.ChooseTargetView;
import com.mathworks.util.Predicate;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CoderStepModel
extends AbstractStepModel {
    public static final Step CHOOSE_SOURCE_FILES_STEP = new Step("entryPoints", CoderResources.getString("wfa.entryPoints.title"), CoderResources.getIcon("wfa_choose_source_files.png")){

        @Override
        public String getName(CoderAppModel coderAppModel) {
            return coderAppModel.getFacetedAttributeValue(FacetAttribute.SUPPORTS_MULTIPLE_ENTRYPOINTS).equals(Boolean.TRUE) ? super.getName(coderAppModel) : CoderResources.getString("wfa.entryPoints.title.single");
        }
    };
    public static final Step REVIEW_POTENTIAL_ISSUES_STEP = new Step("reviewIssues", CoderResources.getString("wfa.reviewIssues.title"), CoderResources.getIcon("wfa_review_issues.png"));
    public static final Step DEFINE_INPUT_TYPES_STEP = new Step("inputTypes", CoderResources.getString("wfa.inputTypes.title"), CoderResources.getIcon("wfa_define_input_types.png"));
    public static final Step CONVERT_TO_FIXED_POINT_STEP = new Step("fixedPoint", CoderResources.getString("wfa.fixedPoint.title"), CoderStepModel.createFixedPointIcon());
    public static final Step HDL_CHOOSE_TARGET_STEP = new Step("chooseTarget", CoderResources.getString("wfa.chooseTarget.title"), CoderResources.getIcon("target3.png"));
    public static final Step GENERATE_CODE_STEP = new Step("generateCode", CoderResources.getString("wfa.generateCode.title"), CoderResources.getIcon("Build_24.png"));
    public static final Step HDL_GENERATE_CODE_STEP = new Step("generateHDLCode", CoderResources.getString("wfa.generateCode.title"), CoderResources.getIcon("Build_24.png"));
    public static final Step HDL_SYNTHESIS_STEP = new Step("synthesis", CoderResources.getString("wfa.synthesis.title"), CoderResources.getIcon("hardware.png"));
    private static final Map<Step, Predicate<CoderAppModel>> COMPLETION_PREDICATES = Collections.unmodifiableMap(CoderStepModel.createCompletionPredicates());
    private static final List<Step> ALL_STEPS = CoderStepModel.createDivergentStepList(HDL_CHOOSE_TARGET_STEP, GENERATE_CODE_STEP, HDL_GENERATE_CODE_STEP, HDL_SYNTHESIS_STEP);
    private static final List<Step> CODER_STEPS = CoderStepModel.createDivergentStepList(GENERATE_CODE_STEP);
    private static final List<Step> HDL_CODER_STEPS = CoderStepModel.createDivergentStepList(HDL_CHOOSE_TARGET_STEP, HDL_GENERATE_CODE_STEP, HDL_SYNTHESIS_STEP);
    private static final List<Step> FIXED_POINT_STEPS = CoderStepModel.createDivergentStepList(new Step[0]);
    private final CoderApp fApp;

    private static List<Step> createDivergentStepList(Step ... stepArray) {
        LinkedList<Step> linkedList = new LinkedList<Step>(Arrays.asList(CHOOSE_SOURCE_FILES_STEP, REVIEW_POTENTIAL_ISSUES_STEP, DEFINE_INPUT_TYPES_STEP));
        if (ProjectManager.hasToolbox((String)"fixedpoint")) {
            linkedList.add(CONVERT_TO_FIXED_POINT_STEP);
        }
        linkedList.addAll(Arrays.asList(stepArray));
        return Collections.unmodifiableList(linkedList);
    }

    public CoderStepModel(CoderApp coderApp, StepViewFactory stepViewFactory) {
        super(stepViewFactory);
        this.fApp = coderApp;
        this.fApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "generic-artifact") {
                    CoderStepModel.this.fireStepsChanged();
                }
            }
        });
    }

    @Override
    public List<Step> getSteps() {
        if (this.fApp.getModel().getGenericArtifact() == GenericArtifact.HDL) {
            return HDL_CODER_STEPS;
        }
        if (this.fApp.getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT) {
            return FIXED_POINT_STEPS;
        }
        return CODER_STEPS;
    }

    @Override
    public List<Step> getAllPossibleSteps() {
        return new ArrayList<Step>(ALL_STEPS);
    }

    @Override
    public String getDescription(Step step) {
        if (this.fApp.getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT && this.fApp.getModel().getArtifact() == Artifact.MEX_FILE && this.getSteps().contains(step)) {
            return CoderResources.getString("wfa." + step.getKey() + ".fixedpoint.desc");
        }
        if (step.equals(GENERATE_CODE_STEP) && this.fApp.getModel().getGenericArtifact() == GenericArtifact.HDL) {
            return CoderResources.getString("wfa.generateCode.hdl.desc");
        }
        return CoderResources.getString("wfa." + step.getKey() + ".desc");
    }

    private static Icon createFixedPointIcon() {
        int n = 24;
        int n2 = 24;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, n, n2, new Color(210, 210, 210)));
        double d = 22.0;
        double d2 = 22.0;
        double d3 = 1.0;
        double d4 = 2.0;
        graphics2D.fill(new Rectangle2D.Double(d3, d4, d - 1.0, d2 - 1.0));
        graphics2D.setColor(new Color(120, 120, 120));
        graphics2D.draw(new Rectangle2D.Double(d3, d4, d - 1.0, d2 - 1.0));
        graphics2D.setColor(new Color(0, 0, 220));
        double d5 = d3;
        double d6 = 0.7 * (double)n2;
        boolean bl = false;
        while (d6 > d4) {
            if (bl) {
                graphics2D.draw(new Line2D.Double(d5, d6, d5, Math.max(d4, d6 - 5.0)));
                d6 -= 5.0;
            } else {
                graphics2D.draw(new Line2D.Double(d5, d6, d5 + 5.0, d6));
                d5 += 5.0;
            }
            bl = !bl;
        }
        graphics2D.setColor(new Color(50, 50, 50));
        double d7 = graphics2D.getFontMetrics().getStringBounds("fi", graphics2D).getWidth();
        graphics2D.drawString("fi", (float)(d3 + d - d7 - 3.0), (float)(d4 + d2 - 3.0));
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    @Override
    protected boolean determineIfCompleted(Step step) {
        return COMPLETION_PREDICATES.get(step).accept((Object)this.fApp.getModel());
    }

    private static Map<Step, Predicate<CoderAppModel>> createCompletionPredicates() {
        HashMap<Step, Predicate<CoderAppModel>> hashMap = new HashMap<Step, Predicate<CoderAppModel>>();
        Predicate<CoderAppModel> predicate = new Predicate<CoderAppModel>(){

            public boolean accept(CoderAppModel coderAppModel) {
                return !coderAppModel.getEntryPointFileSet().getFiles().isEmpty() && !coderAppModel.hasOverwriteWarning();
            }
        };
        hashMap.put(CHOOSE_SOURCE_FILES_STEP, predicate);
        hashMap.put(REVIEW_POTENTIAL_ISSUES_STEP, predicate);
        hashMap.put(CONVERT_TO_FIXED_POINT_STEP, predicate);
        hashMap.put(DEFINE_INPUT_TYPES_STEP, new Predicate<CoderAppModel>(){

            public boolean accept(CoderAppModel coderAppModel) {
                return coderAppModel.getEntryPointWatcher().isAllValid();
            }
        });
        hashMap.put(GENERATE_CODE_STEP, new Predicate<CoderAppModel>(){

            public boolean accept(CoderAppModel coderAppModel) {
                return coderAppModel.isBuilt();
            }
        });
        hashMap.put(HDL_CHOOSE_TARGET_STEP, new Predicate<CoderAppModel>(){

            public boolean accept(CoderAppModel coderAppModel) {
                Configuration configuration = coderAppModel.getConfiguration();
                String string = configuration.getParamAsString("param.hdl.SynthesisTool");
                String string2 = configuration.getParamAsString("param.hdl.TargetPlatform");
                return ChooseTargetView.isGenericAsicFpga(coderAppModel) || string != null && string2 != null && (!string.contains("No synthesis tool") || string2.equals("Generic Xilinx Platform")) && !string2.equals("Choose a platform");
            }
        });
        hashMap.put(HDL_GENERATE_CODE_STEP, (Predicate<CoderAppModel>)hashMap.get(GENERATE_CODE_STEP));
        hashMap.put(HDL_SYNTHESIS_STEP, new Predicate<CoderAppModel>(){

            public boolean accept(CoderAppModel coderAppModel) {
                return false;
            }
        });
        return hashMap;
    }
}

