/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class InternalUtilities {
    private static final Pattern TYPE_LITERAL_PATTERN = Pattern.compile("'numerictype\\(.+?\\)'");

    private InternalUtilities() {
    }

    public static void convertAllLiteralTypesInDir(String string, int n, int n2) {
        InternalUtilities.convertAllLiteralTypesInDir(new File(Utilities.getCurrentDirectory(), string), n, n2);
    }

    public static void convertAllLiteralTypesInDir(File file, int n, int n2) {
        for (File file2 : file.listFiles()) {
            if (!CoderFileSupport.isMatlabSourceFile(file2)) continue;
            try {
                InternalUtilities.convertAllLiteralTypes(file2, n, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void convertAllLiteralTypes(File file, int n, int n2) throws IOException {
        String string;
        String string2 = CoderFileSupport.loadMatlabSource(file);
        if (string2 == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = TYPE_LITERAL_PATTERN.matcher(string2);
        while (matcher.find()) {
            string = matcher.group();
            NumericType numericType = NumericType.parse(Utilities.unquote(string));
            if (numericType != null && numericType.getWordLength() == n) {
                string = Utilities.quote(InternalUtilities.convertNumericType(numericType, n2));
            }
            matcher.appendReplacement(stringBuffer, string);
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        if (!string.equals(string2)) {
            file.setWritable(true);
            CoderFileSupport.writeMatlabSource(stringBuffer.toString(), file);
            System.out.println("Processed file: " + file.getName());
        } else {
            System.out.println("File unchanged: " + file.getName());
        }
    }

    @NotNull
    public static String convertNumericType(String string, int n) {
        NumericType numericType = NumericType.parse(string);
        return numericType != null ? InternalUtilities.convertNumericType(numericType, n) : string;
    }

    @NotNull
    public static String convertNumericType(@NotNull NumericType numericType, int n) {
        if (numericType.isAutoScaling() || numericType.isScaledDouble() || numericType.getSignedness() == NumericType.Signedness.AUTO) {
            return numericType.toString();
        }
        double d = Math.pow(2.0, numericType.getWordLength() - (numericType.isSigned() ? 1 : 0)) - 1.0;
        double d2 = Math.pow(2.0, n - (numericType.isSigned() ? 1 : 0)) - 1.0;
        double d3 = (double)numericType.getFractionLength() - (Math.log(d) - Math.log(d2)) / Math.log(2.0);
        return new NumericType(numericType.isSigned(), n, (int)Math.round(d3), false).toString();
    }
}

