/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerFileWidget;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class UnsupportedFunctionDisplay {
    private final MJPanel fComponent;
    private final ScreenerReportModel fModel;
    private final FunctionList fFunctionList;
    private final InfoBox fInfoBox;
    private final MJRadioButton fViewByCaller;
    private final MJRadioButton fViewByCallee;
    private final boolean fSimpleView;
    private static final int VIEWABLE_FUNCTION_COUNT = 7;

    public UnsupportedFunctionDisplay(ScreenerReportModel screenerReportModel) {
        this.fModel = screenerReportModel;
        this.fFunctionList = new FunctionList();
        this.fSimpleView = this.fModel.getFunctionsByImpact().size() == 1 || this.fModel.getFunctionInvokersByImpact().size() == 1;
        final MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fFunctionList));
        mJScrollPane.setBorder(null);
        mJScrollPane.getViewport().setBorder(null);
        mJScrollPane.setOpaque(false);
        mJScrollPane.getViewport().setOpaque(false);
        final MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d, 3dlu, fill:d, 3dlu", "fill:d"));
        mJPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)new MJLabel(CoderResources.getString("screener.unsupportedFunction.viewBy")), (Object)cellConstraints.xy(1, 1));
        this.fViewByCaller = new MJRadioButton(CoderResources.getString("screener.unsupportedFunction.byCaller"), true);
        this.fViewByCallee = new MJRadioButton(CoderResources.getString("screener.unsupportedFunction.byCallee"));
        if (!PlatformInfo.isMacintosh()) {
            this.fViewByCaller.setOpaque(false);
            this.fViewByCallee.setOpaque(false);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fViewByCaller);
        buttonGroup.add((AbstractButton)this.fViewByCallee);
        mJPanel.add((Component)this.fViewByCaller, (Object)cellConstraints.xy(3, 1));
        mJPanel.add((Component)this.fViewByCallee, (Object)cellConstraints.xy(5, 1));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                UnsupportedFunctionDisplay.this.switchView();
            }
        };
        this.fViewByCaller.addItemListener(itemListener);
        this.fViewByCallee.addItemListener(itemListener);
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (UnsupportedFunctionDisplay.this.fFunctionList.getCount() < 7) {
                    dimension.height += (7 - UnsupportedFunctionDisplay.this.fFunctionList.getCount()) * 24;
                }
                return dimension;
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!UnsupportedFunctionDisplay.this.fSimpleView) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(new Color(210, 210, 210));
                    graphics2D.drawLine(mJScrollPane.getWidth() + 1, mJScrollPane.getY(), mJScrollPane.getWidth() + 1, this.getHeight());
                    graphics2D.dispose();
                }
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = mJPanel.getPreferredSize();
                Dimension dimension2 = mJScrollPane.getPreferredSize();
                if (mJScrollPane.getVerticalScrollBar().isShowing()) {
                    dimension2.width += 12;
                }
                dimension2.width = Math.max(100, dimension2.width);
                if (UnsupportedFunctionDisplay.this.fSimpleView) {
                    UnsupportedFunctionDisplay.this.fInfoBox.setBounds(0, 0, this.getWidth(), this.getHeight());
                } else {
                    mJPanel.setBounds(this.getWidth() / 2 - dimension.width / 2, 3, dimension.width, dimension.height);
                    mJScrollPane.setBounds(0, dimension.height + 6, dimension2.width, this.getHeight() - dimension.height - 6);
                    UnsupportedFunctionDisplay.this.fInfoBox.setBounds(mJScrollPane.getX() + mJScrollPane.getWidth() + 3, mJScrollPane.getY(), this.getWidth() - (mJScrollPane.getX() + mJScrollPane.getWidth() + 3), mJScrollPane.getHeight());
                }
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.setOpaque(false);
        this.fInfoBox = new InfoBox();
        if (!this.fSimpleView) {
            this.fComponent.add((Component)mJPanel);
            this.fComponent.add((Component)mJScrollPane);
        }
        this.fComponent.add((Component)((Object)this.fInfoBox));
        this.switchView();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void switchView() {
        Iterator<Map.Entry<Object, Integer>> iterator;
        this.fFunctionList.reset();
        this.fInfoBox.reset();
        Map<File, Integer> map = this.fModel.getFunctionInvokersByImpact();
        Map<String, Integer> map2 = this.fModel.getFunctionsByImpact();
        if (this.fSimpleView && map.size() == 1) {
            iterator = map.keySet().iterator().next();
            Icon entry = UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(iterator), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
            this.fInfoBox.showFunctionDetails((File)((Object)iterator), entry, ((File)((Object)iterator)).getName());
        } else if (this.fSimpleView && map2.size() == 1) {
            iterator = map2.keySet().iterator().next();
            this.fViewByCallee.setSelected(true);
            this.fInfoBox.showFunctionDetails(null, ApplicationIcon.MATLAB_14x14.getIcon(), (String)((Object)iterator));
        }
        if (this.fViewByCallee.isSelected()) {
            for (Map.Entry<Object, Integer> entry : this.fModel.getFunctionsByImpact().entrySet()) {
                this.fFunctionList.addFunction(null, (String)entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<Object, Integer> entry : this.fModel.getFunctionInvokersByImpact().entrySet()) {
                this.fFunctionList.addFunction((File)entry.getKey(), new FileLocation((File)entry.getKey()).getNameBeforeDot(), entry.getValue());
            }
        }
    }

    private static class ScrollableInfoContent
    extends MJPanel
    implements Scrollable {
        private ScrollableInfoContent() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(0, 0);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            return fontMetrics.getAscent() + fontMetrics.getDescent();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return rectangle.height - 5;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
    }

    private static class InvocationArrow
    extends MJPanel {
        private InvocationArrow() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0x444444));
            graphics2D.setStroke(new BasicStroke(1.7f));
            graphics2D.draw(new Line2D.Double(0.0, (double)this.getHeight() / 2.0, this.getWidth(), (double)this.getHeight() / 2.0));
            graphics2D.draw(new Line2D.Double(this.getWidth() - 1, (double)this.getHeight() / 2.0, this.getWidth() - 6, 3.0));
            graphics2D.draw(new Line2D.Double(this.getWidth() - 1, (double)this.getHeight() / 2.0, this.getWidth() - 6, this.getHeight() - 3));
            graphics2D.dispose();
        }
    }

    private class InfoBox
    extends MJPanel {
        InfoBox() {
            this.setOpaque(false);
            this.reset();
        }

        public void reset() {
            this.removeAll();
            this.setLayout(new BorderLayout());
            MJLabel mJLabel = new MJLabel(CoderResources.getString("screener.moreInfo.blank"));
            mJLabel.setHorizontalAlignment(0);
            this.add((Component)mJLabel);
            this.revalidate();
            this.repaint();
        }

        public void showFunctionDetails(File file, Icon icon, String string) {
            File file2;
            Object object2;
            this.removeAll();
            ScrollableInfoContent scrollableInfoContent = new ScrollableInfoContent();
            scrollableInfoContent.setLayout(new GridBagLayout());
            scrollableInfoContent.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.anchor = 17;
            if (UnsupportedFunctionDisplay.this.fViewByCallee.isSelected()) {
                object2 = UnsupportedFunctionDisplay.this.fModel.getFunctionInvokersByImpact(string);
                Iterator<File> object3 = object2.iterator();
                while (object3.hasNext()) {
                    file2 = object3.next();
                    int n = UnsupportedFunctionDisplay.this.fModel.getFileImpact(file2).getInvocationLines(string).iterator().next();
                    ScreenerFileWidget screenerFileWidget = new ScreenerFileWidget(file2, n);
                    MJLabel mJLabel = new MJLabel(string);
                    mJLabel.setIcon((Icon)ApplicationIcon.MATLAB_14x14.getIcon());
                    MJLabel mJLabel2 = new MJLabel(" " + UnsupportedFunctionDisplay.this.fModel.getFunctionInvocationCount(file2, string));
                    mJLabel2.setForeground(new Color(0x444444));
                    scrollableInfoContent.add(screenerFileWidget.getComponent(), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    scrollableInfoContent.add((Component)((Object)new InvocationArrow()), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    scrollableInfoContent.add((Component)mJLabel, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.insets.left = 0;
                    scrollableInfoContent.add((Component)mJLabel2, gridBagConstraints);
                    gridBagConstraints.insets.left = 6;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridx = 1;
                }
            } else {
                for (Map.Entry entry : UnsupportedFunctionDisplay.this.fModel.getFunctionsByImpact(file).entrySet()) {
                    int n = UnsupportedFunctionDisplay.this.fModel.getFileImpact(file).getInvocationLines((String)entry.getKey()).iterator().next();
                    ScreenerFileWidget screenerFileWidget = new ScreenerFileWidget(file, n, icon);
                    MJLabel mJLabel = new MJLabel((String)entry.getKey());
                    mJLabel.setIcon((Icon)ApplicationIcon.MATLAB_14x14.getIcon());
                    MJLabel mJLabel3 = new MJLabel(" " + entry.getValue());
                    mJLabel3.setForeground(new Color(0x444444));
                    scrollableInfoContent.add(screenerFileWidget.getComponent(), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    scrollableInfoContent.add((Component)((Object)new InvocationArrow()), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    scrollableInfoContent.add((Component)mJLabel, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.insets.left = 0;
                    scrollableInfoContent.add((Component)mJLabel3, gridBagConstraints);
                    gridBagConstraints.insets.left = 6;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridx = 1;
                }
            }
            object2 = new MJPanel();
            object2.setOpaque(false);
            MJPanel mJPanel = new MJPanel();
            mJPanel.setOpaque(false);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = gridBagConstraints.gridy;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            scrollableInfoContent.add((Component)object2, gridBagConstraints);
            gridBagConstraints.gridx = 5;
            scrollableInfoContent.add((Component)mJPanel, gridBagConstraints);
            file2 = new MJScrollPane((Component)((Object)scrollableInfoContent));
            file2.setOpaque(false);
            file2.setBorder(null);
            file2.getViewport().setOpaque(false);
            file2.getViewport().setBorder(null);
            this.add((Component)((Object)file2), "Center");
            this.revalidate();
            this.repaint();
        }
    }

    private class FunctionList
    extends MJPanel
    implements Scrollable {
        private final GridBagConstraints fConstraints;
        private final List<FunctionNode> fFunctions;
        private int fMaxPreferredWidth;
        private int fPreferredHeight;

        FunctionList() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.fFunctions = new ArrayList<FunctionNode>();
            this.fConstraints = new GridBagConstraints();
            this.fConstraints.gridx = 0;
            this.fConstraints.gridy = 0;
            this.fConstraints.insets = new Insets(3, 3, 3, 8);
            this.fConstraints.fill = 2;
        }

        public int getCount() {
            return this.fFunctions.size();
        }

        public void addFunction(File file, String string, int n) {
            FunctionNode functionNode = new FunctionNode(this, file, string, n);
            this.fFunctions.add(functionNode);
            this.add((Component)((Object)functionNode), this.fConstraints);
            this.fMaxPreferredWidth = (int)Math.max((double)this.fMaxPreferredWidth, functionNode.getPreferredSize().getWidth() + 10.0);
            this.fPreferredHeight = (int)functionNode.getPreferredSize().getHeight();
            ++this.fConstraints.gridy;
            this.revalidate();
            this.repaint();
        }

        public void reset() {
            this.fFunctions.clear();
            this.fMaxPreferredWidth = 0;
            this.fPreferredHeight = 0;
            this.removeAll();
            this.revalidate();
            this.repaint();
        }

        public void setActive(FunctionNode functionNode) {
            for (FunctionNode functionNode2 : this.fFunctions) {
                if (functionNode2 == functionNode) continue;
                functionNode2.deactivate();
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(this.fMaxPreferredWidth + 6, (this.fPreferredHeight + 6) * Math.min(7, this.fFunctions.size()));
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            return fontMetrics.getAscent() + fontMetrics.getDescent();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return rectangle.height - 5;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class FunctionNode
    extends MJPanel {
        private boolean fActive;
        private boolean fPressed;
        private final MJLabel fLabel;
        private final MJLabel fInvocationLabel;

        FunctionNode(final FunctionList functionList, final File file, final String string, int n) {
            this.setLayout(new BorderLayout(4, 4));
            this.fLabel = new MJLabel(file != null ? file.getName() : string);
            if (UnsupportedFunctionDisplay.this.fViewByCallee.isSelected()) {
                this.fLabel.setIcon((Icon)ApplicationIcon.MATLAB_14x14.getIcon());
            } else {
                this.fLabel.setIcon(UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance()));
            }
            this.fInvocationLabel = new MJLabel(" " + n);
            this.fInvocationLabel.setForeground(new Color(0x444444));
            this.fLabel.setBorder((Border)new EmptyBorder(3, 3, 3, 0));
            this.fInvocationLabel.setBorder((Border)new EmptyBorder(3, 0, 3, 5));
            this.add((Component)this.fInvocationLabel, "East");
            this.add((Component)this.fLabel, "West");
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    FunctionNode.this.fPressed = true;
                    FunctionNode.this.revalidate();
                    FunctionNode.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    FunctionNode.this.fPressed = false;
                    FunctionNode.this.revalidate();
                    FunctionNode.this.repaint();
                    if (FunctionNode.this.contains(mouseEvent.getPoint())) {
                        UnsupportedFunctionDisplay.this.fInfoBox.showFunctionDetails(file, FunctionNode.this.fLabel.getIcon(), string);
                        FunctionNode.this.fActive = true;
                        functionList.setActive(FunctionNode.this);
                        FunctionNode.this.revalidate();
                        FunctionNode.this.repaint();
                    }
                }
            });
        }

        public void deactivate() {
            this.fActive = false;
            this.revalidate();
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 12.0, 12.0);
            graphics2D.setColor(Color.LIGHT_GRAY);
            if (this.fPressed || this.fActive) {
                this.fLabel.setForeground(Color.WHITE);
                this.fInvocationLabel.setForeground(Color.WHITE);
                graphics2D.setColor(new Color(120, 120, 120));
                graphics2D.fill(double_);
            } else if (this.fLabel.getForeground().equals(Color.WHITE)) {
                this.fLabel.setForeground(new MJLabel().getForeground());
                this.fInvocationLabel.setForeground(new Color(0x444444));
            }
            if (!this.fPressed && !this.fActive) {
                graphics2D.setColor(UIManager.getColor("control"));
                graphics2D.fill(double_);
            }
            graphics2D.setColor(this.fPressed || this.fActive ? Color.DARK_GRAY : Color.LIGHT_GRAY);
            graphics2D.draw(double_);
            graphics2D.dispose();
        }
    }
}

