/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.toolbox.coder.screener.FunctionInfo;
import com.mathworks.toolbox.coder.screener.ImpactModelBuilder;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.toolbox.coder.util.LRUMap;
import com.mathworks.util.tree.DefaultMutableTree;
import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.util.tree.VisitStrategy;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public final class MTreeUtils {
    private static final Method MAX_POSITION_GETTER = MTreeUtils.getMaxPositionMethod();
    private static final Map<MTree.Node, Integer> MAX_POSITION_CACHE = new LRUMap<MTree.Node, Integer>(new LRUMap.LRUPredicate<MTree.Node, Integer>(){

        @Override
        public boolean evictEldestEntry(Map.Entry<MTree.Node, Integer> entry, Map<MTree.Node, Integer> map) {
            return true;
        }
    });

    private MTreeUtils() {
    }

    public static List<MTree.Node> findAsList(ScreenerTarget screenerTarget, String string, MTree mTree, MTree.NodeType ... nodeTypeArray) {
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        TreeUtils.find(MTreeUtils.findAsTree(screenerTarget, string, mTree, nodeTypeArray), (VisitStrategy)new VisitStrategy(TreeUtils.yes()), arrayList);
        assert (!arrayList.isEmpty());
        arrayList.remove(0);
        return arrayList;
    }

    public static Tree<MTree.Node> findAsTree(ScreenerTarget screenerTarget, String string, MTree mTree, MTree.NodeType ... nodeTypeArray) {
        EnumSet<MTree.NodeType> enumSet = EnumSet.copyOf(Arrays.asList(nodeTypeArray));
        MTree.Node node = MTree.parse((String)"disp").getRoot();
        DefaultMutableTree defaultMutableTree = new DefaultMutableTree((Object)node);
        MTreeUtils.find(screenerTarget, string, (DefaultMutableTree<MTree.Node>)defaultMutableTree, node, mTree.getRoot(), enumSet);
        return defaultMutableTree;
    }

    private static void find(ScreenerTarget screenerTarget, String string, DefaultMutableTree<MTree.Node> defaultMutableTree, MTree.Node node, MTree.Node node2, Set<MTree.NodeType> set) {
        for (MTree.Node node3 = node2; node3 != MTree.NULL_NODE; node3 = node3.getNext()) {
            try {
                if ((node3.getType() == MTree.NodeType.IFHEAD || node3.getType() == MTree.NodeType.ELSEIF) && MTreeUtils.constantFold(screenerTarget, string, node3.getLeft(), false) == Boolean.FALSE) {
                    continue;
                }
            }
            catch (FoldException foldException) {
                // empty catch block
            }
            if (node3.getType() == MTree.NodeType.FUNCTION && FunctionInfo.isExemptMethodName(node3.getFunctionName().getText()) || node3.getType() == MTree.NodeType.SUBSCR && node3.getLeft().getType() == MTree.NodeType.DOT && ImpactModelBuilder.assembleQualifiedName(node3.getLeft()).equals("matlab.system.StringSet") || node3.getLeft().isTextSupported() && node3.getLeft().getText().equals("StringSet")) continue;
            MTree.Node node4 = node;
            if (set.contains(node3.getType())) {
                defaultMutableTree.addChild((Object)node, (Object)node3);
                node4 = node3;
            }
            MTreeUtils.find(screenerTarget, string, defaultMutableTree, node4, node3.getLeft(), set);
            MTreeUtils.find(screenerTarget, string, defaultMutableTree, node4, node3.getRight(), set);
        }
    }

    private static Object constantFold(ScreenerTarget screenerTarget, String string, MTree.Node node, boolean bl) throws FoldException {
        if (node.getType() == MTree.NodeType.CALL) {
            if (bl || !node.getLeft().isTextSupported()) {
                throw new FoldException();
            }
            String string2 = node.getLeft().getText();
            MTree.Node node2 = node.getRight();
            if (string2.equals("isempty")) {
                return MTreeUtils.constantFold(screenerTarget, string, node2, false) == null;
            }
            if (string2.equals("strcmp")) {
                Object object;
                Object object2 = MTreeUtils.constantFold(screenerTarget, string, node.getRight(), false);
                return object2 == (object = MTreeUtils.constantFold(screenerTarget, string, node.getRight().getNext(), false)) || object2 != null && object != null && object2.equals(object);
            }
            if (string2.equals("true")) {
                return Boolean.TRUE;
            }
            if (string2.equals("false")) {
                return Boolean.FALSE;
            }
            throw new FoldException();
        }
        if (node.getType() == MTree.NodeType.DOT) {
            if (node.getLeft().isTextSupported() && node.getRight().isTextSupported() && node.getLeft().getText().equals("coder") && node.getRight().getText().equals("target")) {
                return MTreeUtils.constantFoldTarget(screenerTarget, bl);
            }
        } else {
            if (node.getType() == MTree.NodeType.PARENS) {
                return MTreeUtils.constantFold(screenerTarget, string, node.getLeft(), bl);
            }
            if (node.getType() == MTree.NodeType.STRING) {
                if (bl) {
                    throw new FoldException();
                }
                if (!node.isTextSupported()) {
                    try {
                        return string.substring(node.getPosition(), node.getPosition() + node.getSize() - 2);
                    }
                    catch (Exception exception) {
                        throw new FoldException();
                    }
                }
                return node.getText();
            }
            if (node.getType() == MTree.NodeType.SUBSCR) {
                Object object = MTreeUtils.constantFold(screenerTarget, string, node.getLeft(), true);
                if (object != null && object.equals("coder.target")) {
                    if (node.getRight() == MTree.NULL_NODE) {
                        return MTreeUtils.constantFoldTarget(screenerTarget, bl);
                    }
                    Object object3 = MTreeUtils.constantFold(screenerTarget, string, node.getRight(), false);
                    if (object3 == null) {
                        throw new FoldException();
                    }
                    if (screenerTarget == ScreenerTarget.HDL) {
                        return object3.equals("HDL");
                    }
                    if (screenerTarget == ScreenerTarget.C) {
                        return object3.equals("Rtw");
                    }
                    return object3.equals("MEX");
                }
            } else {
                if (node.getType() == MTree.NodeType.ID && node.isTextSupported()) {
                    if (bl) {
                        return node.getText();
                    }
                    if (node.getText().equals("true")) {
                        return Boolean.TRUE;
                    }
                    if (node.getText().equals("false")) {
                        return Boolean.FALSE;
                    }
                    throw new FoldException();
                }
                if (node.getType() == MTree.NodeType.EQ) {
                    Object object;
                    if (bl) {
                        throw new FoldException();
                    }
                    Object object4 = MTreeUtils.constantFold(screenerTarget, string, node.getLeft(), false);
                    return object4 == (object = MTreeUtils.constantFold(screenerTarget, string, node.getRight(), false)) || object4 != null && object != null && object4.equals(object);
                }
                if (node.getType() == MTree.NodeType.NOT) {
                    if (bl) {
                        throw new FoldException();
                    }
                    Object object = MTreeUtils.constantFold(screenerTarget, string, node.getLeft(), false);
                    return object == null || object == Boolean.FALSE;
                }
                if (node.getType() == MTree.NodeType.NE) {
                    Object object;
                    if (bl) {
                        throw new FoldException();
                    }
                    Object object5 = MTreeUtils.constantFold(screenerTarget, string, node.getLeft(), false);
                    return object5 != (object = MTreeUtils.constantFold(screenerTarget, string, node.getRight(), false)) && (object5 == null || object == null || !object5.equals(object));
                }
            }
        }
        throw new FoldException();
    }

    private static String constantFoldTarget(ScreenerTarget screenerTarget, boolean bl) {
        if (bl) {
            return "coder.target";
        }
        if (screenerTarget == ScreenerTarget.HDL) {
            return "hdl";
        }
        if (screenerTarget == ScreenerTarget.C) {
            return "rtw";
        }
        return "mex";
    }

    public static int getPosition(MTree.Node node, BaseDocument baseDocument) {
        return MTreeUtils.convertBytePositionToStringPosition(baseDocument, node.getStartLine() - 1, node.getStartColumn() - 1);
    }

    public static int getMinimumPosition(MTree.Node node, BaseDocument baseDocument) {
        while (!node.getLeft().equals(MTree.NULL_NODE) && node.getLeft().getPosition() <= node.getPosition()) {
            node = node.getLeft();
        }
        return MTreeUtils.getPosition(node, baseDocument);
    }

    public static int convertBytePositionToStringPosition(BaseDocument baseDocument, int n, int n2) {
        return MTreeUtils.convertBytePositionPlusAdditionalBytesToStringPosition(baseDocument, n, n2, 0);
    }

    private static int convertBytePositionPlusAdditionalBytesToStringPosition(BaseDocument baseDocument, int n, int n2, int n3) {
        int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        int n5 = n2;
        try {
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4);
            int n7 = n6 - n4 + n3;
            n7 = Math.min(n7, baseDocument.getLength() - n4);
            n5 = MTreeUtils.convertFromByteToChar(n2 + n3, baseDocument, n4, n7);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        return n4 + n5;
    }

    private static int convertFromByteToChar(int n, BaseDocument baseDocument, int n2, int n3) throws BadLocationException {
        int n4 = n;
        try {
            String string = baseDocument.getText(n2, n3);
            byte[] byArray = string.getBytes("UTF-8");
            n = Math.min(byArray.length, n);
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            n4 = new String(byArray2, "UTF-8").length();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
        return n4;
    }

    public static MTree.Node getNodeAtPosition(MTree mTree, int n, BaseDocument baseDocument, boolean bl) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)baseDocument);
        MTree.Node node = mTree.getRoot();
        return MTreeUtils.getNodeAtPositionUnderNode(n, node, baseDocument, bl);
    }

    private static MTree.Node getNodeAtPositionUnderNode(int n, MTree.Node node, BaseDocument baseDocument, boolean bl) {
        List list = node.getListOfNextNodes();
        for (MTree.Node node2 : list) {
            if (!MTreeUtils.positionInsideNode(n, node2, baseDocument, bl)) continue;
            MTree.Node node3 = null;
            if (MTreeUtils.positionInsideNodeList(n, node2.getLeft(), baseDocument)) {
                node3 = MTreeUtils.getNodeAtPositionUnderNode(n, node2.getLeft(), baseDocument, bl);
            } else if (MTreeUtils.positionInsideNodeList(n, node2.getRight(), baseDocument)) {
                node3 = MTreeUtils.getNodeAtPositionUnderNode(n, node2.getRight(), baseDocument, bl);
            }
            return node3 == null ? node2 : node3;
        }
        return null;
    }

    private static boolean positionInsideNode(int n, MTree.Node node, BaseDocument baseDocument, boolean bl) {
        return MTreeUtils.getMinimumPosition(node, baseDocument) <= n && (bl ? MTreeUtils.getMaximumPosition(node, baseDocument) >= n : MTreeUtils.getMaximumPosition(node, baseDocument) > n);
    }

    private static boolean positionInsideNodeList(int n, MTree.Node node, BaseDocument baseDocument) {
        List list = node.getListOfNextNodes();
        return !list.isEmpty() && MTreeUtils.getMinimumPosition((MTree.Node)list.get(0), baseDocument) <= n && MTreeUtils.getMaximumPosition((MTree.Node)list.get(list.size() - 1), baseDocument) >= n;
    }

    public static int getMaximumPosition(MTree.Node node, BaseDocument baseDocument) {
        MTree.Node node2 = node.getRightmostNode();
        int n = MTreeUtils.maxPosition(node) - node2.getPosition() + 1;
        if (n < 0) {
            return -1;
        }
        assert (n > 0) : "Distance to end of subtree should be non-zero";
        return MTreeUtils.convertBytePositionPlusAdditionalBytesToStringPosition(baseDocument, node2.getStartLine() - 1, node2.getStartColumn() - 1, n);
    }

    private static int maxPosition(MTree.Node node) {
        Integer n = MAX_POSITION_CACHE.get(node);
        if (n == null) {
            try {
                Object object = MAX_POSITION_GETTER.invoke((Object)node, new Object[0]);
                n = object != null ? ((Number)object).intValue() : -1;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                n = -1;
            }
            MAX_POSITION_CACHE.put(node, n);
        }
        return n;
    }

    private static Method getMaxPositionMethod() {
        try {
            Method method = MTree.Node.class.getDeclaredMethod("getMaximumPosition", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Missing MTree Method");
        }
    }

    private static class FoldException
    extends Exception {
        private FoldException() {
        }
    }
}

