/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.model.AnnotatedMetadataTree;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.FieldNature;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.UnifiedSerializationStrategy;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFimath;
import com.mathworks.toolbox.coder.util.ExpressionTree;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class UnifiedModel {
    public static final String XML_USER_NODE = "UserEntities";
    public static final String XML_COMPUTED_NODE = "ComputedEntities";
    public static final String VARIABLE_NAMES_PROPERTY = "VariableNames";
    public static final String VARIABLE_KINDS_PROPERTY = "VariableKinds";
    public static final String FIELD_DEFINITIONS_PROPERTY = "FieldNatures";
    public static final String KEY_TREE_PROPERTY = "KeyTree";
    public static final String CALL_TREE_PROPERTY = "CallTree";
    public static final String EXPRESSION_PROPERTY = "ExpressionPosition";
    public static final String MATLAB_TYPES_PROPERTY = "MatlabTypes";
    public static final Converter<Variable, Variable> FIELD_ACCESS_DISQUALIFIER = UnifiedModel.createDefaultFieldDisqualifier();
    private final PropertyChangeSupport fPropertySupport;
    private final UnifiedSerializationStrategy fPersistenceStrategy;
    private MetadataTree<?> fKeyTree;
    private MetadataTree<VariableKind> fVariableNames;
    private MetadataTree<VariableKind> fVariableKinds;
    private MetadataTree<FieldNature> fFieldNatures;
    private Map<String, PropertyChangeEvent> fPropertyEvents;
    private MetadataTree<MatlabType> fMatlabTypes;
    private Map<String, Function> fLegacyFunctions;
    private Map<Function, ExpressionTree> fExpressions;
    private CallTree fCallTree;

    public UnifiedModel() {
        this(null);
    }

    public UnifiedModel(UnifiedSerializationStrategy unifiedSerializationStrategy) {
        this.fPersistenceStrategy = unifiedSerializationStrategy != null ? unifiedSerializationStrategy : new ConversionSerializer();
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    protected static String createPropertyName(String string, FunctionScopedKey functionScopedKey) {
        return string + functionScopedKey.getFunction() + ":" + functionScopedKey.toString();
    }

    public final void reset(boolean bl) {
        this.fKeyTree = this.fVariableNames;
        this.resetExtensions(bl);
        this.fPropertyEvents = null;
    }

    protected void resetExtensions(boolean bl) {
    }

    public void deserialize(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, UnifiedSerializationStrategy.DeserializationExtender deserializationExtender, boolean bl) {
        this.fPersistenceStrategy.deserialize(xmlSourcePolicy, deserializationExtender != null ? deserializationExtender : new UnifiedSerializationStrategy.DeserializationExtender(){

            @Override
            public void deserializeColumn(Function function, Variable variable, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            @Override
            public void deserializeColumn(Function function, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }
        }, bl);
    }

    public void serialize(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, UnifiedSerializationStrategy.SerializationExtender serializationExtender) {
        this.fPersistenceStrategy.serialize(xmlSourcePolicy, serializationExtender != null ? serializationExtender : new UnifiedSerializationStrategy.SerializationExtender(){

            @Override
            public void serializeFunctionExtensions(Function function, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            @Override
            public void serializeVariableExtensions(Variable variable, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            @Override
            public void serializeAdditionalExtensions(UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            @Override
            public boolean shouldSerializeFunction(Function function) {
                return true;
            }

            @Override
            public boolean shouldSerializeVariable(Variable variable) {
                return true;
            }
        });
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.fPropertyEvents == null) {
            this.fPropertySupport.firePropertyChange(string, object, object2);
        } else {
            this.queuePropertyChangeEvent(string, object, object2);
        }
    }

    protected final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPropertyEvents == null) {
            this.fPropertySupport.firePropertyChange(propertyChangeEvent);
        } else {
            this.queuePropertyChangeEvent(propertyChangeEvent);
        }
    }

    protected final void startBatchingPropertyChangeEvents() {
        this.fPropertyEvents = new LinkedHashMap<String, PropertyChangeEvent>();
    }

    protected final void fireBatchedPropertyChangeEvents() {
        if (this.fPropertyEvents != null) {
            LinkedList<PropertyChangeEvent> linkedList = new LinkedList<PropertyChangeEvent>(this.fPropertyEvents.values());
            this.fPropertyEvents = null;
            for (PropertyChangeEvent propertyChangeEvent : linkedList) {
                this.fPropertySupport.firePropertyChange(propertyChangeEvent);
            }
        }
    }

    protected final void queuePropertyChangeEvent(String string, Object object, Object object2) {
        if (this.fPropertyEvents != null) {
            if (this.fPropertyEvents.containsKey(string)) {
                PropertyChangeEvent propertyChangeEvent = this.fPropertyEvents.get(string);
                object = this.fPropertyEvents.get(string).getOldValue();
            }
            if (object == null || object2 == null || !object.equals(object2)) {
                this.queuePropertyChangeEvent(new PropertyChangeEvent(this, string, object, object2));
            }
        } else {
            this.firePropertyChange(string, object, object2);
        }
    }

    protected final void queuePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        this.fPropertyEvents.put(propertyChangeEvent.getPropertyName(), new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
    }

    public final CallTree getCallTree() {
        return this.fCallTree;
    }

    public final void setCallTree(CallTree callTree) {
        CallTree callTree2 = this.fCallTree;
        this.fCallTree = callTree;
        this.queuePropertyChangeEvent(CALL_TREE_PROPERTY, callTree2, callTree);
    }

    public final boolean hasFunction(Function function) {
        return this.getFunctions().contains(function);
    }

    public List<Function> getFunctions() {
        MetadataTree<?> metadataTree = this.getKeyTree();
        return metadataTree != null ? metadataTree.getFunctions() : new LinkedList<Function>();
    }

    public final Map<File, List<Function>> getFunctionsByFile() {
        HashMap<File, List<Function>> hashMap = new HashMap<File, List<Function>>();
        List<Function> list = this.getFunctions();
        if (list != null) {
            for (Function function : this.getFunctions()) {
                LinkedList<Function> linkedList = (LinkedList<Function>)hashMap.get(function.getFile());
                if (linkedList == null) {
                    linkedList = new LinkedList<Function>();
                    hashMap.put(function.getFile(), linkedList);
                }
                linkedList.add(function);
            }
        }
        return hashMap;
    }

    public final List<Variable> getVariables(Function function) {
        return this.fKeyTree.getKeys(function, Variable.class);
    }

    public final boolean hasVariable(Variable variable) {
        return this.fKeyTree.get(variable) != null;
    }

    public final boolean hasVariableNames() {
        return this.fVariableNames != null;
    }

    public final boolean hasExpressions() {
        return this.fExpressions != null;
    }

    public final boolean hasExpressions(Function function) {
        return this.fExpressions != null && this.fExpressions.containsKey(function);
    }

    public final boolean hasCallTree() {
        return this.fCallTree != null;
    }

    @Nullable
    public final ExpressionTree getExpressions(Function function) {
        return this.fExpressions.get(function);
    }

    public MetadataTree<VariableKind> getVariableKinds() {
        return this.fVariableKinds;
    }

    public final void setVariableKinds(MetadataTree<VariableKind> metadataTree) {
        MetadataTree<VariableKind> metadataTree2 = this.fVariableKinds;
        this.fVariableKinds = metadataTree;
        this.fPropertySupport.firePropertyChange(VARIABLE_KINDS_PROPERTY, metadataTree2, metadataTree);
    }

    public final boolean hasVariableKinds() {
        return this.fVariableKinds != null;
    }

    public final VariableKind getVariableKind(Variable variable) {
        VariableKind variableKind = this.fVariableKinds.get(variable);
        if (variableKind == null && variable.getName().contains(".")) {
            Variable variable2 = new Variable(variable.getFunction(), variable.getName().substring(0, variable.getName().indexOf(".")));
            variableKind = this.fVariableKinds.get(variable2);
        }
        return variableKind;
    }

    public Collection<Function> getEntryPointFunctions() {
        LinkedList<Function> linkedList = new LinkedList<Function>();
        for (Function function : this.getFunctions()) {
            if (!function.isEntryPointFunction()) continue;
            linkedList.add(function);
        }
        return linkedList;
    }

    public Function getEntryPointFunction(File file) {
        LinkedList linkedList = (LinkedList)this.getFunctionsByFile().get(file);
        if (linkedList == null) {
            return null;
        }
        linkedList = new LinkedList(linkedList);
        for (Function function : linkedList) {
            if (!function.isEntryPointFunction()) continue;
            return function;
        }
        return null;
    }

    public Collection<Function> getSubFunctions() {
        LinkedList<Function> linkedList = new LinkedList<Function>();
        for (Function function : this.getFunctions()) {
            if (function.isEntryPointFunction()) continue;
            linkedList.add(function);
        }
        return linkedList;
    }

    public MetadataTree<VariableKind> getVariableNames() {
        return this.fVariableNames;
    }

    protected void setVariableNames(MetadataTree<VariableKind> metadataTree) {
        MetadataTree<VariableKind> metadataTree2 = this.fVariableNames;
        this.fVariableNames = metadataTree;
        this.queuePropertyChangeEvent(VARIABLE_KINDS_PROPERTY, metadataTree2, metadataTree);
    }

    private void transformLegacyMetadata() {
        HashMap<String, Function> hashMap = new HashMap<String, Function>();
        for (Function object : this.getFunctions()) {
            hashMap.put(object.toString(), object);
            if (object.getName().equals(object.toString())) continue;
            if (hashMap.get(object.getName()) != null) {
                hashMap.remove(object.getName());
                continue;
            }
            hashMap.put(object.getName(), object);
        }
        for (Map.Entry entry : this.fLegacyFunctions.entrySet()) {
            int n;
            Function function = (Function)hashMap.get(entry.getKey());
            Function function2 = (Function)entry.getValue();
            if (function == null && (n = ((String)entry.getKey()).indexOf("_")) > 0 && n < ((String)entry.getKey()).length() - 1) {
                String string = ((String)entry.getKey()).substring(0, n);
                if (Pattern.compile("f[\\d]*").matcher(string).matches()) {
                    function = (Function)hashMap.get(((String)entry.getKey()).substring(n + 1));
                }
            }
            if (function == null) continue;
            this.transformLegacyFunction(function2, function);
        }
        this.fLegacyFunctions = null;
    }

    protected void transformLegacyFunction(Function function, Function function2) {
    }

    public final MatlabType getMatlabType(FunctionScopedKey functionScopedKey) {
        if (this.fMatlabTypes == null) {
            return null;
        }
        return this.fMatlabTypes.get(functionScopedKey);
    }

    public final MetadataTree<?> getKeyTree() {
        return this.fKeyTree;
    }

    protected void setKeyTree(MetadataTree<?> metadataTree) {
        MetadataTree<?> metadataTree2 = this.fKeyTree;
        this.fKeyTree = metadataTree;
        this.queuePropertyChangeEvent(KEY_TREE_PROPERTY, metadataTree2, metadataTree);
    }

    public MetadataTree<MatlabType> getMatlabTypes() {
        return this.fMatlabTypes;
    }

    protected void setMatlabTypes(MetadataTree<MatlabType> metadataTree) {
        MetadataTree<MatlabType> metadataTree2 = this.fMatlabTypes;
        this.fMatlabTypes = metadataTree;
        this.queuePropertyChangeEvent(MATLAB_TYPES_PROPERTY, metadataTree2, metadataTree);
    }

    public final void setExpressions(Collection<Expression> collection) {
        Map<Function, ExpressionTree> map = this.fExpressions;
        HashMap<Function, LinkedList<Expression>> hashMap = new HashMap<Function, LinkedList<Expression>>();
        for (Expression object : collection) {
            LinkedList<Expression> linkedList = (LinkedList<Expression>)hashMap.get(object.getFunction());
            if (linkedList == null) {
                linkedList = new LinkedList<Expression>();
                hashMap.put(object.getFunction(), linkedList);
            }
            linkedList.add(object);
        }
        this.fExpressions = new HashMap<Function, ExpressionTree>();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.fExpressions.put((Function)entry.getKey(), new ExpressionTree((Collection)entry.getValue()));
        }
        this.queuePropertyChangeEvent(EXPRESSION_PROPERTY, map, this.fExpressions);
    }

    public final void setVariableNames(MetadataTree<VariableKind> metadataTree, MetadataTree<MatlabType> metadataTree2) {
        MetadataTree<VariableKind> metadataTree3 = this.fVariableNames;
        this.fVariableNames = metadataTree;
        this.fMatlabTypes = metadataTree2;
        this.setKeyTree(metadataTree);
        if (this.fLegacyFunctions != null && this.getKeyTree() != null && !this.getKeyTree().getFunctions().isEmpty()) {
            this.transformLegacyMetadata();
        }
        this.queuePropertyChangeEvent(VARIABLE_NAMES_PROPERTY, metadataTree3, metadataTree);
    }

    public final void setFieldNatures(MetadataTree<FieldNature> metadataTree) {
        MetadataTree<FieldNature> metadataTree2 = this.fFieldNatures;
        this.fFieldNatures = metadataTree;
        this.queuePropertyChangeEvent(FIELD_DEFINITIONS_PROPERTY, metadataTree2, metadataTree);
    }

    public final boolean hasFieldNatures() {
        return this.fFieldNatures != null;
    }

    public final boolean hasFieldNature(Variable variable) {
        return this.fFieldNatures != null && this.fFieldNatures.get(variable) != null;
    }

    public final FieldNature getFieldNature(Variable variable) {
        return this.hasFieldNature(variable) ? this.fFieldNatures.get(variable) : null;
    }

    public final Variable getUnqualifiedField(Variable variable) {
        Variable variable2 = (Variable)FIELD_ACCESS_DISQUALIFIER.convert((Object)variable);
        return variable2 != null ? variable2 : variable;
    }

    private static Converter<Variable, Variable> createDefaultFieldDisqualifier() {
        return new Converter<Variable, Variable>(){

            public Variable convert(Variable variable) {
                int n = variable.getName().indexOf(46);
                Variable variable2 = null;
                if (n != -1) {
                    String string = variable.getName().substring(n + 1);
                    variable2 = new Variable(variable.getFunction(), string);
                }
                return variable2;
            }
        };
    }

    static String createStructAccessString(Variable variable, String string) {
        return variable.getName() + '.' + string;
    }

    private class ConversionSerializer
    implements UnifiedSerializationStrategy {
        private final Map<Class<?>, Converter<Object, String>> fEnumConverters = new HashMap();

        private ConversionSerializer() {
        }

        @Override
        public <T extends Enum<T>> void setEnumConverter(final Class<T> clazz, final Converter<T, String> converter) {
            this.fEnumConverters.put(clazz, new Converter<Object, String>(){

                public String convert(Object object) {
                    return clazz.isInstance(object) ? (String)converter.convert(clazz.cast(object)) : null;
                }
            });
        }

        @Override
        public void serialize(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, UnifiedSerializationStrategy.SerializationExtender serializationExtender) {
            if (UnifiedModel.this.getKeyTree() == null) {
                return;
            }
            XmlWriter xmlWriter = XmlApi.getInstance().create(UnifiedModel.XML_USER_NODE);
            XmlWriter xmlWriter2 = XmlApi.getInstance().create(UnifiedModel.XML_COMPUTED_NODE);
            for (Function function : UnifiedModel.this.getFunctions()) {
                if (!serializationExtender.shouldSerializeFunction(function)) continue;
                XmlWriter xmlWriter3 = this.createFunctionRoot(xmlSourcePolicy, xmlWriter, function);
                XmlWriter xmlWriter4 = this.createFunctionRoot(xmlSourcePolicy, xmlWriter2, function);
                for (Variable variable : UnifiedModel.this.getVariables(function)) {
                    if (!serializationExtender.shouldSerializeVariable(variable)) continue;
                    XmlWriter xmlWriter5 = xmlWriter3.createElement("Variable");
                    XmlWriter xmlWriter6 = xmlWriter4.createElement("Variable");
                    xmlWriter5.writeAttribute("name", variable.getKey());
                    xmlWriter6.writeAttribute("name", variable.getKey());
                    if (UnifiedModel.this.getVariableKinds() != null) {
                        this.serializeProperty(xmlWriter6, "Kind", "String", (Object)UnifiedModel.this.getVariableKind(variable));
                    }
                    serializationExtender.serializeVariableExtensions(variable, xmlWriter5, xmlWriter6, this);
                }
                serializationExtender.serializeFunctionExtensions(function, xmlWriter3, xmlWriter4, this);
            }
            try {
                xmlSourcePolicy.setComputedXML(XmlApi.getInstance().read(xmlWriter2.getXML()));
                xmlSourcePolicy.setAnnotatedXML(XmlApi.getInstance().read(xmlWriter.getXML()));
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            serializationExtender.serializeAdditionalExtensions(this);
        }

        private XmlWriter createFunctionRoot(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, XmlWriter xmlWriter, Function function) {
            XmlWriter xmlWriter2 = xmlWriter.createElement("Function");
            xmlWriter2.writeAttribute("file", (Object)xmlSourcePolicy.convertFileToReference(function.getFile()));
            xmlWriter2.writeAttribute("name", (Object)function.getName());
            xmlWriter2.writeAttribute("uniqueId", (Object)function.getUniqueId());
            xmlWriter2.writeAttribute("specialization", (Object)function.getSpecializationName());
            xmlWriter2.writeAttribute("specializationId", (Object)function.getSpecializationId());
            return xmlWriter2;
        }

        @Override
        public <T> void serializeAnnotatedProperty(XmlWriter xmlWriter, XmlWriter xmlWriter2, String string, String string2, AnnotatedMetadataTree<T> annotatedMetadataTree, Variable variable) {
            if (annotatedMetadataTree.getComputedValues() != null) {
                this.serializeProperty(xmlWriter, string, string2, annotatedMetadataTree.getComputedValues().get(variable));
            }
            this.serializeProperty(xmlWriter2, string, string2, annotatedMetadataTree.getUserValues().get(variable));
        }

        @Override
        public void serializeProperty(XmlWriter xmlWriter, String string, String string2, Object object) {
            if (object != null && object instanceof Enum) {
                object = this.fEnumConverters.containsKey(object.getClass()) ? this.fEnumConverters.get(object.getClass()).convert(object) : ((Enum)object).name().toLowerCase(Locale.ENGLISH);
            }
            if (object != null) {
                XmlWriter xmlWriter2 = xmlWriter.createElement("Column");
                xmlWriter2.writeAttribute("property", (Object)string);
                xmlWriter2.writeAttribute("type", (Object)string2);
                xmlWriter2.writeAttribute("value", object);
            }
        }

        @Override
        public void serializeMatlabType(XmlWriter xmlWriter, MatlabType matlabType) {
            XmlWriter xmlWriter2 = xmlWriter.createElement("MATLABType");
            xmlWriter2.writeAttribute("class", (Object)matlabType.getClassName());
            xmlWriter2.writeAttribute("complex", (Object)matlabType.isComplex());
            for (int n : matlabType.getSize()) {
                xmlWriter2.writeText("size", new Object[]{n});
            }
            for (boolean bl : matlabType.getDynamicFlags()) {
                xmlWriter2.writeText("dynamic", new Object[]{bl});
            }
            if (matlabType.getNumericType() != null) {
                XmlWriter xmlWriter3 = xmlWriter2.createElement("numericType");
                xmlWriter3.writeText("signed", new Object[]{matlabType.getNumericType().isSigned()});
                xmlWriter3.writeText("wordLength", new Object[]{matlabType.getNumericType().getWordLength()});
                xmlWriter3.writeText("fractionLength", new Object[]{matlabType.getNumericType().getFractionLength()});
                xmlWriter3.writeText("fimathIsLocal", new Object[]{matlabType.isFimathLocal()});
            }
            if (matlabType.getFimath() != null) {
                XmlWriter xmlWriter4 = xmlWriter2.createElement("fimath");
                matlabType.getFimath().getData(xmlWriter4);
            }
        }

        @Override
        public MatlabType deserializeMatlabType(XmlReader xmlReader) {
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{"MATLABType"});
            if (xmlReader2.isPresent()) {
                try {
                    String string;
                    String string2 = xmlReader2.readAttribute("class");
                    boolean bl = Boolean.parseBoolean(xmlReader2.readAttribute("complex"));
                    String[] stringArray = xmlReader2.readTextList("size");
                    int[] nArray = new int[stringArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray[i]);
                    }
                    String[] stringArray2 = xmlReader2.readTextList("dynamic");
                    boolean[] blArray = new boolean[stringArray2.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        blArray[i] = stringArray2[i].equals("true");
                    }
                    NumericType numericType = null;
                    IDPFimath iDPFimath = null;
                    boolean bl2 = false;
                    XmlReader xmlReader3 = xmlReader2.getChild(new String[]{"numericType"});
                    if (xmlReader3.isPresent()) {
                        string = xmlReader3.readText("signed");
                        String string3 = xmlReader3.readText("wordLength");
                        String string4 = xmlReader3.readText("fractionLength");
                        if (string != null && string3 != null && string4 != null) {
                            bl2 = Boolean.parseBoolean(xmlReader3.readText("fimathIsLocal"));
                            numericType = new NumericType(Boolean.parseBoolean(string), Integer.parseInt(string3), Integer.parseInt(string4), false);
                        }
                    }
                    if ((string = xmlReader2.getChild(new String[]{"fimath"})).isPresent()) {
                        iDPFimath = new IDPFimath();
                        Utilities.setPropertyValues((XmlReader)string, iDPFimath);
                    }
                    return new MatlabType(string2, nArray, blArray, bl, numericType, iDPFimath, bl2);
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void deserialize(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, UnifiedSerializationStrategy.DeserializationExtender deserializationExtender, boolean bl) {
            if (bl) {
                this.deserializeRoot(xmlSourcePolicy, deserializationExtender, xmlSourcePolicy.getComputedXML(), true);
            }
            this.deserializeRoot(xmlSourcePolicy, deserializationExtender, xmlSourcePolicy.getAnnotatedXML(), false);
        }

        private void deserializeRoot(UnifiedSerializationStrategy.XmlSourcePolicy xmlSourcePolicy, UnifiedSerializationStrategy.DeserializationExtender deserializationExtender, XmlReader xmlReader, boolean bl) {
            if (xmlReader != null) {
                XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Function"});
                while (xmlReader2.isPresent()) {
                    Function function;
                    File file;
                    String string = xmlReader2.readAttribute("file");
                    String string2 = xmlReader2.readAttribute("name");
                    String string3 = xmlReader2.readAttribute("specialization");
                    String string4 = xmlReader2.readAttribute("uniqueId");
                    String string5 = xmlReader2.readAttribute("specializationId");
                    Integer n = null;
                    if (string == null) {
                        file = new File(string2);
                        if (UnifiedModel.this.fLegacyFunctions == null) {
                            UnifiedModel.this.fLegacyFunctions = new HashMap();
                        }
                        function = new Function(file, string2, string3);
                        UnifiedModel.this.fLegacyFunctions.put(string2, function);
                    } else {
                        if (string3 != null && string4 == null) {
                            string4 = string3;
                        }
                        if (string5 != null && !string5.isEmpty()) {
                            try {
                                n = Integer.valueOf(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        file = xmlSourcePolicy.convertReferenceToFile(string);
                        function = string != null && string2 != null && string4 != null && n != null ? new Function(file, string2, string4, string3, n) : new Function(file, string2, string3);
                    }
                    XmlReader xmlReader3 = xmlReader2.getChild(new String[]{"Variable"});
                    while (xmlReader3.isPresent()) {
                        Holder holder = new Holder((Object)false);
                        String string6 = xmlReader3.readAttribute("name");
                        Variable variable = new Variable(function, string6);
                        if (bl) {
                            if (UnifiedModel.this.getVariableNames() == null) {
                                UnifiedModel.this.setVariableNames(new MetadataTree<VariableKind>());
                                UnifiedModel.this.setVariableKinds(new MetadataTree<VariableKind>());
                                UnifiedModel.this.setMatlabTypes(new MetadataTree<MatlabType>());
                                UnifiedModel.this.setKeyTree(UnifiedModel.this.getVariableNames());
                            }
                            UnifiedModel.this.getVariableNames().put(variable, VariableKind.LOCAL);
                            UnifiedModel.this.getMatlabTypes().put(variable, this.deserializeMatlabType(xmlReader3));
                        }
                        XmlReader xmlReader4 = xmlReader3.getChild(new String[]{"Column"});
                        while (xmlReader4.isPresent()) {
                            deserializationExtender.deserializeColumn(function, variable, xmlReader4, bl, this);
                            xmlReader4 = xmlReader4.next();
                        }
                        xmlReader3 = xmlReader3.next();
                    }
                    deserializationExtender.deserializeColumn(function, xmlReader2, bl, this);
                    xmlReader2 = xmlReader2.next();
                }
            }
        }

        @Override
        public AbstractMap.SimpleEntry<String, String> deserializeColumnProperty(XmlReader xmlReader) {
            String string = xmlReader.readAttribute("property");
            String string2 = xmlReader.readAttribute("value");
            if (string != null && string2 != null) {
                return new AbstractMap.SimpleEntry<String, String>(string, string2);
            }
            return null;
        }
    }
}

