/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.mi;

import com.mathworks.jmi.Matlab;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmCancellationException;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.toolbox.coder.mi.MatlabInterfaceLogger;
import java.io.IOException;
import java.io.Writer;
import javax.swing.SwingUtilities;

public class FevalCommand
implements Command {
    private final String fLabel;
    private final String fFunction;
    private final Object[] fArguments;
    private int fOutputCount;
    private int fFatalErrorIndex;
    private boolean fCanceled;
    private boolean fGenericCancel;

    public FevalCommand(String string, String string2, Object ... objectArray) {
        this.fFunction = string2;
        this.fLabel = string;
        this.fArguments = (Object[])objectArray.clone();
        this.fOutputCount = 1;
        this.fFatalErrorIndex = -1;
        this.fGenericCancel = true;
    }

    public void setGenericCancel(boolean bl) {
        this.fGenericCancel = bl;
    }

    public void setOutputCount(int n) {
        this.fOutputCount = n;
    }

    public void setFatalErrorMessageIndex(int n) {
        this.fFatalErrorIndex = n;
    }

    public boolean wasCanceled() {
        return this.fCanceled;
    }

    public void execute(CommandStatus commandStatus) {
        Writer writer = FevalCommand.createOutputWriter(commandStatus);
        Writer writer2 = FevalCommand.createErrorWriter(commandStatus);
        Object[] objectArray = this.getArguments();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(this.fFunction, Integer.valueOf(this.fOutputCount), writer, writer2, objectArray);
        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
        FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
        this.fCanceled = false;
        try {
            final Object object = futureFevalResult.get();
            MatlabInterfaceLogger.logReturn(this.fFunction, this.fOutputCount, objectArray, object);
            if (!this.checkForFatalErrorMessage(object, commandStatus) && this.checkForSuccess(object, commandStatus)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FevalCommand.this.handleResult(object);
                    }
                });
                commandStatus.finished();
            } else {
                commandStatus.failed(new CommandExecutionException((Command)this));
            }
        }
        catch (MvmCancellationException mvmCancellationException) {
            MatlabInterfaceLogger.logCancellation(this.fFunction, this.fOutputCount, objectArray);
            this.fCanceled = true;
            commandStatus.canceled();
        }
        catch (MvmExecutionException mvmExecutionException) {
            MatlabInterfaceLogger.logError(this.fFunction, this.fOutputCount, objectArray, (Exception)((Object)mvmExecutionException));
            this.handleFailure(this, commandStatus, mvmExecutionException);
        }
        catch (InterruptedException interruptedException) {
            MatlabInterfaceLogger.logError(this.fFunction, this.fOutputCount, objectArray, interruptedException);
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)interruptedException));
        }
    }

    protected Object[] getArguments() {
        return this.fArguments;
    }

    protected boolean checkForFatalErrorMessage(Object object, CommandStatus commandStatus) {
        Object[] objectArray;
        if (this.fFatalErrorIndex == 0 && this.fOutputCount == 1) {
            if (object != null && !((String)object).isEmpty()) {
                commandStatus.printErrorLine((String)object);
                return true;
            }
        } else if (this.fFatalErrorIndex >= 0 && object instanceof Object[] && (objectArray = (Object[])object)[this.fFatalErrorIndex] != null && !((String)objectArray[this.fFatalErrorIndex]).isEmpty()) {
            commandStatus.printErrorLine((String)objectArray[this.fFatalErrorIndex]);
            return true;
        }
        return false;
    }

    protected boolean checkForSuccess(Object object, CommandStatus commandStatus) {
        return true;
    }

    protected void handleResult(Object object) {
    }

    public void cancel() {
        this.fCanceled = true;
        new Matlab().interrupt();
    }

    public static Writer createOutputWriter(CommandStatus commandStatus) {
        class OutputWriter
        extends Writer {
            private char[] fWriteBuffer = new char[1024];
            private int fWriteHead = 0;
            private static final int WRITE_BUFFER_SIZE = 1024;
            final /* synthetic */ CommandStatus val$status;

            OutputWriter(CommandStatus commandStatus) {
                this.val$status = commandStatus;
            }

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                for (int i = 0; i < n2; ++i) {
                    if (this.fWriteHead >= 1024) {
                        this.emitBuffer();
                    }
                    this.fWriteBuffer[this.fWriteHead++] = cArray[n + i];
                }
            }

            private void emitBuffer() {
                if (this.fWriteHead > 0) {
                    this.val$status.printOutputLine(String.copyValueOf(this.fWriteBuffer, 0, this.fWriteHead));
                    this.fWriteHead = 0;
                }
            }

            @Override
            public void flush() throws IOException {
                this.emitBuffer();
            }

            @Override
            public void close() throws IOException {
            }
        }
        return new OutputWriter(commandStatus);
    }

    public static Writer createErrorWriter(CommandStatus commandStatus) {
        class ErrorWriter
        extends Writer {
            final /* synthetic */ CommandStatus val$status;

            ErrorWriter(CommandStatus commandStatus) {
                this.val$status = commandStatus;
            }

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                this.val$status.printErrorLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
        return new ErrorWriter(commandStatus);
    }

    private void handleFailure(Command command, CommandStatus commandStatus, MvmExecutionException mvmExecutionException) {
        if (!this.wasCanceled() || !this.fGenericCancel) {
            MvmException mvmException = mvmExecutionException.getMvmCause();
            StackTraceElement[] stackTraceElementArray = mvmException.getStackTrace();
            commandStatus.printErrorLine(mvmException.getLocalizedMessage());
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                commandStatus.printErrorLine("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
            }
        }
        commandStatus.failed(new CommandExecutionException(command, (Throwable)mvmExecutionException));
    }

    public String toString() {
        return this.fLabel;
    }
}

