/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.graph;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.graph.CircuitComponent;
import com.mathworks.toolbox.coder.graph.GraphObject;
import com.mathworks.toolbox.coder.graph.GraphvizAPI;
import com.mathworks.toolbox.coder.graph.Network;
import com.mathworks.toolbox.coder.graph.Signal;
import com.mathworks.toolbox.coder.graph.SignalMap;
import com.mathworks.toolbox.coder.graph.Widget;
import com.mathworks.toolbox.coder.graph.WidgetFactory;
import com.mathworks.util.Pair;
import com.mathworks.util.RequestFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class NetworkPanel {
    private final MJPanel fComponent;
    private final Network fNetwork;
    private final WidgetFactory fFactory;
    private final RequestFilter fRelayoutLines;
    private SignalMap fSignalMap;
    private Map<CircuitComponent, Component> fComponents;
    private Map<CircuitComponent, Widget> fWidgets;
    private List<Shape> fLines;
    private List<Shape> fLineHeaders;
    private Dimension fPreferredSize;
    private Map<CircuitComponent, Rectangle> fIconBounds;
    private static final int SIGNAL_SPACING = 9;

    public NetworkPanel(Network network, WidgetFactory widgetFactory) {
        this.fNetwork = network;
        this.fFactory = widgetFactory;
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                return NetworkPanel.this.fPreferredSize;
            }

            public void paintComponent(Graphics graphics) {
                NetworkPanel.this.paintLines(graphics);
            }
        };
        this.fComponent.setLayout(null);
        this.fSignalMap = new SignalMap(this.fNetwork);
        this.fRelayoutLines = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NetworkPanel.this.layoutLines();
                        NetworkPanel.this.fComponent.revalidate();
                        NetworkPanel.this.fComponent.repaint();
                    }
                });
            }
        });
        this.layoutNetwork();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void layoutNetwork() {
        this.fPreferredSize = new Dimension();
        this.fComponents = new HashMap<CircuitComponent, Component>();
        this.fLines = new LinkedList<Shape>();
        this.fLineHeaders = new LinkedList<Shape>();
        HashMap<CircuitComponent, Dimension> hashMap = new HashMap<CircuitComponent, Dimension>();
        this.fWidgets = new HashMap<CircuitComponent, Widget>();
        for (CircuitComponent object : this.fNetwork.getComponents()) {
            Widget widget = this.fFactory.createWidget(object);
            this.fComponent.add(widget.getComponent());
            new MotionHandler(widget.getComponent());
            this.fComponents.put(object, widget.getComponent());
            hashMap.put(object, widget.getComponent().getPreferredSize());
            this.fWidgets.put(object, widget);
        }
        Map<CircuitComponent, Rectangle> map = GraphvizAPI.layout(this.fNetwork, hashMap);
        for (Map.Entry entry : map.entrySet()) {
            this.fComponents.get(entry.getKey()).setBounds((Rectangle)entry.getValue());
            ((JComponent)this.fComponents.get(entry.getKey())).revalidate();
            this.fPreferredSize.width = (int)Math.max((double)this.fPreferredSize.width, ((Rectangle)entry.getValue()).getX() + ((Rectangle)entry.getValue()).getWidth());
            this.fPreferredSize.height = (int)Math.max((double)this.fPreferredSize.height, ((Rectangle)entry.getValue()).getY() + ((Rectangle)entry.getValue()).getHeight());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkPanel.this.layoutLines();
            }
        });
    }

    private void layoutLines() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Point point;
        Object object;
        this.fLines.clear();
        this.fLineHeaders.clear();
        this.fIconBounds = new HashMap<CircuitComponent, Rectangle>();
        for (Map.Entry<CircuitComponent, Widget> object32 : this.fWidgets.entrySet()) {
            this.fIconBounds.put(object32.getKey(), object32.getValue().getIconBounds((Component)this.fComponent));
        }
        HashMap hashMap = new HashMap();
        for (Signal signal : this.fNetwork.getSignals()) {
            CircuitComponent circuitComponent = this.fSignalMap.getSource(signal);
            CircuitComponent circuitComponent2 = this.fSignalMap.getDestination(signal);
            if (circuitComponent == null || circuitComponent2 == null) continue;
            Rectangle rectangle = this.fIconBounds.get(circuitComponent);
            Rectangle rectangle2 = this.fIconBounds.get(circuitComponent2);
            object = rectangle.getLocation();
            point = rectangle2.getLocation();
            cloneable2 = new Point((int)((Point)object).getX() + (int)rectangle.getWidth(), (int)((Point)object).getY() + (int)rectangle.getHeight() / 2 - (circuitComponent.getOutputCount() - 1) * 9 / 2 + circuitComponent.getOutputIndex(signal) * 9);
            cloneable = new Point((int)point.getX(), (int)point.getY() + (int)rectangle2.getHeight() / 2 - (circuitComponent2.getInputCount() - 1) * 9 / 2 + circuitComponent2.getInputIndex(signal) * 9);
            hashMap.put(signal.getId(), new Pair((Object)cloneable2, (Object)cloneable));
        }
        Area area = new Area(new Rectangle(0, 0, this.fComponent.getWidth(), this.fComponent.getHeight()));
        for (Component component : this.fComponents.values()) {
            area.subtract(new Area(new Rectangle(component.getX() - 5, component.getY() - 5, component.getWidth() + 10, component.getHeight() + 10)));
        }
        Area area2 = new Area(area);
        for (CircuitComponent circuitComponent2 : this.fNetwork.getComponents()) {
            for (String string : circuitComponent2.getOutputs()) {
                Cloneable cloneable3;
                object = this.fNetwork.getSignal(string);
                point = (Pair)hashMap.get(((GraphObject)object).getId());
                cloneable2 = new GeneralPath();
                cloneable = new GeneralPath();
                Component component = this.fComponents.get(this.fSignalMap.getSource((Signal)object));
                Component component2 = this.fComponents.get(this.fSignalMap.getDestination((Signal)object));
                if (component2 == null) continue;
                boolean bl = this.fSignalMap.getDestination((Signal)object).getInputIndex((Signal)object) % 2 == 0;
                Rectangle rectangle = new Rectangle(component.getX() - 5, component.getY() - 5, component.getWidth() + 10, component.getHeight() + 10);
                Rectangle rectangle3 = new Rectangle(component2.getX() - 5, component2.getY() - 5, component2.getWidth() + 10, component2.getHeight() + 10);
                Point point2 = (Point)point.getFirst();
                Point point3 = new Point((int)(rectangle.getX() + rectangle.getWidth() + 1.0), (int)point2.getY());
                ((Path2D)cloneable2).append(new Line2D.Double(point2, point3), false);
                Point point4 = new Point((Point)point.getSecond());
                point = new Pair(point.getFirst(), (Object)new Point((int)(rectangle3.getX() - 1.0), (int)((Point)point.getSecond()).getY()));
                ((Path2D)cloneable2).append(new Line2D.Double((Point2D)point.getSecond(), point4), false);
                while (!point3.equals(point.getSecond())) {
                    cloneable3 = point2;
                    point2 = new Point(point3);
                    point3 = new Point(point3);
                    int n = (int)point3.getX();
                    int n2 = (int)point3.getY();
                    int n3 = 0;
                    if (((Point)point.getSecond()).getX() > point2.getX()) {
                        n3 = 1;
                    } else if (((Point)point.getSecond()).getX() < point2.getX()) {
                        n3 = -1;
                    }
                    int n4 = 0;
                    if (((Point)point.getSecond()).getY() > point2.getY()) {
                        n4 = 1;
                    } else if (((Point)point.getSecond()).getY() < point2.getY()) {
                        n4 = -1;
                    }
                    Point point5 = new Point(n + n3, n2);
                    Point point6 = new Point(n, n2 + n4);
                    if (!area.contains(point5)) {
                        point5 = point2;
                    }
                    if (!area.contains(point6)) {
                        point6 = point2;
                    }
                    if (!bl) {
                        if (!point5.equals(point2) && area2.contains(point5) && !((Path2D)cloneable2).contains(point5)) {
                            point3 = point5;
                        } else if (!(point5.equals(point2) || area2.contains(point6) || ((Path2D)cloneable2).contains(point5))) {
                            point3 = point5;
                        } else if (!point5.equals(point2) && !((Path2D)cloneable2).contains(point5)) {
                            point3 = point5;
                        } else if (!point6.equals(point2) && !((Path2D)cloneable2).contains(point6)) {
                            point3 = point6;
                        } else {
                            point5 = new Point(n - n3, n2);
                            if (!area.contains(point5)) {
                                point5 = point2;
                            }
                            point3 = !point5.equals(point2) && !((Path2D)cloneable2).contains(point5) ? point5 : new Point(n, n2 - n4);
                        }
                    } else if (!point6.equals(point2) && area2.contains(point6) && !((Path2D)cloneable2).contains(point6)) {
                        point3 = point6;
                    } else if (!(point6.equals(point2) || area2.contains(point5) || ((Path2D)cloneable2).contains(point6))) {
                        point3 = point6;
                    } else if (!point6.equals(point2) && !((Path2D)cloneable2).contains(point6)) {
                        point3 = point6;
                    } else if (!point5.equals(point2) && !((Path2D)cloneable2).contains(point5)) {
                        point3 = point5;
                    } else {
                        point6 = new Point(n, n2 - n4);
                        if (!area.contains(point6)) {
                            point6 = point2;
                        }
                        point3 = point6.equals(point2) && !((Path2D)cloneable2).contains(point6) ? point6 : new Point(n - n3, n2);
                    }
                    if (point3.equals(cloneable3)) {
                        point3 = (Point)point.getSecond();
                    }
                    ((Path2D)cloneable2).append(new Line2D.Double(point2, point3), false);
                    ((Path2D)cloneable).append(new Rectangle2D.Double(point2.getX() - 2.0, point2.getY() - 2.0, 4.0, 4.0), false);
                }
                area2.subtract(new Area((Shape)((Object)cloneable)));
                this.fLines.add((Shape)((Object)cloneable2));
                cloneable3 = new GeneralPath();
                Point point7 = new Point((int)(point4.getX() - 5.0), (int)(point4.getY() - 4.0));
                Point point8 = new Point((int)(point4.getX() - 5.0), (int)(point4.getY() + 5.0));
                ((Path2D)cloneable3).append(new Line2D.Double(point4, point7), true);
                ((Path2D)cloneable3).append(new Line2D.Double(point7, point8), true);
                ((Path2D)cloneable3).append(new Line2D.Double(point4, point8), true);
                this.fLineHeaders.add((Shape)((Object)cloneable3));
            }
        }
    }

    private void paintLines(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.fComponent.getWidth(), this.fComponent.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(120, 120, 120));
        for (Shape shape : this.fLines) {
            graphics2D.draw(shape);
        }
        for (Shape shape : this.fLineHeaders) {
            graphics2D.fill(shape);
        }
        graphics2D.dispose();
    }

    private class MotionHandler {
        private Point fStartPoint;

        MotionHandler(final Component component) {
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    MotionHandler.this.fStartPoint = mouseEvent.getPoint();
                }
            });
            component.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)NetworkPanel.this.fComponent);
                    component.setBounds((int)(point.getX() - MotionHandler.this.fStartPoint.getX()), (int)(point.getY() - MotionHandler.this.fStartPoint.getY()), component.getWidth(), component.getHeight());
                    ((JComponent)component).revalidate();
                    NetworkPanel.this.fRelayoutLines.request();
                }
            });
        }
    }
}

