/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.functionbrowser;

import com.mathworks.toolbox.coder.functionbrowser.Artifact;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserCategory;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserNode;
import com.mathworks.toolbox.coder.functionbrowser.TreePerspective;
import com.mathworks.util.MulticastChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FunctionBrowserModel {
    private final List<FunctionBrowserNode> fRoots = new ArrayList<FunctionBrowserNode>();
    private final Map<FunctionBrowserCategory, TreePerspective> fTreePerspectives = new HashMap<FunctionBrowserCategory, TreePerspective>();
    private final Map<FunctionBrowserCategory, ChangeListener> fTreePerspectiveListeners = new HashMap<FunctionBrowserCategory, ChangeListener>();
    private final Map<FunctionBrowserNode, Boolean> fExpandableCache = new HashMap<FunctionBrowserNode, Boolean>();
    private final List<FunctionBrowserNode> fRows = new ArrayList<FunctionBrowserNode>();
    private final Set<FunctionBrowserNode> fExpanded = new HashSet<FunctionBrowserNode>();
    private final MulticastChangeListener fChangeListeners = new MulticastChangeListener();

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    private void fireChange() {
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void addCategory(FunctionBrowserCategory functionBrowserCategory) {
        FunctionBrowserNode functionBrowserNode = new FunctionBrowserNode(functionBrowserCategory);
        this.fRoots.add(functionBrowserNode);
        this.fRows.add(functionBrowserNode);
        this.setExpanded(functionBrowserNode, true);
    }

    public void setTreePerspective(final FunctionBrowserCategory functionBrowserCategory, TreePerspective treePerspective) {
        ChangeListener changeListener = this.fTreePerspectiveListeners.get(functionBrowserCategory);
        if (changeListener != null) {
            this.fTreePerspectives.get(functionBrowserCategory).removeChangeListener(changeListener);
        }
        ChangeListener changeListener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FunctionBrowserModel.this.regenerateTree(functionBrowserCategory);
            }
        };
        treePerspective.addChangeListener(changeListener2);
        this.fTreePerspectiveListeners.put(functionBrowserCategory, changeListener);
        this.fTreePerspectives.put(functionBrowserCategory, treePerspective);
        FunctionBrowserNode functionBrowserNode = new FunctionBrowserNode(functionBrowserCategory);
        HashSet<FunctionBrowserNode> hashSet = new HashSet<FunctionBrowserNode>(this.fExpanded);
        this.setExpanded(functionBrowserNode, false, false);
        this.restoreExpansion(hashSet, functionBrowserNode);
        this.fireChange();
    }

    public int getRowCount() {
        return this.fRows.size();
    }

    public FunctionBrowserNode getNode(int n) {
        return this.fRows.get(n);
    }

    public boolean isExpanded(FunctionBrowserNode functionBrowserNode) {
        return this.fExpanded.contains(functionBrowserNode);
    }

    public void setExpanded(FunctionBrowserNode functionBrowserNode, boolean bl) {
        this.setExpanded(functionBrowserNode, bl, true);
    }

    public FunctionBrowserNode get(int n) {
        return this.fRows.get(n);
    }

    public boolean isExpandable(FunctionBrowserNode functionBrowserNode) {
        if (!this.fExpandableCache.containsKey(functionBrowserNode)) {
            this.fExpandableCache.put(functionBrowserNode, !this.createChildren(functionBrowserNode).isEmpty());
        }
        return this.fExpandableCache.get(functionBrowserNode);
    }

    private List<FunctionBrowserNode> setExpanded(FunctionBrowserNode functionBrowserNode, boolean bl, boolean bl2) {
        if (bl && !this.fExpanded.contains(functionBrowserNode)) {
            int n = this.fRows.indexOf(functionBrowserNode);
            List<FunctionBrowserNode> list = this.createChildren(functionBrowserNode);
            this.fExpanded.add(functionBrowserNode);
            this.fRows.addAll(n + 1, list);
            if (bl2) {
                this.fireChange();
            }
            return list;
        }
        if (!bl && this.fExpanded.contains(functionBrowserNode)) {
            int n = this.fRows.indexOf(functionBrowserNode);
            this.fExpanded.remove(functionBrowserNode);
            while (n + 1 < this.fRows.size() && this.fRows.get(n + 1).getLevel() > functionBrowserNode.getLevel()) {
                FunctionBrowserNode functionBrowserNode2 = this.fRows.remove(n + 1);
                this.fExpanded.remove(functionBrowserNode2);
                this.fExpandableCache.remove(functionBrowserNode2);
            }
            this.fExpandableCache.remove(functionBrowserNode);
            if (bl2) {
                this.fireChange();
            }
        }
        return null;
    }

    private void regenerateTree(FunctionBrowserCategory functionBrowserCategory) {
        FunctionBrowserNode functionBrowserNode = new FunctionBrowserNode(functionBrowserCategory);
        HashSet<FunctionBrowserNode> hashSet = new HashSet<FunctionBrowserNode>(this.fExpanded);
        this.setExpanded(functionBrowserNode, false, false);
        this.restoreExpansion(hashSet, functionBrowserNode);
        this.fireChange();
    }

    private void restoreExpansion(Set<FunctionBrowserNode> set, FunctionBrowserNode functionBrowserNode) {
        if (set.contains(functionBrowserNode)) {
            List<FunctionBrowserNode> list = this.setExpanded(functionBrowserNode, true, false);
            for (FunctionBrowserNode functionBrowserNode2 : list) {
                this.restoreExpansion(set, functionBrowserNode2);
            }
        }
    }

    private List<FunctionBrowserNode> createChildren(FunctionBrowserNode functionBrowserNode) {
        LinkedList<FunctionBrowserNode> linkedList;
        block3: {
            block2: {
                linkedList = new LinkedList<FunctionBrowserNode>();
                if (functionBrowserNode.getArtifact() != null) break block2;
                for (Artifact artifact : functionBrowserNode.getCategory().listRoots()) {
                    linkedList.add(new FunctionBrowserNode(functionBrowserNode, artifact));
                }
                break block3;
            }
            TreePerspective treePerspective = this.fTreePerspectives.get(functionBrowserNode.getCategory());
            if (treePerspective == null) break block3;
            for (Artifact artifact : treePerspective.getChildren(functionBrowserNode.getArtifact())) {
                linkedList.add(new FunctionBrowserNode(functionBrowserNode, artifact));
            }
        }
        return linkedList;
    }
}

