/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.functionbrowser;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.coder.functionbrowser.Artifact;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowser;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserNode;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class DefaultFunctionBrowserPainter
implements FunctionBrowserPainter {
    private final BufferedImage fBuffer = new BufferedImage(1, 1, 2);
    private Font fFont;
    private List<Rectangle2D> fRects;
    private Map<Integer, Integer> fRowsByY;
    private Map<Integer, Integer> fRowLabelX;
    private Map<Artifact, Icon> fIcons = new HashMap<Artifact, Icon>();
    private double fLineHeight;
    private int fPreferredWidth;
    private int fPreferredHeight;
    private static final int CATEGORY_MARGIN = 4;
    private static final int ROW_MARGIN = 2;
    private static final int INDENT_MARGIN = 22;
    private static final int LEFT_MARGIN = 8;
    private static final Color BACKGROUND = new Color(223, 227, 232);
    private static final Color SELECTED_BACKGROUND = new Color(197, 206, 216);

    @Override
    public void update(FunctionBrowser functionBrowser) {
        functionBrowser.getComponent().setBackground(BACKGROUND);
        if (this.fFont == null) {
            this.fFont = new MJLabel().getFont();
        }
        this.fPreferredWidth = 0;
        this.fPreferredHeight = 0;
        this.fRects = new ArrayList<Rectangle2D>(functionBrowser.getModel().getRowCount());
        this.fRowsByY = new HashMap<Integer, Integer>(functionBrowser.getModel().getRowCount());
        this.fRowLabelX = new HashMap<Integer, Integer>(functionBrowser.getModel().getRowCount());
        Graphics2D graphics2D = this.fBuffer.createGraphics();
        graphics2D.setFont(this.fFont);
        this.fLineHeight = Math.max(16.0, graphics2D.getFontMetrics().getStringBounds("Ag", graphics2D).getHeight());
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        double d = 2.0;
        for (int i = 0; i < functionBrowser.getModel().getRowCount(); ++i) {
            FunctionBrowserNode functionBrowserNode = functionBrowser.getModel().getNode(i);
            if (functionBrowserNode.getLevel() == 0 && i > 0) {
                d += 4.0;
            } else if (i > 0) {
                d += 2.0;
            }
            this.fRowsByY.put((int)d, i);
            Rectangle2D.Double double_ = new Rectangle2D.Double(2.0, d, functionBrowser.getComponent().getWidth(), this.fLineHeight);
            this.fRects.add(double_);
            String string = functionBrowserNode.getCategory().getName();
            if (functionBrowserNode.getArtifact() != null) {
                string = functionBrowserNode.getArtifact().getName();
            }
            int n = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
            this.fPreferredWidth = (int)Math.max((double)this.fPreferredWidth, ((RectangularShape)double_).getX() + (double)n + 4.0);
            this.fPreferredHeight = (int)Math.max((double)this.fPreferredHeight, ((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight());
            d += 2.0;
            if (functionBrowserNode.getArtifact() != null) {
                hashSet.add(functionBrowserNode.getArtifact());
                if (!this.fIcons.containsKey(functionBrowserNode.getArtifact())) {
                    this.fIcons.put(functionBrowserNode.getArtifact(), functionBrowserNode.getArtifact().loadIcon());
                }
            }
            double d2 = 8 + functionBrowserNode.getLevel() * 22;
            d2 = this.paintExpander(functionBrowser, graphics2D, functionBrowserNode, double_, d2);
            d2 = this.paintIcon(graphics2D, functionBrowserNode, double_, d2);
            this.fRowLabelX.put(i, (int)d2);
            d = functionBrowserNode.getLevel() == 0 ? (d += 4.0) : (d += 2.0);
            d += this.fLineHeight;
        }
        graphics2D.dispose();
        this.fIcons.keySet().retainAll(hashSet);
    }

    @Override
    public Dimension getPreferredSize(FunctionBrowser functionBrowser) {
        return new Dimension(this.fPreferredWidth, this.fPreferredHeight);
    }

    @Override
    public void paint(FunctionBrowser functionBrowser, Graphics2D graphics2D) {
        int n = functionBrowser.getComponent().getWidth();
        int n2 = functionBrowser.getComponent().getHeight();
        graphics2D.setColor(BACKGROUND);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setFont(this.fFont);
        for (int i = 0; i < this.fRects.size(); ++i) {
            Rectangle2D rectangle2D = this.fRects.get(i);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FunctionBrowserNode functionBrowserNode = functionBrowser.getModel().getNode(i);
            graphics2D.setColor(functionBrowser.getSelectedRow() == i ? SELECTED_BACKGROUND : BACKGROUND);
            graphics2D.fill(rectangle2D);
            double d = 8 + functionBrowserNode.getLevel() * 22;
            d = this.paintExpander(functionBrowser, graphics2D, functionBrowserNode, rectangle2D, d);
            d = this.paintIcon(graphics2D, functionBrowserNode, rectangle2D, d);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            this.paintText(functionBrowser, graphics2D, functionBrowserNode, rectangle2D, d);
        }
    }

    @Override
    public int getRow(FunctionBrowser functionBrowser, Point point) {
        int n = (int)point.getY();
        while ((double)n >= point.getY() - this.fLineHeight * 1.25) {
            Integer n2 = this.fRowsByY.get(n);
            if (n2 != null) {
                return n2;
            }
            --n;
        }
        return -1;
    }

    @Override
    public int getLabelRow(FunctionBrowser functionBrowser, Point point) {
        int n = (int)point.getY();
        while ((double)n >= point.getY() - this.fLineHeight * 1.25) {
            Integer n2 = this.fRowsByY.get(n);
            if (n2 != null) {
                Integer n3 = this.fRowLabelX.get(n2);
                if (point.getX() > (double)n3.intValue()) {
                    return n2;
                }
                return -1;
            }
            --n;
        }
        return -1;
    }

    @Override
    public int getExpanderRow(FunctionBrowser functionBrowser, Point point) {
        int n = this.getRow(functionBrowser, point);
        if (n == -1) {
            return -1;
        }
        FunctionBrowserNode functionBrowserNode = functionBrowser.getModel().get(n);
        if (!functionBrowser.getModel().isExpandable(functionBrowserNode)) {
            return -1;
        }
        double d = 8 + functionBrowserNode.getLevel() * 22;
        return point.getX() >= d && point.getX() <= d + 10.0 ? n : -1;
    }

    protected double paintExpander(FunctionBrowser functionBrowser, Graphics2D graphics2D, FunctionBrowserNode functionBrowserNode, Rectangle2D rectangle2D, double d) {
        if (!functionBrowser.getModel().isExpandable(functionBrowserNode)) {
            return d;
        }
        double d2 = rectangle2D.getY();
        if (functionBrowser.getModel().isExpanded(functionBrowserNode)) {
            int n = 7;
            int n2 = 8;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(d, d2 + rectangle2D.getHeight() / 2.0 + (double)(n2 / 2) - 1.0, d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0 + (double)(n2 / 2) - 1.0), true);
            generalPath.append(new Line2D.Double(d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0 + (double)(n2 / 2) - 1.0, d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0 - (double)(n2 / 2)), true);
            generalPath.append(new Line2D.Double(d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0 - (double)(n2 / 2), d, d2 + rectangle2D.getHeight() / 2.0 + (double)(n2 / 2) - 1.0), true);
            graphics2D.setColor(new Color(75, 75, 75));
            graphics2D.fill(generalPath);
            return d + (double)n + 3.0;
        }
        int n = 5;
        int n3 = 9;
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(d, d2 + rectangle2D.getHeight() / 2.0 - (double)(n3 / 2), d, d2 + rectangle2D.getHeight() / 2.0 + (double)(n3 / 2) - 1.0), true);
        generalPath.append(new Line2D.Double(d, d2 + rectangle2D.getHeight() / 2.0 + (double)(n3 / 2) - 1.0, d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0), true);
        generalPath.append(new Line2D.Double(d + (double)n - 1.0, d2 + rectangle2D.getHeight() / 2.0, d, d2 + rectangle2D.getHeight() / 2.0 - (double)(n3 / 2)), true);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(generalPath);
        graphics2D.setColor(new Color(144, 144, 144));
        graphics2D.draw(generalPath);
        return d + 10.0;
    }

    protected double paintIcon(Graphics2D graphics2D, FunctionBrowserNode functionBrowserNode, Rectangle2D rectangle2D, double d) {
        if (functionBrowserNode.getArtifact() != null) {
            Icon icon = this.fIcons.get(functionBrowserNode.getArtifact());
            icon.paintIcon(null, graphics2D, (int)d, (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (double)(icon.getIconHeight() / 2)));
            return d + (double)icon.getIconWidth() + 2.0;
        }
        return d;
    }

    protected void paintText(FunctionBrowser functionBrowser, Graphics2D graphics2D, FunctionBrowserNode functionBrowserNode, Rectangle2D rectangle2D, double d) {
        String string = functionBrowserNode.getCategory().getName();
        if (functionBrowserNode.getArtifact() != null) {
            string = functionBrowserNode.getArtifact().getName();
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d2 = rectangle2D.getHeight() - (double)(fontMetrics.getAscent() + fontMetrics.getDescent());
        float f = (float)(rectangle2D.getY() + (double)fontMetrics.getAscent() + d2 / 2.0);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, (float)d, f);
    }
}

