/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint.replace;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButtonGroup;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.InvalidFormatException;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.plaf.LightweightComboBoxUI;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.Cell;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategies;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementType;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementsModel;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.AnimationUtils;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolbox.coder.wfa.core.ListEntryButton;
import com.mathworks.toolbox.coder.widgets.FauxColumnDataAdapter;
import com.mathworks.toolbox.coder.widgets.FauxColumnEditorFactory;
import com.mathworks.toolbox.coder.widgets.FauxColumnGroupDecorator;
import com.mathworks.util.Holder;
import com.mathworks.util.Pair;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.xml.XMLLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComboBoxUI;
import org.jetbrains.annotations.Nullable;

public final class ExpandedReplacementsTable {
    private static final Comparator<ReplacementKey> ALPHABETICAL_KEY_COMPARATOR = ExpandedReplacementsTable.createAlphabeticalDisplayNameComparator();
    private static final Comparator<FunctionReplacementType> SUBJECTIVE_STRATEGY_ID_COMPARATOR = ExpandedReplacementsTable.createSubjectiveStrategyIdComparator();
    private static final String NEW_ENTRY_FIELD_NAME = "entryField";
    private final ConversionModel fConversionModel;
    private final JComponent fComponent;
    private final NewEntryPanel fNewEntryPanel;
    private final FunctionReplacementsModel.ModelObserver fModelObserver;
    private final List<ReplacementKey> fRowsToKeys;
    private final Map<ReplacementKey, Integer> fKeysToRows;
    private final Map<FunctionReplacementType, List<ReplacementKey>> fBucketedKeys;
    private final Map<FunctionReplacementType, Integer> fGroupIndices;
    private final FauxColumnGroupDecorator<ReplacementKey> fFauxDecorator;
    private final PropertyTableCellEditorFactory<ReplacementKey> fEditorFactory;
    private final GlassPaneManager fGlassPaneManager;
    private final Window fWindow;
    private HintPopupFrame fPopup;
    private PropertyTable<ReplacementKey> fTable;
    private PropertyTableModel<ReplacementKey> fTableModel;
    private FunctionReplacementsModel fModel;
    private Pair<ReplacementKey, ParameterRunnable<Integer>> fPendingAddition;

    public ExpandedReplacementsTable(FunctionReplacementsModel functionReplacementsModel, ConversionModel conversionModel, Window window, GlassPaneManager glassPaneManager) {
        this.fConversionModel = conversionModel;
        this.fWindow = window;
        this.fGlassPaneManager = glassPaneManager;
        this.fModelObserver = new ModelObserverImpl();
        this.fComponent = new MJPanel(new BorderLayout()){

            public void addNotify() {
                super.addNotify();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExpandedReplacementsTable.this.rebuild();
                    }
                });
            }
        };
        this.fRowsToKeys = new ArrayList<ReplacementKey>();
        this.fKeysToRows = new HashMap<ReplacementKey, Integer>();
        this.fGroupIndices = new EnumMap<FunctionReplacementType, Integer>(FunctionReplacementType.class);
        this.fBucketedKeys = new TreeMap<FunctionReplacementType, List<ReplacementKey>>(SUBJECTIVE_STRATEGY_ID_COMPARATOR);
        this.fFauxDecorator = this.createFauxDecorator();
        this.fEditorFactory = new FauxColumnEditorFactory<ReplacementKey>(new ReplacementEditorFactory(), this.fFauxDecorator);
        this.fNewEntryPanel = new NewEntryPanel();
        this.fFauxDecorator.addDecorationEnabledPredicate(new Predicate<CellPaintContext<ReplacementKey>>(){

            public boolean accept(CellPaintContext<ReplacementKey> cellPaintContext) {
                return ExpandedReplacementsTable.this.fPendingAddition == null || cellPaintContext.getValue() == null || ((ReplacementKey)ExpandedReplacementsTable.this.fPendingAddition.getFirst()).equals(cellPaintContext.getValue());
            }
        });
        this.fFauxDecorator.addDecorationTextPredicate(new Predicate<ReplacementKey>(){

            public boolean accept(ReplacementKey replacementKey) {
                return ExpandedReplacementsTable.this.fPendingAddition == null && !ExpandedReplacementsTable.this.isUserDefinedStrategy(replacementKey);
            }
        });
        this.setModel(functionReplacementsModel);
        conversionModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("FunctionReplacements")) {
                    ExpandedReplacementsTable.this.setModel(ExpandedReplacementsTable.this.fConversionModel.getFunctionReplacementsModel());
                }
            }
        });
    }

    public ExpandedReplacementsTable(FunctionReplacementsModel functionReplacementsModel, ConversionModel conversionModel, CoderApp coderApp) {
        this(functionReplacementsModel, conversionModel, coderApp.getWindow(), coderApp.getGlassPaneManager());
    }

    private FauxColumnGroupDecorator<ReplacementKey> createFauxDecorator() {
        return new FauxColumnGroupDecorator<ReplacementKey>(new FauxColumnDataAdapter<ReplacementKey>(){

            @Override
            public List<Object> getDisplayObjects(int n, ReplacementKey replacementKey) {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                FunctionReplacementStrategy functionReplacementStrategy = ExpandedReplacementsTable.this.getStrategyFromRowIndex(n);
                if (functionReplacementStrategy != null) {
                    for (FunctionReplacementStrategy.Property property : functionReplacementStrategy.getProperties()) {
                        linkedList.add(property.getValue());
                    }
                }
                return linkedList;
            }

            @Override
            public List<String> getFauxFieldsForRow(int n) {
                LinkedList<String> linkedList = new LinkedList<String>();
                FunctionReplacementStrategy functionReplacementStrategy = ExpandedReplacementsTable.this.getStrategyFromRowIndex(n);
                if (functionReplacementStrategy != null) {
                    for (FunctionReplacementStrategy.Property property : functionReplacementStrategy.getProperties()) {
                        linkedList.add(property.getName());
                    }
                }
                return linkedList;
            }
        });
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        if (this.fPopup != null) {
            this.fPopup.close();
        }
        if (this.fTable != null) {
            this.fTable.dispose();
        }
        if (this.fNewEntryPanel != null) {
            this.fNewEntryPanel.dispose();
        }
        if (this.fModel != null) {
            this.fModel.dispose();
        }
    }

    public void setModel(FunctionReplacementsModel functionReplacementsModel) {
        if (this.fModel != null) {
            this.fModel.removeModelObserver(this.fModelObserver);
        }
        this.fModel = functionReplacementsModel;
        if (this.fModel != null) {
            this.fModel.addModelObserver(this.fModelObserver);
        }
        this.rebuild();
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ExpandedReplacementsTable.this.closeError();
                ExpandedReplacementsTable.this.fComponent.removeAll();
                ExpandedReplacementsTable.this.fPendingAddition = null;
                if (ExpandedReplacementsTable.this.fTable != null) {
                    ExpandedReplacementsTable.this.fTable.dispose();
                }
                ExpandedReplacementsTable.this.rebuildTableModel();
                ExpandedReplacementsTable.this.fTable = new PropertyTable(ExpandedReplacementsTable.this.fTableModel, ExpandedReplacementsTable.this.fEditorFactory);
                ExpandedReplacementsTable.this.fTable.setColumnWeights(new double[]{0.18, 0.82});
                ExpandedReplacementsTable.this.fTable.addHighlighter(ExpandedReplacementsTable.this.createBlankHighlighter());
                ExpandedReplacementsTable.this.fTable.setContextMenuCustomizer((PropertyTableContextMenuCustomizer)new ContextMenuCustomizer());
                ExpandedReplacementsTable.this.fTable.getSelectionModel().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ExpandedReplacementsTable.this.closeError();
                    }
                });
                ExpandedReplacementsTable.this.fNewEntryPanel.reset();
                ExpandedReplacementsTable.this.fComponent.add(ExpandedReplacementsTable.this.fTable.getComponent());
                ExpandedReplacementsTable.this.fComponent.add((Component)((Object)ExpandedReplacementsTable.this.fNewEntryPanel), "North");
                ExpandedReplacementsTable.this.fComponent.revalidate();
                ExpandedReplacementsTable.this.fComponent.repaint();
            }
        });
    }

    private void rebuildTableModel() {
        this.fKeysToRows.clear();
        this.fRowsToKeys.clear();
        this.fBucketedKeys.clear();
        this.fGroupIndices.clear();
        List<AbstractPropertyTableColumn> list = Arrays.asList(new AbstractPropertyTableColumn[]{new FunctionKeyColumn(), new StrategyConfigurationColumn()});
        ArrayList<PropertyTableNode<ReplacementKey>> arrayList = new ArrayList<PropertyTableNode<ReplacementKey>>();
        if (this.fModel != null) {
            for (FunctionReplacementType object2 : FunctionReplacementType.values()) {
                this.fBucketedKeys.put(object2, new ArrayList());
            }
            for (ReplacementKey replacementKey : this.fModel.getAllReplacementKeys()) {
                FunctionReplacementStrategy functionReplacementStrategy = this.fModel.getFunctionReplacement(replacementKey);
                List<ReplacementKey> list2 = this.fBucketedKeys.get((Object)functionReplacementStrategy.getFunctionReplacementType());
                list2.add(replacementKey);
            }
            Holder holder = new Holder((Object)0);
            for (Map.Entry<FunctionReplacementType, List<ReplacementKey>> entry : this.fBucketedKeys.entrySet()) {
                FunctionReplacementType functionReplacementType = entry.getKey();
                List<ReplacementKey> list3 = entry.getValue();
                Collections.sort(list3, ALPHABETICAL_KEY_COMPARATOR);
                this.createStrategyNode(functionReplacementType.getStrategyName(), list3, arrayList, (Holder<Integer>)holder);
            }
        }
        this.regenerateGroupIndices();
        this.fTableModel = new PropertyTableModel(list, arrayList);
        this.fTableModel.expandAll();
    }

    private PropertyTableHighlighter<ReplacementKey> createBlankHighlighter() {
        return new PropertyTableHighlighter(null, Color.GRAY, (Predicate)new Predicate<ReplacementKey>(){

            public boolean accept(ReplacementKey replacementKey) {
                if (ExpandedReplacementsTable.this.isSelected(replacementKey)) {
                    return false;
                }
                FunctionReplacementStrategy functionReplacementStrategy = ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey);
                if (ExpandedReplacementsTable.this.isUserDefinedStrategy(replacementKey)) {
                    String string = ((FunctionReplacementStrategies.UserDefined)functionReplacementStrategy).getReplacement();
                    return string == null || string.isEmpty();
                }
                return false;
            }
        }, (Predicate)new Predicate<Cell<ReplacementKey>>(){

            public boolean accept(Cell<ReplacementKey> cell) {
                return !ExpandedReplacementsTable.this.isSelected((ReplacementKey)cell.getValue()) && cell.getColumnIndex() == 1;
            }
        });
    }

    private boolean isUserDefinedStrategy(ReplacementKey replacementKey) {
        return this.fModel != null && this.fModel.hasFunctionReplacement(replacementKey) && this.fModel.getFunctionReplacement(replacementKey) instanceof FunctionReplacementStrategies.UserDefined;
    }

    private boolean isSelected(ReplacementKey replacementKey) {
        return this.fTable != null && replacementKey != null && this.fTable.getSelectionModel().getSelectedRow() != -1 && replacementKey.equals(this.fTable.getSelectedValues(0).get(0));
    }

    private void regenerateGroupIndices() {
        this.fGroupIndices.clear();
        int n = 0;
        for (FunctionReplacementType functionReplacementType : this.fBucketedKeys.keySet()) {
            this.fGroupIndices.put(functionReplacementType, n);
            n += this.fBucketedKeys.get((Object)functionReplacementType).size() + 1;
        }
    }

    private void feignEmptyRow(@Nullable ReplacementKey replacementKey, @Nullable ParameterRunnable<Integer> parameterRunnable) {
        this.fPendingAddition = replacementKey != null ? new Pair((Object)replacementKey, parameterRunnable) : null;
        this.fTable.repaint();
    }

    private void createStrategyNode(String string, Collection<ReplacementKey> collection, List<PropertyTableNode<ReplacementKey>> list, Holder<Integer> holder) {
        PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, string);
        this.fRowsToKeys.add(null);
        list.add((PropertyTableNode<ReplacementKey>)propertyTableNode);
        holder.set((Object)((Integer)holder.get() + 1));
        for (ReplacementKey replacementKey : collection) {
            Integer n = (Integer)holder.get();
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(replacementKey));
            this.fRowsToKeys.add(replacementKey);
            this.fKeysToRows.put(replacementKey, n);
            holder.set((Object)(n + 1));
        }
    }

    private int insertRow(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy) {
        boolean bl;
        this.fTable.stopEditing(true);
        List<ReplacementKey> list = this.fBucketedKeys.get((Object)functionReplacementStrategy.getFunctionReplacementType());
        boolean bl2 = bl = list == null;
        if (bl) {
            list = new ArrayList<ReplacementKey>();
            this.fBucketedKeys.put(functionReplacementStrategy.getFunctionReplacementType(), list);
        }
        this.regenerateGroupIndices();
        int n = this.findGroupRowIndex(functionReplacementStrategy);
        if (bl) {
            this.fRowsToKeys.add(n, null);
            this.fTableModel.addRootLevelGroup(n, functionReplacementStrategy.getFunctionReplacementType().getStrategyName());
        }
        int n2 = ExpandedReplacementsTable.findInsertionIndex(replacementKey, list, ALPHABETICAL_KEY_COMPARATOR);
        list.add(n2, replacementKey);
        int n3 = n2 + n + 1;
        this.fKeysToRows.put(replacementKey, n3);
        this.fRowsToKeys.add(n3, replacementKey);
        for (int i = n3 + 1; i < this.fRowsToKeys.size(); ++i) {
            ReplacementKey replacementKey2 = this.fRowsToKeys.get(i);
            if (replacementKey2 == null) continue;
            this.fKeysToRows.put(replacementKey2, i);
        }
        if (n2 == 0) {
            this.fTableModel.addChild(n3 - 1, 0, (Object)replacementKey);
        } else {
            this.fTableModel.addChildBelow(n3 - 1, (Object)replacementKey);
        }
        this.fNewEntryPanel.reset();
        return n3;
    }

    private void removeRow(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy) {
        this.fTable.stopEditing(true);
        List<ReplacementKey> list = this.fBucketedKeys.get((Object)functionReplacementStrategy.getFunctionReplacementType());
        if (list == null) {
            return;
        }
        int n = this.findGroupRowIndex(functionReplacementStrategy);
        int n2 = n + 1 + list.indexOf(replacementKey);
        list.remove(replacementKey);
        this.fRowsToKeys.remove(n2);
        this.fTableModel.remove(n2);
        this.regenerateGroupIndices();
        this.fKeysToRows.remove(replacementKey);
        for (int i = n2; i < this.fRowsToKeys.size(); ++i) {
            ReplacementKey replacementKey2 = this.fRowsToKeys.get(i);
            if (replacementKey2 == null) continue;
            this.fKeysToRows.put(replacementKey2, i);
        }
        this.fNewEntryPanel.reset();
    }

    private int findGroupRowIndex(FunctionReplacementStrategy functionReplacementStrategy) {
        return this.fGroupIndices.get((Object)functionReplacementStrategy.getFunctionReplacementType());
    }

    private FunctionReplacementStrategy getStrategyFromRowIndex(int n) {
        ReplacementKey replacementKey;
        if (n >= this.fRowsToKeys.size()) {
            return null;
        }
        if (this.fRowsToKeys.get(n) == null) {
            ++n;
        }
        ReplacementKey replacementKey2 = replacementKey = n < this.fRowsToKeys.size() ? this.fRowsToKeys.get(n) : null;
        if (replacementKey != null && this.fModel != null) {
            return this.fModel.getFunctionReplacement(replacementKey);
        }
        return null;
    }

    private void showError(ReplacementKey replacementKey) {
        this.showError(this.fModel.consumeError(), this.fKeysToRows.get(replacementKey), 0);
    }

    private void showError(String string, final int n, final int n2) {
        this.showError(string, new ReturnRunnable<Point>(){

            public Point run() {
                Rectangle rectangle = ExpandedReplacementsTable.this.fTable.getCellRect(n, n2);
                Point point = new Point((int)rectangle.getCenterX(), (int)rectangle.getMaxY());
                SwingUtilities.convertPointToScreen(point, ExpandedReplacementsTable.this.fTable.getTableComponent());
                return point;
            }
        });
    }

    private void showError(String string, ReturnRunnable<Point> returnRunnable) {
        this.closeError();
        if (string != null && !string.isEmpty()) {
            this.fPopup = new HintPopupFrame(SwingUtilities.windowForComponent(this.getComponent()), this.getComponent(), StringUtils.stripLinks((String)string), BuildErrorSeverity.ERROR.getIcon(), false, false, returnRunnable);
        }
    }

    private void closeError() {
        if (this.fPopup != null) {
            this.fPopup.close();
            this.fPopup = null;
        }
    }

    private static <T> int findInsertionIndex(T t, List<T> list, Comparator<T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = comparator.compare(t, list.get(n3));
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return n;
    }

    private static Comparator<ReplacementKey> createAlphabeticalDisplayNameComparator() {
        return new Comparator<ReplacementKey>(){

            @Override
            public int compare(ReplacementKey replacementKey, ReplacementKey replacementKey2) {
                return replacementKey.getDisplayString().compareTo(replacementKey2.getDisplayString());
            }
        };
    }

    private static Comparator<FunctionReplacementType> createSubjectiveStrategyIdComparator() {
        return new Comparator<FunctionReplacementType>(){

            @Override
            public int compare(FunctionReplacementType functionReplacementType, FunctionReplacementType functionReplacementType2) {
                if (functionReplacementType.equals((Object)functionReplacementType2)) {
                    return 0;
                }
                if (functionReplacementType.equals((Object)FunctionReplacementType.USER_DEFINED)) {
                    return -1;
                }
                if (functionReplacementType2.equals((Object)FunctionReplacementType.USER_DEFINED)) {
                    return 1;
                }
                if (functionReplacementType.equals((Object)FunctionReplacementType.LOOKUP_TABLE)) {
                    return -1;
                }
                if (functionReplacementType2.equals((Object)FunctionReplacementType.LOOKUP_TABLE)) {
                    return 1;
                }
                return functionReplacementType.compareTo(functionReplacementType2);
            }
        };
    }

    public static void showTableDemo(final File file) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Project project = ProjectManager.load((File)file.getAbsoluteFile(), (boolean)false, (boolean)false);
                    final FixedPointDataAdapter fixedPointDataAdapter = FixedPointDataAdapterFactory.create(project.getConfiguration());
                    final ConversionModel conversionModel = new ConversionModel();
                    FunctionReplacementsModel functionReplacementsModel = new FunctionReplacementsModel(fixedPointDataAdapter, conversionModel);
                    conversionModel.deserialize(fixedPointDataAdapter, true);
                    functionReplacementsModel.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            conversionModel.serialize(fixedPointDataAdapter);
                        }
                    });
                    ParameterRunnable<SyntaxTextPane> parameterRunnable = new ParameterRunnable<SyntaxTextPane>(){

                        public void run(SyntaxTextPane syntaxTextPane) {
                            syntaxTextPane.setText(fixedPointDataAdapter.getFunctionReplacements() != null ? fixedPointDataAdapter.getFunctionReplacements().getXML() : "");
                        }
                    };
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable((ParameterRunnable)parameterRunnable, fixedPointDataAdapter, functionReplacementsModel, conversionModel){
                        final /* synthetic */ ParameterRunnable val$textUpdater;
                        final /* synthetic */ FixedPointDataAdapter val$fpData;
                        final /* synthetic */ FunctionReplacementsModel val$model;
                        final /* synthetic */ ConversionModel val$conversionModel;
                        {
                            this.val$textUpdater = parameterRunnable;
                            this.val$fpData = fixedPointDataAdapter;
                            this.val$model = functionReplacementsModel;
                            this.val$conversionModel = conversionModel;
                        }

                        @Override
                        public void run() {
                            final SyntaxTextPane syntaxTextPane = new SyntaxTextPane();
                            syntaxTextPane.setContentType(XMLLanguage.INSTANCE.getMimeType());
                            syntaxTextPane.setEditable(false);
                            this.val$textUpdater.run((Object)syntaxTextPane);
                            this.val$fpData.addPropertyChangeListener(new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                    if (propertyChangeEvent.getPropertyName().equals("param.FixedPointFunctionReplacements") || propertyChangeEvent.getPropertyName().equals("param.fixptconv.generatefixptcode.function_replacements")) {
                                        val$textUpdater.run((Object)syntaxTextPane);
                                    }
                                }
                            });
                            MJFrame mJFrame = new MJFrame("Function Replacements Table");
                            GlassPaneManager glassPaneManager = new GlassPaneManager(mJFrame.getRootPane());
                            Component component = new ExpandedReplacementsTable(this.val$model, this.val$conversionModel, (Window)mJFrame, glassPaneManager).getComponent();
                            component.setMinimumSize(component.getPreferredSize());
                            MJSplitPane mJSplitPane = new MJSplitPane(0, (Component)new MJScrollPane((Component)syntaxTextPane), component);
                            mJFrame.add((Component)mJSplitPane);
                            mJFrame.setSize(mJSplitPane.getPreferredSize().width + 30, 420);
                            mJFrame.setMinimumSize(mJFrame.getSize());
                            mJSplitPane.setDividerLocation(0.5);
                            mJFrame.setDefaultCloseOperation(2);
                            mJFrame.setLocationRelativeTo(null);
                            mJFrame.setVisible(true);
                        }
                    });
                }
                catch (InvalidFormatException | UnavailableTargetException throwable) {
                    throwable.printStackTrace();
                }
            }
        }).start();
    }

    public static void showTableDemo(String string) {
        ExpandedReplacementsTable.showTableDemo(new File(Utilities.getCurrentDirectory(), string));
    }

    private class NewEntryPanel
    extends MJPanel {
        private final FormattedTextField fKeyField;
        private final MJComboBox fStrategyCombo;
        private final JComponent fAddButton;
        private final JComponent fRemoveButton;
        private final Animator fAnimator;

        NewEntryPanel() {
            super((LayoutManager)new FormLayout("pref:grow, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu", "fill:pref"));
            this.fKeyField = this.createKeyWidget();
            this.fStrategyCombo = this.createStrategyWidget();
            this.fAddButton = this.createAddButton();
            this.fRemoveButton = this.createRemoveButton();
            this.fAnimator = new Animator();
            Border border = BorderFactory.createLineBorder(ColorUtils.convertToCurrentColorScheme((Color)new Color(215, 215, 215), (Color)UIManager.getColor("control")));
            this.fAddButton.setBorder(border);
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.add(this.fKeyField.getComponent());
            mJPanel.setBorder(border);
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)mJPanel, cellConstraints.xy(1, 1));
            this.add((Component)this.fStrategyCombo, cellConstraints.xy(3, 1));
            this.add(this.fAddButton, cellConstraints.xy(5, 1));
            this.add(this.fRemoveButton, cellConstraints.xy(7, 1));
            this.setBorder(new EmptyBorder(3, 0, 3, 0));
            this.reset();
        }

        public void requestFocus() {
            this.fKeyField.requestFocus();
        }

        private void addAndAnimate(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, final ParameterRunnable<Integer> parameterRunnable) {
            if (this.fKeyField.getTokenCount() == 0) {
                if (parameterRunnable != null) {
                    parameterRunnable.run(null);
                }
                return;
            }
            ExpandedReplacementsTable.this.feignEmptyRow(replacementKey, (ParameterRunnable<Integer>)((ParameterRunnable)new ParameterRunnable<Integer>(){

                public void run(final Integer n) {
                    if (n == null || n < 0) {
                        ExpandedReplacementsTable.this.feignEmptyRow(null, (ParameterRunnable<Integer>)null);
                        parameterRunnable.run(null);
                        return;
                    }
                    ExpandedReplacementsTable.this.fTable.scrollRowToVisible(n.intValue());
                    MJUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Rectangle rectangle = NewEntryPanel.this.getKeyTextRect();
                            Rectangle rectangle2 = ExpandedReplacementsTable.this.fTable.getRowRect(n.intValue());
                            AnimationUtils.animateMoveInGlassPane(NewEntryPanel.this.fAnimator, ExpandedReplacementsTable.this.fGlassPaneManager, ExpandedReplacementsTable.this.fWindow, rectangle, NewEntryPanel.this.fKeyField.getComponent(), rectangle2, ExpandedReplacementsTable.this.fTable.getTableComponent(), AnimationTrack.HILL, new Color(182, 182, 182), new Runnable(){

                                @Override
                                public void run() {
                                    ExpandedReplacementsTable.this.feignEmptyRow(null, (ParameterRunnable<Integer>)null);
                                    if (parameterRunnable != null) {
                                        parameterRunnable.run((Object)n);
                                    }
                                }
                            });
                        }
                    });
                }
            }));
            ExpandedReplacementsTable.this.fModel.addFunctionReplacement(replacementKey, true, functionReplacementStrategy);
        }

        private FormattedTextField createKeyWidget() {
            FormattedTextField formattedTextField = new FormattedTextField(){

                public void doEnter() {
                    if (ExpandedReplacementsTable.this.fModel != null) {
                        ReplacementKey replacementKey = ReplacementKey.parse(this.getText());
                        FunctionReplacementStrategy functionReplacementStrategy = ((FunctionReplacementType)((Object)NewEntryPanel.this.fStrategyCombo.getSelectedItem())).createStrategy();
                        if (!this.getText().trim().isEmpty() && replacementKey != null) {
                            NewEntryPanel.this.addAndAnimate(replacementKey, functionReplacementStrategy, (ParameterRunnable<Integer>)((ParameterRunnable)new ParameterRunnable<Integer>(){

                                public void run(Integer n) {
                                    if (n != null) {
                                        this.doEscape();
                                        ExpandedReplacementsTable.this.fTable.getSelectionModel().select(n.intValue());
                                        ExpandedReplacementsTable.this.fTable.startEditing(n.intValue(), 1, true);
                                    } else {
                                        ExpandedReplacementsTable.this.showError(ExpandedReplacementsTable.this.fModel.consumeError(), (ReturnRunnable<Point>)((ReturnRunnable)new ReturnRunnable<Point>(){

                                            public Point run() {
                                                Point point = new Point((int)NewEntryPanel.this.getKeyTextRect().getCenterX(), (int)NewEntryPanel.this.fKeyField.getComponent().getBounds().getMaxY());
                                                SwingUtilities.convertPointToScreen(point, NewEntryPanel.this.fKeyField.getComponent());
                                                return point;
                                            }
                                        }));
                                    }
                                }
                            }));
                        } else {
                            this.doEscape();
                        }
                    }
                }

                public void doEscape() {
                    this.setText("");
                    ExpandedReplacementsTable.this.fTable.requestFocus();
                }
            };
            formattedTextField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ExpandedReplacementsTable.this.closeError();
                }
            });
            formattedTextField.setName(ExpandedReplacementsTable.NEW_ENTRY_FIELD_NAME);
            formattedTextField.getComponent().setBorder(new LineBorder(new Color(185, 185, 185)));
            formattedTextField.setPrompt(CoderResources.getString("f2f.functionReplacement.label.prompt"));
            formattedTextField.setFont(formattedTextField.getTextComponent().getFont().deriveFont(12.0f));
            formattedTextField.setTokenizer(new FormatTokenizer(){

                public List<Token> tokenize(String string) {
                    return Arrays.asList(new Token(0, string));
                }
            });
            return formattedTextField;
        }

        private MJComboBox createStrategyWidget() {
            MJComboBox mJComboBox = new MJComboBox(new LinkedList<FunctionReplacementType>(Arrays.asList(FunctionReplacementType.values())));
            mJComboBox.setUI((ComboBoxUI)new LightweightComboBoxUI());
            mJComboBox.setName("f2f.functionReplacementStrategy.combo");
            mJComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    this.setText(object != null ? ((FunctionReplacementType)((Object)object)).getStrategyName() : "");
                    return this;
                }
            });
            mJComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExpandedReplacementsTable.this.closeError();
                }
            });
            return mJComboBox;
        }

        private JComponent createAddButton() {
            ListEntryButton listEntryButton = new ListEntryButton(ListEntryButton.ButtonType.ADD);
            listEntryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewEntryPanel.this.fKeyField.doEnter();
                }
            });
            listEntryButton.setName("f2f.addReplacement.button");
            return listEntryButton;
        }

        private JComponent createRemoveButton() {
            ListEntryButton listEntryButton = new ListEntryButton(ListEntryButton.ButtonType.REMOVE);
            listEntryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExpandedReplacementsTable.this.fTable != null && ExpandedReplacementsTable.this.fModel != null && ExpandedReplacementsTable.this.fTable.getSelectionModel().getSelectedRowCount() > 0) {
                        List list = ExpandedReplacementsTable.this.fTable.getSelectedValues(0);
                        for (ReplacementKey replacementKey : list) {
                            ExpandedReplacementsTable.this.fModel.removeFunctionReplacement(replacementKey);
                        }
                    }
                }
            });
            listEntryButton.setName("f2f.removeReplacement.button");
            return listEntryButton;
        }

        private Rectangle getKeyTextRect() {
            return this.fKeyField.getTokenCount() > 0 ? this.fKeyField.getTokenRect((Token)this.fKeyField.getTokens().get(0)) : new Rectangle(0, 0, this.fKeyField.getComponent().getWidth(), this.fKeyField.getComponent().getHeight());
        }

        void reset() {
            this.fKeyField.setText("");
            if (ExpandedReplacementsTable.this.fTable != null && ExpandedReplacementsTable.this.fTable.getSelectionModel().getSelectedRow() != -1) {
                ReplacementKey replacementKey = (ReplacementKey)ExpandedReplacementsTable.this.fTable.getSelectedValues(0).iterator().next();
                if (ExpandedReplacementsTable.this.fModel.hasFunctionReplacement(replacementKey)) {
                    this.fStrategyCombo.setSelectedItem((Object)ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey).getFunctionReplacementType());
                }
            }
            if (ExpandedReplacementsTable.this.fTable != null) {
                ExpandedReplacementsTable.this.fTable.requestFocus();
            }
            this.fRemoveButton.setEnabled(ExpandedReplacementsTable.this.fModel != null && !ExpandedReplacementsTable.this.fModel.getAllReplacementKeys().isEmpty());
            this.fAddButton.setEnabled(ExpandedReplacementsTable.this.fModel != null);
            this.revalidate();
            this.repaint();
        }

        void dispose() {
            this.fKeyField.dispose();
        }
    }

    private class StrategyConfigurationColumn
    extends AbstractPropertyTableColumn<ReplacementKey> {
        StrategyConfigurationColumn() {
            super(CoderResources.getString("f2f.functionReplacement.table.strategyHeading"));
        }

        public String getText(ReplacementKey replacementKey) {
            if (!ExpandedReplacementsTable.this.fModel.hasFunctionReplacement(replacementKey)) {
                return "";
            }
            FunctionReplacementStrategy functionReplacementStrategy = ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey);
            if (ExpandedReplacementsTable.this.isUserDefinedStrategy(replacementKey)) {
                String string = ((FunctionReplacementStrategies.UserDefined)functionReplacementStrategy).getReplacement();
                if (string == null || string.isEmpty()) {
                    string = CoderResources.getString(ExpandedReplacementsTable.this.fModel.isUserAdded(replacementKey) ? "f2f.functionReplacement.noReplacement" : "f2f.functionReplacement.noReplacement.required");
                }
                return string;
            }
            return "";
        }

        public boolean isEditable() {
            return true;
        }

        public PropertyTableDecorator<ReplacementKey> getDecorator() {
            return ExpandedReplacementsTable.this.fFauxDecorator;
        }
    }

    private class FunctionKeyColumn
    extends AbstractPropertyTableColumn<ReplacementKey>
    implements PropertyTableDecorator<ReplacementKey> {
        FunctionKeyColumn() {
            super(CoderResources.getString("f2f.column.function"));
        }

        public String getText(ReplacementKey replacementKey) {
            return replacementKey.getDisplayString();
        }

        public boolean isEditable() {
            return true;
        }

        public PropertyTableDecorator<ReplacementKey> getDecorator() {
            return this;
        }

        public boolean shouldPaintText(ReplacementKey replacementKey) {
            return ExpandedReplacementsTable.this.fPendingAddition == null || !((ReplacementKey)ExpandedReplacementsTable.this.fPendingAddition.getFirst()).equals(replacementKey);
        }

        public void paintDecoration(CellPaintContext<ReplacementKey> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
        }
    }

    private class ReplacementEditorFactory
    extends FauxColumnEditorFactory.MultiPropertyTableCellEditorFactory<ReplacementKey> {
        private ReplacementEditorFactory() {
        }

        @Override
        protected List<PropertyTableCellEditor<ReplacementKey>> createMultipleWidgets(PropertyTable<ReplacementKey> propertyTable, int n, int n2, ReplacementKey replacementKey) {
            LinkedList<PropertyTableCellEditor<ReplacementKey>> linkedList = new LinkedList<PropertyTableCellEditor<ReplacementKey>>();
            if (ExpandedReplacementsTable.this.fModel != null) {
                if (n2 == 0) {
                    linkedList.add(this.createKeyEditor(replacementKey, propertyTable));
                } else if (n2 == 1) {
                    List<? extends FunctionReplacementStrategy.Property> list;
                    List<? extends FunctionReplacementStrategy.Property> list2 = list = ExpandedReplacementsTable.this.fModel.hasFunctionReplacement(replacementKey) ? ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey).getProperties() : null;
                    if (list != null) {
                        for (FunctionReplacementStrategy.Property property : list) {
                            linkedList.add(property.createTableEditor(propertyTable));
                        }
                    }
                }
            }
            return linkedList;
        }

        private PropertyTableCellEditor<ReplacementKey> createKeyEditor(final ReplacementKey replacementKey, PropertyTable<ReplacementKey> propertyTable) {
            return new AbstractSimpleCellEditor<ReplacementKey>(propertyTable){

                public void loadData(Object object, String string) {
                    this.setData(object, string);
                }

                public void commitData() {
                    ReplacementKey replacementKey2;
                    if (ExpandedReplacementsTable.this.fModel != null && (replacementKey2 = ReplacementKey.parse((String)this.getData())) != null) {
                        ExpandedReplacementsTable.this.fModel.replaceExistingKey(replacementKey, replacementKey2);
                    }
                }
            };
        }
    }

    private class ContextMenuCustomizer
    implements PropertyTableContextMenuCustomizer {
        private ContextMenuCustomizer() {
        }

        public void customize(MJPopupMenu mJPopupMenu, int n, int n2) {
            final ReplacementKey replacementKey = (ReplacementKey)ExpandedReplacementsTable.this.fTableModel.getValue(n, 0);
            if (replacementKey == null) {
                return;
            }
            FunctionReplacementType functionReplacementType = ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey).getFunctionReplacementType();
            this.addReplacementTypeMenuItems((JPopupMenu)mJPopupMenu, replacementKey, functionReplacementType);
            mJPopupMenu.addSeparator();
            mJPopupMenu.add((Action)new MJAbstractAction(CoderResources.getString("f2f.functionReplacement.remove")){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExpandedReplacementsTable.this.fModel.removeFunctionReplacement(replacementKey);
                }
            });
        }

        private void addReplacementTypeMenuItems(JPopupMenu jPopupMenu, final ReplacementKey replacementKey, FunctionReplacementType functionReplacementType) {
            MJButtonGroup mJButtonGroup = new MJButtonGroup();
            for (FunctionReplacementType functionReplacementType2 : FunctionReplacementType.values()) {
                MJRadioButtonMenuItem mJRadioButtonMenuItem = new MJRadioButtonMenuItem(functionReplacementType2.getStrategyName());
                mJButtonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                final FunctionReplacementType functionReplacementType3 = functionReplacementType2;
                mJRadioButtonMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExpandedReplacementsTable.this.fModel.setFunctionReplacementStrategy(replacementKey, functionReplacementType3.createStrategy());
                    }
                });
                if (functionReplacementType2.equals((Object)functionReplacementType)) {
                    mJRadioButtonMenuItem.setSelected(true);
                }
                jPopupMenu.add((JMenuItem)mJRadioButtonMenuItem);
            }
        }
    }

    private class ModelObserverImpl
    implements FunctionReplacementsModel.ModelObserver {
        private ModelObserverImpl() {
        }

        @Override
        public void functionReplacementRemapped(final ReplacementKey replacementKey, final ReplacementKey replacementKey2, final boolean bl) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!bl) {
                        FunctionReplacementStrategy functionReplacementStrategy = ExpandedReplacementsTable.this.fModel.getFunctionReplacement(replacementKey2);
                        ModelObserverImpl.this.functionReplacementRemoved(replacementKey, functionReplacementStrategy, false);
                        if (ExpandedReplacementsTable.this.fPendingAddition == null) {
                            ExpandedReplacementsTable.this.fPendingAddition = new Pair((Object)replacementKey2, (Object)new ParameterRunnable<Integer>(){

                                public void run(Integer n) {
                                    if (n != null) {
                                        ExpandedReplacementsTable.this.fTable.getSelectionModel().select(n.intValue());
                                    }
                                }
                            });
                        }
                        ModelObserverImpl.this.functionReplacementAdded(replacementKey2, functionReplacementStrategy, false);
                    } else {
                        ExpandedReplacementsTable.this.showError(replacementKey);
                    }
                }
            });
        }

        @Override
        public void functionReplacementRemoved(final ReplacementKey replacementKey, final FunctionReplacementStrategy functionReplacementStrategy, final boolean bl) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!bl) {
                        ExpandedReplacementsTable.this.removeRow(replacementKey, functionReplacementStrategy);
                    } else {
                        ExpandedReplacementsTable.this.showError(replacementKey);
                    }
                }
            });
        }

        @Override
        public void functionReplacementAdded(final ReplacementKey replacementKey, final FunctionReplacementStrategy functionReplacementStrategy, final boolean bl) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!bl) {
                        int n = ExpandedReplacementsTable.this.insertRow(replacementKey, functionReplacementStrategy);
                        if (ExpandedReplacementsTable.this.fPendingAddition != null) {
                            ((ParameterRunnable)ExpandedReplacementsTable.this.fPendingAddition.getSecond()).run((Object)n);
                        }
                    } else if (ExpandedReplacementsTable.this.fPendingAddition != null) {
                        ((ParameterRunnable)ExpandedReplacementsTable.this.fPendingAddition.getSecond()).run(null);
                    }
                    ExpandedReplacementsTable.this.fPendingAddition = null;
                }
            });
        }

        @Override
        public void functionReplacementUpdated(final ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, final boolean bl) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        ExpandedReplacementsTable.this.showError(replacementKey);
                    }
                    ExpandedReplacementsTable.this.fTable.repaint();
                }
            });
        }

        @Override
        public void modelInvalidated() {
            ExpandedReplacementsTable.this.rebuild();
        }
    }
}

