/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.VirtualComponent;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.toolbox.coder.fixedpoint.CellExpansionPopup;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.RangeColumn;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public final class ProposedTypeColumn
extends AbstractPropertyTableColumn<Variable> {
    private final ConversionModel fModel;
    private final int fStaticMinColumn;
    private final int fStaticMaxColumn;
    private PropertyTable<Variable> fTable;
    private DesignRangeComputation fDesignRangeComputation;
    private boolean fShortSyntax;

    public ProposedTypeColumn(ConversionModel conversionModel, int n, int n2) {
        super(CoderResources.getString("f2f.column.proposedType"));
        this.fModel = conversionModel;
        this.fStaticMinColumn = n;
        this.fStaticMaxColumn = n2;
    }

    public void setTable(PropertyTable<Variable> propertyTable) {
        this.fTable = propertyTable;
    }

    public void setUseShortSyntax(boolean bl) {
        this.fShortSyntax = bl;
    }

    public String getText(Variable variable) {
        String string = this.fModel.getProposedType(variable);
        return string == null ? "" : ConversionUtils.expandFixedPointType(string, this.fShortSyntax);
    }

    public boolean isEditable() {
        return true;
    }

    public void showDesignRangeDerivation(List<Variable> list, Runnable runnable) {
        this.fDesignRangeComputation = new DesignRangeComputation(list, runnable);
    }

    public PropertyTableDecorator<Variable> getDecorator() {
        return new PropertyTableDecorator<Variable>(){

            public boolean shouldPaintText(Variable variable) {
                return true;
            }

            public void paintDecoration(CellPaintContext<Variable> cellPaintContext, final Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
                Object object;
                Object object2;
                if (ProposedTypeColumn.this.fDesignRangeComputation != null) {
                    String string = ProposedTypeColumn.this.fDesignRangeComputation.getDesignMinText((Variable)cellPaintContext.getValue());
                    String string2 = ProposedTypeColumn.this.fDesignRangeComputation.getDesignMaxText((Variable)cellPaintContext.getValue());
                    if (string != null && string2 != null) {
                        graphics2D.setFont(graphics2D.getFont().deriveFont(0));
                        Rectangle2D rectangle2D = cellPaintContext.getCellRect();
                        object2 = cellPaintContext.getCellRect(ProposedTypeColumn.this.fStaticMinColumn);
                        object = cellPaintContext.getCellRect(ProposedTypeColumn.this.fStaticMaxColumn);
                        double d = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
                        double d2 = graphics2D.getFont().getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth();
                        double d3 = rectangle2D.getX() - 3.0 - d2;
                        double d4 = d3 - 3.0 - d;
                        double d5 = ((RectangularShape)object2).getX() + ((RectangularShape)object2).getWidth() - d;
                        double d6 = ((RectangularShape)object).getX() + ((RectangularShape)object).getWidth() - d2;
                        double d7 = d4 - (d4 - d5) * ProposedTypeColumn.this.fDesignRangeComputation.getPhase();
                        double d8 = d3 - (d3 - d6) * ProposedTypeColumn.this.fDesignRangeComputation.getPhase();
                        graphics2D.setColor(color2);
                        FontMetrics fontMetrics = graphics2D.getFontMetrics();
                        int n = cellPaintContext.getLineHeight() - (fontMetrics.getAscent() + fontMetrics.getDescent());
                        int n2 = (int)(cellPaintContext.getCellRect().getY() + (double)fontMetrics.getAscent() + (double)n / 2.0);
                        graphics2D.drawString(string, (float)d7, (float)n2);
                        graphics2D.drawString(string2, (float)d8, (float)n2);
                    }
                }
                if (ProposedTypeColumn.this.fModel.hasVariableNames() && cellPaintContext.getValue() != null) {
                    boolean bl = cellPaintContext.getValue() != null && !cellPaintContext.getText().isEmpty();
                    boolean bl2 = ProposedTypeColumn.this.fModel.getDefaultRoundingMethod((FunctionScopedKey)cellPaintContext.getValue()) != ProposedTypeColumn.this.fModel.getRoundingMethod((FunctionScopedKey)cellPaintContext.getValue());
                    boolean bl3 = ProposedTypeColumn.this.fModel.getDefaultOverflowAction((FunctionScopedKey)cellPaintContext.getValue()) != ProposedTypeColumn.this.fModel.getOverflowAction((FunctionScopedKey)cellPaintContext.getValue());
                    object2 = new StringBuilder();
                    if (bl2) {
                        ((StringBuilder)object2).append(CoderResources.getString("f2f.cell.roundingMethod"));
                        ((StringBuilder)object2).append(": ");
                        ((StringBuilder)object2).append(ProposedTypeColumn.this.fModel.getRoundingMethod((FunctionScopedKey)cellPaintContext.getValue()));
                        if (bl3) {
                            ((StringBuilder)object2).append(", ");
                        }
                    }
                    if (bl3) {
                        ((StringBuilder)object2).append(CoderResources.getString("f2f.cell.overflowAction"));
                        ((StringBuilder)object2).append(": ");
                        ((StringBuilder)object2).append(ProposedTypeColumn.this.fModel.getOverflowAction((FunctionScopedKey)cellPaintContext.getValue()));
                    }
                    if (bl && (bl2 || bl3)) {
                        CellExpansionPopup cellExpansionPopup;
                        object = virtualComponentManager.getComponents(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex());
                        if (object.isEmpty()) {
                            double d = cellPaintContext.getCellRect().getX() + graphics2D.getFontMetrics().getStringBounds(cellPaintContext.getText(), graphics2D).getWidth() + 6.0;
                            cellExpansionPopup = new CellExpansionPopup((PropertyTable<Variable>)ProposedTypeColumn.this.fTable, (CellPaintContext<Variable>)cellPaintContext.clone(), d, false, ((StringBuilder)object2).toString());
                            virtualComponentManager.defineCellComponents(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), new VirtualComponent[]{cellExpansionPopup});
                        } else {
                            cellExpansionPopup = (CellExpansionPopup)((Object)object.get(0));
                        }
                        cellPaintContext.afterTablePainted(new Runnable(){

                            @Override
                            public void run() {
                                cellExpansionPopup.paint(graphics2D);
                            }
                        });
                    } else {
                        virtualComponentManager.defineCellComponents(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), new VirtualComponent[0]);
                    }
                }
            }
        };
    }

    private class DesignRangeComputation {
        private final Runnable fContinuation;
        private final Map<Variable, String> fDesignMinText;
        private final Map<Variable, String> fDesignMaxText;
        private final Timer fTimer;
        private double fIncrement;
        private double fPhase;

        DesignRangeComputation(List<Variable> list, Runnable runnable) {
            this.fContinuation = runnable;
            this.fDesignMinText = new HashMap<Variable, String>();
            this.fDesignMaxText = new HashMap<Variable, String>();
            this.fIncrement = 0.05;
            for (Variable variable : list) {
                Range range = new NumericType(ProposedTypeColumn.this.fModel.getProposedType(variable)).getSupportedRange();
                this.fDesignMinText.put(variable, RangeColumn.format(range.getMin()));
                this.fDesignMaxText.put(variable, RangeColumn.format(range.getMax()));
            }
            this.fTimer = new Timer(30, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignRangeComputation.this.fPhase += DesignRangeComputation.this.fIncrement;
                    DesignRangeComputation.this.fIncrement *= 1.1;
                    if (DesignRangeComputation.this.fPhase >= 1.0) {
                        DesignRangeComputation.this.fTimer.stop();
                        ProposedTypeColumn.this.fDesignRangeComputation = null;
                        DesignRangeComputation.this.fContinuation.run();
                    }
                    if (ProposedTypeColumn.this.fTable != null) {
                        ProposedTypeColumn.this.fTable.repaint();
                    }
                }
            });
            this.fTimer.setRepeats(true);
            this.fTimer.start();
        }

        String getDesignMinText(Variable variable) {
            return this.fDesignMinText.get(variable);
        }

        String getDesignMaxText(Variable variable) {
            return this.fDesignMaxText.get(variable);
        }

        double getPhase() {
            return this.fPhase;
        }
    }
}

