/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.Cell;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ProjectScreenerModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FunctionReplacementsTable {
    private final MJPanel fComponent = new MJPanel(){

        public void addNotify() {
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionReplacementsTable.this.rebuildTable();
                }
            });
        }
    };
    private final FixedPointDataAdapter fData;
    private final ConversionModel fConversionModel;
    private final ProjectScreenerModel fScreenerModel;
    private PropertyTableModel<Function> fModel;
    private PropertyTable<Function> fTable;

    public FunctionReplacementsTable(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, File file) {
        this.fData = fixedPointDataAdapter;
        this.fConversionModel = conversionModel;
        this.fScreenerModel = new ProjectScreenerModel(this.fData.getConfiguration(), ScreenerTarget.FIXED_POINT);
        this.fScreenerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (FunctionReplacementsTable.this.screenerResultsHaveChanged()) {
                            FunctionReplacementsTable.this.rebuildTable();
                        }
                    }
                });
            }
        });
        this.rebuildTable();
    }

    public void dispose() {
        this.fScreenerModel.dispose();
        if (this.fTable != null) {
            this.fTable.dispose();
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    private boolean screenerResultsHaveChanged() {
        if (this.fScreenerModel == null || this.fScreenerModel.getReportModel() == null) {
            return false;
        }
        if (this.fModel == null) {
            return true;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.fScreenerModel.getReportModel().getFunctionsByImpact().keySet());
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (int i = 0; i < this.fModel.getRowCount(); ++i) {
            Function function = (Function)this.fModel.getValue(i, 0);
            if (function.isUserAdded()) continue;
            treeSet2.add(function.getName());
        }
        return !treeSet.equals(treeSet2);
    }

    private void rebuildTable() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FunctionReplacementsTable.this.fComponent.removeAll();
                if (FunctionReplacementsTable.this.fTable != null) {
                    FunctionReplacementsTable.this.fTable.dispose();
                    FunctionReplacementsTable.this.fTable = null;
                }
                if (FunctionReplacementsTable.this.fScreenerModel.getReportModel() != null) {
                    List<AbstractPropertyTableColumn> list = Arrays.asList(new AbstractPropertyTableColumn[]{new FunctionColumn(), new ReplacementColumn()});
                    ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (String string : new TreeSet<String>(FunctionReplacementsTable.this.fScreenerModel.getReportModel().getFunctionsByImpact().keySet())) {
                        arrayList.add(new PropertyTableNode(null, false, Arrays.asList(new Function(string, false))));
                        hashSet.add(string);
                    }
                    for (String string : FunctionReplacementsTable.this.fConversionModel.getFunctionReplacements().keySet()) {
                        if (!hashSet.add(string)) continue;
                        arrayList.add(new PropertyTableNode(null, false, Arrays.asList(new Function(string, true))));
                    }
                    FunctionReplacementsTable.this.fModel = new PropertyTableModel(list, arrayList);
                    FunctionReplacementsTable.this.addExtraRowIfNecessary();
                    FunctionReplacementsTable.this.fTable = new PropertyTable(FunctionReplacementsTable.this.fModel, (PropertyTableCellEditorFactory)new EditorFactory());
                    FunctionReplacementsTable.this.fTable.setColumnWeights(new double[]{0.15, 0.85});
                    FunctionReplacementsTable.this.fTable.setDeleteHandler((ParameterRunnable)new ParameterRunnable<Integer>(){

                        public void run(Integer n) {
                            FunctionReplacementsTable.this.deleteRow(n);
                        }
                    });
                    FunctionReplacementsTable.this.fTable.addHighlighter(FunctionReplacementsTable.this.createBlankHighlighter());
                    FunctionReplacementsTable.this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
                    FunctionReplacementsTable.this.fComponent.add((Component)FunctionReplacementsTable.this.fTable.getComponent());
                }
                FunctionReplacementsTable.this.fComponent.revalidate();
                FunctionReplacementsTable.this.fComponent.repaint();
            }
        });
    }

    private void addExtraRowIfNecessary() {
        if (this.fModel.getRowCount() == 0 || !this.hasNoName((Function)this.fModel.getValue(this.fModel.getRowCount() - 1, 0)) || !this.hasNoReplacement((Function)this.fModel.getValue(this.fModel.getRowCount() - 1, 1))) {
            this.fModel.addRootLevel((Object)new Function("", true));
        }
    }

    private void deleteRow(int n) {
        Function function = (Function)this.fModel.getValue(n, 0);
        if (!function.isUserAdded()) {
            return;
        }
        this.fModel.remove(n);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : this.fConversionModel.getFunctionReplacements().keySet()) {
            if (string.equals(function.getName())) continue;
            linkedHashMap.put(string, this.fConversionModel.getReplacement(string));
        }
        this.fConversionModel.setFunctionReplacements(linkedHashMap);
        this.addExtraRowIfNecessary();
    }

    private boolean hasNoReplacement(Function function) {
        return this.fConversionModel.getReplacement(function.getName()) == null || this.fConversionModel.getReplacement(function.getName()).trim().isEmpty();
    }

    private boolean hasNoName(Function function) {
        return function.getName() == null || function.getName().trim().isEmpty();
    }

    private boolean isSelected(Function function) {
        int n = this.fTable.getSelectionModel().getSelectedRow();
        return n >= 0 && this.fModel.getValue(n, 0) == function;
    }

    private PropertyTableHighlighter<Function> createBlankHighlighter() {
        return new PropertyTableHighlighter(null, Color.GRAY, (Predicate)new Predicate<Function>(){

            public boolean accept(Function function) {
                return !FunctionReplacementsTable.this.isSelected(function) && FunctionReplacementsTable.this.hasNoName(function) || FunctionReplacementsTable.this.hasNoReplacement(function);
            }
        }, (Predicate)new Predicate<Cell<Function>>(){

            public boolean accept(Cell<Function> cell) {
                return !FunctionReplacementsTable.this.isSelected((Function)cell.getValue()) && (cell.getColumnIndex() == 0 && FunctionReplacementsTable.this.hasNoName((Function)cell.getValue()) || cell.getColumnIndex() == 1 && FunctionReplacementsTable.this.hasNoReplacement((Function)cell.getValue()));
            }
        });
    }

    private class EditorFactory
    implements PropertyTableCellEditorFactory<Function> {
        private EditorFactory() {
        }

        public PropertyTableCellEditor<Function> createWidget(PropertyTable<Function> propertyTable, final int n, final int n2, final Function function) {
            if (n2 == 0) {
                if (!function.isUserAdded()) {
                    return null;
                }
                return new AbstractSimpleCellEditor<Function>(propertyTable){

                    public void loadData(Object object, String string) {
                        if (FunctionReplacementsTable.this.hasNoName((Function)object)) {
                            string = "";
                        }
                        this.setData(object, string);
                        if (FunctionReplacementsTable.this.hasNoReplacement((Function)object)) {
                            this.getTextField().addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            FunctionReplacementsTable.this.fTable.startEditing(n, n2 + 1, false);
                                        }
                                    });
                                }
                            });
                        }
                    }

                    public void commitData() {
                        String string = function.getName();
                        function.setName((String)this.getData());
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        for (int i = 0; i < FunctionReplacementsTable.this.fModel.getRowCount(); ++i) {
                            if (i == n) {
                                linkedHashMap.put(function.getName(), FunctionReplacementsTable.this.fConversionModel.getReplacement(string));
                                continue;
                            }
                            Function function2 = (Function)FunctionReplacementsTable.this.fModel.getValue(i, 0);
                            if (string.trim().isEmpty() && !function.getName().trim().isEmpty() && function2.getName().equals(string)) continue;
                            linkedHashMap.put(function2.getName(), FunctionReplacementsTable.this.fConversionModel.getReplacement(function2.getName()));
                        }
                        FunctionReplacementsTable.this.fConversionModel.setFunctionReplacements(linkedHashMap);
                        FunctionReplacementsTable.this.addExtraRowIfNecessary();
                    }
                };
            }
            return new AbstractSimpleCellEditor<Function>(propertyTable){

                public void loadData(Object object, String string) {
                    if (FunctionReplacementsTable.this.hasNoReplacement((Function)object)) {
                        string = "";
                    }
                    this.setData(object, string);
                }

                public void commitData() {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    for (int i = 0; i < FunctionReplacementsTable.this.fModel.getRowCount(); ++i) {
                        if (i == n) {
                            linkedHashMap.put(function.getName(), (String)this.getData());
                            continue;
                        }
                        Function function2 = (Function)FunctionReplacementsTable.this.fModel.getValue(i, 0);
                        linkedHashMap.put(function2.getName(), FunctionReplacementsTable.this.fConversionModel.getReplacement(function2.getName()));
                    }
                    FunctionReplacementsTable.this.fConversionModel.setFunctionReplacements(linkedHashMap);
                    FunctionReplacementsTable.this.addExtraRowIfNecessary();
                }
            };
        }
    }

    private class ReplacementColumn
    extends AbstractPropertyTableColumn<Function> {
        ReplacementColumn() {
            super(CoderResources.getString("f2f.column.replacement"));
        }

        public String getText(Function function) {
            boolean bl;
            boolean bl2 = bl = function == FunctionReplacementsTable.this.fModel.getValue(FunctionReplacementsTable.this.fModel.getRowCount() - 1, 0);
            if (FunctionReplacementsTable.this.hasNoReplacement(function) || bl) {
                if (FunctionReplacementsTable.this.fTable != null && FunctionReplacementsTable.this.fTable.isEditing() && FunctionReplacementsTable.this.fTable.getEditingValue() == function) {
                    return "";
                }
                if (bl || FunctionReplacementsTable.this.hasNoName(function)) {
                    return CoderResources.getString("f2f.functionReplacement.typeToAdd");
                }
                if (function.isUserAdded()) {
                    return CoderResources.getString("f2f.functionReplacement.noReplacement");
                }
                return CoderResources.getString("f2f.functionReplacement.noReplacement.required");
            }
            return FunctionReplacementsTable.this.fConversionModel.getReplacement(function.getName());
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class FunctionColumn
    extends AbstractPropertyTableColumn<Function> {
        FunctionColumn() {
            super(CoderResources.getString("f2f.column.function"));
        }

        public String getText(Function function) {
            boolean bl;
            boolean bl2 = bl = function == FunctionReplacementsTable.this.fModel.getValue(FunctionReplacementsTable.this.fModel.getRowCount() - 1, 0);
            if (bl || FunctionReplacementsTable.this.hasNoName(function)) {
                if (FunctionReplacementsTable.this.fTable != null && FunctionReplacementsTable.this.fTable.isEditing() && FunctionReplacementsTable.this.fTable.getEditingValue() == function) {
                    return "";
                }
                if (bl || FunctionReplacementsTable.this.hasNoReplacement(function)) {
                    return CoderResources.getString("f2f.functionReplacement.typeToAdd");
                }
                return CoderResources.getString("f2f.functionReplacement.noName");
            }
            return function.getName();
        }

        public boolean isEditable() {
            return true;
        }
    }

    private static class Function {
        private String fName;
        private boolean fUserAdded;

        Function(String string, boolean bl) {
            this.fName = string;
            this.fUserAdded = bl;
        }

        public void setName(String string) {
            this.fName = string;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isUserAdded() {
            return this.fUserAdded;
        }
    }
}

