/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.fixedpoint.CCoderDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointTool;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.Validator;
import com.mathworks.util.RequestFilter;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public final class FixedPointSection
implements ProjectComponent {
    private final Configuration fConfiguration;
    private final FixedPointDataAdapter fDataAdapter;
    private final ConversionModel fConversionModel;
    private final MJPanel fComponent;
    private final ParamWidgetBinder fBinder;
    private final WarningLabel fWarningLabel;
    private final ConversionStatusManager fStatusManager;
    private final RequestFilter fRebuild;
    private final BusyAffordance fBusyAffordance;
    private final HyperlinkTextLabel fLink;

    public FixedPointSection(WritableConfiguration writableConfiguration) {
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fConversionModel = new ConversionModel();
        this.fDataAdapter = new CCoderDataAdapter(this.fConfiguration);
        this.fConversionModel.updateDefaultsFromFimath(this.fDataAdapter.getFimath());
        this.fConversionModel.deserialize(this.fDataAdapter, true);
        this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), true);
        this.fComponent = new MJPanel((LayoutManager)new GridBagLayout());
        this.fComponent.setBackground(SectionPanel.BACKGROUND);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fLink = Utilities.createLink(CoderResources.getString("f2f.defineTypes"), "link.fixedpoint", new Runnable(){

            @Override
            public void run() {
                FixedPointSection.this.launch();
            }
        });
        this.fRebuild = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FixedPointSection.this.rebuild();
                    }
                });
            }
        }, 200);
        this.fStatusManager = new ConversionStatusManager(this.fDataAdapter, this.fConversionModel);
        this.fStatusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("ConversionEnabled") || propertyChangeEvent.getPropertyName().equals("PendingCheck")) {
                    FixedPointSection.this.fRebuild.request();
                } else {
                    FixedPointSection.this.refreshWarningLabel();
                }
            }
        });
        this.fWarningLabel = new WarningLabel();
        this.fWarningLabel.setVisible(false);
        this.rebuild();
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MJPanel mJPanel;
                FixedPointSection.this.fComponent.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(3, 0, 3, 9);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                FixedPointSection.this.refreshWarningLabel();
                FixedPointSection.this.fComponent.add(FixedPointSection.this.fBinder.createOrGet(FixedPointSection.this.fConfiguration.getTarget().getParam("param.FixedPointMode")), (Object)gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets.right = 3;
                gridBagConstraints.insets.left = 3;
                String string = FixedPointSection.this.fConfiguration.getParamAsString("param.FixedPointMode");
                if (string != null && string.equals("option.FixedPointMode.Automatic")) {
                    if (FixedPointSection.this.fStatusManager.hasPendingCheck()) {
                        mJPanel = new MJPanel((LayoutManager)new FormLayout("0dlu, fill:d, 3dlu, fill:d, 3dlu:grow", "3dlu, fill:d, 3dlu"));
                        mJPanel.setOpaque(false);
                        CellConstraints cellConstraints = new CellConstraints();
                        mJPanel.add((Component)FixedPointSection.this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(2, 2));
                        mJPanel.add((Component)new MJLabel(CoderResources.getString("f2f.warning.pending")), (Object)cellConstraints.xy(4, 2));
                        FixedPointSection.this.fComponent.add((Component)mJPanel, (Object)gridBagConstraints);
                        FixedPointSection.this.fBusyAffordance.start();
                    } else {
                        FixedPointSection.this.fComponent.add((Component)((Object)FixedPointSection.this.fWarningLabel), (Object)gridBagConstraints);
                        FixedPointSection.this.fBusyAffordance.stop();
                    }
                    gridBagConstraints.anchor = 13;
                    ++gridBagConstraints.gridy;
                }
                gridBagConstraints.insets.bottom = 0;
                if (string != null && !string.equals("option.FixedPointMode.None")) {
                    mJPanel = new MJPanel((LayoutManager)new FlowLayout(2, 0, 0));
                    mJPanel.setOpaque(false);
                    mJPanel.add((Component)FixedPointSection.this.fLink.getComponent());
                    FixedPointSection.this.fComponent.add((Component)mJPanel, (Object)gridBagConstraints);
                }
            }
        });
    }

    public MJPanel getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fStatusManager.dispose();
        this.fBinder.dispose();
        this.fDataAdapter.dispose();
    }

    private void refreshWarningLabel() {
        if (!this.fStatusManager.isConversionEnabled()) {
            this.fWarningLabel.setVisible(false);
        } else if (this.fStatusManager.needsEntryPoints()) {
            this.showWarning("f2f.warning.noEntryPoint");
        } else if (this.fStatusManager.needsTypes()) {
            this.showWarning("f2f.warning.noTypes");
        } else if (this.fStatusManager.isSourceCodeOutdated()) {
            this.showWarning("f2f.warning.codeChanged");
        } else if (this.fStatusManager.needsValidation()) {
            this.showWarning("f2f.warning.validation");
        } else {
            this.showWarning("f2f.warning.ok");
        }
    }

    private void showWarning(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FixedPointSection.this.fWarningLabel.setText(CoderResources.getString(string), CoderResources.getString(string + ".desc"), !string.endsWith(".ok"));
                FixedPointSection.this.fWarningLabel.setVisible(true);
                FixedPointSection.this.fComponent.revalidate();
                FixedPointSection.this.fComponent.repaint();
            }
        });
    }

    private void launch() {
        Configuration configuration = ProjectGUI.getInstance().getCurrentProject().getConfiguration();
        FileSetInstance fileSetInstance = configuration.getFileSet("fileset.entrypoints");
        boolean bl = fileSetInstance.getFiles().isEmpty();
        if (fileSetInstance.getFiles().size() > 1) {
            MJOptionPane.showMessageDialog((Component)ProjectGUI.getInstance().getCurrentClient().getComponent(), (Object)CoderResources.getString("f2f.error.multipleEntryPoints"), (String)CoderResources.getString("f2f.launch.error.title"), (int)0);
            return;
        }
        if (!bl) {
            LinkedList<ValidationMessage> linkedList = new LinkedList<ValidationMessage>();
            Validator.validateEntryPoints((ReadableConfiguration)configuration, linkedList);
            bl = FixedPointSection.hasErrorMessage(linkedList);
        }
        if (bl) {
            MJOptionPane.showMessageDialog((Component)ProjectGUI.getInstance().getCurrentClient().getComponent(), (Object)CoderResources.getString("f2f.launch.error"), (String)CoderResources.getString("f2f.launch.error.title"), (int)0);
        } else {
            FixedPointTool.show(this.fDataAdapter, this.fConversionModel, this.fStatusManager, (File)fileSetInstance.getFiles().iterator().next());
        }
    }

    private static boolean hasErrorMessage(List<ValidationMessage> list) {
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    private static class WarningLabel
    extends MJPanel {
        private final MJLabel fHeadline = new MJLabel();
        private final MJLabel fLabel;
        private final MJLabel fIcon;

        WarningLabel() {
            this.fHeadline.setName("fixedpoint.status.headline");
            this.fLabel = new MJLabel();
            this.fLabel.setName("fixedpoint.status.description");
            this.fIcon = new MJLabel();
            this.fIcon.setName("fixedpoint.status.icon");
            this.fLabel.setForeground(FileSetEditor.DESCRIPTION_FOREGROUND);
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(3, 0, 0, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)this.fIcon, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.top = 2;
            this.add((Component)this.fHeadline, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets.top = 5;
            this.add((Component)this.fLabel, gridBagConstraints);
        }

        public void setText(String string, String string2, boolean bl) {
            this.fHeadline.setText(string);
            this.fLabel.setText(string2);
            if (bl) {
                this.fHeadline.setFont(this.fHeadline.getFont().deriveFont(1));
                this.fIcon.setIcon(CoderResources.getIcon("actionrequired.png"));
            } else {
                this.fHeadline.setFont(this.fHeadline.getFont().deriveFont(0));
                this.fIcon.setIcon(CoderResources.getIcon("check.png"));
            }
        }
    }
}

