/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.VirtualComponent;
import com.mathworks.toolbox.coder.model.Variable;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;

public class CellExpansionPopup
extends VirtualComponent {
    private final String fText;
    private final PropertyTable<Variable> fTable;
    private final CellPaintContext<Variable> fContext;
    private final boolean fExpandLeftward;
    private double fExpansionRatio;
    private double fIncrement;
    private Timer fTimer;
    private boolean fCollapsing;
    public static final int WIDTH = 14;

    public CellExpansionPopup(PropertyTable<Variable> propertyTable, CellPaintContext<Variable> cellPaintContext, double d, boolean bl, String string) {
        super(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), (Shape)new RoundRectangle2D.Double(d, cellPaintContext.getCellRect().getY() + cellPaintContext.getCellRect().getHeight() / 2.0 - 5.0, 14.0, 10.0, 8.0, 8.0));
        this.fContext = cellPaintContext;
        this.fText = string;
        this.fTable = propertyTable;
        this.fExpandLeftward = bl;
    }

    public void setHovered(boolean bl) {
        if (bl != this.isHovered()) {
            if (bl) {
                super.setHovered(bl);
                this.animate(true);
            } else if (!this.fCollapsing) {
                this.animate(false);
            }
        }
    }

    private void animate(final boolean bl) {
        if (this.fTimer != null) {
            this.fTimer.stop();
        }
        this.fIncrement = 0.08;
        this.fCollapsing = !bl;
        this.fTimer = new Timer(8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellExpansionPopup.this.fExpansionRatio += bl ? CellExpansionPopup.this.fIncrement : -CellExpansionPopup.this.fIncrement;
                CellExpansionPopup.this.fIncrement *= 1.3;
                if (bl && CellExpansionPopup.this.fExpansionRatio > 1.0 || !bl && CellExpansionPopup.this.fExpansionRatio < 0.0) {
                    CellExpansionPopup.this.fExpansionRatio = bl ? 1.0 : 0.0;
                    CellExpansionPopup.this.fTimer.stop();
                    CellExpansionPopup.this.fTimer = null;
                    if (CellExpansionPopup.this.fCollapsing) {
                        CellExpansionPopup.super.setHovered(false);
                        CellExpansionPopup.this.fCollapsing = false;
                    }
                }
                if (CellExpansionPopup.this.fTable != null) {
                    CellExpansionPopup.this.fTable.repaint();
                }
            }
        });
        this.fTimer.setRepeats(true);
        this.fTimer.start();
    }

    public double getExpansionRatio() {
        return this.fExpansionRatio;
    }

    public void paint(Graphics2D graphics2D) {
        RoundRectangle2D roundRectangle2D = (RoundRectangle2D)this.getShape();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D rectangle2D = this.fContext.getCellRect();
        if (this.isHovered()) {
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.fill(roundRectangle2D);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0));
            int n = (int)graphics2D.getFontMetrics().getStringBounds(this.fText, graphics2D).getWidth();
            int n2 = (int)(this.getExpansionRatio() * (double)n);
            int n3 = (int)rectangle2D.getHeight();
            int n4 = (int)(roundRectangle2D.getX() - (double)n2 - 6.0);
            int n5 = (int)rectangle2D.getY();
            if (!this.fExpandLeftward && (double)((n4 = (int)(roundRectangle2D.getX() + roundRectangle2D.getWidth() + 1.0)) + n) > rectangle2D.getX() + rectangle2D.getWidth()) {
                if (this.fContext.getRowIndex() == this.fTable.getModel().getRowCount() - 1) {
                    n4 = (int)(roundRectangle2D.getX() - (double)n2 - 6.0);
                } else {
                    n4 = (int)(roundRectangle2D.getX() + roundRectangle2D.getWidth() - (double)n);
                    n5 = (int)(rectangle2D.getY() + rectangle2D.getHeight() + 1.0);
                    n3 = (int)(this.getExpansionRatio() * rectangle2D.getHeight());
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n2 + 4, Math.max(1, n3), 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setColor(new Color(254, 254, 216));
            graphics2D2.fillRect(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
            graphics2D2.setColor(new Color(242, 242, 242));
            graphics2D2.drawRect(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
            graphics2D2.setFont(graphics2D.getFont());
            graphics2D2.setColor(Color.BLACK);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            int n6 = this.fContext.getLineHeight() - (fontMetrics.getAscent() + fontMetrics.getDescent());
            int n7 = (int)((double)fontMetrics.getAscent() + (double)n6 / 2.0);
            graphics2D2.drawString(this.fText, 2, n7);
            graphics2D2.dispose();
            graphics2D.drawImage((Image)bufferedImage, n4, n5, null);
        }
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.draw(roundRectangle2D);
        graphics2D.fill(new RoundRectangle2D.Double(roundRectangle2D.getX() + 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 1.0, 2.0, 2.0, 2.0, 2.0));
        graphics2D.fill(new RoundRectangle2D.Double(roundRectangle2D.getX() + roundRectangle2D.getWidth() / 2.0 - 1.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 1.0, 2.0, 2.0, 2.0, 2.0));
        graphics2D.fill(new RoundRectangle2D.Double(roundRectangle2D.getX() + roundRectangle2D.getWidth() - 4.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 1.0, 2.0, 2.0, 2.0, 2.0));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

