/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Interval;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.widgets.CoderScrollPane;
import com.mathworks.widgets.text.LayerMarkList;
import com.mathworks.widgets.text.MarkPair;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.cplusplus.CLanguage;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.plain.PlainLanguage;
import com.mathworks.widgets.text.verilog.VerilogLanguage;
import com.mathworks.widgets.text.vhdl.VHDLLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorSupport {
    private final EditorView fEditor;

    EditorSupport(EditorView editorView) {
        this.fEditor = editorView;
    }

    boolean scrollToFunction(Function function, boolean bl, boolean bl2) {
        if (this.fEditor.getEntityLocator() == null || bl && this.fEditor.getTextMapper() == null) {
            return false;
        }
        Interval interval = this.fEditor.getEntityLocator().getFunctionSignatureInterval(function);
        if (bl) {
            interval = this.fEditor.getTextMapper().mapToCurrent(interval);
        }
        if (interval != null) {
            boolean bl3 = this.scrollToPosition(interval.getStart(), bl, true);
            if (bl3) {
                this.fEditor.highlight(null, bl2 ? interval : null);
            }
            return bl3;
        }
        return false;
    }

    boolean scrollToVariable(Variable variable, boolean bl) {
        if (this.fEditor.getEntityLocator() == null) {
            return false;
        }
        Collection<Interval> collection = this.fEditor.getEntityLocator().getVariableIntervals(variable);
        if (!collection.isEmpty()) {
            if (bl) {
                this.fEditor.highlight(null, collection.toArray(new Interval[collection.size()]));
            }
            Interval interval = collection.iterator().next();
            return this.scrollToPosition(interval.getStart(), true);
        }
        return false;
    }

    boolean scrollToCallSite(CallTree.CallSite callSite, boolean bl) {
        if (this.fEditor.getEntityLocator() == null) {
            return false;
        }
        Interval interval = this.fEditor.getEntityLocator().getCallSiteInterval(callSite);
        if (interval != null) {
            if (bl) {
                this.fEditor.highlight(null, interval);
            }
            return this.scrollToPosition(interval.getStart(), true);
        }
        return false;
    }

    boolean scrollToPosition(int n, boolean bl) {
        return this.scrollToPosition(n, false, bl);
    }

    boolean scrollToPosition(int n, boolean bl, boolean bl2) {
        if (this.fEditor.getTextPane() == null || n < 0 || n >= this.fEditor.getTextPane().getLength()) {
            return false;
        }
        if (bl) {
            if (this.fEditor.getTextMapper() == null) {
                return false;
            }
            n = this.fEditor.getTextMapper().mapToCurrent(n);
            if (n < 0) {
                return false;
            }
        }
        try {
            Point point = this.fEditor.getTextPane().getPointFromPos(n);
            int n2 = this.fEditor.getTextPane().getPointFromPos((int)n).y - (bl2 ? this.fEditor.getTextPane().getVisibleRect().height / 2 : this.fEditor.getTextPane().getLineHeight());
            int n3 = Math.max(n2, 0);
            Rectangle rectangle = new Rectangle(point.x, n3, 1, Math.min(this.fEditor.getTextPane().getHeight() - n3, n3 + this.fEditor.getTextPane().getVisibleRect().height / 2));
            this.fEditor.getTextPane().scrollRectToVisible(rectangle);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    void focusIfNecessary() {
        this.focusIfNecessary(0);
    }

    private void focusIfNecessary(int n) {
        Window window = SwingUtilities.windowForComponent(this.fEditor.getComponent());
        if (window != null && window.isFocused() && this.fEditor.isAutoRequestFocus() && this.fEditor.getTextPane() != null) {
            this.fEditor.getTextPane().requestFocus();
        }
        if (this.fEditor.getTextPane() != null && this.fEditor.getTextPane().getText().length() > n) {
            this.fEditor.getTextPane().setCaretPosition(n);
        }
    }

    static String getContentType(File file) {
        if (file != null) {
            FileLocation fileLocation = new FileLocation(file);
            for (EditorLanguage editorLanguage : Arrays.asList(MLanguage.INSTANCE, CLanguage.INSTANCE, VHDLLanguage.INSTANCE, VerilogLanguage.INSTANCE)) {
                for (String string : editorLanguage.getDefaultExtensions()) {
                    if (!fileLocation.checkExtension(new String[]{string})) continue;
                    return editorLanguage.getMimeType();
                }
            }
        }
        return PlainLanguage.INSTANCE.getMimeType();
    }

    static JComponent createLeftWrapper(@NotNull Component component, @Nullable Component component2, @Nullable Component component3) {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FormLayout("fill:pref, 3px, fill:pref, 9px, fill:pref", "fill:pref:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add(component, cellConstraints.xy(1, 1));
        if (component2 != null) {
            mJPanel.add(component2, cellConstraints.xy(3, 1));
        }
        if (component3 != null) {
            mJPanel.add(component3, cellConstraints.xy(5, 1));
        }
        return mJPanel;
    }

    static JScrollPane wrapIntoScrollPane(@NotNull Component component, @Nullable Component component2, @Nullable Component component3, @NotNull JTextComponent jTextComponent, @Nullable JScrollPane object) {
        if (object == null) {
            object = new CoderScrollPane();
            ((JComponent)object).setBorder(null);
            ((JScrollPane)object).setViewportBorder(null);
        }
        ScrollPanel scrollPanel = new ScrollPanel(jTextComponent);
        ((Container)((Object)scrollPanel)).setLayout(new BorderLayout());
        ((Container)((Object)scrollPanel)).add(jTextComponent);
        ((Container)((Object)scrollPanel)).add(EditorSupport.createLeftWrapper(component, component2, component3), "West");
        ((JScrollPane)object).setViewportView((Component)((Object)scrollPanel));
        return object;
    }

    static interface CoderEditorUI {
        public JComponent createExtComponent();
    }

    private static class ScrollPanel
    extends MJPanel
    implements Scrollable {
        private final Scrollable fPane;

        ScrollPanel(Scrollable scrollable) {
            this.fPane = scrollable;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.fPane.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.fPane.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.fPane.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getParent() != null && this.getParent() instanceof JViewport && (double)this.getParent().getWidth() > this.getPreferredSize().getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() != null && this.getParent() instanceof JViewport && (double)this.getParent().getHeight() > this.getPreferredSize().getHeight();
        }
    }

    static final class SafeMarkList {
        private final LayerMarkList fMarkList;
        private final STPBaseInterface fTextPane;

        SafeMarkList(@NotNull STPBaseInterface sTPBaseInterface) {
            this.fMarkList = new LayerMarkList(sTPBaseInterface);
            this.fTextPane = sTPBaseInterface;
        }

        void addMark(String string, int n, int n2) {
            if (n >= 0 && n2 > 0 && n + n2 < this.fTextPane.getLength()) {
                this.fMarkList.addMark(string, n, n2);
            }
        }

        boolean textSelectionWithinAMark() {
            return this.fMarkList.textSelectionWithinAMark();
        }

        final int size() {
            return this.fMarkList.size();
        }

        MarkPair get(int n) {
            return this.fMarkList.get(n);
        }

        boolean isEmpty() {
            return this.fMarkList.isEmpty();
        }

        public void clear() {
            this.fMarkList.clear();
        }

        public String toString() {
            return "SafeMarkList[" + this.fMarkList.toString() + ']';
        }
    }
}

