/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.FileMonitor;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditManager {
    public static final String DIRTY_PROPERTY = "dirty";
    private final Object fLock = new Object();
    private final Map<File, FileContext> fContexts = new HashMap<File, FileContext>();
    private final Set<File> fOutdated = new TreeSet<File>();
    private final FileMonitor fFileMonitor;
    private final Predicate<File> fAllowedDirtyFiles;
    private final PropertyChangeSupport fPropertySupport = new PropertyChangeSupport(this);
    private final ExecutorService fReadPool = Executors.newCachedThreadPool();
    private EditStateMediator fHandler;

    public EditManager(@Nullable Predicate<File> predicate) {
        this.fAllowedDirtyFiles = predicate != null ? predicate : new Predicate<File>(){

            public boolean accept(File file) {
                return true;
            }
        };
        this.fFileMonitor = new FileMonitor();
        this.fFileMonitor.addFileChangeObserver(new FileMonitor.FileChangeObserver(){

            @Override
            public void fileChanged(File file) {
                EditManager.this.onMonitoredFileChanged(file);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHandler(EditStateMediator editStateMediator) {
        editStateMediator = editStateMediator != null ? editStateMediator : new EditStateMediator(){

            @Override
            public void fileOutdated(EditorLoadContext editorLoadContext, boolean bl) {
            }

            @Override
            public void fileSaving(EditorLoadContext editorLoadContext, boolean bl, boolean bl2, ParameterRunnable<Boolean> parameterRunnable) {
                parameterRunnable.run((Object)true);
            }

            @Override
            public void fileSavingErrored(EditorLoadContext editorLoadContext, IOException iOException) {
            }
        };
        Object object = this.fLock;
        synchronized (object) {
            this.fHandler = editStateMediator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.fLock;
        synchronized (object) {
            this.reset();
            this.fReadPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.fLock;
        synchronized (object) {
            this.fFileMonitor.clear();
            this.fContexts.clear();
            this.fOutdated.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDirtyFiles() {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fOutdated.isEmpty() || !this.collectEditedFiles().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> collectEditedFiles() {
        Object object = this.fLock;
        synchronized (object) {
            HashSet<File> hashSet = new HashSet<File>();
            for (Map.Entry<File, FileContext> entry : this.fContexts.entrySet()) {
                if (entry.getValue().getDirtyText() == null) continue;
                hashSet.add(entry.getKey());
            }
            return hashSet;
        }
    }

    private Set<File> collectDirtyFiles() {
        HashSet<File> hashSet = new HashSet<File>(this.fOutdated);
        hashSet.addAll(this.collectEditedFiles());
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(File file) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fOutdated.contains(file) || this.collectEditedFiles().contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getDirtyText(File file) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fContexts.containsKey(file)) {
                FileContext fileContext = this.fContexts.get(file);
                String string = fileContext.getDirtyText() != null ? fileContext.getDirtyText() : fileContext.getSavedText();
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMonitoredFileChanged(File file) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fContexts.containsKey(file)) {
                this.fContexts.get(file).updateSavedText();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActive(EditorLoadContext editorLoadContext, boolean bl) {
        Object object = this.fLock;
        synchronized (object) {
            if (editorLoadContext != null && editorLoadContext.hasFile() && (bl || !this.fContexts.containsKey(editorLoadContext.getFile()))) {
                this.setDirty(editorLoadContext, null);
            } else if (this.fContexts.containsKey(editorLoadContext.getFile())) {
                Set<File> set = this.collectDirtyFiles();
                this.fOutdated.remove(editorLoadContext.getFile());
                this.fPropertySupport.firePropertyChange(DIRTY_PROPERTY, set, this.collectDirtyFiles());
            }
        }
    }

    void clear(EditorLoadContext editorLoadContext) {
        this.setInactive(editorLoadContext, true);
    }

    void setInactive(EditorLoadContext editorLoadContext) {
        this.setInactive(editorLoadContext, false);
    }

    void setInactive(final EditorLoadContext editorLoadContext, final boolean bl) {
        if (editorLoadContext == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = EditManager.this.fLock;
                synchronized (object) {
                    Set set = EditManager.this.collectDirtyFiles();
                    EditManager.this.fOutdated.remove(editorLoadContext.getFile());
                    if (bl) {
                        EditManager.this.fContexts.remove(editorLoadContext.getFile());
                        EditManager.this.fFileMonitor.removeFile(editorLoadContext.getFile());
                    } else if (EditManager.this.fContexts.containsKey(editorLoadContext.getFile())) {
                        ((FileContext)EditManager.this.fContexts.get(editorLoadContext.getFile())).setDirtyText(null);
                    }
                    EditManager.this.fPropertySupport.firePropertyChange(EditManager.DIRTY_PROPERTY, set, EditManager.this.collectDirtyFiles());
                }
            }
        };
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDirty(EditorLoadContext editorLoadContext, String string) {
        Set<File> set;
        if (editorLoadContext == null || !editorLoadContext.hasFile() || !this.fAllowedDirtyFiles.accept((Object)editorLoadContext.getFile())) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            set = this.collectDirtyFiles();
            this.fOutdated.remove(editorLoadContext.getFile());
            FileContext fileContext = this.fContexts.get(editorLoadContext.getFile());
            if (fileContext == null) {
                fileContext = new FileContext(editorLoadContext);
                this.fContexts.put(editorLoadContext.getFile(), fileContext);
            }
            fileContext.setDirtyText(Utilities.areValuesDifferent(fileContext.getSavedText(), string) ? string : null);
            this.fFileMonitor.watchFile(editorLoadContext.getFile());
        }
        this.fPropertySupport.firePropertyChange(DIRTY_PROPERTY, set, this.collectDirtyFiles());
    }

    public void save(EditorLoadContext editorLoadContext) {
        this.save(editorLoadContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(final EditorLoadContext editorLoadContext, final Runnable runnable) {
        if (!editorLoadContext.hasFile()) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fContexts.containsKey(editorLoadContext.getFile())) {
                return;
            }
            final Set<File> set = this.collectDirtyFiles();
            final FileContext fileContext = this.fContexts.get(editorLoadContext.getFile());
            final String string = fileContext.getDirtyText();
            fileContext.setDirtyText(null);
            if (string != null) {
                boolean bl = this.fOutdated.remove(editorLoadContext.getFile());
                final EditStateMediator editStateMediator = this.fHandler;
                editStateMediator.fileSaving(editorLoadContext, bl, editorLoadContext.getFile().canWrite(), new ParameterRunnable<Boolean>(){

                    public void run(Boolean bl) {
                        Set set2 = EditManager.this.collectDirtyFiles();
                        if (bl.booleanValue()) {
                            fileContext.runWhenUpdated(new ParameterRunnable<Boolean>(){

                                public void run(Boolean bl) {
                                    if (bl.booleanValue()) {
                                        try {
                                            if (!editorLoadContext.getFile().canWrite()) {
                                                editorLoadContext.getFile().setWritable(true);
                                            }
                                            editorLoadContext.saveText(string);
                                            fileContext.reset();
                                        }
                                        catch (IOException iOException) {
                                            editStateMediator.fileSavingErrored(editorLoadContext, iOException);
                                        }
                                    }
                                    EditManager.this.setInactive(fileContext.getEditorLoadContext());
                                    if (runnable != null) {
                                        runnable.run();
                                    }
                                    EditManager.this.fPropertySupport.firePropertyChange(EditManager.DIRTY_PROPERTY, set, EditManager.this.collectDirtyFiles());
                                }
                            });
                        } else {
                            EditManager.this.setInactive(fileContext.getEditorLoadContext());
                            EditManager.this.fPropertySupport.firePropertyChange(EditManager.DIRTY_PROPERTY, set, EditManager.this.collectDirtyFiles());
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        HashSet<File> hashSet;
        Iterator iterator = this.fLock;
        synchronized (iterator) {
            hashSet = new HashSet<File>(this.fContexts.keySet());
        }
        for (File file : hashSet) {
            FileContext fileContext;
            Object object = this.fLock;
            synchronized (object) {
                fileContext = this.fContexts.get(file);
            }
            if (fileContext == null) continue;
            this.save(fileContext.getEditorLoadContext());
        }
    }

    static interface EditStateMediator {
        public void fileOutdated(EditorLoadContext var1, boolean var2);

        public void fileSaving(EditorLoadContext var1, boolean var2, boolean var3, @NotNull ParameterRunnable<Boolean> var4);

        public void fileSavingErrored(EditorLoadContext var1, IOException var2);
    }

    private static class FileKey {
        private final long fSize;
        private final long fTime;

        private FileKey(EditorLoadContext editorLoadContext) {
            assert (editorLoadContext.getFile() != null);
            this.fSize = editorLoadContext.getFile().length();
            this.fTime = editorLoadContext.getFile().lastModified();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FileKey fileKey = (FileKey)object;
            if (this.fSize != fileKey.fSize) {
                return false;
            }
            return this.fTime == fileKey.fTime;
        }

        public int hashCode() {
            int n = (int)(this.fSize ^ this.fSize >>> 32);
            n = 31 * n + (int)(this.fTime ^ this.fTime >>> 32);
            return n;
        }
    }

    private class FileContext {
        private final EditorLoadContext fEditorLoadContext;
        private FileKey fKey;
        private String fSavedText;
        private boolean fPendingRead;
        private volatile String fText;
        private volatile boolean fInvalid;
        private ParameterRunnable<Boolean> fContinuation;

        FileContext(EditorLoadContext editorLoadContext) {
            this.fEditorLoadContext = editorLoadContext;
            this.fKey = new FileKey(this.fEditorLoadContext);
            this.updateSavedText();
        }

        EditorLoadContext getEditorLoadContext() {
            return this.fEditorLoadContext;
        }

        String getDirtyText() {
            return this.fText;
        }

        void reset() {
            this.setDirtyText(null);
            this.fKey = new FileKey(this.getEditorLoadContext());
        }

        void setDirtyText(String string) {
            this.fText = string;
        }

        void invalidate() {
            this.fInvalid = true;
        }

        String getSavedText() {
            return this.fSavedText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runWhenUpdated(ParameterRunnable<Boolean> parameterRunnable) {
            FileContext fileContext = this;
            synchronized (fileContext) {
                if (!this.fPendingRead) {
                    parameterRunnable.run((Object)this.isTextDifferent());
                    this.fContinuation = null;
                } else {
                    this.fContinuation = parameterRunnable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSavedText() {
            Object object = this;
            synchronized (object) {
                if (this.fPendingRead) {
                    return;
                }
                this.fPendingRead = true;
            }
            object = EditManager.this.fLock;
            synchronized (object) {
                if (!EditManager.this.fReadPool.isShutdown()) {
                    EditManager.this.fReadPool.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            FileContext fileContext = FileContext.this;
                            synchronized (fileContext) {
                                try {
                                    FileContext.this.fSavedText = FileContext.this.fEditorLoadContext.loadText();
                                }
                                catch (IOException iOException) {
                                    FileContext.this.fSavedText = null;
                                }
                                finally {
                                    FileContext.this.fPendingRead = false;
                                }
                            }
                            FileContext.this.onTriggeredReadUpdateCompleted();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTriggeredReadUpdateCompleted() {
            Object object = EditManager.this.fLock;
            synchronized (object) {
                if (EditManager.this.fHandler == null) {
                    return;
                }
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean bl;
                        Object object = FileContext.this;
                        synchronized (object) {
                            bl = !FileContext.this.fKey.equals(new FileKey(FileContext.this.getEditorLoadContext())) && FileContext.this.isTextDifferent();
                        }
                        Object object2 = EditManager.this.fLock;
                        synchronized (object2) {
                            object = EditManager.this.fHandler;
                            if (bl) {
                                Set set = EditManager.this.collectDirtyFiles();
                                EditManager.this.fOutdated.add(FileContext.this.getEditorLoadContext().getFile());
                                EditManager.this.fPropertySupport.firePropertyChange(EditManager.DIRTY_PROPERTY, set, EditManager.this.collectDirtyFiles());
                            }
                        }
                        if (object != null) {
                            if (FileContext.this.fContinuation != null) {
                                object2 = FileContext.this;
                                synchronized (object2) {
                                    FileContext.this.fContinuation.run((Object)bl);
                                    FileContext.this.fContinuation = null;
                                    return;
                                }
                            }
                            if (bl) {
                                EditManager.this.fHandler.fileOutdated(FileContext.this.getEditorLoadContext(), FileContext.this.fText != null);
                            }
                        }
                    }
                });
            }
        }

        private boolean isTextDifferent() {
            return this.fSavedText != null && (this.fText == null || !this.fText.equals(this.fSavedText));
        }
    }
}

