/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.coder.app.ide.EditorContextActionProvider;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CoderContextActionProvider
implements EditorContextActionProvider {
    private final List<EditorContextActionProvider> fProviders = new LinkedList<EditorContextActionProvider>();

    CoderContextActionProvider(IDEFileSidebar iDEFileSidebar) {
        this.fProviders.add(new CallHierarchyContextActionProvider(iDEFileSidebar));
    }

    @Override
    @Nullable
    public List<? extends Action> contributeContextMenuActions(@NotNull EditorView editorView, @NotNull Function function, int n) {
        LinkedList<? extends Action> linkedList = new LinkedList<Action>();
        for (EditorContextActionProvider editorContextActionProvider : this.fProviders) {
            List<? extends Action> list = editorContextActionProvider.contributeContextMenuActions(editorView, function, n);
            if (list == null) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private static class CallHierarchyContextActionProvider
    implements EditorContextActionProvider {
        private final IDEFileSidebar fSidebar;

        CallHierarchyContextActionProvider(IDEFileSidebar iDEFileSidebar) {
            this.fSidebar = iDEFileSidebar;
        }

        @Override
        @Nullable
        public List<? extends Action> contributeContextMenuActions(@NotNull EditorView editorView, @NotNull Function function, int n) {
            if (n == -1) {
                return null;
            }
            Holder holder = new Holder((Object)"");
            final ParameterRunnable<CallTreeFileSetView> parameterRunnable = CallHierarchyContextActionProvider.getHierarchyRunner(editorView, n, (Holder<String>)holder);
            if (parameterRunnable != null) {
                String string = String.format(CoderResources.getString("wfa.editor.callHierarchy.labelFormat"), holder.get());
                return Arrays.asList(new MJAbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Collection<CallTreeFileSetView> collection = CallHierarchyContextActionProvider.this.fSidebar.getFileSetViewsByType(CallTreeFileSetView.class);
                        if (collection != null) {
                            for (CallTreeFileSetView callTreeFileSetView : collection) {
                                parameterRunnable.run((Object)callTreeFileSetView);
                                CallHierarchyContextActionProvider.this.fSidebar.setVisibleFileSetView("input-files", callTreeFileSetView);
                            }
                        }
                    }
                });
            }
            return null;
        }

        @Nullable
        private static ParameterRunnable<CallTreeFileSetView> getHierarchyRunner(EditorView editorView, int n, Holder<String> holder) {
            int n2 = editorView.getTextMapper().mapToOriginal(n);
            if (n2 == -1) {
                return null;
            }
            final Holder holder2 = new Holder();
            for (CodableEntity codableEntity : editorView.getEntityLocator().getEntitiesAtPosition(n2)) {
                if (codableEntity.getEntityType() == CodableEntity.Type.CALL_SITE) {
                    final CallTree.CallSite callSite = (CallTree.CallSite)codableEntity;
                    holder.set((Object)callSite.getTarget().getName());
                    return new ParameterRunnable<CallTreeFileSetView>(){

                        public void run(CallTreeFileSetView callTreeFileSetView) {
                            callTreeFileSetView.showCallHierarchy(callSite);
                        }
                    };
                }
                if (codableEntity.getEntityType() != CodableEntity.Type.FUNCTION) continue;
                holder2.set((Object)((Function)codableEntity));
            }
            if (holder2.get() != null) {
                holder.set((Object)((Function)holder2.get()).getName());
                return new ParameterRunnable<CallTreeFileSetView>(){

                    public void run(CallTreeFileSetView callTreeFileSetView) {
                        callTreeFileSetView.showCallHierarchy((Function)holder2.get());
                    }
                };
            }
            return null;
        }
    }
}

