/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class TabbedPane {
    private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final TabBar fTabBar;
    private final MJPanel fContent;
    private final Map<String, Component> fPanes;
    private final Map<String, String> fNames;
    private final Map<String, List<SubElement>> fSubElements;
    private final Map<String, List<SubElement>> fAllSubElements;
    private final Set<String> fHidden;
    private final Font fFont;
    private final Map<String, Rectangle2D> fTabRects;
    private final MulticastChangeListener fChangeListeners;
    private String fPrevious;
    private String fPreviousSubElement;
    private String fActive;
    private String fActiveSubElement;
    private String fHovered;
    public static final String TABBED_PANE_PROPERTY = "TabbedPane";

    public TabbedPane(Component component) {
        this.fComponent.setName("f2f.output.tabs");
        this.fComponent.putClientProperty((Object)TABBED_PANE_PROPERTY, (Object)this);
        this.fChangeListeners = new MulticastChangeListener();
        this.fContent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fTabBar = new TabBar();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:p, fill:d:grow", "fill:p"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)((Object)this.fTabBar), (Object)cellConstraints.xy(1, 1));
        mJPanel.add(component, (Object)cellConstraints.xy(2, 1));
        this.fComponent.add((Component)mJPanel, (Object)"North");
        this.fComponent.add((Component)this.fContent, (Object)"Center");
        this.fPanes = new LinkedHashMap<String, Component>();
        this.fSubElements = new HashMap<String, List<SubElement>>();
        this.fAllSubElements = new HashMap<String, List<SubElement>>();
        this.fHidden = new HashSet<String>();
        this.fFont = new MJLabel().getFont();
        this.fTabRects = new HashMap<String, Rectangle2D>();
        this.fNames = new HashMap<String, String>();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.fComponent.addMouseListener(mouseListener);
        this.fTabBar.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.fComponent.removeMouseListener(mouseListener);
        this.fTabBar.removeMouseListener(mouseListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public void addTab(String string, String string2) {
        this.addTab(string, string2, null);
    }

    public void addTab(String string, String string2, Component component) {
        this.fPanes.put(string, component);
        this.fSubElements.put(string, new ArrayList());
        this.fAllSubElements.put(string, new ArrayList());
        this.fNames.put(string, string2);
        if (this.fPanes.size() == 1) {
            this.select(string);
        }
        this.update();
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.fPanes.keySet());
    }

    public Rectangle2D getTabRect(int n) {
        return this.getTabRect(this.getKeys().get(n));
    }

    public Rectangle2D getTabRect(String string) {
        return this.fTabRects.get(string);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public int getTabHeight() {
        return this.fTabRects.isEmpty() ? 0 : (int)this.fTabRects.values().iterator().next().getHeight();
    }

    public void addSubElement(String string, String string2, String string3, Component component) {
        SubElement subElement = new SubElement(string2, string3, component);
        this.fAllSubElements.get(string).add(subElement);
        this.fSubElements.get(string).add(subElement);
        this.update();
    }

    public Component removeSubElement(String string, String string2) {
        Component component = this.removeSubElement((Collection<SubElement>)this.fAllSubElements.get(string), string2);
        this.removeSubElement((Collection<SubElement>)this.fSubElements.get(string), string2);
        return component;
    }

    private Component removeSubElement(Collection<SubElement> collection, String string) {
        Iterator<SubElement> iterator = collection.iterator();
        while (iterator.hasNext()) {
            SubElement subElement = iterator.next();
            if (!subElement.getKey().equals(string)) continue;
            iterator.remove();
            this.update();
            return subElement.getComponent();
        }
        return null;
    }

    public void removeSubElements(String string) {
        this.fSubElements.get(string).clear();
        this.update();
    }

    public boolean hasSubElement(String string, String string2) {
        Collection collection = this.fAllSubElements.get(string);
        if (collection != null) {
            for (SubElement subElement : collection) {
                if (!subElement.getKey().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private SubElement getSelectedSubElement(String string) {
        for (SubElement subElement : this.fSubElements.get(string)) {
            if (!subElement.isSelected()) continue;
            return subElement;
        }
        return this.fSubElements.containsKey(string) ? this.fSubElements.get(string).iterator().next() : null;
    }

    private void setSelectedSubElement(String string, String string2) {
        for (SubElement subElement : this.fSubElements.get(string)) {
            if (subElement.getKey().equals(string2)) {
                subElement.setSelected(true);
                this.recordSubElementChange(string2);
                continue;
            }
            subElement.setSelected(false);
        }
        this.update();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public String getSelectedKey() {
        return this.fActive;
    }

    public String getSelectedSubElementKey() {
        return this.fActiveSubElement;
    }

    public String[] getSubElementKeys(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (SubElement subElement : this.fSubElements.get(string)) {
            linkedHashSet.add(subElement.getKey());
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public void select(String string) {
        this.select(string, null);
    }

    public void select(String string, String string2) {
        this.fPrevious = this.fActive;
        this.fActive = string;
        this.setVisible(string, true);
        if (this.fHovered == string) {
            this.fHovered = null;
            this.fTabBar.stopHoverTimer();
        }
        this.fContent.removeAll();
        if (string2 != null) {
            this.setSelectedSubElement(string, string2);
        } else {
            this.recordSubElementChange(string2);
        }
        if (this.fPanes.get(string) != null) {
            this.fContent.add(this.fPanes.get(string));
        } else {
            SubElement subElement = this.getSelectedSubElement(string);
            if (subElement != null) {
                this.setVisible(string, string2, true);
            }
            this.fContent.add(this.getSelectedSubElement(string).getComponent());
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        this.fContent.revalidate();
        this.fContent.repaint();
        this.fTabBar.revalidate();
        this.fTabBar.repaint();
    }

    public void selectPrevious() {
        if (this.hasPrevious()) {
            this.select(this.fPrevious, this.fPreviousSubElement);
        }
    }

    public boolean hasPrevious() {
        return this.fPrevious != null && this.fPanes.containsKey(this.fPrevious) && (this.fPreviousSubElement == null || this.hasSubElement(this.fPrevious, this.fPreviousSubElement));
    }

    private void recordSubElementChange(@Nullable String string) {
        this.fPreviousSubElement = this.fActiveSubElement;
        this.fActiveSubElement = string;
    }

    public void hideAll() {
        this.fHidden.addAll(this.fPanes.keySet());
        this.update();
    }

    private boolean isHidden(String string) {
        return this.fHidden.contains(string) || this.fPanes.get(string) == null && this.fSubElements.get(string).isEmpty();
    }

    public boolean hasVisibleTabs() {
        return !this.fTabRects.isEmpty();
    }

    public String getFirstVisibleTabKey() {
        for (String string : this.getKeys()) {
            if (this.fHidden.contains(string)) continue;
            return string;
        }
        return null;
    }

    public void setVisible(String string, boolean bl) {
        if (!bl) {
            this.fHidden.add(string);
        } else {
            this.fHidden.remove(string);
        }
        this.update();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void setVisible(String string, String string2, boolean bl) {
        ArrayList<SubElement> arrayList = new ArrayList<SubElement>();
        boolean bl2 = false;
        for (SubElement subElement : this.fAllSubElements.get(string)) {
            if (subElement.getKey().equals(string2)) {
                subElement.setVisible(bl);
                if (this.fActiveSubElement != null && this.fActiveSubElement.equals(subElement.getKey()) && !bl) {
                    bl2 = true;
                }
            }
            if (!subElement.isVisible()) continue;
            arrayList.add(subElement);
        }
        if (bl2) {
            this.recordSubElementChange(arrayList.isEmpty() ? null : ((SubElement)arrayList.iterator().next()).getKey());
        }
        this.fSubElements.put(string, arrayList);
        this.update();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    private String getDisplayedName(String string) {
        return this.fSubElements.get(string).isEmpty() ? this.fNames.get(string) : this.getSelectedSubElement(string).getName();
    }

    private void update() {
        this.fTabRects.clear();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n = -1;
        for (String string : this.fPanes.keySet()) {
            if (this.isHidden(string)) continue;
            String string2 = this.getDisplayedName(string);
            int n2 = (int)this.fFont.getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth() + 12;
            int n3 = (int)this.fFont.getStringBounds("Ajg", graphics2D.getFontRenderContext()).getHeight() + 8;
            if (this.fSubElements.get(string).size() > 1) {
                n2 += 16;
            }
            this.fTabRects.put(string, new Rectangle2D.Double(n, 0.0, n2, n3));
            n += n2;
        }
        this.fTabBar.setPreferredSize(new Dimension(n + 2, this.fTabRects.isEmpty() ? 0 : (int)this.fTabRects.values().iterator().next().getHeight()));
        this.fTabBar.revalidate();
        this.fTabBar.repaint();
    }

    private class SubElement {
        private final String fKey;
        private final String fName;
        private final Component fComponent;
        private boolean fVisible;
        private boolean fSelected;

        public SubElement(String string, String string2, Component component) {
            this.fKey = string;
            this.fName = string2;
            this.fComponent = component;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getName() {
            return this.fName;
        }

        public Component getComponent() {
            return this.fComponent;
        }

        public void setVisible(boolean bl) {
            this.fVisible = bl;
            if (!this.fVisible) {
                this.fSelected = false;
            }
        }

        public boolean isVisible() {
            return this.fVisible;
        }

        public void setSelected(boolean bl) {
            this.fSelected = bl;
        }

        public boolean isSelected() {
            return this.fSelected;
        }
    }

    private class TabBar
    extends MJPanel {
        private Timer fHoverTimer;

        TabBar() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    String string = TabBar.this.getTabAt(mouseEvent.getPoint());
                    if (string != null) {
                        if (((List)TabbedPane.this.fSubElements.get(string)).size() > 1 && TabBar.this.showSubElementSelector(string, mouseEvent.getPoint())) {
                            return;
                        }
                        TabbedPane.this.select(string);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    String string = TabBar.this.getTabAt(mouseEvent.getPoint());
                    if (string != null && string != TabbedPane.this.fActive) {
                        TabbedPane.this.fHovered = string;
                        TabBar.this.watchForUnhover();
                        TabBar.this.revalidate();
                        TabBar.this.repaint();
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }
            });
        }

        public void stopHoverTimer() {
            if (this.fHoverTimer != null) {
                this.fHoverTimer.stop();
                this.fHoverTimer = null;
            }
        }

        private void watchForUnhover() {
            if (this.fHoverTimer == null) {
                this.fHoverTimer = new Timer(5, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        if (pointerInfo != null) {
                            Point point = pointerInfo.getLocation();
                            SwingUtilities.convertPointFromScreen(point, (Component)((Object)TabBar.this));
                            String string = TabBar.this.getTabAt(point);
                            if (string == TabbedPane.this.fHovered) {
                                return;
                            }
                        }
                        TabbedPane.this.fHovered = null;
                        TabBar.this.fHoverTimer.stop();
                        TabBar.this.fHoverTimer = null;
                        TabBar.this.revalidate();
                        TabBar.this.repaint();
                    }
                });
                this.fHoverTimer.setRepeats(true);
                this.fHoverTimer.start();
            }
        }

        private boolean showSubElementSelector(final String string, Point point) {
            Rectangle2D rectangle2D = (Rectangle2D)TabbedPane.this.fTabRects.get(string);
            if (point.getX() > rectangle2D.getX() + rectangle2D.getWidth() - 16.0) {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                SubElement subElement = TabbedPane.this.getSelectedSubElement(string);
                for (final SubElement subElement2 : (List)TabbedPane.this.fSubElements.get(string)) {
                    MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(subElement2.getName());
                    mJCheckBoxMenuItem.setSelected(subElement2 == subElement);
                    mJCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabbedPane.this.setSelectedSubElement(string, subElement2.getKey());
                            TabbedPane.this.select(string);
                        }
                    });
                    mJPopupMenu.add((JMenuItem)mJCheckBoxMenuItem);
                }
                mJPopupMenu.show((Component)((Object)this), (int)(rectangle2D.getX() + rectangle2D.getWidth() - 16.0), (int)(rectangle2D.getY() + rectangle2D.getHeight()));
                return true;
            }
            return false;
        }

        public String getTabAt(Point point) {
            for (Map.Entry entry : TabbedPane.this.fTabRects.entrySet()) {
                if (!((Rectangle2D)entry.getValue()).contains(point)) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(UIManager.getColor("control"));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (String string : TabbedPane.this.fPanes.keySet()) {
                Rectangle2D rectangle2D;
                if (TabbedPane.this.isHidden(string)) continue;
                String string2 = TabbedPane.this.getDisplayedName(string);
                RectangularShape rectangularShape = rectangle2D = (Rectangle2D)TabbedPane.this.fTabRects.get(string);
                if (PlatformInfo.isMacintosh()) {
                    rectangularShape = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 10.0, 10.0, 10.0);
                }
                if (TabbedPane.this.fActive == string) {
                    if (PlatformInfo.isMacintosh()) {
                        graphics2D.setPaint(new GradientPaint((float)rectangle2D.getX(), (float)rectangle2D.getY(), new Color(255, 255, 255), (float)rectangle2D.getX(), (float)rectangle2D.getHeight(), new Color(220, 220, 220)));
                    } else {
                        graphics2D.setColor(Color.WHITE);
                    }
                    graphics2D.fill(rectangularShape);
                } else if (TabbedPane.this.fHovered == string && !PlatformInfo.isMacintosh()) {
                    graphics2D.setPaint(new GradientPaint((float)rectangle2D.getX(), (float)rectangle2D.getY(), new Color(234, 246, 253), (float)rectangle2D.getX(), (float)rectangle2D.getHeight(), new Color(167, 217, 245)));
                    graphics2D.fill(rectangularShape);
                } else {
                    graphics2D.setPaint(new GradientPaint((float)rectangle2D.getX(), (float)rectangle2D.getY(), new Color(242, 242, 242), (float)rectangle2D.getX(), (float)rectangle2D.getHeight(), new Color(185, 185, 185)));
                    graphics2D.fill(rectangularShape);
                }
                if (TabbedPane.this.fHovered == string && !PlatformInfo.isMacintosh()) {
                    graphics2D.setColor(new Color(60, 127, 177));
                    graphics2D.draw(rectangularShape);
                } else {
                    graphics2D.setColor(new Color(160, 160, 160));
                    graphics2D.draw(rectangularShape);
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                graphics2D.setColor(Color.BLACK);
                graphics2D.setFont(TabbedPane.this.fFont);
                if (PlatformInfo.isMacintosh()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                graphics2D.drawString(string2, (float)rectangle2D.getX() + 6.0f, (float)(rectangle2D.getY() + 4.0 + (double)graphics2D.getFontMetrics().getAscent()));
                if (((List)TabbedPane.this.fSubElements.get(string)).size() <= 1) continue;
                MiscellaneousIcon.DROP_DOWN_ARROW_9x6.getIcon().paintIcon((Component)((Object)this), graphics2D, (int)(rectangle2D.getX() + rectangle2D.getWidth() - 12.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 2.0));
                Line2D.Double double_ = new Line2D.Double(rectangle2D.getX() + rectangle2D.getWidth() - 16.0, rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth() - 16.0, rectangle2D.getY() + rectangle2D.getHeight());
                if (TabbedPane.this.fHovered == string && !PlatformInfo.isMacintosh()) {
                    graphics2D.setColor(new Color(60, 127, 177));
                    graphics2D.draw(double_);
                    continue;
                }
                if (TabbedPane.this.fActive != string && !PlatformInfo.isMacintosh()) continue;
                graphics2D.setColor(new Color(200, 200, 200));
                graphics2D.draw(double_);
            }
        }
    }
}

