/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.toolbox.coder.app.PopupBarListener;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolbox.coder.widgets.GuiDefaults;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public final class PopupBar {
    private final Animator fAnimator;
    private final PanelComponent fComponent;
    private final List<PopupBarListener> fListeners;
    private PopupBarContent fContent;
    private static final Icon X_ICON = GuiDefaults.createCloseIcon(18);

    public PopupBar(Animator animator) {
        this.fAnimator = animator;
        this.fComponent = new PanelComponent();
        this.fListeners = new LinkedList<PopupBarListener>();
    }

    public void addPopupBarListener(PopupBarListener popupBarListener) {
        this.fListeners.add(popupBarListener);
    }

    public void removePopupBarListener(PopupBarListener popupBarListener) {
        this.fListeners.remove(popupBarListener);
    }

    private List<PopupBarListener> getPopupBarListeners() {
        return new ArrayList<PopupBarListener>(this.fListeners);
    }

    public void update(PopupBarContent popupBarContent) {
        this.fContent = popupBarContent;
        this.fComponent.removeAll();
        this.fComponent.add(popupBarContent.createComponent(new CloseButton(popupBarContent.getCloseButtonText())));
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public PopupBarContent getContent() {
        return this.fContent;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void extend() {
        this.fComponent.extend();
    }

    public void collapse() {
        this.collapse(null);
    }

    public void collapse(Runnable runnable) {
        this.fComponent.collapse(runnable);
    }

    public boolean isExtended() {
        return this.fComponent.isExtended();
    }

    private class CloseButton
    extends MJButton {
        CloseButton(String string) {
            if (PlatformInfo.isMacintosh()) {
                this.setText(string);
                this.putClientProperty("JButton.buttonType", "roundRect");
            } else {
                this.setBackground(HintPopupFrame.BACKGROUND);
                this.setIcon(X_ICON);
            }
            if (PlatformInfo.isLinux()) {
                this.setBorder(null);
            }
            this.setName("f2f.popupBar.close");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupBar.this.collapse();
                }
            });
        }

        public Dimension getPreferredSize() {
            if (PlatformInfo.isMacintosh()) {
                return super.getPreferredSize();
            }
            return new Dimension(20, 20);
        }

        public Dimension getMinimumSize() {
            if (PlatformInfo.isMacintosh()) {
                return super.getMinimumSize();
            }
            return this.getPreferredSize();
        }
    }

    private class PanelComponent
    extends MJPanel {
        private double fExtendedPercent;

        PanelComponent() {
            this.setLayout(new BorderLayout(0, 0));
            if (!PlatformInfo.isMacintosh()) {
                this.setBorder(new Border(){

                    @Override
                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        graphics.setColor(new Color(180, 180, 180));
                        graphics.drawLine(0, PanelComponent.this.getHeight() - 1, PanelComponent.this.getWidth(), PanelComponent.this.getHeight() - 1);
                    }

                    @Override
                    public Insets getBorderInsets(Component component) {
                        return new Insets(0, 0, 1, 0);
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return true;
                    }
                });
            }
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (PlatformInfo.isMacintosh()) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(235, 235, 235), 0.0f, this.getHeight(), new Color(219, 219, 219)));
            } else {
                graphics2D.setColor(HintPopupFrame.BACKGROUND);
            }
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, (int)((double)dimension.height * this.fExtendedPercent));
        }

        public boolean isExtended() {
            return this.fExtendedPercent > 0.0;
        }

        public void extend() {
            for (PopupBarListener popupBarListener : PopupBar.this.getPopupBarListeners()) {
                popupBarListener.popupBarWillExtend(PopupBar.this);
            }
            PopupBar.this.fAnimator.animate(AnimationTrack.LINEAR, new Animation(){

                @Override
                public void step(double d) {
                    PanelComponent.this.fExtendedPercent = d;
                    if (d == 1.0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (PopupBar.this.fContent != null) {
                                    PopupBar.this.fContent.activate();
                                }
                                for (PopupBarListener popupBarListener : PopupBar.this.getPopupBarListeners()) {
                                    popupBarListener.popupBarExtended(PopupBar.this);
                                }
                            }
                        });
                    }
                    PanelComponent.this.revalidate();
                    PanelComponent.this.repaint();
                }
            });
        }

        public void collapse(final Runnable runnable) {
            for (PopupBarListener popupBarListener : PopupBar.this.getPopupBarListeners()) {
                popupBarListener.popupBarWillCollapse(PopupBar.this);
            }
            if (PopupBar.this.fContent == null) {
                return;
            }
            PopupBar.this.fContent.close();
            PopupBar.this.fContent = null;
            PopupBar.this.fAnimator.animate(AnimationTrack.LINEAR, new Animation(){

                @Override
                public void step(double d) {
                    PanelComponent.this.fExtendedPercent = 1.0 - d;
                    PanelComponent.this.revalidate();
                    PanelComponent.this.repaint();
                    if (PanelComponent.this.fExtendedPercent == 0.0 && runnable != null) {
                        runnable.run();
                    }
                    for (PopupBarListener popupBarListener : PopupBar.this.getPopupBarListeners()) {
                        popupBarListener.popupBarCollapsed(PopupBar.this);
                    }
                }
            });
        }
    }
}

