/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.InvalidFormatException;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.toolbox.coder.annot.PropertyBindingSupport;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppFacet;
import com.mathworks.toolbox.coder.app.EntryPointError;
import com.mathworks.toolbox.coder.app.EntryPointWatchService;
import com.mathworks.toolbox.coder.app.FacetAttribute;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.app.UnifiedTargetFactory;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.screener.ProjectScreenerModel;
import com.mathworks.toolbox.coder.wfa.core.CommandHistoryModel;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class CoderAppModel {
    private final Project fProject;
    private final FileSetInstance fEntryPoints;
    private final ProjectScreenerModel fScreenerModel;
    private final EntryPointWatchService fEntryPointWatcher;
    private final Map<CoderAppFacet, Boolean> fFacets;
    private final InferenceModel fInferenceModel;
    private final Set<GenericArtifact> fSupportedGenericArtifacts;
    private final Map<String, SourceSet> fSourceSets;
    private final PropertyBindingSupport fPropertySupport;
    private final Collection<Runnable> fCleanupTasks;
    private String fEntryPointBeingAnalyzed;
    private EntryPointError fEntryPointError;
    private boolean fValidated;
    private boolean fDirty;
    private CallTree fCallTree;
    private Artifact fArtifact;
    private GenericArtifact fGenericArtifact;
    private Set<File> fOutputFiles;
    private List<BuildError> fErrors;
    private CommandHistoryModel fTestSnippets;
    private File fExplicitProjectFile;
    private SourceSet fActiveSourceSet;
    private boolean fProjectOverwriteWarning;
    private boolean fDisposed;
    private boolean fTemporaryFile;
    private boolean fBuilt;
    private boolean fSuppressScreenerUpdate;
    public static final String ENTRY_POINT_ERROR_PROPERTY = "entry-point-error";
    public static final String ENTRY_POINT_BEING_ANALYZED_PROPERTY = "entry-point-being-analyzed";
    public static final String CALL_TREE_PROPERTY = "call-tree";
    public static final String ARTIFACT_PROPERTY = "artifact";
    public static final String GENERIC_ARTIFACT_PROPERTY = "generic-artifact";
    public static final String OUTPUT_FILES_PROPERTY = "output-files";
    public static final String INPUT_FILES_PROPERTY = "input-files";
    public static final String ERRORS_PROPERTY = "errors";
    public static final String BUILT_PROPERTY = "built";
    public static final String PROJECT_OVERWRITE_WARNING_PROPERTY = "overwrite-warning";
    public static final String SUPPORTS_MULTIPLE_ENTRY_POINTS_PROPERTY = "multiple-entry-points-supported";
    public static final String SUPPORTS_GLOBALS_PROPERTY = "globals-supported";
    public static final String SUPPORTS_IMPORT_AND_EXPORT_PROPERTY = "import-export-supported";
    public static final String ACTIVE_SOURCE_SET_PROPERTY = "active-source-set";
    public static final String SOURCE_SETS_PROPERTY = "registered-source-sets";
    public static final String PROJECT_FILE_PROPERTY = "project-file";
    public static final String ACTIVE_FACETS_CHANGED = "active-facets-changed";
    private static final String OBJECTIVE_PARAM_KEY = "param.objective";
    private static final String WORKFLOW_STEP_PARAM = "param.WorkflowStep";
    private static final String TEST_SNIPPETS_PARAM = "param.TestSnippets";
    private static final String HDL_WORKFLOW_PARAM = "param.hdl.Workflow";
    private static final String HDL_IP_CORE_OPTION = "option.workflow.IpCore";
    private static final String HDL_TURNKEY_OPTION = "option.workflow.FpgaTurnkey";
    private static final String HDL_GENERIC_OPTION = "option.workflow.GenericAsicFpga";
    public static final String USE_GLOBALS_PARAM_KEY = "param.UseGlobals";
    private static final String USE_GLOBALS_YES_OPTION = "option.UseGlobals.Yes";
    private static final String USE_GLOBALS_NO_OPTION = "option.UseGlobals.No";
    private static final String DEFAULT_IMPORT_EXPORT_PARAM_KEY = "param.DefaultImportExportVariable";
    private static final String SOURCE_SET_PRIMARY = "primarySourceSet";
    private static final String SOURCE_SET_CONVERTED = "convertedSourceSet";
    private static final int TEST_SNIPPET_LIMIT = 15;
    private static final String MIRROR_ON_OPEN_KEY = "var.MirrorOnOpen";
    private static final String TEST_FILE_UPGRADE_MARKER = "__fileset.testbench::";

    public static void createNew(final ParameterRunnable<CoderAppModel> parameterRunnable) throws IOException {
        final File file = File.createTempFile("temp", ".prj");
        new Thread(new Runnable(){

            @Override
            public void run() {
                final Project project = ProjectManager.create((File)file, (Target)PluginManager.getLicensedTarget((String)"target.coder"));
                GenericArtifact.getSupportedArtifacts(new ParameterRunnable<EnumSet<GenericArtifact>>(){

                    public void run(final EnumSet<GenericArtifact> enumSet) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                parameterRunnable.run((Object)new CoderAppModel(project, enumSet, true));
                            }
                        });
                    }
                });
            }
        }).start();
    }

    public static void load(final File file, final ParameterRunnable<CoderAppModel> parameterRunnable, final ParameterRunnable<Target> parameterRunnable2, final ParameterRunnable<Exception> parameterRunnable3, final boolean bl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        Target target = ProjectManager.getTarget((File)file);
                        if (target != null) {
                            Target target2 = UnifiedTargetFactory.getUnifiedTargetIfSupported(target.getKey());
                            if (!bl && target2 != null && UnifiedTargetFactory.isUnifiedTarget(target2)) {
                                final Project project = ProjectManager.load((File)file, (boolean)false, (boolean)true, (Converter)new Converter<String, Target>(){

                                    public Target convert(String string) {
                                        return UnifiedTargetFactory.getUnifiedTargetIfSupported(string);
                                    }
                                });
                                GenericArtifact.getSupportedArtifacts(new ParameterRunnable<EnumSet<GenericArtifact>>(){

                                    public void run(final EnumSet<GenericArtifact> enumSet) {
                                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                CoderAppModel coderAppModel = new CoderAppModel(project, enumSet, false);
                                                parameterRunnable.run((Object)coderAppModel);
                                            }
                                        });
                                    }
                                });
                            } else {
                                parameterRunnable2.run((Object)target);
                            }
                            break block5;
                        }
                        throw new UnavailableTargetException("Unavailable target");
                    }
                    catch (InvalidFormatException | UnavailableTargetException throwable) {
                        parameterRunnable3.run((Object)throwable);
                    }
                }
            }
        }).start();
    }

    public CoderAppModel(Project project, Set<GenericArtifact> set, boolean bl) {
        FileSetInstance fileSetInstance;
        Object object;
        Object object2;
        this.fProject = project;
        this.fTemporaryFile = bl;
        if (!this.fTemporaryFile) {
            this.fExplicitProjectFile = this.fProject.getFile();
        }
        if (this.getConfiguration().getParamAsBoolean(MIRROR_ON_OPEN_KEY)) {
            object2 = this.getConfiguration().getParamAsString("var.LegacyTarget");
            if (!((String)object2).isEmpty()) {
                object = null;
                if (((String)object2).equals("target.matlab.coder")) {
                    object = "profile.c";
                } else if (((String)object2).endsWith("target.matlab.hdlcoder")) {
                    object = "profile.hdl";
                }
                if (object != null) {
                    Utilities.mirrorParamsFromProfile(this.getConfiguration(), (String)object);
                }
            }
            this.getConfiguration().setParamAsBoolean(MIRROR_ON_OPEN_KEY, false);
        }
        this.fArtifact = CoderAppModel.getArtifact(project);
        this.fSupportedGenericArtifacts = EnumSet.copyOf(set);
        this.fOutputFiles = new HashSet<File>();
        this.fErrors = new LinkedList<BuildError>();
        this.fEntryPoints = this.fProject.getConfiguration().getFileSet("fileset.entrypoints");
        this.fScreenerModel = new ProjectScreenerModel(this.fProject.getConfiguration());
        this.fInferenceModel = new InferenceModel(this);
        this.fPropertySupport = new PropertyBindingSupport(this);
        this.fTestSnippets = new CommandHistoryModel(15);
        this.fSourceSets = new LinkedHashMap<String, SourceSet>();
        this.fFacets = new HashMap<CoderAppFacet, Boolean>();
        this.fCleanupTasks = new LinkedList<Runnable>();
        object2 = this.fProject.getConfiguration().getParamAsStringList(TEST_SNIPPETS_PARAM);
        object = Utilities.getTestFileSet((ReadableConfiguration)this.fProject.getConfiguration()).getFiles();
        if (object2 != null) {
            Collections.reverse(object2);
            fileSetInstance = object2.iterator();
            while (fileSetInstance.hasNext()) {
                String string = (String)fileSetInstance.next();
                File file = null;
                if (string.startsWith(TEST_FILE_UPGRADE_MARKER)) {
                    File file2 = ProjectManager.relativeLocationToFile((File)this.fProject.getFile(), (String)string.substring(TEST_FILE_UPGRADE_MARKER.length()));
                    string = new FileLocation(file2).getNameBeforeDot();
                    if (object.remove(file2)) {
                        file = file2;
                    }
                }
                if (file != null) {
                    this.fTestSnippets.add(file);
                    continue;
                }
                this.fTestSnippets.add(string);
            }
        }
        this.addInputSourceSet(new SourceSet(SOURCE_SET_PRIMARY, this.fEntryPoints));
        if (FixedPointDataAdapterFactory.create(this.getConfiguration()).isModeAutomatic()) {
            this.registerFixedPointSourceSet();
            this.setActiveInputSourceSet(SOURCE_SET_CONVERTED);
        } else {
            this.setActiveInputSourceSet(SOURCE_SET_PRIMARY);
        }
        this.fScreenerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CoderAppModel.this.fScreenerModel.getReportModel() != null) {
                    CoderAppModel.this.getPrimarySourceSet().setFiles(CoderAppModel.this.fScreenerModel.getReportModel().getNonMathWorksFiles());
                }
            }
        });
        if (this.fScreenerModel.getReportModel() != null) {
            this.getPrimarySourceSet().setFiles(this.fScreenerModel.getReportModel().getNonMathWorksFiles());
        }
        fileSetInstance = Utilities.getTestFileSet((ReadableConfiguration)this.fProject.getConfiguration());
        this.fTestSnippets.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CoderAppModel.this.fProject.getConfiguration().setParamAsStringList(CoderAppModel.TEST_SNIPPETS_PARAM, CoderAppModel.this.getTestSnippets().getCommands());
                fileSetInstance.remove(new LinkedList(fileSetInstance.getFiles()));
                fileSetInstance.add(CoderAppModel.this.filterOutEntryPointFiles(CoderAppModel.this.getTestSnippets().getTestFiles()));
            }
        });
        fileSetInstance.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                for (File file : fileSetInstance.getFiles()) {
                    CoderAppModel.this.fTestSnippets.add(file);
                }
            }
        });
        this.fProject.getConfiguration().setParamAsStringList(TEST_SNIPPETS_PARAM, this.getTestSnippets().getCommands());
        this.fEntryPointWatcher = new EntryPointWatchService(this.fEntryPoints, this);
        this.setGenericArtifact(CoderAppModel.getGenericArtifact(project));
    }

    private Set<File> filterOutEntryPointFiles(Set<File> set) {
        Set set2 = this.getEntryPointFileSet().getFiles();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (File file : set) {
            if (set2.contains(file.getAbsoluteFile())) continue;
            linkedHashSet.add(file);
        }
        return linkedHashSet;
    }

    public void dispose() {
        if (this.fDisposed) {
            return;
        }
        this.fDisposed = true;
        this.fScreenerModel.dispose();
        for (CoderAppFacet object : this.fFacets.keySet()) {
            object.dispose();
        }
        for (Runnable runnable : this.fCleanupTasks) {
            runnable.run();
        }
        if (this.isTemporaryProjectFile()) {
            this.fProject.getFile().delete();
        }
        ProjectManager.close((Project)this.fProject, (boolean)true);
    }

    public GenericArtifact getGenericArtifact() {
        return this.fGenericArtifact;
    }

    public Artifact getArtifact() {
        return this.fArtifact;
    }

    public String getCompiledArtifactName() {
        if (this.fArtifact == Artifact.MEX_FILE) {
            return this.getConfiguration().getParamAsString("param.mex.outputfile");
        }
        return this.getConfiguration().getParamAsString("param.grt.outputfile");
    }

    public void setGenericArtifact(GenericArtifact genericArtifact) {
        this.setGenericArtifact(genericArtifact, true);
    }

    private void setGenericArtifact(GenericArtifact genericArtifact, boolean bl) {
        if (genericArtifact == this.fGenericArtifact) {
            return;
        }
        GenericArtifact genericArtifact2 = this.fGenericArtifact;
        this.fGenericArtifact = genericArtifact;
        this.fPropertySupport.firePropertyChange(GENERIC_ARTIFACT_PROPERTY, (Object)genericArtifact2, (Object)genericArtifact);
        this.fProject.getConfiguration().setParamAsString(OBJECTIVE_PARAM_KEY, genericArtifact.getObjectiveString());
        if (bl) {
            this.setArtifact(genericArtifact.getDefaultSpecificArtifact(), false);
        }
        this.fPropertySupport.firePropertyChange(SUPPORTS_MULTIPLE_ENTRY_POINTS_PROPERTY, genericArtifact2 == GenericArtifact.C, genericArtifact == GenericArtifact.C);
        this.fPropertySupport.firePropertyChange(SUPPORTS_GLOBALS_PROPERTY, genericArtifact2 != GenericArtifact.HDL, genericArtifact != GenericArtifact.HDL);
        this.fPropertySupport.firePropertyChange(SUPPORTS_IMPORT_AND_EXPORT_PROPERTY, genericArtifact2 == GenericArtifact.C, genericArtifact != GenericArtifact.C);
        if (genericArtifact == GenericArtifact.FIXED_POINT) {
            FixedPointDataAdapterFactory.create(this.getConfiguration()).setModeAutomatic(true);
        }
    }

    public boolean supportsMultipleEntryPoints() {
        return this.fGenericArtifact == GenericArtifact.C;
    }

    public boolean supportsGlobalVariables() {
        return this.getFacetedAttributeValue(FacetAttribute.SUPPORTS_GLOBALS).equals(true);
    }

    public boolean supportsImportAndExport() {
        return this.fGenericArtifact == GenericArtifact.C;
    }

    private void setGenericArtifactIfNecessary(Artifact artifact) {
        boolean bl;
        boolean bl2 = bl = artifact == Artifact.GENERIC_ASIC_FPGA || artifact == Artifact.IP_CORE_LIBRARY || artifact == Artifact.FPGA_TURNKEY;
        if (this.fGenericArtifact != GenericArtifact.HDL && bl) {
            this.setGenericArtifact(GenericArtifact.HDL, false);
        } else if (this.fGenericArtifact == GenericArtifact.HDL && !bl) {
            this.setGenericArtifact(GenericArtifact.C, false);
        }
    }

    public void setArtifact(Artifact artifact) {
        this.setArtifact(artifact, true);
    }

    private void setArtifact(Artifact artifact, boolean bl) {
        Artifact artifact2 = this.fArtifact;
        this.fArtifact = artifact;
        if (bl) {
            this.setGenericArtifactIfNecessary(artifact);
        }
        switch (this.fArtifact) {
            case MEX_FILE: {
                this.fProject.getConfiguration().setParamAsString("param.artifact", "option.target.artifact.mex");
                break;
            }
            case STATIC_LIBRARY: {
                this.fProject.getConfiguration().setParamAsString("param.artifact", "option.target.artifact.lib");
                break;
            }
            case SHARED_LIBRARY: {
                this.fProject.getConfiguration().setParamAsString("param.artifact", "option.target.artifact.dll");
                break;
            }
            case EXECUTABLE: {
                this.fProject.getConfiguration().setParamAsString("param.artifact", "option.target.artifact.exe");
                break;
            }
            case GENERIC_ASIC_FPGA: {
                this.fProject.getConfiguration().setParamAsString(HDL_WORKFLOW_PARAM, HDL_GENERIC_OPTION);
                break;
            }
            case IP_CORE_LIBRARY: {
                this.fProject.getConfiguration().setParamAsString(HDL_WORKFLOW_PARAM, HDL_IP_CORE_OPTION);
                break;
            }
            case FPGA_TURNKEY: {
                this.fProject.getConfiguration().setParamAsString(HDL_WORKFLOW_PARAM, HDL_TURNKEY_OPTION);
            }
        }
        this.fPropertySupport.firePropertyChange(ARTIFACT_PROPERTY, (Object)artifact2, (Object)artifact);
    }

    public InferenceModel getInferenceModel() {
        return this.fInferenceModel;
    }

    public ProjectScreenerModel getScreenerModel() {
        return this.fScreenerModel;
    }

    public boolean isEntryPointSelectionRelated(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals("files") || propertyChangeEvent.getPropertyName().equals(ENTRY_POINT_ERROR_PROPERTY) || propertyChangeEvent.getPropertyName().equals(ENTRY_POINT_BEING_ANALYZED_PROPERTY);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
        this.fProject.getConfiguration().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
        this.fProject.getConfiguration().removePropertyChangeListener(propertyChangeListener);
    }

    public void addCleanupTask(Runnable runnable) {
        this.fCleanupTasks.add(runnable);
    }

    public void bind(Object object) {
        this.fPropertySupport.bind(object);
    }

    public void unbind(Object object) {
        this.fPropertySupport.unbind(object);
    }

    public Configuration getConfiguration() {
        return this.fProject.getConfiguration();
    }

    public void setEntryPointError(final EntryPointError entryPointError) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderAppModel.this.setEntryPointBeingAnalyzed(null);
                EntryPointError entryPointError2 = CoderAppModel.this.fEntryPointError;
                CoderAppModel.this.fEntryPoints.remove(new ArrayList(CoderAppModel.this.fEntryPoints.getFiles()));
                CoderAppModel.this.fEntryPointError = entryPointError;
                CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.ENTRY_POINT_ERROR_PROPERTY, (Object)entryPointError2, (Object)entryPointError);
            }
        });
    }

    public EntryPointError getEntryPointError() {
        return this.fEntryPointError;
    }

    public void setEntryPointBeingAnalyzed(final @Nullable String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = CoderAppModel.this.fEntryPointBeingAnalyzed;
                CoderAppModel.this.fEntryPointBeingAnalyzed = string;
                CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.ENTRY_POINT_BEING_ANALYZED_PROPERTY, string2, string);
            }
        });
    }

    public String getEntryPointBeingAnalyzed() {
        return this.fEntryPointBeingAnalyzed;
    }

    public void setEntryPoints(final Set<File> set) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderAppModel.this.fTemporaryFile = false;
                CoderAppModel.this.setEntryPointBeingAnalyzed(null);
                EntryPointError entryPointError = CoderAppModel.this.fEntryPointError;
                CoderAppModel.this.fEntryPointError = null;
                CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.ENTRY_POINT_ERROR_PROPERTY, (Object)entryPointError, null);
                if (!CoderAppModel.this.fEntryPoints.getFiles().equals(set)) {
                    CoderAppModel.this.fEntryPoints.remove(new ArrayList(CoderAppModel.this.fEntryPoints.getFiles()));
                    CoderAppModel.this.fEntryPoints.add(set);
                    CoderAppModel.this.autoRenameProjectFile();
                }
            }
        });
    }

    public boolean hasOverwriteWarning() {
        return this.fProjectOverwriteWarning;
    }

    public void ignoreOverwriteWarning() {
        if (this.fProjectOverwriteWarning) {
            this.fProjectOverwriteWarning = false;
            if (this.fExplicitProjectFile != null) {
                this.fExplicitProjectFile.delete();
                File file = this.fProject.getFile();
                this.fProject.setFile(this.fExplicitProjectFile);
                file.delete();
            } else {
                File file = this.getDefaultProjectFile();
                if (file != null) {
                    file.delete();
                }
                this.autoRenameProjectFile();
            }
            this.fPropertySupport.firePropertyChange(PROJECT_OVERWRITE_WARNING_PROPERTY, true, false);
        }
    }

    private void autoRenameProjectFile() {
        Set set = this.fEntryPoints.getFiles();
        boolean bl = this.fProjectOverwriteWarning;
        if (this.fExplicitProjectFile == null && !set.isEmpty()) {
            File file = CoderAppModel.getDefaultProjectFileName((File)set.iterator().next());
            if (!file.exists()) {
                File file2 = this.fProject.getFile();
                this.fProject.setFile(file);
                file2.delete();
                this.fProjectOverwriteWarning = false;
            } else {
                this.fProjectOverwriteWarning = true;
            }
        }
        this.fPropertySupport.firePropertyChange(PROJECT_OVERWRITE_WARNING_PROPERTY, bl, this.fProjectOverwriteWarning);
    }

    public File getDefaultProjectFile() {
        Set set = this.fEntryPoints.getFiles();
        return set.isEmpty() ? null : CoderAppModel.getDefaultProjectFileName((File)set.iterator().next());
    }

    public static File getDefaultProjectFileName(File file) {
        String string = new FileLocation(file).getNameBeforeDot();
        return new File(file.getParentFile(), string + ".prj");
    }

    public boolean isTemporaryProjectFile() {
        return this.fTemporaryFile;
    }

    public File getExplicitProjectFile() {
        return this.fExplicitProjectFile;
    }

    public void setProjectFile(final File file) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CoderAppModel.this.fExplicitProjectFile != null && CoderAppModel.this.fExplicitProjectFile.equals(file) || CoderAppModel.this.fProject.getConfiguration().getFile().equals(file)) {
                    return;
                }
                boolean bl = CoderAppModel.this.fProjectOverwriteWarning;
                CoderAppModel.this.fExplicitProjectFile = file;
                CoderAppModel.this.fProjectOverwriteWarning = CoderAppModel.this.fExplicitProjectFile.exists();
                if (!CoderAppModel.this.fProjectOverwriteWarning) {
                    File file2 = CoderAppModel.this.fProject.getFile();
                    CoderAppModel.this.fProject.setFile(file);
                    file2.delete();
                    CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.PROJECT_FILE_PROPERTY, file2, file);
                }
                CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.PROJECT_OVERWRITE_WARNING_PROPERTY, bl, CoderAppModel.this.fProjectOverwriteWarning);
            }
        });
    }

    public EntryPointWatchService getEntryPointWatcher() {
        return this.fEntryPointWatcher;
    }

    public File getEntryPoint() {
        Set set = this.fEntryPoints.getFiles();
        return set.isEmpty() ? null : (File)set.iterator().next();
    }

    public Function getEntryPointFunction() {
        File file = this.getEntryPoint();
        return new Function(file, new FileLocation(file).getNameBeforeDot());
    }

    public XmlReader getInputTypeData(File file) {
        return this.getEntryPointFileSet().getCustomData(file);
    }

    public boolean hasAnyInputTypeData() {
        FileSetInstance fileSetInstance = this.getEntryPointFileSet();
        for (File file : fileSetInstance.getFiles()) {
            if (fileSetInstance.getCustomData(file) == null) continue;
            XmlReader xmlReader = fileSetInstance.getCustomData(file);
            if (xmlReader.getChild(new String[]{"Input"}).readText("Class") == null) continue;
            return true;
        }
        return false;
    }

    public FileSetInstance getEntryPointFileSet() {
        return this.fEntryPoints;
    }

    public void setCallTree(CallTree callTree) {
        CallTree callTree2 = this.fCallTree;
        this.fCallTree = callTree;
        this.fPropertySupport.firePropertyChange(CALL_TREE_PROPERTY, callTree2, callTree);
    }

    public CallTree getCallTree() {
        return this.fCallTree;
    }

    public Set<GenericArtifact> getSupportedGenericArtifacts() {
        return EnumSet.copyOf(this.fSupportedGenericArtifacts);
    }

    private static GenericArtifact getGenericArtifact(Project project) {
        String string = project.getConfiguration().getParamAsString(OBJECTIVE_PARAM_KEY);
        if (string != null && string.contains("hdl") && CoderApp.isUsingUnifiedUIForHDL()) {
            return GenericArtifact.HDL;
        }
        if (CoderApp.isUsingUnifiedUIForC()) {
            if (string != null && string.contains("fixedpoint")) {
                return GenericArtifact.FIXED_POINT;
            }
            return GenericArtifact.C;
        }
        return GenericArtifact.FIXED_POINT;
    }

    private static Artifact getArtifact(Project project) {
        String string;
        if (project.getConfiguration().getTargetKey().contains("hdl")) {
            String string2;
            switch (string2 = project.getConfiguration().getParamAsString(HDL_WORKFLOW_PARAM)) {
                case "option.workflow.FpgaTurnkey": {
                    return Artifact.FPGA_TURNKEY;
                }
                case "option.workflow.IpCore": {
                    return Artifact.IP_CORE_LIBRARY;
                }
            }
            return Artifact.GENERIC_ASIC_FPGA;
        }
        switch (string = project.getConfiguration().getParamAsString("param.artifact")) {
            case "option.target.artifact.dll": {
                return Artifact.SHARED_LIBRARY;
            }
            case "option.target.artifact.exe": {
                return Artifact.EXECUTABLE;
            }
            case "option.target.artifact.lib": {
                return Artifact.STATIC_LIBRARY;
            }
        }
        return Artifact.MEX_FILE;
    }

    public void setOutputFiles(@Nullable Set<File> set) {
        Set<File> set2 = this.fOutputFiles;
        this.fOutputFiles = set == null ? new TreeSet<File>() : new TreeSet<File>(set);
        this.fPropertySupport.firePropertyChange(OUTPUT_FILES_PROPERTY, set2, this.fOutputFiles);
    }

    public Set<File> getOutputFiles() {
        return new TreeSet<File>(this.fOutputFiles);
    }

    public void setInputFiles(Set<File> set, String string) {
        if (!this.fSourceSets.containsKey(string)) {
            return;
        }
        SourceSet sourceSet = this.fSourceSets.get(string);
        sourceSet.setFiles(set);
    }

    @Deprecated
    public void setInputFiles(Set<File> set) {
        if (this.getActiveInputSourceSet() != null) {
            this.setInputFiles(set, this.getActiveInputSourceSet().getKey());
        }
    }

    public Set<File> getInputFiles() {
        return this.getActiveInputSourceSet() != null ? this.getActiveInputSourceSet().getFiles() : new TreeSet();
    }

    public boolean registerFixedPointSourceSet() {
        if (this.getFixedPointSourceSet() == null) {
            this.addInputSourceSet(new SourceSet(SOURCE_SET_CONVERTED));
            return true;
        }
        return false;
    }

    public Set<SourceSet> getInputSourceSets() {
        return new LinkedHashSet<SourceSet>(this.fSourceSets.values());
    }

    public SourceSet getPrimarySourceSet() {
        return this.getInputSourceSet(SOURCE_SET_PRIMARY);
    }

    public SourceSet getFixedPointSourceSet() {
        return this.getInputSourceSet(SOURCE_SET_CONVERTED);
    }

    public void setActiveInputSourceSet(String string) {
        this.setActiveInputSourceSet(this.fSourceSets.get(string));
    }

    public void setActiveInputSourceSet(SourceSet sourceSet) {
        SourceSet sourceSet2;
        SourceSet sourceSet3;
        if (sourceSet != null && this.fSourceSets.containsKey(sourceSet.getKey()) && (sourceSet3 = this.fSourceSets.get(sourceSet.getKey())) == sourceSet && sourceSet3 != this.fActiveSourceSet && ((sourceSet2 = this.fActiveSourceSet) == null || sourceSet2.isDeactivatable()) && sourceSet3.isActivatable()) {
            this.fActiveSourceSet = sourceSet3;
            FixedPointDataAdapterFactory.create(this.getConfiguration()).setModeAutomatic(sourceSet.getKey().equals(SOURCE_SET_CONVERTED));
            this.fPropertySupport.firePropertyChange(ACTIVE_SOURCE_SET_PROPERTY, sourceSet2, this.fActiveSourceSet);
        }
    }

    public Object getFacetedAttributeValue(FacetAttribute facetAttribute) {
        Object object = facetAttribute.getDefaultValue();
        for (Map.Entry<CoderAppFacet, Boolean> entry : this.fFacets.entrySet()) {
            if (!entry.getValue().booleanValue() || entry.getKey().getAttributeValue(facetAttribute) == null) continue;
            object = facetAttribute.getResolver().resolveValue(object, entry.getKey().getAttributeValue(facetAttribute));
        }
        return object;
    }

    public SourceSet getActiveInputSourceSet() {
        return this.fActiveSourceSet;
    }

    public SourceSet getInputSourceSet(String string) {
        return this.fSourceSets.get(string);
    }

    private void addInputSourceSet(SourceSet sourceSet) {
        if (this.fSourceSets.containsKey(sourceSet.getKey())) {
            throw new IllegalArgumentException(String.format("SourceSet with key '%s' already exists.", sourceSet.getKey()));
        }
        Set<SourceSet> set = this.getInputSourceSets();
        this.fSourceSets.put(sourceSet.getKey(), sourceSet);
        sourceSet.addSourceSetObserver(new ParameterRunnable<SourceSet>(){

            public void run(SourceSet sourceSet) {
                if (CoderAppModel.this.getActiveInputSourceSet() != null && CoderAppModel.this.getActiveInputSourceSet().equals(sourceSet)) {
                    CoderAppModel.this.fPropertySupport.firePropertyChange(CoderAppModel.INPUT_FILES_PROPERTY, new TreeSet(), sourceSet.getFiles());
                }
            }
        });
        this.fPropertySupport.firePropertyChange(SOURCE_SETS_PROPERTY, set, this.getInputSourceSets());
    }

    public void setErrors(List<BuildError> list) {
        List<BuildError> list2 = this.fErrors;
        this.fErrors = new ArrayList<BuildError>(list);
        this.fPropertySupport.firePropertyChange(ERRORS_PROPERTY, list2, this.fErrors);
    }

    public List<BuildError> getErrors() {
        return new ArrayList<BuildError>(this.fErrors);
    }

    public void setBuilt(boolean bl) {
        boolean bl2 = this.fBuilt;
        this.fBuilt = bl;
        this.fPropertySupport.firePropertyChange(new PropertyChangeEvent(this, BUILT_PROPERTY, bl2, bl));
    }

    public boolean isBuilt() {
        return this.fBuilt;
    }

    public String getProjectWorkingFolder() {
        String string;
        switch (string = this.getConfiguration().getParamAsString("param.WorkingFolder")) {
            case "option.WorkingFolder.Specified": {
                return this.getConfiguration().getParamAsString("param.SpecifiedWorkingFolder");
            }
            case "option.WorkingFolder.Project": {
                return this.getConfiguration().getFile().getParent();
            }
        }
        return "";
    }

    public CommandHistoryModel getTestSnippets() {
        return this.fTestSnippets;
    }

    public void setCurrentWorkflowStep(Step step) {
        this.fProject.getConfiguration().setParamAsString(WORKFLOW_STEP_PARAM, step.getKey());
    }

    public Step getCurrentWorkflowStep(StepModel stepModel) {
        String string = this.fProject.getConfiguration().getParamAsString(WORKFLOW_STEP_PARAM);
        for (Step step : stepModel.getSteps()) {
            if (!step.getKey().equals(string)) continue;
            return step;
        }
        return null;
    }

    public void setUseGlobalVariables(boolean bl) {
        this.fProject.getConfiguration().setParamAsString(USE_GLOBALS_PARAM_KEY, bl ? USE_GLOBALS_YES_OPTION : USE_GLOBALS_NO_OPTION);
    }

    public boolean isUsingGlobalVariables() {
        return this.supportsGlobalVariables() && this.fProject.getConfiguration().getParamAsString(USE_GLOBALS_PARAM_KEY).equals(USE_GLOBALS_YES_OPTION);
    }

    public void setDefaultImportExportVariable(String string) {
        this.fProject.getConfiguration().setParamAsString(DEFAULT_IMPORT_EXPORT_PARAM_KEY, string);
    }

    public String getDefaultImportExportVariable() {
        return this.fProject.getConfiguration().getParamAsString(DEFAULT_IMPORT_EXPORT_PARAM_KEY);
    }

    public boolean isSuppressScreenerUpdate() {
        return this.fSuppressScreenerUpdate;
    }

    public void setSuppressScreenerUpdate(boolean bl) {
        this.fSuppressScreenerUpdate = bl;
    }

    void installFacet(CoderAppFacet coderAppFacet, CoderApp coderApp, boolean bl) {
        if (!this.fFacets.containsKey(coderAppFacet)) {
            this.fFacets.put(coderAppFacet, false);
            coderAppFacet.init(coderApp);
            if (bl) {
                this.setFacetEnabled(coderAppFacet, true);
            }
        }
    }

    public void setFacetEnabled(CoderAppFacet coderAppFacet, boolean bl) {
        HashMap<CoderAppFacet, Boolean> hashMap;
        if (this.fFacets.containsKey(coderAppFacet)) {
            hashMap = new HashMap<CoderAppFacet, Boolean>(this.fFacets);
            this.fFacets.put(coderAppFacet, bl);
            if (bl) {
                coderAppFacet.enable();
            } else {
                coderAppFacet.disable();
            }
        } else {
            throw new IllegalArgumentException("Specified facet has not been installed: " + coderAppFacet);
        }
        this.fPropertySupport.firePropertyChange(ACTIVE_FACETS_CHANGED, hashMap, new HashMap<CoderAppFacet, Boolean>(this.fFacets));
    }

    Map<CoderAppFacet, Boolean> getFacets() {
        return new HashMap<CoderAppFacet, Boolean>(this.fFacets);
    }

    public <T extends CoderAppFacet> T getInstalledFacet(Class<T> clazz) {
        for (CoderAppFacet coderAppFacet : this.fFacets.keySet()) {
            if (!clazz.isAssignableFrom(coderAppFacet.getClass())) continue;
            return (T)((CoderAppFacet)clazz.cast(coderAppFacet));
        }
        return null;
    }
}

