/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.List;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.jca.ServiceId;

public class GetInstance {
    private GetInstance() {
    }

    public static Provider.Service getService(String string, String string2) throws NoSuchAlgorithmException {
        ProviderList providerList = Providers.getProviderList();
        Provider.Service service = providerList.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException(string2 + " " + string + " not available");
        }
        return service;
    }

    public static Provider.Service getService(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider provider = Providers.getProviderList().getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string3);
        }
        Provider.Service service = provider.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string2 + " for provider " + string3);
        }
        return service;
    }

    public static Provider.Service getService(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider.Service service = provider.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string2 + " for provider " + provider.getName());
        }
        return service;
    }

    public static List<Provider.Service> getServices(String string, String string2) {
        ProviderList providerList = Providers.getProviderList();
        return providerList.getServices(string, string2);
    }

    @Deprecated
    public static List<Provider.Service> getServices(String string, List<String> list) {
        ProviderList providerList = Providers.getProviderList();
        return providerList.getServices(string, list);
    }

    public static List<Provider.Service> getServices(List<ServiceId> list) {
        ProviderList providerList = Providers.getProviderList();
        return providerList.getServices(list);
    }

    public static Instance getInstance(String string, Class clazz, String string2) throws NoSuchAlgorithmException {
        ProviderList providerList = Providers.getProviderList();
        Provider.Service service = providerList.getService(string, string2);
        if (service == null) {
            throw new NoSuchAlgorithmException(string2 + " " + string + " not available");
        }
        try {
            return GetInstance.getInstance(service, clazz);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            for (Provider.Service service2 : providerList.getServices(string, string2)) {
                if (service2 == service) continue;
                try {
                    return GetInstance.getInstance(service2, clazz);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                    noSuchAlgorithmException2 = noSuchAlgorithmException3;
                }
            }
            throw noSuchAlgorithmException2;
        }
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices(string, string2);
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (Provider.Service service : list) {
            try {
                return GetInstance.getInstance(service, clazz, object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string2 + " " + string + " not available");
    }

    public static Instance getInstance(String string, Class clazz, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, string3), clazz);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, string3), clazz, object);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, provider), clazz);
    }

    public static Instance getInstance(String string, Class clazz, String string2, Object object, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(GetInstance.getService(string, string2, provider), clazz, object);
    }

    public static Instance getInstance(Provider.Service service, Class clazz) throws NoSuchAlgorithmException {
        Object object = service.newInstance(null);
        GetInstance.checkSuperClass(service, object.getClass(), clazz);
        return new Instance(service.getProvider(), object);
    }

    public static Instance getInstance(Provider.Service service, Class clazz, Object object) throws NoSuchAlgorithmException {
        Object object2 = service.newInstance(object);
        GetInstance.checkSuperClass(service, object2.getClass(), clazz);
        return new Instance(service.getProvider(), object2);
    }

    public static void checkSuperClass(Provider.Service service, Class clazz, Class clazz2) throws NoSuchAlgorithmException {
        if (clazz2 == null) {
            return;
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new NoSuchAlgorithmException("class configured for " + service.getType() + ": " + service.getClassName() + " not a " + service.getType());
        }
    }

    public static final class Instance {
        public final Provider provider;
        public final Object impl;

        private Instance(Provider provider, Object object) {
            this.provider = provider;
            this.impl = object;
        }

        public Object[] toArray() {
            return new Object[]{this.impl, this.provider};
        }
    }
}

