/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.util;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Logger;

public final class ConfigReader {
    private static final Logger sLogger = Logger.getLogger(ConfigReader.class.getName());
    private static final ConfigReaderImpl reader = new ConfigReaderImpl();

    public static void init(String configFile) throws Exception {
        try {
            ConfigReader.reader.init(configFile);
        }
        catch (Exception e) {
            sLogger.severe(e.toString());
            throw e;
        }
    }

    public static void initNoConfig() throws Exception {
        ConfigReader.reader.initNoConfig();
    }

    public static boolean isInitialized() {
        return reader.isInitialized();
    }

    public static String getValue(String parameter, String defaultValue) {
        return reader.getValue(parameter, defaultValue);
    }

    public static int getValueAsInt(String parameter, int defaultValue) {
        String str = ConfigReader.getValue(parameter, Integer.toString(defaultValue));
        return Integer.parseInt(str, 10);
    }

    public static boolean getValueAsBool(String parameter, boolean defaultValue) {
        String str = ConfigReader.getValue(parameter, Boolean.toString(defaultValue));
        return str.equals("true");
    }

    private static class ConfigReaderImpl {
        private Properties prop = null;
        private boolean initialized = false;

        private ConfigReaderImpl() {
        }

        private void init(String configFile) throws Exception {
            FileInputStream stream = new FileInputStream(configFile);
            this.prop = new Properties();
            this.prop.load(stream);
            stream.close();
            this.initialized = true;
        }

        private void initNoConfig() {
            this.prop = null;
            this.initialized = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public String getValue(String parameter, String defaultValue) {
            if (this.prop == null || !this.prop.containsKey(parameter)) {
                return defaultValue;
            }
            return (String)this.prop.get(parameter);
        }
    }
}

