/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.ImageRotator;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;

public class RotatedText {
    private static Hashtable sCache = new Hashtable();
    private String fText;
    private int fAngle;
    private transient Point fOrigin;
    private transient Image fImage;

    public RotatedText(String string, int n) {
        this.fText = string;
        this.fAngle = n;
        this.fImage = null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component) {
        if (this.fAngle == 0) {
            graphics.drawString(this.fText, n, n2);
        } else {
            if (this.fImage == null) {
                this.buildImage(graphics, component);
            }
            if (this.fImage != null) {
                if (this.fOrigin == null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n3 = fontMetrics.getAscent();
                    int n4 = fontMetrics.stringWidth(this.fText);
                    int n5 = fontMetrics.getHeight();
                    this.calcOriginOffset(n4, n5, n3);
                }
                graphics.drawImage(this.fImage, n + this.fOrigin.x, n2 + this.fOrigin.y, component);
            }
        }
    }

    private void calcOriginOffset(int n, int n2, int n3) {
        switch (this.fAngle) {
            case 90: {
                this.fOrigin = new Point(-n3, -n);
                break;
            }
            case 180: {
                this.fOrigin = new Point(-n, n3 - n2);
                break;
            }
            case 270: {
                this.fOrigin = new Point(n3 - n2, 0);
                break;
            }
            default: {
                this.fOrigin = new Point(0, -n3);
            }
        }
    }

    public void setAngle(int n) {
        if (n != this.fAngle) {
            this.fAngle = n;
            this.fImage = null;
            this.fOrigin = null;
        }
    }

    public void setText(String string) {
        if (!string.equals(this.fText)) {
            this.fText = string;
            this.fImage = null;
            this.fOrigin = null;
        }
    }

    public void flushImage() {
        if (this.fImage != null) {
            this.fImage.flush();
        }
    }

    private void buildImage(Graphics graphics, Component component) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.fText);
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        int[] nArray = new int[n * n2];
        boolean bl = false;
        int n4 = 0xFFFFFF & graphics.getColor().getRGB();
        n4 = n4 == 0xFFFFFF ? -16777216 : -1;
        Image image = component.createImage(n, n2);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(new Color(n4));
        graphics2.fillRect(0, 0, n, n2);
        graphics2.setFont(graphics.getFont());
        graphics2.setColor(graphics.getColor());
        graphics2.drawString(this.fText, 0, n3);
        graphics2.dispose();
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            bl = pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            image.flush();
            n4 &= 0xFFFFFF;
            for (int i = 0; i < nArray.length; ++i) {
                if ((nArray[i] & 0xFFFFFF) != n4) continue;
                nArray[i] = 0;
            }
            this.fImage = ImageRotator.rotateImage(nArray, n, n2, this.fAngle);
        } else {
            this.fImage = ImageRotator.rotateImage(image, this.fAngle);
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(this.fImage, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawRotatedText(Graphics graphics, String string, int n, int n2, int n3, Component component) {
        RotatedText rotatedText;
        String string2 = string + n3;
        if (sCache.containsKey(string2)) {
            rotatedText = (RotatedText)sCache.get(string2);
        } else {
            rotatedText = new RotatedText(string, n3);
            sCache.put(string2, rotatedText);
        }
        rotatedText.draw(graphics, n, n2, component);
    }
}

