/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private static final Lookup[] EMPTY_ARR = new Lookup[0];
    private Object lookups;
    private HashMap results;

    public ProxyLookup(Lookup[] lookupArray) {
        this.setLookupsNoFire(lookupArray);
    }

    protected ProxyLookup() {
        this(EMPTY_ARR);
    }

    public String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getLookups(false));
    }

    protected final Lookup[] getLookups() {
        return this.getLookups(true);
    }

    private final Lookup[] getLookups(boolean bl) {
        Object object = this.lookups;
        if (object instanceof Lookup) {
            return new Lookup[]{(Lookup)object};
        }
        Lookup[] lookupArray = (Lookup[])object;
        if (bl) {
            lookupArray = (Lookup[])lookupArray.clone();
        }
        return lookupArray;
    }

    private void setLookupsNoFire(Lookup[] lookupArray) {
        if (lookupArray.length == 1) {
            this.lookups = lookupArray[0];
            assert (this.lookups != null) : "Cannot assign null delegate";
        } else {
            this.lookups = lookupArray.length == 0 ? EMPTY_ARR : lookupArray.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Lookup[] lookupArray) {
        LookupListener lookupListener;
        Reference[] referenceArray;
        Object object = this;
        synchronized (object) {
            Lookup[] lookupArray2 = this.getLookups(false);
            HashSet<Lookup> hashSet = new HashSet<Lookup>(Arrays.asList(lookupArray2));
            HashSet<Lookup> hashSet2 = new HashSet<Lookup>(Arrays.asList(lookupArray));
            this.setLookupsNoFire(lookupArray);
            if (this.results == null || this.results.isEmpty()) {
                return;
            }
            referenceArray = this.results.values().toArray(new Reference[0]);
            HashSet<Lookup> hashSet3 = new HashSet<Lookup>(hashSet);
            hashSet3.removeAll(hashSet2);
            hashSet2.removeAll(hashSet);
            if (hashSet3.isEmpty() && hashSet2.isEmpty()) {
                return;
            }
            for (int i = 0; i < referenceArray.length; ++i) {
                lookupListener = (R)referenceArray[i].get();
                if (lookupListener == null) continue;
                ((R)lookupListener).lookupChange(hashSet2, hashSet3, lookupArray2, lookupArray);
            }
        }
        object = new ArrayList();
        for (int i = 0; i < referenceArray.length; ++i) {
            R r = (R)referenceArray[i].get();
            if (r == null) continue;
            r.collectFires((Collection)object);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            LookupEvent lookupEvent = (LookupEvent)iterator.next();
            lookupListener = (LookupListener)iterator.next();
            lookupListener.resultChanged(lookupEvent);
        }
    }

    protected void beforeLookup(Lookup.Template template) {
    }

    @Override
    public final Object lookup(Class clazz) {
        this.beforeLookup(new Lookup.Template(clazz));
        Lookup[] lookupArray = this.getLookups(false);
        for (int i = 0; i < lookupArray.length; ++i) {
            Object object = lookupArray[i].lookup(clazz);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        Lookup[] lookupArray = this.getLookups(false);
        for (int i = 0; i < lookupArray.length; ++i) {
            Lookup.Item item = lookupArray[i].lookupItem(template);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public final synchronized Lookup.Result lookup(Lookup.Template template) {
        R r;
        if (this.results != null) {
            Reference reference = (Reference)this.results.get(template);
            R r2 = r = reference == null ? null : (R)reference.get();
            if (r != null) {
                return r;
            }
        } else {
            this.results = new HashMap();
        }
        r = new R(template);
        this.results.put(template, new SoftReference<R>(r));
        return r;
    }

    private final synchronized void unregisterTemplate(Lookup.Template template) {
        if (this.results == null) {
            return;
        }
        Reference reference = (Reference)this.results.remove(template);
        if (reference != null && reference.get() != null) {
            this.results.put(template, reference);
        }
    }

    private final class R
    extends WaitableResult
    implements LookupListener {
        private EventListenerList listeners;
        private Lookup.Template template;
        private Lookup.Result[] results;
        private Collection[] cache;

        public R(Lookup.Template template) {
            this.template = template;
        }

        protected void finalize() {
            ProxyLookup.this.unregisterTemplate(this.template);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result[] initResults() {
            Lookup[] lookupArray = this;
            synchronized (this) {
                if (this.results != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.results;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                lookupArray = ProxyLookup.this.getLookups(false);
                Lookup.Result[] resultArray = new Lookup.Result[lookupArray.length];
                for (int i = 0; i < resultArray.length; ++i) {
                    resultArray[i] = lookupArray[i].lookup(this.template);
                }
                Lookup[] lookupArray2 = this;
                synchronized (this) {
                    if (this.results != null) {
                        // ** MonitorExit[var3_5] (shouldn't be in output)
                        return this.results;
                    }
                    for (int i = 0; i < resultArray.length; ++i) {
                        resultArray[i].addLookupListener((LookupListener)this);
                    }
                    this.results = resultArray;
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return resultArray;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void lookupChange(Set set, Set set2, Lookup[] lookupArray, Lookup[] lookupArray2) {
            R r = this;
            synchronized (r) {
                if (this.results == null) {
                    return;
                }
                HashMap<Lookup, Lookup.Result> hashMap = new HashMap<Lookup, Lookup.Result>(lookupArray.length * 2);
                for (int i = 0; i < lookupArray.length; ++i) {
                    if (set2.contains(lookupArray[i])) {
                        this.results[i].removeLookupListener(this);
                        continue;
                    }
                    hashMap.put(lookupArray[i], this.results[i]);
                }
                Lookup.Result[] resultArray = new Lookup.Result[lookupArray2.length];
                for (int i = 0; i < lookupArray2.length; ++i) {
                    if (set.contains(lookupArray2[i])) {
                        resultArray[i] = lookupArray2[i].lookup(this.template);
                        resultArray[i].addLookupListener(this);
                        continue;
                    }
                    resultArray[i] = (Lookup.Result)hashMap.get(lookupArray2[i]);
                    if (resultArray[i] != null) continue;
                    throw new IllegalStateException();
                }
                this.results = resultArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                R r = this;
                synchronized (r) {
                    if (this.listeners == null) {
                        this.listeners = new EventListenerList();
                    }
                }
            }
            this.listeners.add(LookupListener.class, lookupListener);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, lookupListener);
            }
        }

        @Override
        public Collection allInstances() {
            return this.computeResult(0);
        }

        @Override
        public Set allClasses() {
            return (Set)this.computeResult(1);
        }

        @Override
        public Collection allItems() {
            return this.computeResult(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int n) {
            Collection collection;
            Lookup.Result[] resultArray = this.myBeforeLookup();
            ArrayList arrayList = this;
            synchronized (arrayList) {
                if (this.cache != null && (collection = this.cache[n]) != null) {
                    return collection;
                }
            }
            if (n == 1) {
                arrayList = new HashSet();
                collection = Collections.unmodifiableSet((Set)((Object)arrayList));
            } else {
                arrayList = new ArrayList(resultArray.length * 2);
                collection = Collections.unmodifiableList(arrayList);
            }
            block11: for (int i = 0; i < resultArray.length; ++i) {
                switch (n) {
                    case 0: {
                        arrayList.addAll(resultArray[i].allInstances());
                        continue block11;
                    }
                    case 1: {
                        arrayList.addAll(resultArray[i].allClasses());
                        continue block11;
                    }
                    case 2: {
                        arrayList.addAll(resultArray[i].allItems());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Wrong index: " + n;
                        continue block11;
                    }
                }
            }
            R r = this;
            synchronized (r) {
                if (this.cache == null) {
                    this.cache = new Collection[3];
                }
                if (resultArray == this.results) {
                    this.cache[n] = collection;
                }
            }
            return collection;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection collection) {
            Object object;
            Collection collection2;
            Collection collection3;
            R r = this;
            synchronized (r) {
                if (this.cache == null) {
                    return;
                }
                collection3 = this.cache[0];
                collection2 = this.cache[2];
                if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                    this.cache = new Collection[3];
                    return;
                }
                this.cache = null;
            }
            boolean bl = true;
            if (collection2 != null) {
                object = this.allItems();
                if (collection2.equals(object)) {
                    bl = false;
                }
            } else if (collection3 != null) {
                object = this.allInstances();
                if (collection3.equals(object)) {
                    bl = false;
                }
            } else {
                object = this;
                synchronized (object) {
                    if (this.cache == null) {
                        this.cache = new Collection[3];
                    }
                }
            }
            assert (this.cache != null);
            if (bl) {
                object = new LookupEvent(this);
                AbstractLookup.notifyListeners(this.listeners.getListenerList(), (LookupEvent)object, collection);
            }
        }

        private Lookup.Result[] myBeforeLookup() {
            ProxyLookup.this.beforeLookup(this.template);
            Lookup.Result[] resultArray = this.initResults();
            for (int i = 0; i < resultArray.length; ++i) {
                if (!(resultArray[i] instanceof WaitableResult)) continue;
                WaitableResult waitableResult = (WaitableResult)resultArray[i];
                waitableResult.beforeLookup(this.template);
            }
            return resultArray;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.template.getType()) {
                this.myBeforeLookup();
            }
        }
    }
}

