/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MWScrollbar
extends MWCanvas
implements Adjustable,
MouseListener,
MouseMotionListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int NO_PART = -1;
    public static final int DECREMENT_ARROW = 0;
    public static final int DECREMENT_PAGE = 1;
    public static final int THUMB = 2;
    public static final int INCREMENT_PAGE = 3;
    public static final int INCREMENT_ARROW = 4;
    private static final int INIT_SLEEP = 250;
    private static final int SLEEP = 25;
    private static final Color sXPScrollbar = new Color(239, 231, 231);
    private static int sThreadCount = 0;
    private int fBlockIncrement;
    private int fMaximum;
    private int fMinimum;
    private int fOrientation;
    private int fUnitIncrement;
    private int fValue;
    private int fVisibleAmount;
    private boolean fThumbProportional;
    private Rectangle[] fRects;
    private Point fThumbClickOffset;
    private int fTrackingPart;
    private boolean fMouseDown;
    private Point fMousePoint;
    private int fMouseDownID;
    private int fPreferredLength;
    private int fPreferredWidth;
    private int fMinimumLength;
    private int fMinimumWidth;
    private transient int fRolloverPart;
    private transient boolean fHasRollover;
    private transient Rectangle fRolloverRect;
    transient AdjustmentListener fAdjustmentListener;

    public MWScrollbar(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: 
            case 1: {
                this.fOrientation = n;
                break;
            }
            default: {
                this.fOrientation = 0;
            }
        }
        this.fTrackingPart = -1;
        this.fRects = new Rectangle[5];
        for (int i = 0; i < 5; ++i) {
            this.fRects[i] = new Rectangle();
        }
        this.setValues(n2, n3, n4, n5);
        this.fBlockIncrement = this.fVisibleAmount;
        this.fUnitIncrement = 1;
        this.fPreferredLength = 200;
        this.fPreferredWidth = 16;
        this.fMinimumLength = 22;
        this.fMinimumWidth = 11;
        this.fMouseDownID = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public MWScrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public MWScrollbar() {
        this(0, 0, 10, 0, 100);
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawScrollbar(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.drawScrollbar(graphics);
    }

    private void drawScrollbar(Graphics graphics) {
        boolean bl;
        this.calcRects();
        boolean bl2 = bl = this.isEnabled() && this.fMaximum > this.fMinimum;
        if (PlatformInfo.getAppearance() == 0 && bl) {
            bl = MWUtils.isParentFrameActive(this);
        }
        Decorations.drawScrollTrack(graphics, this.fRects[1], 1, this.fOrientation, this.fTrackingPart == 1, bl);
        Decorations.drawScrollTrack(graphics, this.fRects[3], 3, this.fOrientation, this.fTrackingPart == 3, bl);
        Decorations.drawScrollThumb(graphics, this.fRects[2], this.fOrientation, this.fTrackingPart == 2, bl, this.fRolloverPart == 2);
        boolean bl3 = this.fTrackingPart == 0 && this.fRects[this.fTrackingPart].contains(this.fMousePoint);
        Rectangle rectangle = this.fRects[0];
        Rectangle rectangle2 = this.fRects[4];
        if (PlatformInfo.useWindowsXPAppearance()) {
            this.drawRectangleOutline(graphics, this.fRects[2]);
            graphics.setColor(sXPScrollbar);
            graphics.translate(this.fRects[0].x, this.fRects[0].y);
            graphics.drawLine(0, 0, 0, this.fRects[0].height);
            graphics.translate(-this.fRects[0].x, -this.fRects[0].y);
            rectangle = new Rectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            rectangle2 = new Rectangle(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
        }
        Decorations.drawScrollArrowButton(graphics, rectangle, bl3, bl, this.fRolloverPart == 0, this.fOrientation, 0);
        boolean bl4 = bl3 = this.fTrackingPart == 4 && this.fRects[this.fTrackingPart].contains(this.fMousePoint);
        if (PlatformInfo.useWindowsXPAppearance()) {
            this.drawRectangleOutline(graphics, rectangle);
            graphics.setColor(sXPScrollbar);
            graphics.translate(this.fRects[4].x, this.fRects[4].y);
            graphics.drawLine(0, 0, 0, this.fRects[4].height);
            graphics.translate(-this.fRects[4].x, -this.fRects[4].y);
        }
        Decorations.drawScrollArrowButton(graphics, rectangle2, bl3, bl, this.fRolloverPart == 4, this.fOrientation, 4);
        if (PlatformInfo.useWindowsXPAppearance()) {
            this.drawRectangleOutline(graphics, rectangle2);
        }
    }

    private void drawRectangleOutline(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(sXPScrollbar);
        graphics.translate(rectangle.x, rectangle.y);
        graphics.drawLine(rectangle.width, 0, rectangle.width, rectangle.height);
        graphics.drawLine(0, rectangle.height, rectangle.width, rectangle.height);
        graphics.drawLine(-1, -1, rectangle.width, -1);
        graphics.drawLine(-1, -1, -1, rectangle.height);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private void calcRects() {
        Dimension dimension = this.getSize();
        if (this.fOrientation == 0) {
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = n2 - 2 * n;
            this.fRects[0].setBounds(0, 0, n, n);
            this.fRects[4].setBounds(0, n2 - n, n, n);
            if (n3 <= 0) {
                this.fRects[2].setBounds(0, n, n, 0);
                this.fRects[1].setBounds(0, n, n, 0);
                this.fRects[3].setBounds(0, n, n, 0);
            } else {
                int n4 = this.thumbLength(dimension);
                int n5 = this.valueToPos(this.fValue, dimension);
                this.fRects[1].setBounds(0, n, n, n5);
                this.fRects[2].setBounds(0, n + n5, n, n4);
                this.fRects[3].setBounds(0, n + n5 + n4, n, n3 - n4 - n5);
            }
        } else {
            int n = dimension.height;
            int n6 = dimension.width;
            int n7 = n6 - 2 * n;
            this.fRects[0].setBounds(0, 0, n, n);
            this.fRects[4].setBounds(n6 - n, 0, n, n);
            if (n7 <= 0) {
                this.fRects[2].setBounds(n, 0, 0, n);
                this.fRects[1].setBounds(n, 0, 0, n);
                this.fRects[3].setBounds(n, 0, 0, n);
            } else {
                int n8 = this.thumbLength(dimension);
                int n9 = this.valueToPos(this.fValue, dimension);
                this.fRects[1].setBounds(n, 0, n9, n);
                this.fRects[2].setBounds(n + n9, 0, n8, n);
                this.fRects[3].setBounds(n + n9 + n8, 0, n7 - n8 - n9, n);
            }
        }
    }

    private int findPart(Point point) {
        int n = -1;
        for (int i = 0; i < 5; ++i) {
            if (!this.fRects[i].contains(point)) continue;
            n = i;
        }
        return n;
    }

    private int minimumThumbLength(Dimension dimension) {
        int n;
        if (dimension == null) {
            dimension = this.getSize();
        }
        int n2 = n = this.fOrientation == 0 ? dimension.width : dimension.height;
        if (PlatformInfo.getAppearance() == 1) {
            n /= 2;
        }
        return n;
    }

    private int thumbLength(Dimension dimension) {
        int n;
        int n2;
        int n3;
        if (dimension == null) {
            dimension = this.getSize();
        }
        int n4 = this.fOrientation == 0 ? dimension.height - 2 * dimension.width : dimension.width - 2 * dimension.height;
        int n5 = n3 = this.fOrientation == 0 ? dimension.width : dimension.height;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n2 = n4 * this.fVisibleAmount / (n = this.fMaximum - this.fMinimum + this.fVisibleAmount)) < this.minimumThumbLength(dimension)) {
            n2 = this.minimumThumbLength(dimension);
        }
        return n2;
    }

    private int posToValue(int n, Dimension dimension) {
        int n2;
        int n3;
        if (dimension == null) {
            dimension = this.getSize();
        }
        int n4 = n3 = this.fOrientation == 0 ? dimension.height - 2 * dimension.width : dimension.width - 2 * dimension.height;
        if (this.thumbLength(dimension) > this.minimumThumbLength(dimension)) {
            n2 = this.fMaximum - this.fMinimum + this.fVisibleAmount;
        } else {
            n3 -= this.thumbLength(dimension);
            n2 = this.fMaximum - this.fMinimum;
        }
        return n * n2 / n3 + this.fMinimum;
    }

    private int valueToPos(int n, Dimension dimension) {
        int n2;
        if (n == this.fMinimum) {
            n2 = 0;
        } else {
            int n3;
            if (dimension == null) {
                dimension = this.getSize();
            }
            int n4 = n3 = this.fOrientation == 0 ? dimension.height - 2 * dimension.width : dimension.width - 2 * dimension.height;
            if (n == this.fMaximum) {
                n2 = n3 - this.thumbLength(dimension);
            } else {
                int n5;
                if (this.thumbLength(dimension) > this.minimumThumbLength(dimension)) {
                    n5 = this.fMaximum - this.fMinimum + this.fVisibleAmount;
                } else {
                    n3 -= this.thumbLength(dimension);
                    n5 = this.fMaximum - this.fMinimum;
                }
                n2 = n3 * (n - this.fMinimum) / n5;
            }
        }
        return n2;
    }

    private void setValueInternal(int n) {
        if (n < this.fMinimum) {
            n = this.fMinimum;
        }
        if (n > this.fMaximum) {
            n = this.fMaximum;
        }
        this.fValue = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustValue(int n) {
        int n2;
        boolean bl;
        int n3;
        Rectangle rectangle;
        MWScrollbar mWScrollbar = this;
        synchronized (mWScrollbar) {
            rectangle = null;
            n3 = 0;
            bl = false;
            n2 = this.fValue;
            switch (n) {
                case 0: {
                    if ((n2 -= this.fUnitIncrement) < this.fMinimum) {
                        n2 = this.fMinimum;
                    }
                    n3 = 2;
                    break;
                }
                case 1: {
                    if ((n2 -= this.fBlockIncrement) < this.fMinimum) {
                        n2 = this.fMinimum;
                    }
                    n3 = 3;
                    break;
                }
                case 3: {
                    if ((n2 += this.fBlockIncrement) > this.fMaximum) {
                        n2 = this.fMaximum;
                    }
                    n3 = 4;
                    break;
                }
                case 4: {
                    if ((n2 += this.fUnitIncrement) > this.fMaximum) {
                        n2 = this.fMaximum;
                    }
                    n3 = 1;
                }
            }
            if (n2 != this.fValue) {
                rectangle = new Rectangle(this.fRects[2]);
                this.setValueInternal(n2);
                this.calcRects();
                rectangle = rectangle.union(this.fRects[2]);
                if (this.fOrientation == 0) {
                    rectangle.grow(0, 3);
                } else {
                    rectangle.grow(3, 0);
                }
                bl = true;
                n2 = this.fValue;
            }
        }
        if (bl) {
            this.processAdjustmentEvent(new AdjustmentEvent(this, 601, n3, n2));
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public boolean getThumbProportional() {
        return this.fThumbProportional;
    }

    public boolean isThumbProportional() {
        return this.fThumbProportional;
    }

    public synchronized void setThumbProportional(boolean bl) {
        this.fThumbProportional = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fOrientation == 0) {
            return new Dimension(this.fPreferredWidth, this.fPreferredLength);
        }
        return new Dimension(this.fPreferredLength, this.fPreferredWidth);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.fOrientation == 0) {
            return new Dimension(this.fMinimumWidth, this.fMinimumLength);
        }
        return new Dimension(this.fMinimumLength, this.fMinimumWidth);
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            n4 = n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4) {
            n = n4;
        }
        this.fValue = n;
        this.fVisibleAmount = n2;
        this.fMinimum = n3;
        this.fMaximum = n4;
        if (n4 == n3 != (this.fMaximum == this.fMinimum)) {
            this.repaint();
        } else {
            int n5;
            int n6;
            Dimension dimension = this.getSize();
            int n7 = this.thumbLength(dimension);
            int n8 = this.valueToPos(n, dimension);
            if (this.fOrientation == 0) {
                n6 = this.fRects[2].y;
                n5 = this.fRects[2].height;
                n8 += dimension.width;
            } else {
                n6 = this.fRects[2].x;
                n5 = this.fRects[2].width;
                n8 += dimension.height;
            }
            if (n6 != n8 || n5 != n7) {
                Rectangle rectangle = new Rectangle(this.fRects[1]);
                rectangle = rectangle.union(this.fRects[3]);
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    public int getBlockIncrement() {
        return this.fBlockIncrement;
    }

    @Override
    public synchronized void setBlockIncrement(int n) {
        this.fBlockIncrement = n;
    }

    @Override
    public int getMaximum() {
        return this.fMaximum;
    }

    @Override
    public synchronized void setMaximum(int n) {
        this.setValues(this.fValue, this.fVisibleAmount, this.fMinimum, n);
    }

    @Override
    public int getMinimum() {
        return this.fMinimum;
    }

    @Override
    public synchronized void setMinimum(int n) {
        this.setValues(this.fValue, this.fVisibleAmount, n, this.fMaximum);
    }

    @Override
    public int getOrientation() {
        return this.fOrientation;
    }

    public synchronized void setOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                if (this.fOrientation == n) break;
                this.fOrientation = n;
                this.calcRects();
            }
        }
    }

    @Override
    public int getUnitIncrement() {
        return this.fUnitIncrement;
    }

    @Override
    public synchronized void setUnitIncrement(int n) {
        this.fUnitIncrement = n;
    }

    @Override
    public int getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(int n) {
        this.setValues(n, this.fVisibleAmount, this.fMinimum, this.fMaximum);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    @Override
    public int getVisibleAmount() {
        return this.fVisibleAmount;
    }

    @Override
    public synchronized void setVisibleAmount(int n) {
        this.setValues(this.fValue, n, this.fMinimum, this.fMaximum);
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fAdjustmentListener = AWTEventMulticaster.add(this.fAdjustmentListener, adjustmentListener);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fAdjustmentListener = AWTEventMulticaster.remove(this.fAdjustmentListener, adjustmentListener);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.fAdjustmentListener != null) {
            this.fAdjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    private void scrollAdjust() {
        if (this.fMouseDown) {
            this.adjustValue(this.fTrackingPart);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fHasRollover && PlatformInfo.useWindowsXPAppearance()) {
            this.fHasRollover = false;
            this.fRolloverPart = -1;
            if (this.isEnabled()) {
                this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.findPart(mouseEvent.getPoint());
        if (this.isEnabled() && this.fMaximum > this.fMinimum) {
            switch (n) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    this.fTrackingPart = n;
                    this.fMousePoint = mouseEvent.getPoint();
                    this.fMouseDown = true;
                    MWScrollbar mWScrollbar = this;
                    synchronized (mWScrollbar) {
                        Object object;
                        if (n == 0 || n == 4) {
                            object = this.fRects[n];
                            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                        }
                        this.adjustValue(n);
                        ++this.fMouseDownID;
                        object = new Thread(new ScrollRunner(this.fMouseDownID));
                        ((Thread)object).setName("MWScrollbar@" + Integer.toHexString(this.hashCode()));
                        ((Thread)object).setPriority(1);
                        ((Thread)object).start();
                        break;
                    }
                }
                case 2: {
                    this.fTrackingPart = 2;
                    Rectangle rectangle = this.fRects[2];
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.fThumbClickOffset = mouseEvent.getPoint();
                    this.fThumbClickOffset.translate(-this.fRects[2].x, -this.fRects[2].y);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fTrackingPart == 2) {
            this.fTrackingPart = -1;
            Rectangle rectangle = this.fRects[2];
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (this.fTrackingPart != -1) {
            MWScrollbar mWScrollbar = this;
            synchronized (mWScrollbar) {
                this.fMouseDown = false;
                switch (this.fTrackingPart) {
                    case 0: 
                    case 4: {
                        Rectangle rectangle = this.fRects[this.fTrackingPart];
                        this.fTrackingPart = -1;
                        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    default: {
                        if (PlatformInfo.useWindowsXPAppearance()) {
                            Rectangle rectangle = this.fRects[this.fTrackingPart];
                            this.fTrackingPart = -1;
                            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            break;
                        }
                        this.fTrackingPart = -1;
                    }
                }
                this.fTrackingPart = -1;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (PlatformInfo.useWindowsXPAppearance()) {
            Point point = mouseEvent.getPoint();
            if (this.fHasRollover && !this.fRolloverRect.contains(point)) {
                this.fHasRollover = false;
                this.fRolloverPart = -1;
                if (this.isEnabled()) {
                    this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
                }
            }
            if (!this.fHasRollover) {
                this.fRolloverPart = this.fRects[0].contains(point) ? 0 : (this.fRects[4].contains(point) ? 4 : (this.fRects[2].contains(point) ? 2 : -1));
                if (this.fRolloverPart != -1) {
                    this.fHasRollover = true;
                    this.fRolloverRect = this.fRects[this.fRolloverPart];
                    if (this.isEnabled()) {
                        this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
                    }
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Dimension dimension = this.getSize();
        if (this.fTrackingPart == 2) {
            int n = this.fOrientation == 0 ? point.y - this.fThumbClickOffset.y - dimension.width : point.x - this.fThumbClickOffset.x - dimension.height;
            int n2 = this.posToValue(n, dimension);
            if (n2 < this.fMinimum) {
                n2 = this.fMinimum;
            }
            if (n2 > this.fMaximum) {
                n2 = this.fMaximum;
            }
            if (n2 != this.fValue) {
                Rectangle rectangle = new Rectangle(this.fRects[2]);
                this.setValueInternal(n2);
                this.calcRects();
                rectangle = rectangle.union(this.fRects[2]);
                if (this.fOrientation == 0) {
                    rectangle.grow(0, 3);
                } else {
                    rectangle.grow(3, 0);
                }
                Graphics graphics = this.getGraphics();
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.paint(graphics);
                graphics.dispose();
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 5, this.fValue));
            }
        } else if (this.fTrackingPart != -1) {
            boolean bl = this.fRects[this.fTrackingPart].contains(this.fMousePoint);
            this.fMousePoint = point;
            boolean bl2 = this.fRects[this.fTrackingPart].contains(point);
            if (bl2 != bl && (this.fTrackingPart == 0 || this.fTrackingPart == 4)) {
                Rectangle rectangle = this.fRects[this.fTrackingPart];
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private class ScrollAdjustEvent
    extends QueueEvent {
        private ScrollAdjustEvent() {
        }

        public void dispatch() {
            MWScrollbar.this.scrollAdjust();
        }
    }

    private class ScrollRunner
    implements Runnable {
        private int fRunnerID;

        ScrollRunner(int n) {
            this.fRunnerID = n;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {
                return;
            }
            while (MWScrollbar.this.fMouseDown && this.fRunnerID == MWScrollbar.this.fMouseDownID) {
                try {
                    if (MWScrollbar.this.fMouseDown && MWScrollbar.this.fTrackingPart != -1 && MWScrollbar.this.fTrackingPart != 2 && MWScrollbar.this.fRects[MWScrollbar.this.fTrackingPart].contains(MWScrollbar.this.fMousePoint)) {
                        QueueEvent.postQueueEvent((QueueEvent)new ScrollAdjustEvent());
                    }
                    Thread.sleep(25L);
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }
}

