/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWLightweight;
import com.mathworks.mwt.MWUtils;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.Offscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Enumeration;

public class MWPanel
extends MWContainer {
    protected static final boolean CLIPPING_DEBUG = false;
    protected static final Color DEBUG_INSET_C = new Color(128, 255, 128);
    protected static final Color DEBUG_BG_C = new Color(255, 128, 128);
    private static Object sBufferLock = new Object();
    private static IntBuffer sChildRects = new IntBuffer(64, 64);
    private static IntBuffer sDrawRects = new IntBuffer(64, 64);
    private static int[] sInsert = new int[4];
    private Offscreen fOffscreen;
    private Insets fInsets;
    private boolean fOpaqueInsets = true;

    public MWPanel(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
    }

    public MWPanel() {
        this(new FlowLayout());
    }

    @Override
    public Insets getInsets() {
        if (this.fInsets == null) {
            return super.getInsets();
        }
        return this.fInsets;
    }

    public void setInsets(Insets insets) {
        this.fInsets = insets;
    }

    public void setOpaqueInsets(boolean bl) {
        this.fOpaqueInsets = bl;
    }

    public final boolean getOpaqueInsets() {
        return this.fOpaqueInsets;
    }

    public boolean getUseBackingStore() {
        return this.fOffscreen != null;
    }

    public void setUseBackingStore(boolean bl) {
        this.fOffscreen = bl ? new Offscreen((Component)this) : null;
    }

    public void bufferedPaint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        try {
            this.paintBackground(graphics, dimension, insets);
        }
        catch (Exception exception) {
            return;
        }
        this.paintInsets(graphics, dimension, insets);
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.fOffscreen != null) {
            graphics2 = this.fOffscreen.startRender(graphics);
        }
        if (graphics2 == null) {
            return;
        }
        this.bufferedPaint(graphics2);
        if (this.fOffscreen != null) {
            this.fOffscreen.finishRender(graphics);
        }
    }

    private void paintInsets(Graphics graphics, Dimension dimension, Insets insets) {
        if (this.getOpaqueInsets()) {
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = insets.top;
            int n4 = insets.left;
            int n5 = insets.bottom;
            int n6 = insets.right;
            graphics.setColor(this.getBackground());
            if (n3 > 0) {
                graphics.fillRect(0, 0, n, n3);
            }
            if (n5 > 0) {
                graphics.fillRect(0, n2 - n5, n, n5);
            }
            if (n4 > 0) {
                graphics.fillRect(0, n3, n4, n2 - n3 - n5);
            }
            if (n6 > 0) {
                graphics.fillRect(n - n6, n3, n6, n2 - n3 - n5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBackground(Graphics graphics, Dimension dimension, Insets insets) {
        if (this.isOpaque()) {
            Object object = sBufferLock;
            synchronized (object) {
                Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
                rectangle = rectangle.intersection(graphics.getClipBounds());
                sChildRects.setSize(0, false);
                MWPanel.insert(0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, sChildRects);
                MWPanel.clipOpaqueDescendants(this, rectangle, this, sChildRects);
                MWPanel.clipFloaters(this, rectangle, sChildRects);
                sDrawRects.setSize(0, false);
                MWPanel.regionRects(sChildRects, 0, sDrawRects);
                graphics.setColor(this.getBackground());
                for (int i = 0; i < sDrawRects.length(); i += 4) {
                    int n = sDrawRects.getAt(i);
                    int n2 = sDrawRects.getAt(i + 1);
                    int n3 = sDrawRects.getAt(i + 2);
                    int n4 = sDrawRects.getAt(i + 3);
                    graphics.fillRect(n, n2, n3, n4);
                }
            }
        }
    }

    private static void clipOpaqueDescendants(Container container, Rectangle rectangle, Container container2, IntBuffer intBuffer) {
        for (int i = 0; i < container2.getComponentCount(); ++i) {
            Component component = container2.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle2 = component.getBounds();
            if (container2 != container) {
                MWUtils.mapFromComponentToComponent(rectangle2, (Component)container2, (Component)container);
            }
            if (!rectangle2.intersects(rectangle)) continue;
            if (component instanceof MWLightweight && ((MWLightweight)((Object)component)).isOpaque()) {
                MWPanel.insertSorted(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, intBuffer);
                continue;
            }
            if (!(component instanceof Container)) continue;
            MWPanel.clipOpaqueDescendants(container, rectangle, (Container)component, intBuffer);
        }
    }

    private static void clipFloaters(Container container, Rectangle rectangle, IntBuffer intBuffer) {
        Window window = MWUtils.getTopLevelWindow(container);
        LayoutManager layoutManager = window.getLayout();
        if (layoutManager instanceof MWBorderLayout && ((MWBorderLayout)layoutManager).getFloaterCount() > 0) {
            Enumeration enumeration = ((MWBorderLayout)layoutManager).getFloaters().elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (!component.isVisible()) continue;
                Rectangle rectangle2 = component.getBounds();
                MWUtils.mapFromComponentToComponent(rectangle2, (Component)window, (Component)container);
                if (!rectangle2.intersects(rectangle)) continue;
                MWPanel.insertSorted(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, intBuffer);
            }
        }
    }

    private static void insert(int n, int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        MWPanel.sInsert[0] = n2;
        MWPanel.sInsert[1] = n3;
        MWPanel.sInsert[2] = n4;
        MWPanel.sInsert[3] = n5;
        intBuffer.insert(n, sInsert);
    }

    private static void insertSorted(int n, int n2, int n3, int n4, IntBuffer intBuffer) {
        int n5;
        MWPanel.sInsert[0] = n;
        MWPanel.sInsert[1] = n2;
        MWPanel.sInsert[2] = n3;
        MWPanel.sInsert[3] = n4;
        for (n5 = 4; n5 < intBuffer.length() && intBuffer.getAt(n5 + 1) < n2; n5 += 4) {
        }
        intBuffer.insert(n5, sInsert);
    }

    private static void regionRects(IntBuffer intBuffer, int n, IntBuffer intBuffer2) {
        int n2 = intBuffer.getAt(n);
        int n3 = intBuffer.getAt(n + 1);
        int n4 = intBuffer.getAt(n + 2);
        int n5 = intBuffer.getAt(n + 3);
        MWPanel.sInsert[0] = n2;
        MWPanel.sInsert[1] = n3;
        MWPanel.sInsert[2] = n4;
        MWPanel.sInsert[3] = n5;
        if ((n += 4) == intBuffer.length()) {
            intBuffer2.append(sInsert);
        } else {
            while (n < intBuffer.length() && !MWPanel.intersect(intBuffer.getAt(n), intBuffer.getAt(n + 1), intBuffer.getAt(n + 2), intBuffer.getAt(n + 3), n2, n3, n4, n5)) {
                n += 4;
            }
            if (n == intBuffer.length()) {
                intBuffer2.append(sInsert);
            } else {
                int n6 = intBuffer.getAt(n);
                int n7 = intBuffer.getAt(n + 1);
                int n8 = intBuffer.getAt(n + 2);
                int n9 = intBuffer.getAt(n + 3);
                if (n7 > n3) {
                    MWPanel.sInsert[0] = n2;
                    MWPanel.sInsert[1] = n3;
                    MWPanel.sInsert[2] = n4;
                    MWPanel.sInsert[3] = n7 - n3;
                    intBuffer2.append(sInsert);
                }
                if (n7 + n9 < n3 + n5) {
                    intBuffer.setAt(n, n2);
                    intBuffer.setAt(n + 1, n7 + n9);
                    intBuffer.setAt(n + 2, n4);
                    intBuffer.setAt(n + 3, n3 + n5 - (n7 + n9));
                    MWPanel.regionRects(intBuffer, n, intBuffer2);
                }
                int n10 = Math.max(n3, n7);
                int n11 = Math.min(n3 + n5, n7 + n9) - n10;
                if (n6 > n2) {
                    intBuffer.setAt(n, n2);
                    intBuffer.setAt(n + 1, n10);
                    intBuffer.setAt(n + 2, n6 - n2);
                    intBuffer.setAt(n + 3, n11);
                    MWPanel.regionRects(intBuffer, n, intBuffer2);
                }
                if (n6 + n8 < n2 + n4) {
                    intBuffer.setAt(n, n6 + n8);
                    intBuffer.setAt(n + 1, n10);
                    intBuffer.setAt(n + 2, n2 + n4 - (n6 + n8));
                    intBuffer.setAt(n + 3, n11);
                    MWPanel.regionRects(intBuffer, n, intBuffer2);
                }
                intBuffer.setAt(n, n6);
                intBuffer.setAt(n + 1, n7);
                intBuffer.setAt(n + 2, n8);
                intBuffer.setAt(n + 3, n9);
            }
        }
    }

    private static boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n + n3 > n5 && n2 + n4 > n6 && n < n5 + n7 && n2 < n6 + n8;
    }
}

