/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.MWMenuSeparator;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class MWMenu
extends MWMenuComponent {
    private MWCommandCenter fCenter;
    private Menu fMenu;
    private boolean fHasPeer;
    static Object sAwtLock;

    public MWMenu(String string) {
        super(string);
    }

    public MWMenu(String string, MWCommandCenter mWCommandCenter) {
        super(string);
        this.fCenter = mWCommandCenter;
    }

    @Override
    void deferredAction(int n) {
        switch (n) {
            case 3: {
                this.restore();
                break;
            }
            case 4: {
                this.setLabel(this.getLabel());
                break;
            }
            case 5: {
                this.set_enabled(this.isEnabled());
                break;
            }
            case 6: {
                this.setFont(this.getFont());
                break;
            }
            case 8: {
                this.disconnect();
                break;
            }
            default: {
                super.deferredAction(n);
            }
        }
    }

    @Override
    void deferredAction(int n, Object object, int n2) {
        if (n == 7) {
            this.insert((MWMenuComponent)object, n2);
        } else {
            super.deferredAction(n, object, n2);
        }
    }

    public MWMenuItem addMenuItem(String string, int n) {
        MWMenuItem mWMenuItem = new MWMenuItem(string);
        if (this.fCenter != null) {
            this.fCenter.addCommandSource(mWMenuItem, n);
        }
        this.add(mWMenuItem);
        return mWMenuItem;
    }

    public MWMenuItem addMenuItem(String string, int n, int n2) {
        MWMenuItem mWMenuItem = new MWMenuItem(string, n2);
        if (this.fCenter != null) {
            this.fCenter.addCommandSource(mWMenuItem, n);
        }
        this.add(mWMenuItem);
        return mWMenuItem;
    }

    public MWMenuItem addCheckboxMenuItem(String string, int n) {
        MWCheckboxMenuItem mWCheckboxMenuItem = new MWCheckboxMenuItem(string);
        if (this.fCenter != null) {
            this.fCenter.addCommandSource(mWCheckboxMenuItem, n);
        }
        this.add(mWCheckboxMenuItem);
        return mWCheckboxMenuItem;
    }

    public MWMenu addMenu(String string, int n) {
        MWMenu mWMenu = new MWMenu(string, this.fCenter);
        if (this.fCenter != null) {
            this.fCenter.addCommandSource(mWMenu, n);
        }
        this.add(mWMenu);
        return mWMenu;
    }

    public MWMenuSeparator addSeparator() {
        MWMenuSeparator mWMenuSeparator = new MWMenuSeparator();
        this.add(mWMenuSeparator);
        return mWMenuSeparator;
    }

    public MWMenuSeparator insertSeparator(int n) {
        MWMenuSeparator mWMenuSeparator = new MWMenuSeparator();
        this.insert(mWMenuSeparator, n);
        return mWMenuSeparator;
    }

    public void add(String string) {
        this.add(new MWMenuItem(string));
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public MWMenuComponent getItem(int n) {
        return this.getMenuComponent(n);
    }

    @Override
    public void setLabel(String string) {
        super.setLabel(string);
        if (this.fMenu != null) {
            if (MWMenu.isAWTEventQueueThread()) {
                this.fMenu.setLabel(MWMenu.stripLabel(string));
            } else {
                MWMenu.awtDeferAction(4, this);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.set_enabled(bl);
        }
    }

    private void set_enabled(boolean bl) {
        super.setEnabled(bl);
        if (this.fMenu != null) {
            if (MWMenu.isAWTEventQueueThread()) {
                this.fMenu.setEnabled(bl);
            } else {
                MWMenu.awtDeferAction(5, this);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fMenu != null) {
            if (MWMenu.isAWTEventQueueThread()) {
                this.fMenu.setFont(font);
            } else {
                MWMenu.awtDeferAction(6, this);
            }
        }
    }

    @Override
    public void insert(MWMenuComponent mWMenuComponent, int n) {
        super.insert(mWMenuComponent, n);
        if (this.fMenu != null) {
            if (MWMenu.isAWTEventQueueThread()) {
                MenuItem menuItem = mWMenuComponent.getImpl();
                this.fMenu.insert(menuItem, n);
                this.restore();
            } else {
                MWMenu.awtDeferAction(7, this, mWMenuComponent, n);
            }
        }
    }

    @Override
    public void remove(MWMenuComponent mWMenuComponent) {
        if (this.fMenu != null && !MWMenu.isAWTEventQueueThread()) {
            MWMenu.awtDeferAction(1, this, mWMenuComponent, mWMenuComponent.getInitialIndex());
        }
        super.remove(mWMenuComponent);
    }

    public void show(Component component, int n, int n2) {
        if (this.fMenu != null && this.fMenu instanceof PopupMenu) {
            ((PopupMenu)this.fMenu).show(component, n, n2);
        }
    }

    public void attachTo(Component component) {
        if (this.fMenu == null) {
            this.fMenu = new PopupMenu(MWMenu.stripLabel(this.getLabel()));
            this.populateMenu(this.fMenu);
        }
        component.add((PopupMenu)this.fMenu);
    }

    @Override
    MenuItem getImpl() {
        if (this.fMenu == null) {
            this.fMenu = new MenuImpl(MWMenu.stripLabel(this.getLabel()));
            this.populateMenu(this.fMenu);
        }
        return this.fMenu;
    }

    private void populateMenu(Menu menu) {
        boolean bl;
        Font font = this.getFont();
        if (font != null) {
            menu.setFont(font);
        }
        if (!(bl = this.isEnabled())) {
            this.fMenu.setEnabled(bl);
        }
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            MWMenuComponent mWMenuComponent = (MWMenuComponent)enumeration.nextElement();
            MenuItem menuItem = mWMenuComponent.getImpl();
            menu.add(menuItem);
        }
    }

    @Override
    public void disconnect() {
        if (this.fMenu != null) {
            if (MWMenu.isAWTEventQueueThread()) {
                MenuContainer menuContainer = this.fMenu.getParent();
                if (menuContainer != null) {
                    menuContainer.remove(this.fMenu);
                }
            } else {
                MWMenu.awtDeferAction(8, this);
            }
        }
        super.disconnect();
    }

    @Override
    long getPlatformHandle() {
        int n;
        long l;
        long l2 = 0L;
        MWMenuComponent mWMenuComponent = this.getParent();
        if (mWMenuComponent != null && this.fHasPeer && NativeJava.nativeLibraryExists() && (l = mWMenuComponent.getPlatformHandle()) != 0L && (n = mWMenuComponent.getComponentIndex(this)) != -1) {
            l2 = NativeJava.getSubmenu((long)l, (int)n);
        }
        return l2;
    }

    @Override
    void restore() {
        if (this.fMenu == null || this.getRootParent() == null) {
            return;
        }
        if (MWMenu.isAWTEventQueueThread()) {
            int n;
            Object object;
            long l;
            if (PlatformInfo.isWindows() && NativeJava.nativeLibraryExists() && (l = ((MWMenuComponent)(object = this.getParent())).getPlatformHandle()) != 0L && (n = ((MWMenuComponent)object).getComponentIndex(this)) != -1) {
                NativeJava.setMenuItemLabel((long)l, (int)n, (String)this.getLabel());
            }
            object = this.children();
            while (object.hasMoreElements()) {
                MWMenuComponent mWMenuComponent = (MWMenuComponent)object.nextElement();
                mWMenuComponent.restore();
            }
        } else {
            MWMenu.awtDeferAction(3, this);
        }
    }

    void setHasPeer(boolean bl) {
        this.fHasPeer = bl;
    }

    boolean getHasPeer() {
        return this.fHasPeer;
    }

    private static String stripLabel(String string) {
        return MWUtils.stripMenuItemLabel(string);
    }

    static {
        if (PlatformInfo.isXWindows() && NativeJava.nativeLibraryExists()) {
            if (PlatformInfo.isVersion118()) {
                sAwtLock = Toolkit.getDefaultToolkit();
            } else {
                if (PlatformInfo.getVersion() < 6 && PlatformInfo.getVersion() != 0) {
                    try {
                        sAwtLock = Class.forName("sun.awt.font.NativeFontWrapper");
                    }
                    catch (Exception exception) {
                        sAwtLock = null;
                    }
                }
                if (sAwtLock == null) {
                    try {
                        Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
                        Method method = clazz.getMethod("getLocalGraphicsEnvironment", null);
                        sAwtLock = method.invoke(null, null);
                    }
                    catch (Exception exception) {
                        System.out.println("Unable to obtain AWT lock in MWMenu");
                        sAwtLock = new Object();
                    }
                }
            }
        }
    }

    private class MenuImpl
    extends Menu {
        MenuImpl(String string) {
            super(string);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            MWMenu.this.setHasPeer(true);
        }

        @Override
        public void removeNotify() {
            MWMenu.this.setHasPeer(false);
            super.removeNotify();
        }
    }
}

