/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMouseWheelTarget;
import com.mathworks.mwt.MWScrollPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dnd.DragItem;
import com.mathworks.mwt.floater.FloaterContainer;
import com.mathworks.mwt.floater.FloaterContainerSupport;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.window.FullWindowRegistry;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;

public class MWFrame
extends Frame
implements ComponentListener,
WindowListener,
FloaterContainer,
HWndProvider {
    private static final int WAY_OFF_SCREEN = 8192;
    private static int sStructureLeftInset = 0;
    private static int sStructureTopInset = 0;
    private static int sStructureMenuTopInset = 0;
    private static int sStructureWidth = 0;
    private static int sStructureHeight = 0;
    private static int sStructureMenuHeight = 0;
    private static boolean sOffsetsCalculated = false;
    private static Image sMatlabIcon = null;
    private static int sUniqueId = new Random().nextInt();
    private boolean fActive = false;
    private boolean fUsePlatformBG = true;
    private int fBackgroundType = 1;
    private MWMenuBar fMenuBar;
    private boolean fDragInProgress = false;
    private DragItem fCurrentDrag = null;
    private Component fFocus;
    private Component fUnixFocus;
    private long hWnd;
    private String fTitle;
    private boolean fHasUniqueTitle;
    private Rectangle fBogusBounds;

    public MWFrame(String string) {
        super(MWFrame.uniqueTitle(string));
        this.fTitle = string;
        this.fHasUniqueTitle = string != MWFrame.uniqueTitle(string);
        this.setLayout(new MWBorderLayout());
        this.setBackground(Decorations.getColor(this.fBackgroundType));
        this.addComponentListener(this);
        this.addWindowListener(this);
        if (!PlatformInfo.isMacintosh()) {
            if (sMatlabIcon == null) {
                String string2 = PlatformInfo.isWindows() ? "/com/mathworks/mwt/resources/matlabicon.gif" : "/com/mathworks/mwt/resources/matlabicon48.gif";
                MWImageResource mWImageResource = new MWImageResource(string2, this);
                sMatlabIcon = mWImageResource.getImage();
            }
            this.setIconImage(sMatlabIcon);
        }
        FullWindowRegistry.register(this);
    }

    public MWFrame() {
        this("");
    }

    private static synchronized String uniqueTitle(String string) {
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            return Integer.toString(sUniqueId++);
        }
        return string;
    }

    public long getHWnd() {
        return this.hWnd;
    }

    public String getSpecifiedTitle() {
        return this.fTitle;
    }

    @Override
    public void setTitle(String string) {
        this.fTitle = string;
        if (!this.fHasUniqueTitle) {
            super.setTitle(string);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            this.hWnd = NativeJava.getHWnd((Frame)this);
            if (this.hWnd != 0L) {
                NativeJava.enableNativeEvents((Window)this, (long)this.hWnd);
            }
            this.fHasUniqueTitle = false;
            this.setTitle(this.fTitle);
        }
    }

    @Override
    public void dispose() {
        FullWindowRegistry.unregister(this);
        if (this.hWnd != 0L && this.getPeer() != null) {
            NativeJava.disableNativeEvents((long)this.hWnd);
            this.hWnd = 0L;
        }
        if (MWUtils.isAWTEventQueueThread()) {
            super.dispose();
        } else {
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    MWFrame.this.superDispose();
                }
            });
        }
    }

    private void superDispose() {
        super.dispose();
    }

    public synchronized void setMWMenuBar(MWMenuBar mWMenuBar) {
        if (mWMenuBar != this.fMenuBar) {
            if (this.fMenuBar != null) {
                this.fMenuBar.disconnect();
            }
            this.fMenuBar = mWMenuBar;
            if (this.fMenuBar != null) {
                this.fMenuBar.connect(this);
            }
        }
    }

    public final MWMenuBar getMWMenuBar() {
        return this.fMenuBar;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof MWBorderLayout) {
            super.setLayout(layoutManager);
        } else if (!(layoutManager instanceof BorderLayout)) {
            throw new IllegalArgumentException("MWFrame's layout manager must be MWBorderLayout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        boolean bl;
        boolean bl2 = bl = NativeJava.nativeLibraryExists() && PlatformInfo.isWindows();
        if (bl) {
            NativeJava.detachThreadInput();
        }
        try {
            super.show();
            if (bl) {
                this.toFront();
            }
        }
        finally {
            if (bl) {
                NativeJava.attachThreadInput();
            }
        }
        if (PlatformInfo.isMacintosh()) {
            NativeJava.macActivateIgnoringOtherApps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void superShow() {
        boolean bl;
        boolean bl2 = bl = NativeJava.nativeLibraryExists() && PlatformInfo.isWindows();
        if (bl) {
            NativeJava.detachThreadInput();
        }
        try {
            super.show();
        }
        finally {
            if (bl) {
                NativeJava.attachThreadInput();
            }
        }
        if (PlatformInfo.isMacintosh()) {
            NativeJava.macActivateIgnoringOtherApps();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl || !PlatformInfo.isBlackdownVM() || PlatformInfo.isVersion118()) {
            super.setVisible(bl);
        } else {
            int n = this.surrogateGetState();
            super.setVisible(bl);
            if (this.surrogateGetState() != n) {
                this.surrogateSetState(n);
            }
        }
    }

    protected void processNativeEvent(NativeEvent nativeEvent) {
        block3: {
            block2: {
                if (NativeEvent.WM_IME_CHAR != nativeEvent.getNativeMessage()) break block2;
                Component component = this.getFocusOwner();
                if (component == null || !(component instanceof MWComponent)) break block3;
                int n = (int)nativeEvent.getLParam();
                KeyEvent keyEvent = new KeyEvent(component, 401, 0L, 0, n, (char)n);
                ((MWComponent)component).processKeyEvent(keyEvent);
                break block3;
            }
            if (NativeEvent.WM_MOUSEWHEEL == nativeEvent.getNativeMessage()) {
                for (Component component = this.getFocusOwner(); component != null; component = component.getParent()) {
                    if (!(component instanceof MWMouseWheelTarget)) continue;
                    long l = nativeEvent.getWParam();
                    int n = (int)l >> 16;
                    ((MWMouseWheelTarget)((Object)component)).mouseWheelTurned(n > 0 ? -3 : 3, (int)l & 0xFFFF);
                    break;
                }
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof NativeEvent) {
            this.processNativeEvent((NativeEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.hideFloaters(null);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.hideFloaters(null);
        MWMenuBar mWMenuBar = this.fMenuBar;
        if (mWMenuBar != null) {
            mWMenuBar.restore();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.fActive = true;
        if (PlatformInfo.isMacintosh()) {
            Component component = this.getFocusOwner();
            if (component == null) {
                if (this.getComponentCount() > 0) {
                    component = this.getComponent(0);
                    component.transferFocus();
                }
            } else {
                component.transferFocus();
                Component component2 = this.getFocusOwner();
                if (component2 != component) {
                    while (component2 != null) {
                        if (component2 instanceof MWTextView) {
                            MWTextView mWTextView = (MWTextView)component2;
                            while (component2 != null) {
                                if (component2 instanceof MWCombobox) {
                                    mWTextView.setSel(mWTextView.getModel().length());
                                    component2 = null;
                                    continue;
                                }
                                component2 = component2.getParent();
                            }
                            continue;
                        }
                        component2 = component2.getParent();
                    }
                }
                component.requestFocus();
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.fActive = false;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        if (PlatformInfo.isMacintosh() && this.isVisible()) {
            super.toFront();
            NativeJava.macActivateIgnoringOtherApps();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean isFrameActive() {
        return this.fActive;
    }

    @Override
    public void hideFloaters(FloaterOwner floaterOwner) {
        FloaterContainerSupport.hideFloaters(this, floaterOwner);
    }

    public void setContentSize(int n, int n2) {
        if (!sOffsetsCalculated) {
            MWFrame.calculateOffsets();
        }
        n2 = this.getMenuBar() != null ? (n2 += sStructureMenuHeight) : (n2 += sStructureHeight);
        this.setSize(n += sStructureWidth, n2);
    }

    public void setContentSize(Dimension dimension) {
        this.setContentSize(dimension.width, dimension.height);
    }

    public void setContentLocation(int n, int n2) {
        if (!sOffsetsCalculated) {
            MWFrame.calculateOffsets();
        }
        n2 = this.getMenuBar() != null ? (n2 -= sStructureMenuTopInset) : (n2 -= sStructureTopInset);
        this.setLocation(n -= sStructureLeftInset, n2);
    }

    public Point getContentLocation() {
        if (!sOffsetsCalculated) {
            MWFrame.calculateOffsets();
        }
        Point point = this.getLocation();
        if (this.getMenuBar() != null) {
            point.translate(sStructureLeftInset, sStructureMenuTopInset);
        } else {
            point.translate(sStructureLeftInset, sStructureTopInset);
        }
        return point;
    }

    private static void calculateOffsets() {
        Frame frame = new Frame("");
        Panel panel = new Panel();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.add((Component)panel, "Center");
        if (PlatformInfo.isXWindows()) {
            frame.setLocation(dimension.width - 1, dimension.height - 1);
        } else {
            frame.setLocation(dimension.width + 8192, dimension.height + 8192);
        }
        frame.setSize(100, 100);
        frame.setVisible(true);
        Dimension dimension2 = frame.getSize();
        Dimension dimension3 = panel.getSize();
        Point point = panel.getLocation();
        sStructureWidth = dimension2.width - dimension3.width;
        sStructureHeight = dimension2.height - dimension3.height;
        sStructureLeftInset = point.x;
        sStructureTopInset = point.y;
        if (PlatformInfo.getPlatform() != 0) {
            MenuBar menuBar = new MenuBar();
            Menu menu = new Menu("Tmp");
            menuBar.add(menu);
            frame.setMenuBar(menuBar);
            frame.setSize(100, 100);
            frame.validate();
            dimension2 = frame.getSize();
            dimension3 = panel.getSize();
            point = panel.getLocation();
            sStructureMenuHeight = dimension2.height - dimension3.height;
            sStructureMenuTopInset = point.y;
        }
        if (MWUtils.isAWTEventQueueThread()) {
            frame.dispose();
        } else {
            QueueEvent.postQueueEvent((QueueEvent)new DisposeEvent(frame));
        }
        sOffsetsCalculated = true;
    }

    public static Dimension getStructureSize() {
        if (!sOffsetsCalculated) {
            MWFrame.calculateOffsets();
        }
        return new Dimension(sStructureWidth, sStructureHeight);
    }

    public void setBackgroundType(int n) {
        if (n != this.fBackgroundType) {
            this.fBackgroundType = n;
            if (this.fUsePlatformBG) {
                this.setBackground(Decorations.getColor(this.fBackgroundType));
                this.repaint(5L);
            }
        }
    }

    public void setUsePlatformBG(boolean bl) {
        if (bl != this.fUsePlatformBG) {
            this.fUsePlatformBG = bl;
            if (this.fUsePlatformBG) {
                this.setBackground(Decorations.getColor(this.fBackgroundType));
            } else {
                this.setBackground(null);
            }
            this.repaint(5L);
        }
    }

    public void startDrag(DragItem dragItem) {
        this.fDragInProgress = true;
        this.fCurrentDrag = dragItem;
    }

    public void stopDrag() {
        this.fDragInProgress = false;
        this.fCurrentDrag = null;
    }

    private Component eraseFocusOutline(Graphics graphics) {
        Rectangle rectangle;
        Component component = this.getFocusOwner();
        if (component != this.fFocus && this.fFocus != null && (rectangle = MWUtils.getFocusBounds(this.fFocus)) != null) {
            Rectangle rectangle2 = graphics.getClipBounds();
            rectangle2 = MWUtils.unionRect(rectangle2, rectangle, rectangle2);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        this.fFocus = component;
        return component;
    }

    private void drawFocusOutline(Graphics graphics, Component component) {
        Rectangle rectangle;
        if (component != null && (rectangle = MWUtils.getFocusBounds(component)) != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Decorations.getColor(4));
            if (PlatformInfo.getAppearance() == 0) {
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4, 4);
                graphics.drawRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, 4, 4);
            } else {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Component component = this.eraseFocusOutline(graphics);
        if (this.isFrameActive()) {
            if (component != this) {
                this.fUnixFocus = component;
                if (component != null) {
                    Container container = component.getParent();
                    if (container != null) {
                        container = container.getParent();
                    }
                    if (container != null && container instanceof MWTextView && !((MWTextView)container).hasFocus()) {
                        component.requestFocus();
                        component.dispatchEvent(new FocusEvent(container, 1004));
                    }
                }
            }
            if (PlatformInfo.getAppearance() == 2 && component == this && this.fUnixFocus != null) {
                this.fUnixFocus.requestFocus();
            }
        }
        super.paint(graphics);
        if (!(component instanceof MWButton) || ((MWButton)component).getBehavior() != 1) {
            this.drawFocusOutline(graphics, component);
        }
    }

    @Override
    public void update(Graphics graphics) {
        Serializable serializable;
        Object object;
        Object object2 = null;
        Rectangle rectangle = null;
        if (!this.isShowing()) {
            return;
        }
        if (this.getLayout() instanceof MWBorderLayout && ((MWBorderLayout)(object = (MWBorderLayout)this.getLayout())).getFloaterCount() > 0 && (object2 = ((MWBorderLayout)object).getFloaterContainingRect(rectangle = graphics.getClipBounds())) != null) {
            serializable = ((Component)object2).getBounds();
            rectangle.translate(-((Rectangle)serializable).x, -((Rectangle)serializable).y);
        }
        if (object2 == null) {
            object2 = this.getFocusOwner();
            if (!(object2 == null || object2 != this && ((Component)object2).isShowing())) {
                object2 = null;
            }
            if (object2 != null) {
                for (object = ((Component)object2).getParent(); object != null && object != this; object = ((Component)object).getParent()) {
                    if (!(object instanceof MWScrollPanel)) continue;
                    object2 = object;
                    break;
                }
            }
            if (object2 != null) {
                if (rectangle == null) {
                    rectangle = graphics.getClipBounds();
                }
                try {
                    rectangle = MWUtils.mapFromComponentToComponent(rectangle, (Component)this, (Component)object2);
                    Rectangle rectangle2 = MWFrame.calculateAperture((Component)object2);
                    if (!MWUtils.contains(rectangle2, rectangle)) {
                        object2 = null;
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
        if (object2 == null) {
            if (this.fDragInProgress) {
                this.fCurrentDrag.setDragVisible(false);
            }
            this.paint(graphics);
            if (this.fDragInProgress) {
                this.fCurrentDrag.setDragVisible(true);
            }
        } else {
            object = ((Component)object2).getGraphics();
            if (object != null) {
                ((Graphics)object).setClip(rectangle);
                serializable = this.eraseFocusOutline(graphics);
                ((Component)object2).update((Graphics)object);
                this.drawFocusOutline(graphics, (Component)serializable);
                ((Graphics)object).dispose();
            }
        }
    }

    private static Rectangle calculateAperture(Component component) {
        Dimension dimension = component.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            Rectangle rectangle2 = MWUtils.boundsInOtherComponent(container, component);
            if (rectangle2.x <= rectangle.x && rectangle2.y <= rectangle.y && rectangle2.x + rectangle2.width >= rectangle.x + rectangle.width && rectangle2.y + rectangle2.height >= rectangle.y + rectangle.height) continue;
            rectangle = rectangle.intersection(rectangle2);
        }
        return rectangle;
    }

    @Override
    public void toFront() {
        if (!PlatformInfo.isMacintosh()) {
            if (this.isMinimized()) {
                this.setMinimized(false);
            }
            super.toFront();
        } else if (this.isMinimized()) {
            try {
                Class[] classArray = new Class[]{Integer.TYPE};
                Field field = Frame.class.getField("NORMAL");
                Method method = Frame.class.getMethod("setState", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{field.get(null)};
                    method.invoke((Object)this, objectArray);
                }
            }
            catch (Exception exception) {}
        } else {
            WindowEvent windowEvent = new WindowEvent(this, 204);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent);
        }
    }

    public boolean isMinimized() {
        return NativeJava.isMinimized((Window)this);
    }

    public void setMinimized(boolean bl) {
        NativeJava.setMinimized((Window)this, (boolean)bl);
    }

    public boolean isMaximized() {
        return NativeJava.isMaximized((Window)this);
    }

    public void setMaximized(boolean bl) {
        NativeJava.setMaximized((Window)this, (boolean)bl);
    }

    public Dimension getRestoredSize() {
        return NativeJava.getRestoredSize((Window)this);
    }

    public void setRestoredSize(Dimension dimension) {
        NativeJava.setRestoredSize((Window)this, (Dimension)dimension);
    }

    public void setRestoredSize(int n, int n2) {
        NativeJava.setRestoredSize((Window)this, (int)n, (int)n2);
    }

    public Point getRestoredLocation() {
        return NativeJava.getRestoredLocation((Window)this);
    }

    public void setRestoredLocation(Point point) {
        NativeJava.setRestoredLocation((Window)this, (Point)point);
    }

    public void setRestoredLocation(int n, int n2) {
        NativeJava.setRestoredLocation((Window)this, (int)n, (int)n2);
    }

    public void falsifyBounds(Rectangle rectangle) {
        this.fBogusBounds = rectangle;
    }

    @Override
    public Rectangle getBounds() {
        if (this.fBogusBounds != null) {
            return this.fBogusBounds;
        }
        return super.getBounds();
    }

    public int surrogateGetState() {
        try {
            Class<Frame> clazz = Frame.class;
            Method method = clazz.getMethod("getState", null);
            return (Integer)method.invoke((Object)this, null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void surrogateSetState(int n) {
        try {
            Class<Frame> clazz = Frame.class;
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = clazz.getMethod("setState", classArray);
            Object[] objectArray = new Object[]{new Integer(n)};
            method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class DisposeEvent
    extends QueueEvent {
        Frame fFrame;

        DisposeEvent(Frame frame) {
            this.fFrame = frame;
        }

        public void dispatch() {
            this.fFrame.dispose();
        }
    }
}

