/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.validation;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidationListener;
import com.mathworks.mwswing.validation.Validity;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ValidatableTextField
extends MJTextField {
    private static final int DELAY_BETWEEN_CHECKS_MS = 250;
    private final Timer fTimer;
    private Validity fValidity = Validity.VALID;
    private boolean fIsValidatable = true;
    private final Validatable fValidatable;
    private boolean fIconPaintingEnabled = true;
    private Vector<ValidationListener> fListeners = new Vector();

    public ValidatableTextField(Validatable validatable) {
        if (validatable == null) {
            throw new IllegalArgumentException("The given Validateable cannot be null.");
        }
        this.fValidatable = validatable;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatableTextField.this.doValidationCheck();
            }
        };
        this.fTimer = new Timer(250, actionListener);
        this.fTimer.setRepeats(false);
        this.init();
    }

    private void init() {
        this.initListeners();
        this.doValidationCheck();
    }

    private void initListeners() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ValidatableTextField.this.fTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ValidatableTextField.this.fTimer.restart();
            }
        });
    }

    public boolean isValidatable() {
        return this.fIsValidatable;
    }

    public void setIconPaintingEnabled(boolean bl) {
        this.fIconPaintingEnabled = bl;
    }

    public boolean isIconPaintingEnabled() {
        return this.fIconPaintingEnabled;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isIconPaintingEnabled() && this.isValidatable() && !this.fValidity.equals((Object)Validity.VALID)) {
            Shape shape = graphics.getClip();
            graphics.setClip(null);
            ImageIcon imageIcon = this.fValidity.getIcon();
            int n = -imageIcon.getIconWidth() / 2;
            int n2 = -imageIcon.getIconHeight() / 2;
            graphics.drawImage(imageIcon.getImage(), n, this.getHeight() + n2, null);
            graphics.setClip(shape);
        }
    }

    private Validity validateText() {
        Validity validity = this.getText() == null || this.getText().equals("") ? this.fValidatable.getValidityWhenBlank() : this.fValidatable.validateText(this.getText());
        return validity;
    }

    private void doValidationCheck() {
        this.setValidity(this.validateText());
        this.setBackground(this.isValidatable() ? this.fValidity.getAssociatedColor() : UIManager.getColor("TextField.background"));
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public boolean isTextValid() {
        this.doValidationCheck();
        return this.fValidity == Validity.VALID;
    }

    public Validity getValidity() {
        this.doValidationCheck();
        return this.fValidity;
    }

    private void setValidity(Validity validity) {
        Validity validity2 = this.fValidity;
        this.fValidity = validity;
        this.fireValidationChanged(validity2, this.fValidity);
    }

    public void setIsValidatable(boolean bl) {
        this.fIsValidatable = bl;
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.doValidationCheck();
    }

    public void setText(String string, boolean bl) {
        this.setIsValidatable(bl);
        this.setText(string);
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.fListeners.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.fListeners.remove(validationListener);
    }

    private void fireValidationChanged(Validity validity, Validity validity2) {
        if (validity != validity2) {
            for (ValidationListener validationListener : this.fListeners) {
                validationListener.validityChanged(validity, validity2);
            }
        }
    }
}

