/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.border;

import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FocusBorderFactory {
    public static Border create() {
        return PlatformInfo.isMacintosh() ? new MacFocusBorder() : new BasicFocusBorder();
    }

    private static boolean containsFocus(Component component) {
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component2 == component || component2 != null && SwingUtilities.isDescendingFrom(component2, component);
    }

    private static class MacFocusBorder
    extends AbstractBorder {
        private MacFocusBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 2;
            insets.left = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (FocusBorderFactory.containsFocus(component)) {
                Color color = MacAppearanceUtils.getColor(MacAppearanceUtils.ColorType.FOCUS_INDICATOR);
                if (color == null) {
                    color = Color.blue.brighter();
                }
                graphics.setColor(color);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(2.0f, 0, 1));
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }

    private static class BasicFocusBorder
    extends AbstractBorder {
        private BasicFocusBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 2;
            insets.left = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (FocusBorderFactory.containsFocus(component)) {
                BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
            }
        }
    }
}

