/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class TransferableText
implements Transferable {
    private String fText;
    private static DataFlavor sPlatformTextFlavor = new DataFlavor("text/plain; charset=ascii", "ASCII text");
    private static DataFlavor[] sSupportedFlavors = new DataFlavor[]{DataFlavor.stringFlavor, sPlatformTextFlavor};

    public TransferableText(String string) {
        this.fText = string;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return sSupportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(sSupportedFlavors[0]) || dataFlavor.equals(sSupportedFlavors[1]);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.fText;
        }
        if (dataFlavor.equals(sPlatformTextFlavor)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            outputStreamWriter.write(this.fText);
            outputStreamWriter.write(0);
            outputStreamWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            outputStreamWriter.close();
            return new ByteArrayInputStream(byArray, 0, byArray.length);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static boolean canGetString(Transferable transferable) {
        return transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(sPlatformTextFlavor);
    }

    public static String getString(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            if (transferable.isDataFlavorSupported(sPlatformTextFlavor)) {
                String string = null;
                Object object = transferable.getTransferData(sPlatformTextFlavor);
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                String string2 = "ascii";
                for (int i = 0; i < dataFlavorArray.length && string2 == null; ++i) {
                    if (!dataFlavorArray[i].equals(sPlatformTextFlavor)) continue;
                    string2 = dataFlavorArray[i].getParameter("charset");
                }
                if (object instanceof InputStream) {
                    InputStream inputStream = (InputStream)object;
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    int n = byArray.length;
                    while (byArray[n - 1] == 0) {
                        --n;
                    }
                    try {
                        string = new String(byArray, 0, n, string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n);
                    }
                }
                return string;
            }
            return null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

