/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class MacAppearanceUtils {
    private MacAppearanceUtils() {
    }

    public static void initialize() {
        assert (PlatformInfo.isMacintosh()) : "Cannot initialize MacAppearanceUtils on non-Mac platforms";
        MacAppearanceUtils.setMacAppearanceColors();
    }

    public static void createMacToolBarButtonGroup(AbstractButton ... abstractButtonArray) {
        MacAppearanceUtils.createMacSegmentedButtonGroup(ButtonType.SEGMENTED_TEXTURED, abstractButtonArray);
    }

    public static void createMacSegmentedButtonGroup(ButtonType buttonType, AbstractButton ... abstractButtonArray) {
        if (buttonType == null || !buttonType.isSegmented()) {
            throw new IllegalArgumentException("'buttonType' must be non-null and must be segmented");
        }
        if (PlatformInfo.isMacintosh()) {
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                SegmentPosition segmentPosition = abstractButtonArray.length == 1 ? SegmentPosition.ONLY : (i == 0 ? SegmentPosition.FIRST : (i == abstractButtonArray.length - 1 ? SegmentPosition.LAST : SegmentPosition.MIDDLE));
                buttonType.apply(abstractButtonArray[i]);
                segmentPosition.apply(abstractButtonArray[i]);
            }
        }
    }

    public static Color getColor(ColorType colorType) {
        return UIManager.getColor(colorType.getUiManagerKey());
    }

    private static void setMacAppearanceColors() {
        UIManager.getLookAndFeelDefaults().put("List.selectionBackground", MacAppearanceUtils.getMacAlternateSelectedControlColor());
        UIManager.getLookAndFeelDefaults().put("List.selectionForeground", Color.white);
        UIManager.getLookAndFeelDefaults().put(ColorType.ALTERNATING_BACKGROUND_EVEN.getUiManagerKey(), MacAppearanceUtils.getMacControlAlternatingBackgroundEvenColor());
        UIManager.getLookAndFeelDefaults().put(ColorType.ALTERNATING_BACKGROUND_ODD.getUiManagerKey(), MacAppearanceUtils.getMacControlAlternatingBackgroundOddColor());
        UIManager.getLookAndFeelDefaults().put(ColorType.CONTROL_HIGHLIGHT.getUiManagerKey(), MacAppearanceUtils.getMacSelectedControlColor());
        UIManager.getLookAndFeelDefaults().put(ColorType.CONTROL_DARK_HIGHLIGHT.getUiManagerKey(), MacAppearanceUtils.getMacAlternateSelectedControlColor());
        UIManager.getLookAndFeelDefaults().put(ColorType.FOCUS_INDICATOR.getUiManagerKey(), MacAppearanceUtils.getMacKeyboardFocusIndicatorColor());
        UIManager.getLookAndFeelDefaults().put(ColorType.TEXT_EDIT_BORDER.getUiManagerKey(), MacAppearanceUtils.getMacTextEditBorderColor());
    }

    private static Color getMacSelectedControlColor() {
        return NativeJava.componentColorFromSystemColor((String)"selectedControlColor");
    }

    private static Color getMacAlternateSelectedControlColor() {
        return NativeJava.componentColorFromSystemColor((String)"alternateSelectedControlColor");
    }

    private static Color getMacControlAlternatingBackgroundEvenColor() {
        return Color.white;
    }

    private static Color getMacControlAlternatingBackgroundOddColor() {
        return PlatformInfo.getMacAppearanceTheme() == 6 ? new Color(240, 240, 240) : new Color(237, 243, 254);
    }

    private static Color getMacKeyboardFocusIndicatorColor() {
        return NativeJava.componentColorFromSystemColor((String)"keyboardFocusIndicatorColor");
    }

    private static Color getMacTextEditBorderColor() {
        return NativeJava.componentColorFromSystemColor((String)"textColor");
    }

    public static enum ColorType {
        ALTERNATING_BACKGROUND_EVEN("com.mathworks.alternatingBackgroundEven"),
        ALTERNATING_BACKGROUND_ODD("com.mathworks.alternatingBackgroundOdd"),
        CONTROL_HIGHLIGHT("com.mathworks.controlHighlightColor"),
        CONTROL_DARK_HIGHLIGHT("com.mathworks.controlDarkHighlightColor"),
        FOCUS_INDICATOR("com.mathworks.focusIndicatorColor"),
        TEXT_EDIT_BORDER("com.mathworks.textEditBorderColor");

        private final String fUiManagerKey;

        private ColorType(String string2) {
            this.fUiManagerKey = string2;
        }

        private String getUiManagerKey() {
            return this.fUiManagerKey;
        }
    }

    private static enum SegmentPosition {
        ONLY("only"),
        FIRST("first"),
        MIDDLE("middle"),
        LAST("last");

        private String fPropertyValue;

        private SegmentPosition(String string2) {
            this.fPropertyValue = string2;
        }

        public void apply(AbstractButton abstractButton) {
            abstractButton.putClientProperty("JButton.segmentPosition", this.fPropertyValue);
        }
    }

    public static enum ButtonType {
        SQUARE("square"),
        GRADIENT("gradient"),
        BEVEL("bevel"),
        TEXTURED("textured"),
        ROUND_RECT("roundRect"),
        RECESSED("recessed"),
        HELP("help"),
        SEGMENTED("segmented", true),
        SEGMENTED_ROUND_RECT("segmentedRoundRect", true),
        SEGMENTED_CAPSULE("segmentedCapsule", true),
        SEGMENTED_TEXTURED("segmentedTextured", true),
        SEGMENTED_GRADIENT("segmentedGradient", true);

        private final boolean fSegmented;
        private final String fPropertyValue;

        private ButtonType(String string2) {
            this(string2, false);
        }

        private ButtonType(String string2, boolean bl) {
            this.fPropertyValue = string2;
            this.fSegmented = bl;
        }

        public boolean isSegmented() {
            return this.fSegmented;
        }

        public void apply(AbstractButton abstractButton) {
            abstractButton.putClientProperty("JButton.buttonType", this.fPropertyValue);
        }
    }

    public static enum SizeVariant {
        REGULAR("regular"),
        SMALL("small"),
        MINI("mini");

        private final String fPropertyValue;

        private SizeVariant(String string2) {
            this.fPropertyValue = string2;
        }

        public void apply(JComponent jComponent) {
            jComponent.putClientProperty("JComponent.sizeVariant", this.fPropertyValue);
        }
    }
}

