/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MJSplitPane
extends JSplitPane {
    protected double fPendingDividerProportion = Double.NaN;
    protected boolean fProportionalResizeEnabled;
    protected MouseInputListener fIntersectionListener;

    public MJSplitPane() {
        this.doCustomSetup();
    }

    public MJSplitPane(int n) {
        super(n);
        this.doCustomSetup();
    }

    public MJSplitPane(int n, boolean bl) {
        super(n, bl);
        this.doCustomSetup();
    }

    public MJSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.doCustomSetup();
    }

    public MJSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        this.doCustomSetup();
    }

    protected void doCustomSetup() {
        super.setBorder(new ConditionalBorder(this.getBorder()));
        this.addSafetyListener();
        this.setIntersectionDragEnabled(true);
    }

    public void suppressBorderIfNested(boolean bl) {
        Border border = this.getBorder();
        if (bl) {
            if (!(border instanceof ConditionalBorder)) {
                super.setBorder(new ConditionalBorder(border));
            }
        } else if (border instanceof ConditionalBorder) {
            super.setBorder(((ConditionalBorder)border).getOriginal());
        }
    }

    public boolean isSuppressingBorderIfNested() {
        return this.getBorder() instanceof ConditionalBorder;
    }

    @Override
    public void setBorder(Border border) {
        Border border2 = this.getBorder();
        if (border2 instanceof ConditionalBorder) {
            ((ConditionalBorder)border2).setOriginal(border);
        } else {
            super.setBorder(border);
        }
    }

    private void addSafetyListener() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    public void setProportionalResizeEnabled(boolean bl) {
        this.fProportionalResizeEnabled = bl;
    }

    public boolean getProportionalResizeEnabled() {
        return this.fProportionalResizeEnabled;
    }

    @Override
    public void setDividerLocation(double d) {
        if (this.getOrientation() == 0 && this.getHeight() > 0 || this.getOrientation() == 1 && this.getWidth() > 0) {
            super.setDividerLocation(d);
        } else {
            this.fPendingDividerProportion = d;
        }
    }

    @Override
    public void setDividerLocation(int n) {
        super.setDividerLocation(n);
        if (this.fProportionalResizeEnabled) {
            double d = -1.0;
            if (this.getOrientation() == 0) {
                if (this.getHeight() > 0) {
                    d = (double)n / (double)this.getHeight();
                }
            } else if (this.getWidth() > 0) {
                d = (double)n / (double)this.getWidth();
            }
            if (d > 1.0) {
                d = 1.0;
            }
            if (d >= 0.0) {
                this.setResizeWeight(d);
            }
        }
    }

    public void setIntersectionDragEnabled(boolean bl) {
        if (!(this.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        if (bl && this.fIntersectionListener == null) {
            BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
            this.fIntersectionListener = new IntersectionListener();
            basicSplitPaneDivider.addMouseListener(this.fIntersectionListener);
            basicSplitPaneDivider.addMouseMotionListener(this.fIntersectionListener);
        } else if (!bl && this.fIntersectionListener != null) {
            BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
            basicSplitPaneDivider.removeMouseListener(this.fIntersectionListener);
            basicSplitPaneDivider.removeMouseMotionListener(this.fIntersectionListener);
            this.fIntersectionListener = null;
        }
    }

    public boolean isIntersectionDragEnabled() {
        return this.fIntersectionListener != null;
    }

    @Override
    public void setOneTouchExpandable(boolean bl) {
        BareSwingDetector.exempt();
        super.setOneTouchExpandable(bl);
        BareSwingDetector.reinstate();
    }

    @Override
    public void doLayout() {
        if (!Double.isNaN(this.fPendingDividerProportion)) {
            int n;
            int n2 = n = this.getOrientation() == 0 ? this.getHeight() : this.getWidth();
            if (n > this.getDividerSize()) {
                int n3 = (int)((double)n * this.fPendingDividerProportion);
                this.setDividerLocation(n3);
                this.fPendingDividerProportion = Double.NaN;
            }
        }
        super.doLayout();
    }

    private class IntersectionListener
    extends MouseInputAdapter {
        Cursor iPreviousCursor;
        MJSplitPane iIntersectingPane;
        int iDragStartPosition = -1;
        int iDividerStartPosition = -1;

        private IntersectionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MJSplitPane mJSplitPane = this.getIntersectingPane(mouseEvent);
            if (mJSplitPane != this.iIntersectingPane) {
                Component component = mouseEvent.getComponent();
                if (mJSplitPane != null) {
                    if (this.iIntersectingPane == null) {
                        this.iPreviousCursor = component.getCursor();
                    }
                    component.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    component.setCursor(this.iPreviousCursor);
                    this.iPreviousCursor = null;
                }
                this.iIntersectingPane = mJSplitPane;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.iIntersectingPane != null) {
                this.iDragStartPosition = this.iIntersectingPane.getOrientation() == 1 ? mouseEvent.getX() : mouseEvent.getY();
                this.iDividerStartPosition = this.iIntersectingPane.getDividerLocation();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.iDragStartPosition = -1;
            this.iDividerStartPosition = -1;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iIntersectingPane != null && this.iDragStartPosition != -1) {
                int n = (this.iIntersectingPane.getOrientation() == 1 ? mouseEvent.getX() : mouseEvent.getY()) - this.iDragStartPosition;
                int n2 = this.iDividerStartPosition + n;
                if (n2 < this.iIntersectingPane.getMinimumDividerLocation()) {
                    n2 = this.iIntersectingPane.getMinimumDividerLocation();
                }
                if (n2 > this.iIntersectingPane.getMaximumDividerLocation()) {
                    n2 = this.iIntersectingPane.getMaximumDividerLocation();
                }
                if (n2 != this.iIntersectingPane.getDividerLocation()) {
                    this.iIntersectingPane.setDividerLocation(n2);
                }
            }
        }

        private MJSplitPane getIntersectingPane(MouseEvent mouseEvent) {
            if (!(MJSplitPane.this.getLeftComponent() instanceof MJSplitPane) && !(MJSplitPane.this.getRightComponent() instanceof MJSplitPane)) {
                return null;
            }
            int n = MJSplitPane.this.getOrientation() == 0 ? 1 : 0;
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, MJSplitPane.this);
            MJSplitPane mJSplitPane = this.getIntersectingPane(MJSplitPane.this.getLeftComponent(), true, n, point.x, point.y);
            if (mJSplitPane == null) {
                mJSplitPane = this.getIntersectingPane(MJSplitPane.this.getRightComponent(), false, n, point.x, point.y);
            }
            return mJSplitPane;
        }

        private MJSplitPane getIntersectingPane(Component component, boolean bl, int n, int n2, int n3) {
            boolean bl2;
            if (!(component instanceof MJSplitPane)) {
                return null;
            }
            MJSplitPane mJSplitPane = (MJSplitPane)component;
            int n4 = n2 - mJSplitPane.getX();
            int n5 = n3 - mJSplitPane.getY();
            boolean bl3 = bl2 = mJSplitPane.getOrientation() == n;
            if (bl2) {
                int n6 = mJSplitPane.getDividerLocation();
                int n7 = n6 + mJSplitPane.getDividerSize();
                if (n == 1 && n6 <= n4 && n4 <= n7 || n == 0 && n6 <= n5 && n5 <= n7) {
                    return mJSplitPane;
                }
            }
            MJSplitPane mJSplitPane2 = null;
            if (bl2 || !bl) {
                mJSplitPane2 = this.getIntersectingPane(mJSplitPane.getLeftComponent(), bl, n, n4, n5);
            }
            if (mJSplitPane2 == null && (bl2 || bl)) {
                mJSplitPane2 = this.getIntersectingPane(mJSplitPane.getRightComponent(), bl, n, n4, n5);
            }
            return mJSplitPane2;
        }
    }

    private static class ConditionalBorder
    extends AbstractBorder
    implements UIResource {
        private Border iOriginalBorder;

        ConditionalBorder(Border border) {
            this.iOriginalBorder = border;
        }

        Border getOriginal() {
            return this.iOriginalBorder;
        }

        void setOriginal(Border border) {
            this.iOriginalBorder = border;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (component.getParent() instanceof JSplitPane || this.iOriginalBorder == null) {
                return new Insets(0, 0, 0, 0);
            }
            return this.iOriginalBorder.getBorderInsets(component);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (component.getParent() instanceof JSplitPane || this.iOriginalBorder == null) {
                insets.bottom = 0;
                insets.top = 0;
                insets.right = 0;
                insets.left = 0;
            } else if (this.iOriginalBorder instanceof AbstractBorder) {
                ((AbstractBorder)this.iOriginalBorder).getBorderInsets(component, insets);
            } else {
                Insets insets2 = this.iOriginalBorder.getBorderInsets(component);
                insets.left = insets2.left;
                insets.right = insets2.right;
                insets.top = insets2.top;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component.getParent() instanceof JSplitPane) && this.iOriginalBorder != null) {
                this.iOriginalBorder.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }
}

