/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.mwswing.MouseWheelRedirector;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.window.MJFullWindowRegistry;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.MatlabWindowBlocker;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class MJDialog
extends JDialog
implements HWndProvider {
    private MatlabWindowBlocker fBlocker;
    private boolean fActive;
    private boolean fNativeEventsEnabled;
    private boolean fHasPeer;
    private Component fFocusTarget;
    private Component fPrevFocusOwner;
    private KeyCatcher fKeyCatcher;
    private Action fEscapeAction;
    private Component fSaveFocusOwner;

    public MJDialog() {
        this((Frame)null, null);
    }

    public MJDialog(Frame frame) {
        this(frame, null);
    }

    public MJDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public MJDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
    }

    public MJDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init();
    }

    public MJDialog(Dialog dialog) {
        this(dialog, null);
    }

    public MJDialog(Dialog dialog, boolean bl) {
        this(dialog, null, bl);
    }

    public MJDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.init();
    }

    public MJDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.init();
    }

    @Override
    public void setLocationRelativeTo(Component component) {
        Window window = WindowUtils.getWindowForComponent(component);
        if (window instanceof Frame && (((Frame)window).getExtendedState() & 1) != 0) {
            super.setLocationRelativeTo(null);
        } else {
            super.setLocationRelativeTo(component);
        }
    }

    private void init() {
        if (MouseWheelRedirector.isEnabled()) {
            this.getRootPane().addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                }
            });
        }
        this.addWindowListener(new WindowTracker());
        if (this.getParent() instanceof MJDialogParent) {
            ((MJDialogParent)this.getParent()).attachDialog(this);
        }
        if (this.isModal()) {
            this.fBlocker = new MatlabWindowBlocker();
        }
        this.setCloseOnEscapeEnabled(true);
    }

    public void setFocusTarget(Component component) {
        this.fFocusTarget = component;
    }

    public void catchPrematureKeyEvents(Component component) {
        this.fPrevFocusOwner = component;
        if (component == null) {
            return;
        }
        if (this.fKeyCatcher == null) {
            this.fKeyCatcher = new KeyCatcher();
        }
        this.fPrevFocusOwner.addKeyListener(this.fKeyCatcher);
    }

    @Override
    public boolean isActive() {
        return this.fActive;
    }

    public long getHWnd() {
        return NativeJava.getHWnd((Dialog)this);
    }

    public String getSpecifiedTitle() {
        return super.getTitle();
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.getParent() instanceof MJDialogParent) {
            ((Frame)this.getParent()).setTitle(string);
        }
    }

    public void setCloseOnEscapeEnabled(boolean bl) {
        if (bl && this.fEscapeAction == null) {
            this.fEscapeAction = new MJWindow.EscapeAction();
            ((MJWindow.EscapeAction)this.fEscapeAction).attachTo(this);
        }
        if (this.fEscapeAction != null) {
            this.fEscapeAction.setEnabled(bl);
        }
    }

    public boolean isCloseOnEscapeEnabled() {
        return this.fEscapeAction != null && this.fEscapeAction.isEnabled();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        MJFullWindowRegistry.register(this);
        if (!this.fNativeEventsEnabled && this.isModal()) {
            NativeJava.enableNativeDialogEvents((Window)this, (long)this.getHWnd());
            this.fNativeEventsEnabled = true;
        }
        this.fHasPeer = true;
        if (this.fBlocker != null) {
            this.fBlocker.componentShown(null);
        }
        if (this.isModal() && PlatformInfo.isMacintosh()) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
        }
    }

    @Override
    public void removeNotify() {
        MJFullWindowRegistry.unregister(this);
        if (this.fNativeEventsEnabled) {
            MJWindow.disableNativeEvents(this);
            this.fNativeEventsEnabled = false;
        }
        if (this.fBlocker != null && this.fHasPeer) {
            this.fBlocker.componentHidden(null);
        }
        this.fHasPeer = false;
        super.removeNotify();
        if (this.isModal() && PlatformInfo.isMacintosh()) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
    }

    @Override
    public void show() {
        if (this.isModal() && FactoryUtils.isMatlabThread()) {
            this.invokeAndWaitWithDispatch(new DoShow());
        } else {
            super.show();
        }
    }

    @Override
    public void hide() {
        this.fSaveFocusOwner = null;
        super.hide();
    }

    public void setNonBlockingVisible(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJDialog.this.setVisible(true);
                }
            });
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        if (this.getParent() instanceof MJDialogParent && this.getParent().isVisible()) {
            this.getParent().setVisible(false);
        }
        this.fSaveFocusOwner = null;
        super.dispose();
    }

    private void invokeAndWaitWithDispatch(DoShow doShow) {
        assert (FactoryUtils.isMatlabThread());
        EventQueue.invokeLater(doShow);
        while (!doShow.isDone()) {
            FactoryUtils.processPendingEvents();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class KeyCatcher
    implements KeyListener {
        private KeyCatcher() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.redispatch(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.redispatch(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.redispatch(keyEvent);
        }

        private void redispatch(KeyEvent keyEvent) {
            if (MJDialog.this.fPrevFocusOwner != null) {
                if (MJDialog.this.fFocusTarget != null) {
                    MJDialog.this.fFocusTarget.dispatchEvent(keyEvent);
                }
                keyEvent.consume();
            }
        }
    }

    private class WindowTracker
    extends WindowAdapter {
        private WindowTracker() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (MJDialog.this.fFocusTarget != null) {
                MJDialog.this.fFocusTarget.requestFocus();
            }
            this.removeKeyCatcher();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.removeKeyCatcher();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MJDialog.this.fActive = true;
            this.removeKeyCatcher();
            if (MJDialog.this.fSaveFocusOwner != null) {
                MJDialog.this.fSaveFocusOwner.dispatchEvent(new FocusEvent(MJDialog.this.fSaveFocusOwner, 1004, true));
                MJDialog.this.fSaveFocusOwner = null;
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            MJDialog.this.fActive = false;
            this.removeKeyCatcher();
            if (PlatformInfo.isMacintosh()) {
                MJDialog.this.fSaveFocusOwner = MJDialog.this.getMostRecentFocusOwner();
                if (MJDialog.this.fSaveFocusOwner != null) {
                    MJDialog.this.fSaveFocusOwner.dispatchEvent(new FocusEvent(MJDialog.this.fSaveFocusOwner, 1005, false));
                }
            }
        }

        private void removeKeyCatcher() {
            if (MJDialog.this.fPrevFocusOwner != null) {
                MJDialog.this.fPrevFocusOwner.removeKeyListener(MJDialog.this.fKeyCatcher);
                MJDialog.this.fPrevFocusOwner = null;
            }
        }
    }

    private class DoShow
    implements Runnable {
        private boolean fDone = false;

        private DoShow() {
        }

        public boolean isDone() {
            return this.fDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MJDialog.super.setVisible(true);
            }
            finally {
                this.fDone = true;
            }
        }
    }
}

