/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MJCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private PropertyChangeListener fActionPropertyHandler;
    protected static final String BASE_NAME = "CheckBoxMenuItem";

    public MJCheckBoxMenuItem() {
    }

    public MJCheckBoxMenuItem(Action action) {
        this.setAction(action);
    }

    public MJCheckBoxMenuItem(Icon icon) {
        super(icon);
    }

    public MJCheckBoxMenuItem(String string) {
        this.setText(string);
    }

    public MJCheckBoxMenuItem(String string, boolean bl) {
        super(string, bl);
        this.setText(string);
    }

    public MJCheckBoxMenuItem(String string, Icon icon) {
        super(icon);
        this.setText(string);
    }

    public MJCheckBoxMenuItem(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
        this.setText(string);
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsVistaAppearance() && !this.isEnabled() ? UIManager.getColor("CheckBoxMenuItem.foreground") : super.getForeground();
    }

    @Override
    public void setAction(Action action) {
        String string;
        Integer n;
        Action action2 = this.getAction();
        if (action2 != null) {
            WeakPropertyChangeCoupler.detach(action2, this.fActionPropertyHandler);
            if (action2.getValue("AcceleratorKey") != null) {
                this.setAccelerator(null);
            }
            if (action2 instanceof MJAbstractAction) {
                this.removeItemListener((ItemListener)((Object)action2));
            }
        }
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction) {
                this.setName(BASE_NAME);
            }
            return;
        }
        if (action.getValue("ShortDescription") != null) {
            this.setToolTipText(null);
        }
        if (this.fActionPropertyHandler == null) {
            this.fActionPropertyHandler = new ActionPropertyHandler();
        }
        WeakPropertyChangeCoupler.attach(action, this.fActionPropertyHandler);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            this.setAccelerator(keyStroke);
        }
        if ((n = (Integer)action.getValue("MnemonicIndex")) != null) {
            this.setDisplayedMnemonicIndex(n);
        }
        if ((string = (String)action.getValue("ComponentName")) != null) {
            this.setName(string + BASE_NAME);
        }
        if (action instanceof MJAbstractAction) {
            this.setSelected(((MJAbstractAction)action).isSelected());
            this.addItemListener((ItemListener)((Object)action));
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        Integer n = action == null ? null : (Integer)action.getValue("MnemonicKey");
        this.setMnemonic(n == null ? 0 : n);
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        super.setText(MJUtilities.exciseAmpersand(string));
        MJUtilities.setMnemonicFromText(this, string);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                boolean bl2 = MJMenuItem.isInDisabledParent(this);
                if (bl2) {
                    return false;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    class ActionPropertyHandler
    implements PropertyChangeListener {
        ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent.getPropertyName().equals("checked")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MJCheckBoxMenuItem.this.setSelected(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("AcceleratorKey")) {
                MJCheckBoxMenuItem.this.setAccelerator((KeyStroke)propertyChangeEvent.getNewValue());
                MJCheckBoxMenuItem.this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                MJCheckBoxMenuItem.this.setToolTipText(null);
            } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                if (MJCheckBoxMenuItem.this.getMnemonic() != 0 && MJPopupMenu.isInContextMenu(MJCheckBoxMenuItem.this)) {
                    MJPopupMenu.removeMnemonic(MJCheckBoxMenuItem.this);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("ComponentName") && (string = (String)propertyChangeEvent.getNewValue()) != null) {
                MJCheckBoxMenuItem.this.setName(string + MJCheckBoxMenuItem.BASE_NAME);
            }
        }
    }
}

