/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.bitmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.apache.fop.util.bitmap.DefaultMonochromeBitmapConverter;
import org.apache.fop.util.bitmap.MonochromeBitmapConverter;

public final class BitmapImageUtil {
    private BitmapImageUtil() {
    }

    public static boolean isMonochromeImage(RenderedImage renderedImage) {
        return BitmapImageUtil.getColorIndexSize(renderedImage) == 2;
    }

    public static boolean isZeroBlack(RenderedImage renderedImage) {
        int n;
        if (!BitmapImageUtil.isMonochromeImage(renderedImage)) {
            throw new IllegalArgumentException("Image is not a monochrome image!");
        }
        IndexColorModel indexColorModel = (IndexColorModel)renderedImage.getColorModel();
        int n2 = BitmapImageUtil.convertToGray(indexColorModel.getRGB(0));
        return n2 < (n = BitmapImageUtil.convertToGray(indexColorModel.getRGB(1)));
    }

    public static int convertToGray(int n, int n2, int n3) {
        return (n * 30 + n2 * 59 + n3 * 11) / 100;
    }

    public static int convertToGray(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        return BitmapImageUtil.convertToGray(n2, n3, n4);
    }

    public static int getColorIndexSize(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            return indexColorModel.getMapSize();
        }
        return 0;
    }

    public static boolean isGrayscaleImage(RenderedImage renderedImage) {
        return renderedImage.getColorModel().getColorSpace().getNumComponents() == 1;
    }

    public static BufferedImage convertTosRGB(RenderedImage renderedImage, Dimension dimension) {
        return BitmapImageUtil.convertAndScaleImage(renderedImage, dimension, 1);
    }

    public static BufferedImage convertToGrayscale(RenderedImage renderedImage, Dimension dimension) {
        return BitmapImageUtil.convertAndScaleImage(renderedImage, dimension, 10);
    }

    public static BufferedImage convertToMonochrome(RenderedImage renderedImage, Dimension dimension) {
        return BitmapImageUtil.toBufferedImage(BitmapImageUtil.convertToMonochrome(renderedImage, dimension, 0.0f));
    }

    public static RenderedImage convertToMonochrome(RenderedImage renderedImage, Dimension dimension, float f) {
        if (!BitmapImageUtil.isMonochromeImage(renderedImage) && f >= 0.5f) {
            BufferedImage bufferedImage;
            Object object;
            Dimension dimension2 = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
            if (dimension != null && !dimension2.equals(dimension)) {
                object = renderedImage.getColorModel();
                BufferedImage bufferedImage2 = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(dimension.width, dimension.height), ((ColorModel)object).isAlphaPremultiplied(), null);
                BitmapImageUtil.transferImage(renderedImage, bufferedImage2);
                bufferedImage = bufferedImage2;
            } else {
                bufferedImage = BitmapImageUtil.toBufferedImage(renderedImage);
            }
            object = BitmapImageUtil.createDefaultMonochromeBitmapConverter();
            if (f >= 0.8f) {
                object.setHint("quality", Boolean.TRUE.toString());
                bufferedImage = BitmapImageUtil.convertToGrayscale(bufferedImage, dimension);
            }
            try {
                return object.convertToMonochrome(bufferedImage);
            }
            catch (Exception exception) {
                bufferedImage = BitmapImageUtil.convertToGrayscale(bufferedImage, dimension);
                return object.convertToMonochrome(bufferedImage);
            }
        }
        return BitmapImageUtil.convertAndScaleImage(renderedImage, dimension, 12);
    }

    private static BufferedImage convertAndScaleImage(RenderedImage renderedImage, Dimension dimension, int n) {
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            dimension2 = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        }
        BufferedImage bufferedImage = new BufferedImage(dimension2.width, dimension2.height, n);
        BitmapImageUtil.transferImage(renderedImage, bufferedImage);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        WritableRaster writableRaster = renderedImage.getColorModel().createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        boolean bl = renderedImage.getColorModel().isAlphaPremultiplied();
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getColorModel(), writableRaster, bl, null);
        BitmapImageUtil.transferImage(renderedImage, bufferedImage);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferImage(RenderedImage renderedImage, BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setBackground(Color.white);
            graphics2D.setColor(Color.black);
            graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            AffineTransform affineTransform = new AffineTransform();
            if (renderedImage.getWidth() != bufferedImage.getWidth() || renderedImage.getHeight() != bufferedImage.getHeight()) {
                double d = (double)bufferedImage.getWidth() / (double)renderedImage.getWidth();
                double d2 = (double)bufferedImage.getHeight() / (double)renderedImage.getHeight();
                affineTransform.scale(d, d2);
            }
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static MonochromeBitmapConverter createDefaultMonochromeBitmapConverter() {
        MonochromeBitmapConverter monochromeBitmapConverter = null;
        try {
            String string = "org.apache.fop.util.bitmap.JAIMonochromeBitmapConverter";
            Class<?> clazz = Class.forName(string);
            monochromeBitmapConverter = (MonochromeBitmapConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (monochromeBitmapConverter == null) {
            monochromeBitmapConverter = new DefaultMonochromeBitmapConverter();
        }
        return monochromeBitmapConverter;
    }
}

