/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.tools.fontlist.FontSpec;

public class FontListGenerator {
    public SortedMap listFonts(FopFactory fopFactory, String string, FontEventListener fontEventListener) throws FOPException {
        FontInfo fontInfo = this.setupFonts(fopFactory, string, fontEventListener);
        SortedMap sortedMap = this.buildFamilyMap(fontInfo);
        return sortedMap;
    }

    private FontInfo setupFonts(FopFactory fopFactory, String string, FontEventListener fontEventListener) throws FOPException {
        FOUserAgent fOUserAgent = fopFactory.newFOUserAgent();
        IFDocumentHandler iFDocumentHandler = fopFactory.getRendererFactory().createDocumentHandler(fOUserAgent, string);
        IFDocumentHandlerConfigurator iFDocumentHandlerConfigurator = iFDocumentHandler.getConfigurator();
        FontInfo fontInfo = new FontInfo();
        iFDocumentHandlerConfigurator.setupFontInfo(iFDocumentHandler, fontInfo);
        return fontInfo;
    }

    private SortedMap buildFamilyMap(FontInfo fontInfo) {
        Map<String, Typeface> map = fontInfo.getFonts();
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        HashMap<String, FontSpec> hashMap = new HashMap<String, FontSpec>();
        TreeMap<String, ArrayList<FontSpec>> treeMap = new TreeMap<String, ArrayList<FontSpec>>();
        for (Map.Entry<FontTriplet, String> entry : fontInfo.getFontTriplets().entrySet()) {
            FontSpec fontSpec;
            FontTriplet fontTriplet = entry.getKey();
            String string = entry.getValue();
            if (hashSet.contains(string)) {
                hashSet.remove(string);
                FontMetrics fontMetrics = map.get(string);
                fontSpec = new FontSpec(string, fontMetrics);
                fontSpec.addFamilyNames(fontMetrics.getFamilyNames());
                hashMap.put(string, fontSpec);
                String string2 = (String)fontSpec.getFamilyNames().first();
                ArrayList<FontSpec> arrayList = (ArrayList<FontSpec>)treeMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<FontSpec>();
                    treeMap.put(string2, arrayList);
                }
                arrayList.add(fontSpec);
                Collections.sort(arrayList);
            } else {
                fontSpec = (FontSpec)hashMap.get(string);
            }
            fontSpec.addTriplet(fontTriplet);
        }
        return treeMap;
    }
}

