/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.text.linebreak;

import org.apache.fop.text.linebreak.LineBreakUtils;

public class LineBreakStatus {
    public static final byte DIRECT_BREAK = 0;
    public static final byte INDIRECT_BREAK = 1;
    public static final byte COMBINING_INDIRECT_BREAK = 2;
    public static final byte COMBINING_PROHIBITED_BREAK = 3;
    public static final byte PROHIBITED_BREAK = 4;
    public static final byte EXPLICIT_BREAK = 5;
    private byte leftClass;
    private boolean hadSpace;

    public LineBreakStatus() {
        this.reset();
    }

    public void reset() {
        this.leftClass = (byte)-1;
        this.hadSpace = false;
    }

    public byte nextChar(char c) {
        int n = LineBreakUtils.getLineBreakProperty(c);
        block0 : switch (n) {
            case 0: 
            case 1: 
            case 32: 
            case 36: {
                n = 2;
                break;
            }
            case 31: {
                switch (Character.getType(c)) {
                    case 6: 
                    case 8: {
                        n = 9;
                        break block0;
                    }
                }
                n = 2;
            }
        }
        switch (this.leftClass) {
            case -1: {
                this.leftClass = (byte)n;
                if (this.leftClass == 9) {
                    this.leftClass = (byte)2;
                }
                return 4;
            }
            case 6: 
            case 23: 
            case 24: {
                this.reset();
                this.leftClass = (byte)n;
                return 5;
            }
            case 11: {
                if (n == 23) break;
                this.reset();
                this.leftClass = (byte)n;
                return 5;
            }
        }
        switch (n) {
            case 6: 
            case 11: 
            case 23: 
            case 24: {
                this.leftClass = (byte)n;
                return 4;
            }
            case 33: {
                this.hadSpace = true;
                return 4;
            }
        }
        boolean bl = this.hadSpace;
        this.hadSpace = false;
        byte by = LineBreakUtils.getLineBreakPairProperty(this.leftClass, n);
        switch (by) {
            case 0: 
            case 4: {
                this.leftClass = (byte)n;
                return by;
            }
            case 1: {
                this.leftClass = (byte)n;
                if (bl) {
                    return 1;
                }
                return 4;
            }
            case 2: {
                if (bl) {
                    this.leftClass = (byte)n;
                    return 2;
                }
                return 4;
            }
            case 3: {
                if (bl) {
                    this.leftClass = (byte)n;
                }
                return 3;
            }
        }
        assert (false);
        return by;
    }
}

