/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.ACIUtils;
import org.apache.fop.util.CharUtilities;

public abstract class NativeTextPainter
extends StrokingTextPainter {
    protected Log log = LogFactory.getLog(NativeTextPainter.class);
    protected final FontInfo fontInfo;

    public NativeTextPainter(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    protected abstract boolean isSupported(Graphics2D var1);

    protected abstract void paintTextRun(StrokingTextPainter.TextRun var1, Graphics2D var2) throws IOException;

    protected void paintTextRuns(List list, Graphics2D graphics2D) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("paintTextRuns: count = " + list.size()));
        }
        if (!this.isSupported(graphics2D)) {
            super.paintTextRuns(list, graphics2D);
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(i);
            try {
                this.paintTextRun(textRun, graphics2D);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected Font[] findFonts(AttributedCharacterIterator attributedCharacterIterator) {
        Font[] fontArray = ACIUtils.findFontsForBatikACI(attributedCharacterIterator, this.fontInfo);
        return fontArray;
    }

    protected CharSequence collectCharacters(AttributedCharacterIterator attributedCharacterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.first();
        while (attributedCharacterIterator.getIndex() < attributedCharacterIterator.getEndIndex()) {
            stringBuffer.append(attributedCharacterIterator.current());
            attributedCharacterIterator.next();
        }
        return stringBuffer;
    }

    protected final void logTextRun(AttributedCharacterIterator attributedCharacterIterator, TextSpanLayout textSpanLayout) {
        if (this.log.isTraceEnabled()) {
            int n = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
            this.log.trace((Object)"================================================");
            this.log.trace((Object)"New text run:");
            this.log.trace((Object)("char count: " + n));
            this.log.trace((Object)("range: " + attributedCharacterIterator.getBeginIndex() + " - " + attributedCharacterIterator.getEndIndex()));
            this.log.trace((Object)("glyph count: " + textSpanLayout.getGlyphCount()));
        }
    }

    protected final void logCharacter(char c, TextSpanLayout textSpanLayout, int n, boolean bl) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("glyph " + n + " -> " + textSpanLayout.getGlyphIndex(n) + " => " + c));
            if (CharUtilities.isAnySpace(c) && c != ' ') {
                this.log.trace((Object)("Space found: " + Integer.toHexString(c)));
            } else if (c == '\u200d') {
                this.log.trace((Object)("ZWJ found: " + Integer.toHexString(c)));
            } else if (c == '\u00ad') {
                this.log.trace((Object)("Soft hyphen found: " + Integer.toHexString(c)));
            }
            if (!bl) {
                this.log.trace((Object)("Invisible glyph found: " + Integer.toHexString(c)));
            }
        }
    }
}

