/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.svg.AbstractFOPBridgeContext;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractFOPImageElementBridge
extends SVGImageElementBridge {
    protected GraphicsNode createImageGraphicsNode(BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        AbstractFOPBridgeContext abstractFOPBridgeContext = (AbstractFOPBridgeContext)bridgeContext;
        ImageManager imageManager = abstractFOPBridgeContext.getImageManager();
        ImageSessionContext imageSessionContext = abstractFOPBridgeContext.getImageSessionContext();
        try {
            Object object;
            ImageInfo imageInfo = imageManager.getImageInfo(parsedURL.toString(), imageSessionContext);
            ImageFlavor[] imageFlavorArray = this.getSupportedFlavours();
            Image image = imageManager.getImage(imageInfo, imageFlavorArray, imageSessionContext);
            AbstractGraphicsNode abstractGraphicsNode = null;
            if (image instanceof ImageXMLDOM) {
                object = (ImageXMLDOM)image;
                if (object.getDocument() instanceof SVGDocument) {
                    SVGDocument sVGDocument = (SVGDocument)BatikUtil.cloneSVGDocument(object.getDocument());
                    return this.createSVGImageNode(bridgeContext, element, sVGDocument);
                }
                image = imageManager.convertImage((Image)object, new ImageFlavor[]{ImageFlavor.GRAPHICS2D});
            }
            if (image instanceof ImageRawJPEG) {
                abstractGraphicsNode = this.createLoaderImageNode(image, bridgeContext, element, parsedURL);
            } else if (image instanceof ImageRawCCITTFax) {
                abstractGraphicsNode = this.createLoaderImageNode(image, bridgeContext, element, parsedURL);
            } else if (image instanceof ImageGraphics2D) {
                object = (ImageGraphics2D)image;
                abstractGraphicsNode = new Graphics2DNode((ImageGraphics2D)object);
            } else {
                bridgeContext.getUserAgent().displayError((Exception)((Object)new ImageException("Cannot convert an image to a usable format: " + parsedURL)));
            }
            if (abstractGraphicsNode != null) {
                object = AbstractFOPImageElementBridge.getImageBounds((BridgeContext)bridgeContext, (Element)element);
                Rectangle2D rectangle2D = abstractGraphicsNode.getPrimitiveBounds();
                float[] fArray = new float[]{0.0f, 0.0f, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()};
                AbstractFOPImageElementBridge.initializeViewport((BridgeContext)bridgeContext, (Element)element, (GraphicsNode)abstractGraphicsNode, (float[])fArray, (Rectangle2D)object);
                return abstractGraphicsNode;
            }
        }
        catch (Exception exception) {
            bridgeContext.getUserAgent().displayError(exception);
        }
        return this.superCreateGraphicsNode(bridgeContext, element, parsedURL);
    }

    protected GraphicsNode superCreateGraphicsNode(BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        return super.createImageGraphicsNode(bridgeContext, element, parsedURL);
    }

    protected abstract ImageFlavor[] getSupportedFlavours();

    protected LoaderImageNode createLoaderImageNode(Image image, BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        return new LoaderImageNode(image, bridgeContext, element, parsedURL);
    }

    public static class Graphics2DNode
    extends AbstractGraphicsNode {
        private final ImageGraphics2D image;

        public Graphics2DNode(ImageGraphics2D imageGraphics2D) {
            this.image = imageGraphics2D;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D graphics2D) {
            int n = this.image.getSize().getWidthPx();
            int n2 = this.image.getSize().getHeightPx();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            Graphics2DImagePainter graphics2DImagePainter = this.image.getGraphics2DImagePainter();
            graphics2DImagePainter.paint(graphics2D, (Rectangle2D)double_);
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }

    public class LoaderImageNode
    extends AbstractGraphicsNode {
        protected final Image image;
        protected final BridgeContext ctx;
        protected final Element imageElement;
        protected final ParsedURL purl;
        protected GraphicsNode origGraphicsNode = null;

        public LoaderImageNode(Image image, BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
            this.image = image;
            this.ctx = bridgeContext;
            this.imageElement = element;
            this.purl = parsedURL;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D graphics2D) {
            if (graphics2D instanceof NativeImageHandler) {
                NativeImageHandler nativeImageHandler = (NativeImageHandler)((Object)graphics2D);
                float f = 0.0f;
                float f2 = 0.0f;
                try {
                    float f3 = this.image.getSize().getWidthPx();
                    float f4 = this.image.getSize().getHeightPx();
                    nativeImageHandler.addNativeImage(this.image, f, f2, f3, f4);
                }
                catch (Exception exception) {
                    this.ctx.getUserAgent().displayError(exception);
                }
            } else {
                if (this.origGraphicsNode == null) {
                    this.origGraphicsNode = AbstractFOPImageElementBridge.this.superCreateGraphicsNode(this.ctx, this.imageElement, this.purl);
                }
                this.origGraphicsNode.primitivePaint(graphics2D);
            }
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }
}

