/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.servlet.ServletContextURIResolver;

public class FopServlet
extends HttpServlet {
    private static final long serialVersionUID = -908918093488215264L;
    protected static final String FO_REQUEST_PARAM = "fo";
    protected static final String XML_REQUEST_PARAM = "xml";
    protected static final String XSLT_REQUEST_PARAM = "xslt";
    protected TransformerFactory transFactory = null;
    protected FopFactory fopFactory = null;
    protected URIResolver uriResolver;

    public void init() throws ServletException {
        this.uriResolver = new ServletContextURIResolver(this.getServletContext());
        this.transFactory = TransformerFactory.newInstance();
        this.transFactory.setURIResolver(this.uriResolver);
        this.fopFactory = FopFactory.newInstance();
        this.fopFactory.setURIResolver(this.uriResolver);
        this.configureFopFactory();
    }

    protected void configureFopFactory() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            String string = httpServletRequest.getParameter(FO_REQUEST_PARAM);
            String string2 = httpServletRequest.getParameter(XML_REQUEST_PARAM);
            String string3 = httpServletRequest.getParameter(XSLT_REQUEST_PARAM);
            if (string != null) {
                this.renderFO(string, httpServletResponse);
            } else if (string2 != null && string3 != null) {
                this.renderXML(string2, string3, httpServletResponse);
            } else {
                httpServletResponse.setContentType("text/html");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("<html><head><title>Error</title></head>\n<body><h1>FopServlet Error</h1><h3>No 'fo' request param given.</body></html>");
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    protected Source convertString2Source(String string) {
        Source source;
        try {
            source = this.uriResolver.resolve(string, null);
        }
        catch (TransformerException transformerException) {
            source = null;
        }
        if (source == null) {
            source = new StreamSource(new File(string));
        }
        return source;
    }

    private void sendPDF(byte[] byArray, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("application/pdf");
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.getOutputStream().write(byArray);
        httpServletResponse.getOutputStream().flush();
    }

    protected void renderFO(String string, HttpServletResponse httpServletResponse) throws FOPException, TransformerException, IOException {
        Source source = this.convertString2Source(string);
        Transformer transformer = this.transFactory.newTransformer();
        transformer.setURIResolver(this.uriResolver);
        this.render(source, transformer, httpServletResponse);
    }

    protected void renderXML(String string, String string2, HttpServletResponse httpServletResponse) throws FOPException, TransformerException, IOException {
        Source source = this.convertString2Source(string);
        Source source2 = this.convertString2Source(string2);
        Transformer transformer = this.transFactory.newTransformer(source2);
        transformer.setURIResolver(this.uriResolver);
        this.render(source, transformer, httpServletResponse);
    }

    protected void render(Source source, Transformer transformer, HttpServletResponse httpServletResponse) throws FOPException, TransformerException, IOException {
        FOUserAgent fOUserAgent = this.getFOUserAgent();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Fop fop = this.fopFactory.newFop("application/pdf", fOUserAgent, (OutputStream)byteArrayOutputStream);
        SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
        transformer.transform(source, sAXResult);
        this.sendPDF(byteArrayOutputStream.toByteArray(), httpServletResponse);
    }

    protected FOUserAgent getFOUserAgent() {
        FOUserAgent fOUserAgent = this.fopFactory.newFOUserAgent();
        return fOUserAgent;
    }
}

