/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt.border;

import java.util.Arrays;
import org.apache.fop.render.txt.border.AbstractBorderElement;
import org.apache.fop.render.txt.border.DashedBorderElement;
import org.apache.fop.render.txt.border.DottedBorderElement;

public class SolidAndDoubleBorderElement
extends AbstractBorderElement {
    private static final char LIGHT_HORIZONTAL = '\u2500';
    private static final char LIGHT_VERTICAL = '\u2502';
    private static final char LIGHT_DOWN_AND_RIGHT = '\u250c';
    private static final char LIGHT_DOWN_AND_LEFT = '\u2510';
    private static final char LIGHT_UP_AND_RIGHT = '\u2514';
    private static final char LIGHT_UP_AND_LEFT = '\u2518';
    private static final char LIGHT_VERTICAL_AND_RIGHT = '\u251c';
    private static final char LIGHT_VERTICAL_AND_LEFT = '\u2524';
    private static final char LIGHT_DOWN_AND_HORIZONTAL = '\u252c';
    private static final char LIGHT_UP_AND_HORIZONTAL = '\u2534';
    private static final char LIGHT_VERTICAL_AND_HORIZONTAL = '\u253c';
    private static final char DOUBLE_HORIZONTAL = '\u2550';
    private static final char DOUBLE_VERTICAL = '\u2551';
    private static final char DOUBLE_DOWN_AND_RIGHT = '\u2554';
    private static final char DOUBLE_DOWN_AND_LEFT = '\u2557';
    private static final char DOUBLE_UP_AND_RIGHT = '\u255a';
    private static final char DOUBLE_UP_AND_LEFT = '\u255d';
    private static final char DOUBLE_VERTICAL_AND_RIGHT = '\u2560';
    private static final char DOUBLE_VERTICAL_AND_LEFT = '\u2563';
    private static final char DOUBLE_DOWN_AND_HORIZONTAL = '\u2566';
    private static final char DOUBLE_UP_AND_HORIZONTAL = '\u2569';
    private static final char DOUBLE_VERTICAL_AND_HORIZONTAL = '\u256c';
    private static final char DOWN_SINGLE_AND_RIGHT_DOUBLE = '\u2552';
    private static final char DOWN_DOUBLE_AND_RIGHT_SINGLE = '\u2553';
    private static final char DOWN_SINGLE_AND_LEFT_DOUBLE = '\u2555';
    private static final char DOWN_DOUBLE_AND_LEFT_SINGLE = '\u2556';
    private static final char UP_SINGLE_AND_RIGHT_DOUBLE = '\u2558';
    private static final char UP_DOUBLE_AND_RIGHT_SINGLE = '\u2559';
    private static final char UP_SINGLE_AND_LEFT_DOUBLE = '\u255b';
    private static final char UP_DOUBLE_AND_LEFT_SINGLE = '\u255c';
    private static final char VERTICAL_SINGLE_AND_RIGHT_DOUBLE = '\u255e';
    private static final char VERTICAL_DOUBLE_AND_RIGHT_SINGLE = '\u255f';
    private static final char VERTICAL_SINGLE_AND_LEFT_DOUBLE = '\u2561';
    private static final char VERTICAL_DOUBLE_AND_LEFT_SINGLE = '\u2562';
    private static final char DOWN_SINGLE_AND_HORIZONTAL_DOUBLE = '\u2564';
    private static final char DOWN_DOUBLE_AND_HORIZONTAL_SINGLE = '\u2565';
    private static final char UP_SINGLE_AND_HORIZONTAL_DOUBLE = '\u2567';
    private static final char UP_DOUBLE_AND_HORIZONTAL_SINGLE = '\u2568';
    private static final char VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE = '\u256a';
    private static final char VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE = '\u256b';
    private static final char UNDEFINED = '?';
    private static final int UP3 = 1;
    private static final int DOWN3 = 3;
    private static final int LEFT3 = 9;
    private static final int RIGHT3 = 27;
    private static final char[] MAP = new char[100];

    public SolidAndDoubleBorderElement() {
    }

    public SolidAndDoubleBorderElement(int n, int n2) {
        super(n2);
        if (n == 37) {
            int n3 = 0;
            while (n3 < 4) {
                int n4 = n3++;
                this.data[n4] = this.data[n4] * 2;
            }
        }
    }

    public AbstractBorderElement mergeSolid(SolidAndDoubleBorderElement solidAndDoubleBorderElement) {
        SolidAndDoubleBorderElement solidAndDoubleBorderElement2 = new SolidAndDoubleBorderElement(133, 0);
        for (int i = 0; i < 4; ++i) {
            if (solidAndDoubleBorderElement.getData(i) != 0) {
                solidAndDoubleBorderElement2.setData(i, solidAndDoubleBorderElement.getData(i));
                continue;
            }
            solidAndDoubleBorderElement2.setData(i, this.data[i]);
        }
        return solidAndDoubleBorderElement2;
    }

    public AbstractBorderElement merge(AbstractBorderElement abstractBorderElement) {
        AbstractBorderElement abstractBorderElement2 = this;
        if (abstractBorderElement instanceof SolidAndDoubleBorderElement) {
            abstractBorderElement2 = this.mergeSolid((SolidAndDoubleBorderElement)abstractBorderElement);
        } else if (abstractBorderElement instanceof DottedBorderElement) {
            abstractBorderElement2 = abstractBorderElement;
        } else if (abstractBorderElement instanceof DashedBorderElement) {
            abstractBorderElement2 = abstractBorderElement.merge(this);
        }
        return abstractBorderElement2;
    }

    private char map2Char() {
        int n = 0;
        n += this.data[0] * 1;
        n += this.data[3] * 9;
        n += this.data[2] * 3;
        return MAP[n += this.data[1] * 27];
    }

    private void modifyData() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 4; ++n) {
            n2 += this.data[n] == 1 ? 1 : 0;
            n3 += this.data[n] == 2 ? 1 : 0;
        }
        n = n2 > n3 ? 1 : 0;
        int[] nArray = new int[]{0, n, 2 * (1 - n)};
        for (int i = 0; i < 4; ++i) {
            this.data[i] = nArray[this.data[i]];
        }
    }

    public char convert2Char() {
        char c = this.map2Char();
        if (c == '?') {
            this.modifyData();
            c = this.map2Char();
        }
        return c;
    }

    static {
        Arrays.fill(MAP, '?');
        SolidAndDoubleBorderElement.MAP[0] = 32;
        SolidAndDoubleBorderElement.MAP[1] = 9474;
        SolidAndDoubleBorderElement.MAP[3] = 9474;
        SolidAndDoubleBorderElement.MAP[27] = 9472;
        SolidAndDoubleBorderElement.MAP[9] = 9472;
        SolidAndDoubleBorderElement.MAP[4] = 9474;
        SolidAndDoubleBorderElement.MAP[36] = 9472;
        SolidAndDoubleBorderElement.MAP[10] = 9496;
        SolidAndDoubleBorderElement.MAP[12] = 9488;
        SolidAndDoubleBorderElement.MAP[30] = 9484;
        SolidAndDoubleBorderElement.MAP[28] = 9492;
        SolidAndDoubleBorderElement.MAP[31] = 9500;
        SolidAndDoubleBorderElement.MAP[13] = 9508;
        SolidAndDoubleBorderElement.MAP[39] = 9516;
        SolidAndDoubleBorderElement.MAP[37] = 9524;
        SolidAndDoubleBorderElement.MAP[40] = 9532;
        SolidAndDoubleBorderElement.MAP[2] = 9553;
        SolidAndDoubleBorderElement.MAP[6] = 9553;
        SolidAndDoubleBorderElement.MAP[54] = 9552;
        SolidAndDoubleBorderElement.MAP[18] = 9552;
        SolidAndDoubleBorderElement.MAP[8] = 9553;
        SolidAndDoubleBorderElement.MAP[72] = 9552;
        SolidAndDoubleBorderElement.MAP[20] = 9565;
        SolidAndDoubleBorderElement.MAP[24] = 9559;
        SolidAndDoubleBorderElement.MAP[60] = 9556;
        SolidAndDoubleBorderElement.MAP[56] = 9562;
        SolidAndDoubleBorderElement.MAP[62] = 9568;
        SolidAndDoubleBorderElement.MAP[26] = 9571;
        SolidAndDoubleBorderElement.MAP[78] = 9574;
        SolidAndDoubleBorderElement.MAP[74] = 9577;
        SolidAndDoubleBorderElement.MAP[80] = 9580;
        SolidAndDoubleBorderElement.MAP[57] = 9554;
        SolidAndDoubleBorderElement.MAP[33] = 9555;
        SolidAndDoubleBorderElement.MAP[21] = 9557;
        SolidAndDoubleBorderElement.MAP[15] = 9558;
        SolidAndDoubleBorderElement.MAP[55] = 9560;
        SolidAndDoubleBorderElement.MAP[29] = 9561;
        SolidAndDoubleBorderElement.MAP[19] = 9563;
        SolidAndDoubleBorderElement.MAP[11] = 9564;
        SolidAndDoubleBorderElement.MAP[58] = 9566;
        SolidAndDoubleBorderElement.MAP[35] = 9567;
        SolidAndDoubleBorderElement.MAP[22] = 9569;
        SolidAndDoubleBorderElement.MAP[17] = 9570;
        SolidAndDoubleBorderElement.MAP[75] = 9572;
        SolidAndDoubleBorderElement.MAP[42] = 9573;
        SolidAndDoubleBorderElement.MAP[73] = 9575;
        SolidAndDoubleBorderElement.MAP[38] = 9576;
        SolidAndDoubleBorderElement.MAP[76] = 9578;
        SolidAndDoubleBorderElement.MAP[44] = 9579;
    }
}

