/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHeader;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public final class RtfStyleSheetTable {
    private static int startIndex = 15;
    public static final int STATUS_OK = 0;
    public static final int STATUS_DEFAULT = 1;
    private static final String STANDARD_STYLE = "Standard";
    private static RtfStyleSheetTable instance = null;
    private Hashtable styles = new Hashtable();
    private Hashtable attrTable = new Hashtable();
    private Vector nameTable = new Vector();
    private String defaultStyleName = "Standard";

    private RtfStyleSheetTable() {
    }

    public static RtfStyleSheetTable getInstance() {
        if (instance == null) {
            instance = new RtfStyleSheetTable();
        }
        return instance;
    }

    public void setDefaultStyle(String string) {
        this.defaultStyleName = string;
    }

    public String getDefaultStyleName() {
        if (this.attrTable.get(this.defaultStyleName) != null) {
            return this.defaultStyleName;
        }
        if (this.attrTable.get(STANDARD_STYLE) != null) {
            this.defaultStyleName = STANDARD_STYLE;
            return this.defaultStyleName;
        }
        return null;
    }

    public void addStyle(String string, RtfAttributes rtfAttributes) {
        this.nameTable.addElement(string);
        if (rtfAttributes != null) {
            this.attrTable.put(string, rtfAttributes);
        }
        this.styles.put(string, new Integer(this.nameTable.size() - 1 + startIndex));
    }

    public int addStyleToAttributes(String string, RtfAttributes rtfAttributes) {
        int n = 0;
        Integer n2 = (Integer)this.styles.get(string);
        if (n2 == null && !string.equals(this.defaultStyleName)) {
            string = this.defaultStyleName;
            n2 = (Integer)this.styles.get(string);
            n = 1;
        }
        if (n2 == null) {
            return n;
        }
        rtfAttributes.set("cs", n2);
        Object v = this.attrTable.get(string);
        if (v != null) {
            RtfAttributes rtfAttributes2 = (RtfAttributes)v;
            Iterator iterator = rtfAttributes2.nameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (rtfAttributes.isSet(string2)) continue;
                Integer n3 = (Integer)rtfAttributes2.getValue(string2);
                if (n3 == null) {
                    rtfAttributes.set(string2);
                    continue;
                }
                rtfAttributes.set(string2, n3);
            }
        }
        return n;
    }

    public void writeStyleSheet(RtfHeader rtfHeader) throws IOException {
        if (this.styles == null || this.styles.size() == 0) {
            return;
        }
        rtfHeader.writeGroupMark(true);
        rtfHeader.writeControlWord("stylesheet");
        int n = this.nameTable.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.nameTable.elementAt(i);
            rtfHeader.writeGroupMark(true);
            rtfHeader.writeControlWord("*\\" + this.getRtfStyleReference(string));
            Object v = this.attrTable.get(string);
            if (v != null) {
                rtfHeader.writeAttributes((RtfAttributes)v, RtfText.ATTR_NAMES);
                rtfHeader.writeAttributes((RtfAttributes)v, RtfText.ALIGNMENT);
            }
            rtfHeader.write(string + ";");
            rtfHeader.writeGroupMark(false);
        }
        rtfHeader.writeGroupMark(false);
    }

    private String getRtfStyleReference(String string) {
        return "cs" + this.styles.get(string).toString();
    }
}

