/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class RtfStringConverter {
    private static final RtfStringConverter INSTANCE = new RtfStringConverter();
    private static final Map SPECIAL_CHARS;
    private static final Character DBLQUOTE;
    private static final Character QUOTE;
    private static final Character SPACE;

    private RtfStringConverter() {
    }

    public static RtfStringConverter getInstance() {
        return INSTANCE;
    }

    public void writeRtfString(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        writer.write(this.escape(string));
    }

    public String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(Math.max(16, string.length()));
        for (int i = 0; i < string.length(); ++i) {
            Character c = new Character(string.charAt(i));
            Character c2 = i != 0 ? new Character(string.charAt(i - 1)) : new Character(string.charAt(i));
            String string2 = c.equals(DBLQUOTE) && c2.equals(SPACE) ? "ldblquote" : (c.equals(QUOTE) && c2.equals(SPACE) ? "lquote" : (String)SPECIAL_CHARS.get(c));
            if (string2 != null) {
                stringBuffer.append('\\');
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                continue;
            }
            if (c.charValue() > '\u007f') {
                stringBuffer.append("\\u");
                stringBuffer.append(Integer.toString(c.charValue()));
                stringBuffer.append("\\'3f");
                continue;
            }
            stringBuffer.append(c.charValue());
        }
        return stringBuffer.toString();
    }

    static {
        DBLQUOTE = new Character('\"');
        QUOTE = new Character('\'');
        SPACE = new Character(' ');
        SPECIAL_CHARS = new HashMap();
        SPECIAL_CHARS.put(new Character('\t'), "tab");
        SPECIAL_CHARS.put(new Character('\n'), "line");
        SPECIAL_CHARS.put(new Character('\''), "rquote");
        SPECIAL_CHARS.put(new Character('\"'), "rdblquote");
        SPECIAL_CHARS.put(new Character('\\'), "\\");
        SPECIAL_CHARS.put(new Character('{'), "{");
        SPECIAL_CHARS.put(new Character('}'), "}");
    }
}

