/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.util.LinkedList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;

public class RtfSpaceManager {
    private LinkedList blockAttributes = new LinkedList();
    private LinkedList inlineAttributes = new LinkedList();
    private int accumulatedSpace = 0;

    public void stopUpdatingSpaceBefore() {
        for (RtfSpaceSplitter rtfSpaceSplitter : this.blockAttributes) {
            if (!rtfSpaceSplitter.isBeforeCadidateSet()) continue;
            rtfSpaceSplitter.stopUpdatingSpaceBefore();
        }
    }

    public void setCandidate(RtfAttributes rtfAttributes) {
        for (RtfSpaceSplitter rtfSpaceSplitter : this.blockAttributes) {
            rtfSpaceSplitter.setSpaceBeforeCandidate(rtfAttributes);
            rtfSpaceSplitter.setSpaceAfterCandidate(rtfAttributes);
        }
    }

    public RtfSpaceSplitter pushRtfSpaceSplitter(RtfAttributes rtfAttributes) {
        RtfSpaceSplitter rtfSpaceSplitter = new RtfSpaceSplitter(rtfAttributes, this.accumulatedSpace);
        this.accumulatedSpace = 0;
        this.blockAttributes.addLast(rtfSpaceSplitter);
        return rtfSpaceSplitter;
    }

    public void popRtfSpaceSplitter() {
        if (!this.blockAttributes.isEmpty()) {
            RtfSpaceSplitter rtfSpaceSplitter = (RtfSpaceSplitter)this.blockAttributes.removeLast();
            this.accumulatedSpace += rtfSpaceSplitter.flush();
        }
    }

    public void pushInlineAttributes(RtfAttributes rtfAttributes) {
        this.inlineAttributes.addLast(rtfAttributes);
    }

    public void popInlineAttributes() {
        if (!this.inlineAttributes.isEmpty()) {
            this.inlineAttributes.removeLast();
        }
    }

    public RtfAttributes getLastInlineAttribute() {
        return (RtfAttributes)this.inlineAttributes.getLast();
    }
}

