/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFontTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfGenerator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfStringConverter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfStyleSheetTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTemplate;

class RtfHeader
extends RtfContainer {
    private final String charset = "ansi";
    private final Map userProperties = new HashMap();

    RtfHeader(RtfFile rtfFile, Writer writer) throws IOException {
        super(rtfFile, writer);
        new RtfFontTable(this, writer);
        new RtfGenerator(this, writer);
    }

    protected void writeRtfContent() throws IOException {
        this.writeControlWord("ansi");
        this.writeUserProperties();
        RtfColorTable.getInstance().writeColors(this);
        super.writeRtfContent();
        RtfTemplate.getInstance().writeTemplate(this);
        RtfStyleSheetTable.getInstance().writeStyleSheet(this);
        this.writeFootnoteProperties();
    }

    private void writeUserProperties() throws IOException {
        if (this.userProperties.size() > 0) {
            this.writeGroupMark(true);
            this.writeStarControlWord("userprops");
            for (Map.Entry entry : this.userProperties.entrySet()) {
                this.writeGroupMark(true);
                this.writeControlWord("propname");
                RtfStringConverter.getInstance().writeRtfString(this.writer, entry.getKey().toString());
                this.writeGroupMark(false);
                this.writeControlWord("proptype30");
                this.writeGroupMark(true);
                this.writeControlWord("staticval");
                RtfStringConverter.getInstance().writeRtfString(this.writer, entry.getValue().toString());
                this.writeGroupMark(false);
            }
            this.writeGroupMark(false);
        }
    }

    void write(String string) throws IOException {
        this.writer.write(string);
    }

    void writeRtfString(String string) throws IOException {
        RtfStringConverter.getInstance().writeRtfString(this.writer, string);
    }

    private void writeFootnoteProperties() throws IOException {
        this.newLine();
        this.writeControlWord("fet0");
        this.writeControlWord("ftnbj");
    }
}

